package cn.gtmap.landtax.web.ydqc;

/**
 * Created by Administrator on 2014/9/2.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SwdjSyTempService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.YdqcService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.*;

/**
 * .
 * <p/>
 * 申报入库疑点清册
 * @author xuchao
 * @version V1.0, 2014/9/2
 */
@Controller
@RequestMapping("/ydqc/zs")
public class ZsYdqcController {
    @Autowired
    YdqcService ydqcService;
    @Autowired
    TaxService taxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SwdjSyTempService swdjSyTempService;

    @RequestMapping("list")
    public String list(Model model){
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int sssq = Integer.valueOf(CommonUtil.getSssqByNow(Szdm.CZTDSYS.toString()));
        if (sssq == 1) {
            sssq = 4;
            currentYear = currentYear - 1;
        } else {
            sssq = sssq - 1;
        }

        List<String> yearList = new ArrayList<String>();
        String minYear = "2014";
        for (int year = currentYear; year >= Integer.valueOf(minYear); year--) {
            yearList.add(String.valueOf(year));
        }
        model.addAttribute("yearList",yearList);
        model.addAttribute("sssq", String.valueOf(sssq));
        model.addAttribute("currentYear",String.valueOf(currentYear));
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(userInfo!=null){
            String regionCode = userInfo.getRegionCode();
            model.addAttribute("regionCode",regionCode);
        }
        return "landtax/ydqc/zs/tdzsList";
    }
    @RequestMapping("listJson")
    @ResponseBody
    public Object listJson(Model model,Pageable pageable,SbZsQuery sbZsQuery) {
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int sssq = Integer.valueOf(CommonUtil.getSssqByNow(Szdm.CZTDSYS.toString()));
        if (sssq == 1) {
            sssq = 4;
            currentYear = currentYear - 1;
        } else {
            sssq = sssq - 1;
        }
        if (StringUtils.isEmpty(sbZsQuery.getYear())) {
            sbZsQuery.setYear(String.valueOf(currentYear));
        }
        if (StringUtils.isEmpty(sbZsQuery.getSssq())) {
            sbZsQuery.setSssq(String.valueOf(sssq));
        }

        return ydqcService.findZsListJson(sbZsQuery,Szdm.CZTDSYS.toString(), pageable);
    }

    @RequestMapping("getSyListByGlbm")
    public String getSyListByGlbm(Model model,String glbm){
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByGlbm(glbm,Szdm.CZTDSYS.toString());
        model.addAttribute("syxx",syxx);
        model.addAttribute("glbm",glbm);
        return "landtax/ydqc/zs/syxx";
    }

    @RequestMapping("getZsListByGlbm")
    public String getZsListByGlbm(Model model,SbZsQuery sbZsQuery){
        List<HashMap<String,Object>> syxx = taxService.getZsSyxxListByGlbm(sbZsQuery,Szdm.CZTDSYS.toString());
        model.addAttribute("glbm",sbZsQuery.getGlbm());
        model.addAttribute("syxx",syxx);
        return "landtax/ydqc/zs/zsSyxx";
    }

    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String szdm,String ydqcId) throws Exception{
        String result = "true";
        String[] ydqcIdArr = ydqcId.split(",");
        SwHcXm swHcXm = new SwHcXm();
        String hcxmMc = "";
        String xmlx = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())) {
            hcxmMc = "土地税征收疑点核查项目" + Calendar.getInstance().getTime();
            xmlx = Hcxmlx.TDZSYDQC.toString();
        } else {
            hcxmMc = "房产税征收疑点核查项目" + Calendar.getInstance().getTime();
            xmlx = Hcxmlx.FCZSYDQC.toString();
        }
        swHcXm.setMc(hcxmMc);
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(xmlx);
        swHcXm.setXmybj("0");

        hcxmService.createZsydqcHcxm(swHcXm, ydqcIdArr, szdm);
        return result;
    }

    @RequestMapping("xjxmAll")
    @ResponseBody
    public Object xjxmAll(Model model, String szdm, SbZsQuery sbZsQuery) throws Exception {
        String result = "true";
        SwHcXm swHcXm = new SwHcXm();
        String hcxmMc = "";
        String xmlx = "";
        String ydqcIdField = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())) {
            hcxmMc = "土地税征收疑点核查项目" + Calendar.getInstance().getTime();
            ydqcIdField = "TDZSYD_ID";
            xmlx = Hcxmlx.TDZSYDQC.toString();
        } else {
            hcxmMc = "房产税征收疑点核查项目" + Calendar.getInstance().getTime();
            ydqcIdField = "FCZSYD_ID";
            xmlx = Hcxmlx.FCZSYDQC.toString();
        }
        swHcXm.setMc(hcxmMc);
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(xmlx);
        swHcXm.setXmybj("0");

        sbZsQuery.setJdlx("0"); // 只查询待下发的
        StringBuffer sql = ydqcService.getZsListSql(szdm, sbZsQuery);
        sql.append("order by cyje desc");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap> list = (List<HashMap>)query.getResultList();
        String[] ydqcIdArr = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ydqcIdArr[i] = list.get(i).get(ydqcIdField).toString();
        }
        hcxmService.createZsydqcHcxm(swHcXm, ydqcIdArr, szdm);
        return result;
    }


    @RequestMapping("/tdXgsqb")
    public String tdXgsqb(Model model,String proid) {
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcId);

        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);

            if(sSjZsydqcTd!=null){
                tdSbXgsqb.setGlbm(sSjZsydqcTd.getGlbm());
                tdSbXgsqb.setNsrmc(sSjZsydqcTd.getSwDjJbb().getNsrmc());
                tdSbXgsqb.setYnmj(sSjZsydqcTd.getYnmj());
                tdSbXgsqb.setNynse(sSjZsydqcTd.getYjse());
                tdSbXgsqb.setRkse(sSjZsydqcTd.getRkse());
                tdSbXgsqb.setCyje(sSjZsydqcTd.getCyje());
            }
            //初始税务机关和税管员
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userVo = sysUserService.getUserVo(userId);
            model.addAttribute("userId",userVo.getUserId());
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            //根据地区码，获取主管税务机关列表
            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }

        HashMap<String, BigDecimal> ydxx = new HashMap<String, BigDecimal>();
        if (sSjZsydqcTd != null) {
            ydxx.put("sbse", sSjZsydqcTd.getRkse());
            ydxx.put("yjse", sSjZsydqcTd.getYjse());
            if (ydxx.get("yjse") != null) {
                BigDecimal sbse = (ydxx.get("sbse") == null) ? new BigDecimal(0) : ydxx.get("sbse");
                BigDecimal yjse = (ydxx.get("yjse") == null) ? new BigDecimal(0) : ydxx.get("yjse");
                ydxx.put("cyje", ydxx.get("yjse").subtract(sbse));
                if (yjse == null || (new BigDecimal(0)).equals(yjse)) {
                    ydxx.put("cybl", new BigDecimal(0.00));
                } else {
                    ydxx.put("cybl", (ydxx.get("cyje").multiply(new BigDecimal(100))).divide(yjse, 2, BigDecimal.ROUND_HALF_UP));
                }
            }

            if (sSjZsydqcTd.getEndCybl() == null) {
                ydxx.put("endSbse", ydqcService.getRkseByProid(proid, Szdm.CZTDSYS.toString(), sSjZsydqcTd.getSsnf(), sSjZsydqcTd.getSssq()));
                BigDecimal endYjse = ydqcService.getTotalTdNynseByProid(proid);
                if (endYjse != null) {
                    Integer sssq = Integer.valueOf(sSjZsydqcTd.getSssq());
                    endYjse = endYjse.multiply(new BigDecimal((sssq - 1) % 4 - (sssq - 1) / 4 + 1)).divide(new BigDecimal(4), 2, BigDecimal.ROUND_HALF_UP);
                }
                ydxx.put("endYjse", endYjse);
                if (endYjse != null) {
                    BigDecimal endSbse = (ydxx.get("endSbse") == null) ? new BigDecimal(0) : ydxx.get("endSbse");
                    ydxx.put("endCyje", ydxx.get("endYjse").subtract(endSbse));
                    if (endYjse == null || (new BigDecimal(0)).equals(endYjse)) {
                        ydxx.put("endCybl", new BigDecimal(0.00));
                    } else {
                        ydxx.put("endCybl", (ydxx.get("endCyje").multiply(new BigDecimal(100))).divide(endYjse, 2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            } else {
                ydxx.put("endSbse", sSjZsydqcTd.getEndSbse());
                ydxx.put("endYjse", sSjZsydqcTd.getEndYjse());
                ydxx.put("endCybl", sSjZsydqcTd.getEndCybl());
            }

        }

        model.addAttribute("syxx",tdSbXgsqb);
        model.addAttribute("ydxx",ydxx);
        model.addAttribute("szMc", "城镇土地使用税");
        return "landtax/ydqc/zs/tdXgsqb";
    }

    @RequestMapping("zssyList")
    public String zssyList(Model model,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcId);
        String ssnf = sSjZsydqcTd.getSsnf();
        String sssq = sSjZsydqcTd.getSssq();
        SbZsQuery sbZsQuery = new SbZsQuery();
        sbZsQuery.setYear(ssnf);
        sbZsQuery.setSssq(sssq);
        sbZsQuery.setGlbm(sSjZsydqcTd.getGlbm());
        return getZsListByGlbm(model,sbZsQuery);
    }

    @RequestMapping("/wf/end")
    @ResponseBody
    public String wfEnd(Model model,String proid) throws  Exception{
        ydqcService.zsYdqcWfEnd(proid,Szdm.CZTDSYS.toString());
        return "";
    }

    @RequestMapping("/wf/del")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        ydqcService.zsYdqcWfDel(proid,Szdm.CZTDSYS.toString());
        return "";
    }

    //*******************************************************************************************************房产征收
    @RequestMapping("fcList")
    public String fcList(Model model){
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int sssq = Integer.valueOf(CommonUtil.getSssqByNow(Szdm.FCS.toString()));
        if (sssq == 1) {
            sssq = 2;
            currentYear = currentYear - 1;
        } else {
            sssq = sssq - 1;
        }

        List<String> yearList = new ArrayList<String>();
        String minYear = "2015";
        for (int year = currentYear; year >= Integer.valueOf(minYear); year--) {
            yearList.add(String.valueOf(year));
        }
        model.addAttribute("yearList",yearList);
        model.addAttribute("sssq", String.valueOf(sssq));
        model.addAttribute("currentYear",String.valueOf(currentYear));
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(userInfo!=null){
            String regionCode = userInfo.getRegionCode();
            model.addAttribute("regionCode",regionCode);
        }
        return "landtax/ydqc/zs/fczsList";
    }

    @RequestMapping("fcListJson")
    @ResponseBody
    public Object fcListJson(Model model,Pageable pageable,SbZsQuery sbZsQuery) {
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int sssq = Integer.valueOf(CommonUtil.getSssqByNow(Szdm.FCS.toString()));
        if (sssq == 1) {
            sssq = 2;
            currentYear = currentYear - 1;
        } else {
            sssq = sssq - 1;
        }
        if (StringUtils.isEmpty(sbZsQuery.getYear())) {
            sbZsQuery.setYear(String.valueOf(currentYear));
        }
        if (StringUtils.isEmpty(sbZsQuery.getSssq())) {
            sbZsQuery.setSssq(String.valueOf(sssq));
        }

        return ydqcService.findZsListJson(sbZsQuery,Szdm.FCS.toString(), pageable);
    }

    @RequestMapping("getFcSyListByGlbm")
    public String getFcSyListByGlbm(Model model,String glbm){
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByGlbm(glbm,Szdm.FCS.toString());
        model.addAttribute("syxx",syxx);
        model.addAttribute("glbm",glbm);
        return "landtax/ydqc/zs/fcsyxx";
    }

    @RequestMapping("getFcZsListByGlbm")
    public String getFcZsListByGlbm(Model model,SbZsQuery sbZsQuery){
        List<HashMap<String,Object>> syxx = taxService.getZsSyxxListByGlbm(sbZsQuery,Szdm.FCS.toString());
        model.addAttribute("glbm",sbZsQuery.getGlbm());
        model.addAttribute("syxx",syxx);
        return "landtax/ydqc/zs/fczsSyxx";
    }

    @RequestMapping("/fcXgsqb")
    public String fcXgsqb(Model model,String proid) {
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcfc = swHcXmRwRel.getBdId();
        SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcfc);

        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);

            if(sSjZsydqcFc!=null){
                tdSbXgsqb.setGlbm(sSjZsydqcFc.getGlbm());
                tdSbXgsqb.setNsrmc(sSjZsydqcFc.getSwDjJbb().getNsrmc());
                tdSbXgsqb.setNynse(sSjZsydqcFc.getYjse());
                tdSbXgsqb.setRkse(sSjZsydqcFc.getRkse());
                tdSbXgsqb.setCyje(sSjZsydqcFc.getCyje());
            }
            //初始税务机关和税管员
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userVo = sysUserService.getUserVo(userId);
            model.addAttribute("userId",userVo.getUserId());
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            if(regionCode.length()>6){
                regionCode = regionCode.substring(0,6);
            }
            //根据地区码，获取主管税务机关列表
            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }

        HashMap<String, BigDecimal> ydxx = new HashMap<String, BigDecimal>();
        if (sSjZsydqcFc != null) {
            ydxx.put("sbse", sSjZsydqcFc.getRkse());
            ydxx.put("yjse", sSjZsydqcFc.getYjse());
            if (ydxx.get("yjse") != null) {
                BigDecimal sbse = (ydxx.get("sbse") == null) ? new BigDecimal(0) : ydxx.get("sbse");
                BigDecimal yjse = (ydxx.get("yjse") == null) ? new BigDecimal(0) : ydxx.get("yjse");
                ydxx.put("cyje", ydxx.get("yjse").subtract(sbse));
                if (yjse == null || (new BigDecimal(0)).equals(yjse)) {
                    ydxx.put("cybl", new BigDecimal(0.00));
                } else {
                    ydxx.put("cybl", (ydxx.get("cyje").multiply(new BigDecimal(100))).divide(yjse, 2, BigDecimal.ROUND_HALF_UP));
                }
            }
            if (sSjZsydqcFc.getEndCybl() == null) {
                ydxx.put("endSbse", ydqcService.getRkseByProid(proid, Szdm.FCS.toString(), sSjZsydqcFc.getSsnf(), sSjZsydqcFc.getSssq()));
                BigDecimal endYjse = ydqcService.getTotalFcNynseByProid(proid);
                if (endYjse != null) {
                    Integer sssq = Integer.valueOf(sSjZsydqcFc.getSssq());
                    endYjse = endYjse.multiply(new BigDecimal((sssq - 1) % 2 - (sssq - 1) / 2 + 1)).divide(new BigDecimal(2), 2, BigDecimal.ROUND_HALF_UP);
                }
                ydxx.put("endYjse", endYjse);
                if (endYjse != null) {
                    BigDecimal endSbse = (ydxx.get("endSbse") == null) ? new BigDecimal(0) : ydxx.get("endSbse");
                    ydxx.put("endCyje", ydxx.get("endYjse").subtract(endSbse));
                    if (endYjse == null || (new BigDecimal(0)).equals(endYjse)) {
                        ydxx.put("endCybl", new BigDecimal(0.00));
                    } else {
                        ydxx.put("endCybl", (ydxx.get("endCyje").multiply(new BigDecimal(100))).divide(endYjse, 2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            } else {
                ydxx.put("endSbse", sSjZsydqcFc.getEndSbse());
                ydxx.put("endYjse", sSjZsydqcFc.getEndYjse());
                ydxx.put("endCybl", sSjZsydqcFc.getEndCybl());
            }
        }

        model.addAttribute("syxx",tdSbXgsqb);
        model.addAttribute("ydxx",ydxx);
        model.addAttribute("szMc", "房产税");
        return "landtax/ydqc/zs/tdXgsqb";
    }

    @RequestMapping("fczssyList")
    public String fczssyList(Model model,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcId);
        String ssnf = sSjZsydqcFc.getSsnf();
        String sssq = sSjZsydqcFc.getSssq();
        SbZsQuery sbZsQuery = new SbZsQuery();
        sbZsQuery.setYear(ssnf);
        sbZsQuery.setSssq(sssq);
        sbZsQuery.setGlbm(sSjZsydqcFc.getGlbm());
        return getFcZsListByGlbm(model,sbZsQuery);
    }

    @RequestMapping("/wf/fcEnd")
    @ResponseBody
    public String wfFcEnd(Model model,String proid) throws  Exception{
        ydqcService.zsYdqcWfEnd(proid,Szdm.FCS.toString());
        return "";
    }


    @RequestMapping("/wf/fcDel")
    @ResponseBody
    public String wfFcDel(Model model,String proid) {
        ydqcService.zsYdqcWfDel(proid,Szdm.FCS.toString());
        return "";
    }

    @RequestMapping("exportExcelTdZsyd")
    public String exportExcelTdZsyd(HttpServletRequest request, SbZsQuery sbZsQuery, String gridOptions){
        try {
            StringBuffer sql = ydqcService.getZsListSql(Szdm.CZTDSYS.toString(), sbZsQuery);
            sql.append("order by cyje desc");
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap> list = (List<HashMap>)query.getResultList();

            com.alibaba.fastjson.JSONObject jsonObject = (new com.alibaba.fastjson.JSONObject()).parseObject(gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle("城镇土地使用税征收疑点清册");
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelFcZsyd")
    public String exportExcelFcZsyd(HttpServletRequest request, SbZsQuery sbZsQuery, String gridOptions){
        try {
            StringBuffer sql = ydqcService.getZsListSql(Szdm.FCS.toString(), sbZsQuery);
            sql.append("order by cyje desc");
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap> list = (List<HashMap>)query.getResultList();

            com.alibaba.fastjson.JSONObject jsonObject = (new com.alibaba.fastjson.JSONObject()).parseObject(gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle("房产税征收疑点清册");
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,String proid) {
        List<SwDjSyTemp> swDjSyTempList =  ydqcService.findSytzByProid(proid);
        model.addAttribute("swDjSyTempList",swDjSyTempList);
        model.addAttribute("proid",proid);
        return "landtax/ydqc/zs/sbSyxxTz";
    }

    @RequestMapping("/tdXgsqb/save")
    @ResponseBody
    public Object saveTdXgsqb(Model model,TdSbXgsqb tdSbXgsqb) {

        ResponseMessage responseMessage = new ResponseMessage();
        try {
            ydqcService.saveOrUpdateTdSbXgsqb(tdSbXgsqb);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            responseMessage.setMsg("保存失败");
        }
        return responseMessage;
    }

    @RequestMapping("printXgsqb")
    @ResponseBody
    public void printXgsqb(Model model,HttpServletRequest request,HttpServletResponse response,String proid,String szmc,String userId) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcId);

        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);

            if(sSjZsydqcTd!=null){
                tdSbXgsqb.setGlbm(sSjZsydqcTd.getGlbm());
                tdSbXgsqb.setNsrmc(sSjZsydqcTd.getSwDjJbb().getNsrmc());
                tdSbXgsqb.setYnmj(sSjZsydqcTd.getYnmj());
                tdSbXgsqb.setNynse(sSjZsydqcTd.getYjse());
                tdSbXgsqb.setRkse(sSjZsydqcTd.getRkse());
                tdSbXgsqb.setCyje(sSjZsydqcTd.getCyje());
            }
            //初始税务机关和税管员
            PfUserVo userVo = sysUserService.getUserVo(userId);
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            //根据地区码，获取主管税务机关列表
            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }

        HashMap<String, BigDecimal> ydxx = new HashMap<String, BigDecimal>();
        if (sSjZsydqcTd != null) {
            ydxx.put("sbse", sSjZsydqcTd.getRkse());
            ydxx.put("yjse", sSjZsydqcTd.getYjse());
            if (ydxx.get("yjse") != null) {
                BigDecimal sbse = (ydxx.get("sbse") == null) ? new BigDecimal(0) : ydxx.get("sbse");
                BigDecimal yjse = (ydxx.get("yjse") == null) ? new BigDecimal(0) : ydxx.get("yjse");
                ydxx.put("cyje", ydxx.get("yjse").subtract(sbse));
                if (yjse == null || (new BigDecimal(0)).equals(yjse)) {
                    ydxx.put("cybl", new BigDecimal(0.00));
                } else {
                    ydxx.put("cybl", (ydxx.get("cyje").multiply(new BigDecimal(100))).divide(yjse, 2, BigDecimal.ROUND_HALF_UP));
                }
            }

            if (sSjZsydqcTd.getEndCybl() == null) {
                ydxx.put("endSbse", ydqcService.getRkseByProid(proid, Szdm.CZTDSYS.toString(), sSjZsydqcTd.getSsnf(), sSjZsydqcTd.getSssq()));
                BigDecimal endYjse = ydqcService.getTotalTdNynseByProid(proid);
                if (endYjse != null) {
                    Integer sssq = Integer.valueOf(sSjZsydqcTd.getSssq());
                    endYjse = endYjse.multiply(new BigDecimal((sssq - 1) % 4 - (sssq - 1) / 4 + 1)).divide(new BigDecimal(4), 2, BigDecimal.ROUND_HALF_UP);
                }
                ydxx.put("endYjse", endYjse);
                if (endYjse != null) {
                    BigDecimal endSbse = (ydxx.get("endSbse") == null) ? new BigDecimal(0) : ydxx.get("endSbse");
                    ydxx.put("endCyje", ydxx.get("endYjse").subtract(endSbse));
                    if (endYjse == null || (new BigDecimal(0)).equals(endYjse)) {
                        ydxx.put("endCybl", new BigDecimal(0.00));
                    } else {
                        ydxx.put("endCybl", (ydxx.get("endCyje").multiply(new BigDecimal(100))).divide(endYjse, 2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            } else {
                ydxx.put("endSbse", sSjZsydqcTd.getEndSbse());
                ydxx.put("endYjse", sSjZsydqcTd.getEndYjse());
                ydxx.put("endCybl", sSjZsydqcTd.getEndCybl());
            }
        }
        xml.append(xmlBuildHelper.voToXml(tdSbXgsqb));

        xml.append("<data name=\"yjse\" type=\"String\">");
        xml.append(ydxx.get("yjse")==null?"":ydxx.get("yjse"));
        xml.append("</data>");
        xml.append("<data name=\"cyje\" type=\"String\">");
        xml.append(ydxx.get("cyje")==null?"":ydxx.get("cyje"));
        xml.append("</data>");
        xml.append("<data name=\"cybl\" type=\"String\">");
        xml.append(ydxx.get("cybl")==null?"":ydxx.get("cybl"));
        xml.append("</data>");
        xml.append("<data name=\"endYjse\" type=\"String\">");
        xml.append(ydxx.get("endYjse")==null?"":ydxx.get("endYjse"));
        xml.append("</data>");
        xml.append("<data name=\"endRkse\" type=\"String\">");
        xml.append(ydxx.get("endSbse")==null?"":ydxx.get("endSbse"));
        xml.append("</data>");
        xml.append("<data name=\"endCyje\" type=\"String\">");
        xml.append(ydxx.get("endCyje")==null?"":ydxx.get("endCyje"));
        xml.append("</data>");
        xml.append("<data name=\"endCybl\" type=\"String\">");
        xml.append(ydxx.get("endCybl")==null?"":ydxx.get("endCybl"));
        xml.append("</data>");
        xml.append("<data name=\"szmc\" type=\"String\">");
        xml.append(szmc);
        xml.append("</data>");

        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("sgyqr", false);
        keyMap.put("fjzqr", false);
        keyMap.put("qxqr", false);
        xml.append(xmlBuildHelper.getSignToXml(proid, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("printXgsqbFc")
    @ResponseBody
    public void printXgsqbFc(Model model,HttpServletRequest request,HttpServletResponse response,String proid,String szmc,String userId) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcfc = swHcXmRwRel.getBdId();
        SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcfc);

        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);

            if(sSjZsydqcFc!=null){
                tdSbXgsqb.setGlbm(sSjZsydqcFc.getGlbm());
                tdSbXgsqb.setNsrmc(sSjZsydqcFc.getSwDjJbb().getNsrmc());
                tdSbXgsqb.setNynse(sSjZsydqcFc.getYjse());
                tdSbXgsqb.setRkse(sSjZsydqcFc.getRkse());
                tdSbXgsqb.setCyje(sSjZsydqcFc.getCyje());
            }
            //初始税务机关和税管员
            PfUserVo userVo = sysUserService.getUserVo(userId);
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            if(regionCode.length()>6){
                regionCode = regionCode.substring(0,6);
            }
            //根据地区码，获取主管税务机关列表
            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }

        HashMap<String, BigDecimal> ydxx = new HashMap<String, BigDecimal>();
        if (sSjZsydqcFc != null) {
            ydxx.put("sbse", sSjZsydqcFc.getRkse());
            ydxx.put("yjse", sSjZsydqcFc.getYjse());
            if (ydxx.get("yjse") != null) {
                BigDecimal sbse = (ydxx.get("sbse") == null) ? new BigDecimal(0) : ydxx.get("sbse");
                BigDecimal yjse = (ydxx.get("yjse") == null) ? new BigDecimal(0) : ydxx.get("yjse");
                ydxx.put("cyje", ydxx.get("yjse").subtract(sbse));
                if (yjse == null || (new BigDecimal(0)).equals(yjse)) {
                    ydxx.put("cybl", new BigDecimal(0.00));
                } else {
                    ydxx.put("cybl", (ydxx.get("cyje").multiply(new BigDecimal(100))).divide(yjse, 2, BigDecimal.ROUND_HALF_UP));
                }
            }

            if (sSjZsydqcFc.getEndCybl() == null) {
                ydxx.put("endSbse", ydqcService.getRkseByProid(proid, Szdm.FCS.toString(), sSjZsydqcFc.getSsnf(), sSjZsydqcFc.getSssq()));
                BigDecimal endYjse = ydqcService.getTotalFcNynseByProid(proid);
                if (endYjse != null) {
                    Integer sssq = Integer.valueOf(sSjZsydqcFc.getSssq());
                    endYjse = endYjse.multiply(new BigDecimal((sssq - 1) % 2 - (sssq - 1) / 2 + 1)).divide(new BigDecimal(2), 2, BigDecimal.ROUND_HALF_UP);
                }
                ydxx.put("endYjse", endYjse);
                if (endYjse != null) {
                    BigDecimal endSbse = (ydxx.get("endSbse") == null) ? new BigDecimal(0) : ydxx.get("endSbse");
                    ydxx.put("endCyje", ydxx.get("endYjse").subtract(endSbse));
                    if (endYjse == null || (new BigDecimal(0)).equals(endYjse)) {
                        ydxx.put("endCybl", new BigDecimal(0.00));
                    } else {
                        ydxx.put("endCybl", (ydxx.get("endCyje").multiply(new BigDecimal(100))).divide(endYjse, 2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            } else {
                ydxx.put("endSbse", sSjZsydqcFc.getEndSbse());
                ydxx.put("endYjse", sSjZsydqcFc.getEndYjse());
                ydxx.put("endCybl", sSjZsydqcFc.getEndCybl());
            }
        }

        xml.append(xmlBuildHelper.voToXml(tdSbXgsqb));

        xml.append("<data name=\"yjse\" type=\"String\">");
        xml.append(ydxx.get("yjse")==null?"":ydxx.get("yjse"));
        xml.append("</data>");
        xml.append("<data name=\"cyje\" type=\"String\">");
        xml.append(ydxx.get("cyje")==null?"":ydxx.get("cyje"));
        xml.append("</data>");
        xml.append("<data name=\"cybl\" type=\"String\">");
        xml.append(ydxx.get("cybl")==null?"":ydxx.get("cybl"));
        xml.append("</data>");
        xml.append("<data name=\"endYjse\" type=\"String\">");
        xml.append(ydxx.get("endYjse")==null?"":ydxx.get("endYjse"));
        xml.append("</data>");
        xml.append("<data name=\"endRkse\" type=\"String\">");
        xml.append(ydxx.get("endSbse")==null?"":ydxx.get("endSbse"));
        xml.append("</data>");
        xml.append("<data name=\"endCyje\" type=\"String\">");
        xml.append(ydxx.get("endCyje")==null?"":ydxx.get("endCyje"));
        xml.append("</data>");
        xml.append("<data name=\"endCybl\" type=\"String\">");
        xml.append(ydxx.get("endCybl")==null?"":ydxx.get("endCybl"));
        xml.append("</data>");
        xml.append("<data name=\"szmc\" type=\"String\">");
        xml.append(szmc);
        xml.append("</data>");

        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("sgyqr", false);
        keyMap.put("fjzqr", false);
        keyMap.put("qxqr", false);
        xml.append(xmlBuildHelper.getSignToXml(proid, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("printSyxx")
    @ResponseBody
    public void exportSyxx(Model model,HttpServletResponse response,String syId,String proid, String djh) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSyQuery syxx = new SwDjSyQuery();
        if(syId!=null && proid!=null){
            SwDjSyTemp tempVo = swdjSyTempService.getswDjSyTempBySyIdAndRwid(syId,proid);
            BeanUtils.copyProperties(tempVo, syxx);
        }
        if(StringUtils.isBlank(djh)){
            djh = syxx.getDjh();
        }
        Zd zd = baseRepository.get(Zd.class,djh);
        if (zd != null) {
            syxx.setDjh(zd.getDjh());
            syxx.setTdytMc(Dldm.getMcByDm(zd.getTdyt()));
            syxx.setQlrmc(zd.getQlrmc());
            syxx.setScmjZd(zd.getScmjZd());
            syxx.setTdzl(zd.getTdzl());
        }
        if(StringUtils.isNotBlank(syId) && StringUtils.isNotBlank(proid)){
            //根据下拉框代码获取下拉框名称
            //根据税管代码获取税管状态名称
            String sgztDm = syxx.getSgztDm();
            String sgzdMc = Sgzt.getMcByDm(sgztDm);
            syxx.setSgztMc(sgzdMc);
            //根据土地用途代码获取土地用途名称
            String tdyt = syxx.getTdyt();
            String tdytMc = Dldm.getMcByDm(tdyt);
            syxx.setTdytMc(tdytMc);
            //根据土地使用权类型获取土地使用权类型名称
            String tdsyqlx = syxx.getTdsyqlx();
            String tdsyqlxMc = Tdsyqlx.getMcByDm(tdsyqlx);
            syxx.setTdsyqlxMc(tdsyqlxMc);
            //根据主管控管代码获取主管空管名称
            String zgkgDm = syxx.getZgkgDm();
            String sql = "select mc from dm_swbm where swbmbm="+zgkgDm;
            String zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
            syxx.setZgkgMc(zgkgMc);
            //根据登记注册类型代码获取登记注册类型名称
            String zclxDm = syxx.getZclxDm();
            String zclxMc = Zclx.getMcByDm(zclxDm);
            syxx.setZclxMc(zclxMc);
            //根据行业代码获取行业名称
            String hyDm = syxx.getHyDm();
            String hyMc = Hylx.getMcByDm(hyDm);
            syxx.setHyMc(hyMc);
            //根据土地使用状态代码获取土地使用状态名称
            String tdsyztDm = syxx.getTdsyztDm();
            String tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
            syxx.setTdsyztMc(tdsyztMc);
            //根据土地登记代码获取土地登记名称
            String tddj = syxx.getTddj();
            String tddjMc = Tdjb.getMcByDm(tddj);
            syxx.setTddjMc(tddjMc);
            //根据房屋性质代码获取房屋性质名称
            String fwxzDm = syxx.getFwxzDm();
            String fwxzMc = Fwxz.getMcByDm(fwxzDm);
            syxx.setFwxzMc(fwxzMc);
            //根据自用或者租用代码获取名称
            String zyhczDm = syxx.getZyhczDm();
            String zyhczMc = Fwsyzt.getMcByDm(zyhczDm);
            syxx.setZyhczMc(zyhczMc);
            //根据是否已核查代码获取名称
            String ishc = syxx.getIshc();
            ishc = Ishc.getMcByDm(ishc);
            syxx.setIshc(ishc);
        }

        xml.append(xmlBuildHelper.voToXml(syxx));

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }
}
