package cn.gtmap.landtax.web.ydqc;

/**
 * Created by Administrator on 2014/9/2.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;

/**
 * .
 * <p/>
 * 税源宗地数据对比疑点清册
 * @author xuchao
 * @version V1.0, 2014/9/2
 */
@Controller
@RequestMapping("/ydqc/sb")
public class SbYdqcController {
    @Autowired
    YdqcService ydqcService;
    @Autowired
    TaxService taxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("getSyListByGlbm")
    public String getSyListByGlbm(Model model,String glbm){
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByGlbm(glbm,Szdm.CZTDSYS.toString());
        model.addAttribute("syxx",syxx);
        model.addAttribute("glbm",glbm);
        return "landtax/ydqc/sb/syxx";
    }

    @RequestMapping("getSbListByGlbm")
    public String getSbListByGlbm(Model model,SbZsQuery sbZsQuery){
        List<HashMap<String,Object>> syxx = taxService.getSbSyxxListByGlbm(sbZsQuery,Szdm.CZTDSYS.toString());
        model.addAttribute("glbm",sbZsQuery.getGlbm());
        model.addAttribute("syxx",syxx);
        return "landtax/ydqc/sb/sbSyxx";
    }

    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String ydqcId){
        String result = "true";
        String[] ydqcIdArr = ydqcId.split(",");
        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("土地税申报疑点核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.TDSBJSYDQC.toString());
        swHcXm.setXmybj("0");

        hcxmService.createSbydqcHcxm(swHcXm, ydqcIdArr, Szdm.CZTDSYS.toString());
        return result;
    }
    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,String proid) {
        List<SwDjSyTemp> swDjSyTempList =  ydqcService.findSytzByProid(proid);
        model.addAttribute("swDjSyTempList",swDjSyTempList);
        model.addAttribute("proid",proid);
        return "landtax/ydqc/sb/sbSyxxTz";
    }

    @RequestMapping("/tdXgsqb")
    public String tdXgsqb(Model model,String proid) {
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
            String ydqcId = swHcXmRwRel.getBdId();
            SSjSbydqcTd sSjSbydqcTd = baseRepository.get(SSjSbydqcTd.class,ydqcId);
            if(sSjSbydqcTd!=null){
                tdSbXgsqb.setGlbm(sSjSbydqcTd.getGlbm());
                tdSbXgsqb.setYnmj(sSjSbydqcTd.getYnmj());
                tdSbXgsqb.setNynse(sSjSbydqcTd.getYjse());
                tdSbXgsqb.setSbse(sSjSbydqcTd.getSbse());
                tdSbXgsqb.setCyje(sSjSbydqcTd.getCyje());
            }
            //初始税务机关和税管员
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userVo = sysUserService.getUserVo(userId);
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            //根据地区码，获取主管税务机关列表
            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }
        model.addAttribute("syxx",tdSbXgsqb);
        return "landtax/ydqc/sb/tdXgsqb";
    }

    @RequestMapping("/tdXgsqb/save")
    @ResponseBody
    public Object saveTdXgsqb(Model model,TdSbXgsqb tdSbXgsqb) {

        ResponseMessage responseMessage = new ResponseMessage();
       try {
           ydqcService.saveOrUpdateTdSbXgsqb(tdSbXgsqb);
           responseMessage.setMsg("保存成功");
       }catch (Exception e){
           responseMessage.setMsg("保存失败");
       }
        return responseMessage;
    }



    @RequestMapping("sbsyList")
    public String sbsyList(Model model,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjSbydqcTd sSjSbydqcTd = baseRepository.get(SSjSbydqcTd.class,ydqcId);
        String ssnf = sSjSbydqcTd.getSsnf();
        String sssq = sSjSbydqcTd.getSssq();
        SbZsQuery sbZsQuery = new SbZsQuery();
        sbZsQuery.setYear(ssnf);
        sbZsQuery.setJdlx(sssq);
        sbZsQuery.setGlbm(sSjSbydqcTd.getGlbm());
        return getSbListByGlbm(model,sbZsQuery);
    }

    /**
     *
     */
    @RequestMapping("getZtById")
    @ResponseBody
    public Object getZtById(Model model,String id,String hcxmlx) {
        return ydqcService.getZtById(id,hcxmlx);
    }

    @RequestMapping("getFcSyListByGlbm")
    public String getFcSyListByGlbm(Model model,String glbm){
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByGlbm(glbm,Szdm.FCS.toString());
        model.addAttribute("syxx",syxx);
        model.addAttribute("glbm",glbm);
        return "landtax/ydqc/sb/fcsyxx";
    }

    @RequestMapping("getFcSbListByGlbm")
    public String getFcSbListByGlbm(Model model,SbZsQuery sbZsQuery){
        List<HashMap<String,Object>> syxx = taxService.getSbSyxxListByGlbm(sbZsQuery,Szdm.FCS.toString());
        model.addAttribute("glbm",sbZsQuery.getGlbm());
        model.addAttribute("syxx",syxx);
        return "landtax/ydqc/sb/fcsbSyxx";
    }

    @RequestMapping("fcxjxm")
    @ResponseBody
    public Object fcxjxm(Model model,String hcxmMc,String ydqcId){
        String result = "true";
        String[] ydqcIdArr = ydqcId.split(",");
        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("土地税申报疑点核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.FCSBJSYDQC.toString());
        swHcXm.setXmybj("0");
        hcxmService.createSbydqcHcxm(swHcXm, ydqcIdArr, Szdm.FCS.toString());
        return result;
    }

    @RequestMapping("/fcXgsqb")
    public String fcXgsqb(Model model,String proid) {
        TdSbXgsqb tdSbXgsqb = baseRepository.get(TdSbXgsqb.class,proid);
        if(tdSbXgsqb==null){
            tdSbXgsqb = new TdSbXgsqb();
            tdSbXgsqb.setProid(proid);
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
            String ydqcId = swHcXmRwRel.getBdId();
            SSjSbydqcFc sSjSbydqcFc = baseRepository.get(SSjSbydqcFc.class,ydqcId);
            if(sSjSbydqcFc!=null){
                tdSbXgsqb.setGlbm(sSjSbydqcFc.getGlbm());
                tdSbXgsqb.setNynse(sSjSbydqcFc.getYjse());
                tdSbXgsqb.setSbse(sSjSbydqcFc.getSbse());
                tdSbXgsqb.setCyje(sSjSbydqcFc.getCyje());
            }
            //初始税务机关和税管员
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userVo = sysUserService.getUserVo(userId);
            if(userVo!=null){
                tdSbXgsqb.setSgydm(userId);
                tdSbXgsqb.setSgymc(userVo.getUserName());
            }
            String regionCode = sysUserService.getRegionCodeByUserId(userId);
            if(regionCode.length()>6){
                regionCode = regionCode.substring(0,6);
            }
            //根据地区码，获取主管税务机关列表

            String whereClause = "where swbmbm like '2"+regionCode+"%'";
            String sql = "select swbmbm,mc from dm_swbm "+whereClause;
            List swjgList= baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
            if(CollectionUtils.isNotEmpty(swjgList)){
                String swjgdm = String.valueOf(((Object[])swjgList.get(0))[0]);
                String swjgmc = String.valueOf(((Object[])swjgList.get(0))[1]);
                tdSbXgsqb.setSwjgdm(swjgdm);
                tdSbXgsqb.setSwjgmc(swjgmc);
            }
        }
        model.addAttribute("syxx",tdSbXgsqb);
        return "landtax/ydqc/sb/tdXgsqb";
    }

    @RequestMapping("fcsbsyList")
    public String fcsbsyList(Model model,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String ydqcId = swHcXmRwRel.getBdId();
        SSjSbydqcFc sSjSbydqcFc = baseRepository.get(SSjSbydqcFc.class,ydqcId);
        String ssnf = sSjSbydqcFc.getSsnf();
        String sssq = sSjSbydqcFc.getSssq();
        SbZsQuery sbZsQuery = new SbZsQuery();
        sbZsQuery.setYear(ssnf);
        sbZsQuery.setJdlx(sssq);
        sbZsQuery.setGlbm(sSjSbydqcFc.getGlbm());
        return getFcSbListByGlbm(model,sbZsQuery);
    }
}
