package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.Hylx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.dictionary.Tdjb;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import com.gtis.web.SessionUtil;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Controller
@RequestMapping("/tj/hz")
public class SyHzController {
    @Autowired
    TjService tjService;
    @Autowired
    TaxService taxService;
    @Autowired
    DicServiceImpl dicServiceImpl;
    @Autowired
    DwxxService dwxxService;
    //城镇土地使用税税源汇总台账（不含可转化税源）
    @RequestMapping("tdExcKzh")
    public String tdExcKzh(Model model) {
        return "landtax/tj/hz/tdExcKzh";
    }
    //城镇土地使用税税源汇总台账（不含未登记户和可转化税源）
    @RequestMapping("tdExcKzhAndLzlg")
    public String tdExcKzhAndLzlg(Model model) {
        return "landtax/tj/hz/tdExcKzhAndLzlg";
    }
    //房产税税源汇总台账（不含可转化税源）
    @RequestMapping("fcExcKzh")
    public String fcExcKzh(Model model) {
        return "landtax/tj/hz/fcExcKzh";
    }
    //房产税税源汇总台账（不含未登记户和可转化税源）
    @RequestMapping("fcExcKzhAndLzlg")
    public String fcExcKzhAndLzlg(Model model) {
        return "landtax/tj/hz/fcExcKzhAndLzlg";
    }
    //征管系统土地税征收台账
    @RequestMapping("tdExcZgNsrZs")
    public String tdExcZgNsrZs(Model model) {
        return "landtax/tj/hz/tdExcZgNsrZs";
    }
    //征管系统房产税征收台账
    @RequestMapping("fcExcZgNsrZs")
    public String fcExcZgZs(Model model) {
        return "landtax/tj/hz/fcExcZgNsrZs";
    }
    //城镇土地使用税和房产税税源核查进度统计表
    @RequestMapping("tdfcHcjdTj")
    public String tdfcHcjdTj(Model model, String beginRq, String endRq) {
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank(beginRq))
            beginRq = (sdf.format(dt)).substring(0, 4) + "-01-01";
        if (StringUtils.isBlank(endRq))
            endRq = sdf.format(dt);
        List<HashMap> list = (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
        model.addAttribute("listData",list);
        model.addAttribute("beginRq", beginRq);
        model.addAttribute("endRq", endRq);
        return "landtax/tj/hz/tdfcHcjdTj";
    }

    //基础统计表
    @RequestMapping("baseTj")
    public String baseTj(Model model, String tag, String reportName, String colJson, String headPagePath, String excelTemplate, String excelXml) {
        model.addAttribute("tag",tag);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
        }
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        model.addAttribute("regionCode",regionCode);
        return "landtax/tj/hz/baseTj";
    }

    @RequestMapping("tdExcKzhJson")
    @ResponseBody
    public Object tdExcKzhJson(Model model,Pageable request) {
        return tjService.tdExcKzhJson(request);
    }

    @RequestMapping("exptdExcKzhSyhzF")
    public String expExcTdSyhzF(HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getTdSyhzF();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[10];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                        strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                        strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                        strs[3] = String.valueOf(tempMap.get("ZDMJ")==null?"":tempMap.get("ZDMJ"));
                        strs[4] = String.valueOf(tempMap.get("YSMJ")==null?"":tempMap.get("YSMJ"));
                        strs[5] = String.valueOf(tempMap.get("MSMJ")==null?"":tempMap.get("MSMJ"));
                        strs[6] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                        strs[7] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                        strs[8] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                        strs[9] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("tdsyhzf.xls"); //
            eb.setExcelXml("tdsyhzf.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("tdExcKzhAndLzlgJson")
    @ResponseBody
    public Object tdExcKzhAndLzlgJson(Model model,Pageable request) {
        return tjService.tdExcKzhAndLzlgJson(request);
    }

    @RequestMapping("expExctdExcKzhAndLzlg")
    public String expExctdExcKzhAndLzlg(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getTdSyhzS();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[10];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("ZDMJ")==null?"":tempMap.get("ZDMJ"));
                    strs[4] = String.valueOf(tempMap.get("YSMJ")==null?"":tempMap.get("YSMJ"));
                    strs[5] = String.valueOf(tempMap.get("MSMJ")==null?"":tempMap.get("MSMJ"));
                    strs[6] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[7] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[8] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[9] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("tdsyhzs.xls"); //
            eb.setExcelXml("tdsyhzs.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("fcExcKzhJson")
    @ResponseBody
    public Object fcExcKzhJson(Model model,Pageable request) {
        return tjService.fcExcKzhJson(request);
    }

    @RequestMapping("expExcfcExcKzh")
    public String expExcfcExcKzh(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getFcSyhzF();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[15];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("FCYZ")==null?"":tempMap.get("FCYZ"));
                    strs[4] = String.valueOf(tempMap.get("FCYZ_YS")==null?"":tempMap.get("FCYZ_YS"));
                    strs[5] = String.valueOf(tempMap.get("FCYZ_MS")==null?"":tempMap.get("FCYZ_MS"));
                    strs[6] = String.valueOf(tempMap.get("NZJ")==null?"":tempMap.get("NZJ"));
                    strs[7] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[8] = String.valueOf(tempMap.get("YNSE_ZY")==null?"":tempMap.get("YNSE_ZY"));
                    strs[9] = String.valueOf(tempMap.get("YNSE_CZ")==null?"":tempMap.get("YNSE_CZ"));
                    strs[10] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[11] = String.valueOf(tempMap.get("ZY_MSSE")==null?"":tempMap.get("ZY_MSSE"));
                    strs[12] = String.valueOf(tempMap.get("CZ_MSSE")==null?"":tempMap.get("CZ_MSSE"));
                    strs[13] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[14] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("fcsyhzf.xls"); //
            eb.setExcelXml("fcsyhzf.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("fcExcKzhAndLzlgJson")
    @ResponseBody
    public Object fcExcKzhAndLzlgJson(Model model,Pageable request) {
        return tjService.fcExcKzhAndLzlgJson(request);
    }

    @RequestMapping("expExcfcExcKzhAndLzlg")
    public String expExcfcExcKzhAndLzlg(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getFcSyhzS();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[15];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("FCYZ")==null?"":tempMap.get("FCYZ"));
                    strs[4] = String.valueOf(tempMap.get("FCYZ_YS")==null?"":tempMap.get("FCYZ_YS"));
                    strs[5] = String.valueOf(tempMap.get("FCYZ_MS")==null?"":tempMap.get("FCYZ_MS"));
                    strs[6] = String.valueOf(tempMap.get("NZJ")==null?"":tempMap.get("NZJ"));
                    strs[7] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[8] = String.valueOf(tempMap.get("YNSE_ZY")==null?"":tempMap.get("YNSE_ZY"));
                    strs[9] = String.valueOf(tempMap.get("YNSE_CZ")==null?"":tempMap.get("YNSE_CZ"));
                    strs[10] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[11] = String.valueOf(tempMap.get("ZY_MSSE")==null?"":tempMap.get("ZY_MSSE"));
                    strs[12] = String.valueOf(tempMap.get("CZ_MSSE")==null?"":tempMap.get("CZ_MSSE"));
                    strs[13] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[14] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("fcsyhzs.xls"); //
            eb.setExcelXml("fcsyhzs.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("tdExcZgNsrZsJson")
    @ResponseBody
    public Object tdExcZgNsrZsJson(Model model,Pageable request) {
        return tjService.tdExcZgNsrZsJson(request);
    }
    @RequestMapping("fcExcZgNsrZsJson")
    @ResponseBody
    public Object fcExcZgNsrZsJson(Model model,Pageable request) {
        return tjService.fcExcZgNsrZsJson(request);
    }

    @RequestMapping("tdfcHcjdTjData")
    @ResponseBody
    public Object tdfcHcjdTjData(Model model, String beginRq, String endRq) {
        return (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
    }

    // 获取统计报表的数据
    @RequestMapping("tjJson")
    @ResponseBody
    public Object tjJson(Model model,Pageable request, String tag, String param) {
        HashMap queryFilter = null;
        try {
            if (param != null) {
                JSONArray jsonArray = JSONArray.fromObject("[" + param + "]");
                HashMap[] hashMaps = (HashMap[]) JSONArray.toArray(jsonArray, HashMap.class);
                if (hashMaps != null && hashMaps.length > 0) {
                    queryFilter = hashMaps[0];
                }
            }
        } catch (Exception e){

        }
        return tjService.getTjJson(request, tag, queryFilter);
    }

    // 导出Excel
    @RequestMapping("exportExcelTd")
    public String exportExcelTd(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            List<SwDjSyQuery> swDjSyQueryList = new ArrayList<SwDjSyQuery>();
            // 判断是checkbox导出，还是查询导出
            //计算合计
            String hjZdmj = "";
            String hjYnmj = "";
            String hjYnse = "";
            String hjMsmj = "";
            String hjMsse = "";
            Object[] objArr = null;
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
                objArr = tjService.lzlgTdHjByTdIds(ids);

            } else {
                param.put("swDjSyQuery",swDjSyQuery);
                objArr = tjService.lzlgTdHj(swDjSyQuery);
            }
            hjZdmj = String.valueOf(objArr[0]);
            hjYnmj = String.valueOf(objArr[1]);
            hjYnse = String.valueOf(objArr[2]);
            hjMsmj = String.valueOf(objArr[3]);
            hjMsse = String.valueOf(objArr[4]);

            request.setAttribute("hjZdmj",String.valueOf(hjZdmj));
            request.setAttribute("hjYnmj",String.valueOf(hjYnmj));
            request.setAttribute("hjYnse",String.valueOf(hjYnse));
            request.setAttribute("hjMsmj",String.valueOf(hjMsmj));
            request.setAttribute("hjMsse",String.valueOf(hjMsse));

            swDjSyQueryList = tjService.getLzlgTdList(param);
            List<String[]> retList = this.getStrList(swDjSyQueryList); // 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", "汇总日期："+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year","所属年份："+new SimpleDateFormat("yyyy").format(new Date()));
            request.setAttribute("hzdw","汇总单位：汉中市地税局");

            eb.setGroupMap(map);
            eb.setExcelTemplate("lzlghTd.xls"); //
            eb.setExcelXml("lzlghTd.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelTj")
    public String exportExcelTj(HttpServletRequest request, String tag, Object param) throws Exception {
        try {
            HashMap queryFilter = null;
            try {
                queryFilter = (HashMap)param;
            } catch (Exception e){

            }
            TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            String[] fieldList = tjBaseParamVo.getExportFieldList().split(",");
            List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryFilter);
            List<String[]> retList = new ArrayList<String[]>(); // 组织参数
            for (int i = 0; i < list.size(); i++) {
                HashMap tempVo = list.get(i);
                if (tempVo != null) {
                    String[] strs = new String[fieldList.length];
                    for (int j = 0; j < fieldList.length; j++){
                        if (tempVo.get(fieldList[j].toString()) != null) {
                            strs[j] = tempVo.get(fieldList[j].toString()).toString();
                        } else if (fieldList[j].toString().equals("XH")) {
                            strs[j] = String.valueOf((i + 1));
                        }
                    }
                    retList.add(strs);
                }
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", ""+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year",""+new SimpleDateFormat("yyyy").format(new Date()));
            request.setAttribute("hzdw","汉中市地税局");

            eb.setGroupMap(map);
            eb.setExcelTemplate(tjBaseParamVo.getExcelTemplate()); //
            eb.setExcelXml(tjBaseParamVo.getExcelXml()); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<String[]> getStrList(List<SwDjSyQuery> list) {
        List<String[]> retList = new ArrayList<String[]>();
        for (int i = 0; i < list.size(); i++) {
            SwDjSyQuery tempVo = list.get(i);
            if (tempVo != null) {
                String[] strs = new String[20];
                for (int j = 0; j < strs.length; j++) {
                    strs[j] = "";
                }
                strs[0] = String.valueOf(i + 1);

                if (StringUtils.isNotBlank(tempVo.getGlbm())) {
                    strs[1] = tempVo.getGlbm();
                }

                if (StringUtils.isNotBlank(tempVo.getNsrmc())) {
                    strs[2] = tempVo.getNsrmc();
                }
                if (StringUtils.isNotBlank(tempVo.getDjh())) {
                    strs[3] = tempVo.getDjh();
                }
                if (StringUtils.isNotBlank(tempVo.getDbh())) {
                    strs[4] = tempVo.getDbh();
                }
                if (StringUtils.isNotBlank(tempVo.getTdzl())) {
                    strs[5] = tempVo.getTdzl();
                }

                if (tempVo.getYnmj()!=null){
                    strs[7] = String.valueOf(tempVo.getYnmj());
                }
                if (StringUtils.isNotBlank(tempVo.getTddj())) {
                    strs[8] = tempVo.getTddj();
                }
                if (tempVo.getDwse()!=null) {
                    strs[9] = String.valueOf(tempVo.getDwse());
                }
                if (tempVo.getNynseTd()!=null) {
                    strs[10] = String.valueOf(tempVo.getNynseTd());
                }
                if (tempVo.getMsmj()!=null) {
                    strs[11] = String.valueOf(tempVo.getMsmj());
                }
                if (tempVo.getTddj()!=null) {
                    strs[12] = String.valueOf(tempVo.getTddj());
                }
                if (tempVo.getDwse()!=null) {
                    strs[13] = String.valueOf(tempVo.getDwse());
                }
                //计算strs[6]
                Double ynmj = 0.0;
                Double msmj = 0.0;
                if(StringUtils.isNotBlank(strs[7])){
                    ynmj =  Double.parseDouble(strs[7]);
                }
                if(StringUtils.isNotBlank(strs[11])){
                    msmj = Double.parseDouble(strs[11]);
                }
                strs[6] = String.valueOf(ynmj+msmj);

                //计算strs[14]
                Double dwse = 0.0;
                if(StringUtils.isNotBlank(strs[13])){
                    dwse = Double.parseDouble(strs[13]);
                }
                strs[14] = String.valueOf(msmj*dwse);

                strs[15] = "";
                strs[16] = "";
                strs[17] = "";

                if (StringUtils.isNotBlank(tempVo.getZgkgMc())) {
                    strs[18] = tempVo.getZgkgMc();
                }
                if (StringUtils.isNotBlank(tempVo.getSgyMc())){
                    strs[19]  =tempVo.getSgyMc();
                }
                retList.add(strs);
            }
        }

        return retList;
    }

    @RequestMapping("exportExceltdfcHcjdTj")
    public String exportExceltdfcHcjdTj(HttpServletRequest request, String beginRq, String endRq) throws Exception {
        try {
            List<HashMap> list = (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
            List<String[]> retList = this.getStrListHashMap(list); // 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", "汇总日期："+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year","所属年份："+new SimpleDateFormat("yyyy").format(new Date()));

            eb.setGroupMap(map);
            eb.setExcelTemplate("tdfcHcjdTj.xls"); //
            eb.setExcelXml("tdfcHcjdTj.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<String[]> getStrListHashMap(List<HashMap> list) {
        List<String[]> retList = new ArrayList<String[]>();
        for (int i = 0; i < list.size(); i++) {
            HashMap tempVo = list.get(i);
            if (tempVo != null) {
                String[] strs = new String[20];
                strs[0] = tempVo.get("DWMC").toString();
                strs[1] = tempVo.get("TDHCZHS").toString();
                strs[2] = tempVo.get("TDSBBSH").toString();
                strs[3] = tempVo.get("TDLZLGH").toString();
                strs[4] = tempVo.get("TDMJ").toString();
                strs[5] = tempVo.get("YSTDMJ").toString();
                strs[6] = tempVo.get("TDYNSE").toString();
                strs[7] = tempVo.get("TDNSE").toString();
                strs[8] = tempVo.get("FCHCZHS").toString();
                strs[9] = tempVo.get("FCSBBSH").toString();
                strs[10] = tempVo.get("FCLZLGH").toString();
                strs[11] = tempVo.get("FCYZ").toString();
                strs[12] = tempVo.get("ZJSR").toString();
                strs[13] = tempVo.get("FCYNSE").toString();
                strs[14] = tempVo.get("FCNSE").toString();
                retList.add(strs);
            }
        }

        return retList;
    }

    @RequestMapping("zhfx")
    public String zhfx(Model model) throws Exception{
        Map hylxMap = dicServiceImpl.buildEnumMap("Hylx");
        model.addAttribute("hylxMap",hylxMap);

        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        List allSwjgList = new ArrayList();
        if(regionCode.length()==4){//市
            model.addAttribute("issj",true);
        }else if(regionCode.length()==6){//区县
            model.addAttribute("issj",false);
            allSwjgList = (List) taxService.getSgjgByQx(regionCode);
        }
        model.addAttribute("dwList",allQxList);
        model.addAttribute("swjgList",allSwjgList);

        return "landtax/tj/hz/zhfx";

    }

    //税源分析，根据行业性质进行查询和统计
    @RequestMapping("hyxzFx")
    public String hyxzFx(Model model,String hydm,String sylx,String nf) throws Exception{

        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        List<String> queryHydmList = new ArrayList<String>();
        if(StringUtils.isNotBlank(hydm)){
            String[] queryHydmArr = hydm.split(",");
            queryList = (List) taxService.tjNynseByHylx(queryHydmArr, sylx,nf);
        }
        model.addAttribute("queryList",queryList);
        if(Sylx.TDSY.toString().equals(sylx)){
            return "landtax/tj/hz/tdHyxzFx";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            return "landtax/tj/hz/fcHyxzFx";
        }
        return null;
    }

    @RequestMapping("hyxzFx/chart")
    @ResponseBody
    public Object hyxzFxChart(String hydm,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(hydm)){
            String[] queryHydmArr = hydm.split(",");
            if(Sylx.TDSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.TDSY.toString(),nf);
            }else if(Sylx.FCSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.FCSY.toString(),nf);
            }
        }
        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("HY_MC")));
            nynseData.add(tempMap.get("SUMNYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }
        Map nynseMap = new HashMap();
        nynseMap.put("name","年应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);

        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);

        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }


    //税源分析，根据行业性质进行查询和统计
    @RequestMapping("sgjgFx")
    public String sgjgFx(Model model,String sylx,String qx,String swjg,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(qx)){
            String[] queryQx = qx.split(",");
            queryList = taxService.tjNynseByQx(sylx,queryQx,nf);
        }else if (StringUtils.isNotBlank(swjg)){
            String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);
        }

        model.addAttribute("queryList",queryList);
        return "landtax/tj/hz/tdSgjgFx";
    }

    @RequestMapping("sgjgFx/chart")
    @ResponseBody
    public Object sgjgFxChart(String qx,String swjg,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(qx)){
            String[] queryQx = qx.split(",");
            queryList = taxService.tjNynseByQx(sylx,queryQx,nf);
        }else if (StringUtils.isNotBlank(swjg)){
            String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("DWMC")));
            nynseData.add(tempMap.get("SUMNYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }
        Map nynseMap = new HashMap();
        nynseMap.put("name","年应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);
        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }

    //税源变化分析
    @RequestMapping("sybhFx")
    public String sybhFx(Model model,String sylx,String nf) throws Exception{

        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isBlank(sylx)){
            sylx = Sylx.TDSY.toString();
        }
        if(StringUtils.isBlank(nf)){
            nf = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }

        queryList = taxService.tjSybhfx(sylx,nf);
        model.addAttribute("queryList",queryList);
        model.addAttribute("sylx",sylx);
        model.addAttribute("nf",nf);

            return "landtax/tj/hz/tdSybhFx";

    }

    @RequestMapping("sybhFx/chart")
    @ResponseBody
    public Object sybhFxChart(Model model,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isBlank(sylx)){
            sylx = Sylx.TDSY.toString();
        }
        if(StringUtils.isBlank(nf)){
            nf = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }
        queryList = taxService.tjSybhfx(sylx,nf);

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("YF")));
            nynseData.add(tempMap.get("SUMYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }

        Map nynseMap = new HashMap();
        nynseMap.put("name","月应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","月已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);
        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }


}
