package cn.gtmap.landtax.web.syhc;/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.*;

/**
 * .
 * <p/>
 * 国土宗地未核查列表，及其核查情况
 * @author shenjian
 * @version V1.0, 2014/8/19
 */
@Controller
@RequestMapping("/syhc/zdhc")
public class ZdhcController {


    @Autowired
    ZdhcService zdhcService;

    @Autowired
    TaxService taxService;
    @Autowired
    ZdService zdService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TddjtzService tddjtzService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    DwxxService dwxxService;

    /**
     * 未核查国土宗地列表
     * @param model
     * @return
     */
    @RequestMapping("whclb")
    public String whclb(Model model){
        zdhcService.isShowBtnByRoleName("zdhcDelBtnRoleName","zdhcAutoCreRoleName","zdhcCreateRoleName",model);
        model.addAttribute("showJd","true");
        return "landtax/syhc/zdhc/zdwhclb";
    }

    @RequestMapping("whclbJson")
    @ResponseBody
    public Page whclbJson(Model model,String xzqbh,String lx,Pageable request,GtSwTzQuery sSjGtbd) {
        model.addAttribute("xzq",xzqbh);
        return tddjtzService.findGtppxxMap(xzqbh, lx, request, sSjGtbd);
    }

    @RequestMapping("yxflb")
    public String yxflb(Model model){
        return "landtax/syhc/zdhc/zdyxflb";
    }

    @RequestMapping("yxflbJson")
    @ResponseBody
    public Page<GtSwTzQuery> yxflbJson(Model model,Pageable request,GtSwTzQuery sSjGtbd) {
        return zdhcService.yxflbJson(request, sSjGtbd);
    }

    @RequestMapping("exportExcelTz")
    public String exportExcelTz(String xzqbh,GtSwTzQuery sSjGtbd,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("xzqbh",xzqbh);
            param.put("lx","0");
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("sSjGtbd",sSjGtbd);
            }
            List<GtSwTzQuery> whczdList = zdhcService.getWhczdList(param);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = sSjGtbd.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(whczdList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                GtSwTzQuery gtSwTzQuery = whczdList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = gtSwTzQuery.getDjh();
                tempArr[2] = new BigDecimal(String.valueOf(gtSwTzQuery.getScmj() == null ? "0" : gtSwTzQuery.getScmj())).setScale(2, BigDecimal.ROUND_DOWN).toString();
                tempArr[3] = gtSwTzQuery.getTdytMc();
                tempArr[4] = gtSwTzQuery.getTdzl();
                tempArr[5] = gtSwTzQuery.getQlrmc();
                //根据gtbdId获取任务节点
                String statue = String.valueOf(((HashMap)zdhcService.getZtByGtbdId(gtSwTzQuery.getGtbdId())).get("statue"));
                String userName = String.valueOf(((HashMap)zdhcService.getZtByGtbdId(gtSwTzQuery.getGtbdId())).get("userName"));
                String ppzt = gtSwTzQuery.getPpzt();
                if("0".equals(statue)){
                    tempArr[6] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[6] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[6] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[6] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[6] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[6] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[6] = "已办结";
                }
                tempArr[7] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("wppzdTz.xls"); //
            eb.setExcelXml("wppzdTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    /**
     *新建国土宗地信息核查项目
     * @param model
     * @param hcxmMc
     * @param djhs
     * @return
     */
    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String djhs,GtSwTzQuery gtSwTzQuery,String xzqbh,String lx){
        String result = "true";
        List<SSjGtbd> sSjGtbdList=null;
        if(StringUtils.isNotBlank(djhs)){
            String[] djhArray = djhs.split(",");
            sSjGtbdList = zdhcService.getDxfGtbdByDjh(djhArray);
        }else{
            sSjGtbdList = zdhcService.findGtppxxList(xzqbh, lx, gtSwTzQuery);
        }

        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("国土宗地核查项目"+Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.ZDHC.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        hcxmService.createGtzdHcxm(swHcXm,sSjGtbdList,userId);
        return result;
    }

    @RequestMapping("/sybl/findZdhcrw")
    @ResponseBody
    public String zdhcrwByDjh(Model model,String djh){
        String msg = "";
        String sqlZdhc = "SELECT t2.DJH " +
                        "FROM SW_HC_XM_RW_REL t " +
                        "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                        "     LEFT JOIN S_SJ_GTBD t2 ON t.BD_ID=t2.GTBD_ID " +
                        "WHERE t1.XMLX='" + Hcxmlx.ZDHC.toString() + "' AND t.BLZT <> 1 AND t2.DJH='" + djh + "'";
        Query queryZdhc = baseRepository.getEntityManager().createNativeQuery(sqlZdhc);
        queryZdhc.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listZdhc = queryZdhc.getResultList();
        if(CollectionUtils.isNotEmpty(listZdhc)){
            msg = "1";
        }

        String sqlSybl = "SELECT t.* " +
                "FROM SW_HC_XM_RW_REL t " +
                "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                "WHERE t1.XMLX='" + Hcxmlx.SYBL.toString() + "' AND t.BLZT <> 1 AND t.BD_ID='" + djh + "'";
        Query querySybl = baseRepository.getEntityManager().createNativeQuery(sqlSybl);
        querySybl.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listSybl = querySybl.getResultList();
        if(CollectionUtils.isNotEmpty(listSybl)){
            msg = "2";
        }
        return msg;
    }

    @RequestMapping("/sybl/xjxm")
    @ResponseBody
    public Object syblXjxm(Model model,String hcxmMc,String djh){
        Zd zd = zdService.findZdByDjh(djh);

        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc("税源数据补录"+zd.getQlrmc());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.SYBL.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        return hcxmService.createSyblHcxm(swHcXm,zd,userId);
    }

    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,@RequestParam String wiid) {
        if(hcxmService.isYbjByProid(wiid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        //根据wiid获取关联对象
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(wiid);
        model.addAttribute("swHcXmRwRel",swHcXmRwRel);

        String xmlx = swHcXmRwRel.getSwHcXm().getXmlx();
        String djh = "";
        if (Hcxmlx.ZDHC.toString().equals(xmlx)) {
            SSjGtbd sSjGtbd = zdhcService.getGtbdById(swHcXmRwRel.getBdId());
            djh = sSjGtbd.getDjh();
        } else if (Hcxmlx.SYBL.toString().equals(xmlx)) {
            djh = swHcXmRwRel.getBdId();
        }

        Zd zd = baseRepository.get(Zd.class,djh);
        if (zd.getScmjZd() != null) {
            zd.setScmjZd(zd.getScmjZd().setScale(2, BigDecimal.ROUND_DOWN));
        }
        model.addAttribute("zd",zd);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        model.addAttribute("swDjSyList",swDjSyList);
        //根据djh获取已录税源列表
        List<SwDjSyQuery> rkSwDjSyList = taxService.getSwDjSyByDjh(djh);
        model.addAttribute("rkSwDjSyList",rkSwDjSyList);

        //根据djh获取税源核查面积之和
        HashMap scmjMap = zdhcService.getSyScmjSumByDjh(djh);

        model.addAttribute("sumScmj",scmjMap.get("SUMSCMJ"));

        if (zd.getScmjZd() == null || zd.getScmjZd().equals(new BigDecimal(0))) {
            model.addAttribute("mjbl", "--");
        } else {
            BigDecimal sumScmj = new BigDecimal(scmjMap.get("SUMSCMJ").toString());
            String mjbl = sumScmj.multiply(new BigDecimal(100)).divide(zd.getScmjZd(), 2, BigDecimal.ROUND_HALF_UP).toString();
            model.addAttribute("mjbl", mjbl + "%");
        }
        return "landtax/syhc/zdhc/sytz";
    }


    @RequestMapping("input")
    public String input(Model model,String djh,String tdId,String fcId,String shxrId){
        Zd zd = zdService.findZdByDjh(djh);

        if (zd.getSgqdm() == null) {
            UserInfo user = SessionUtil.getCurrentUser();
            String regionCode = user.getRegionCode();
            zd.setSgqdm(regionCode);
        }
        model.addAttribute("zd",zd);

        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId, fcId);
        syxx.setDbh(taxService.createDbhByDjh(djh));
        syxx.setShxrId(shxrId);


        if(StringUtils.isBlank(syxx.getTddj())){
            syxx.setTddj(zd.getTddj());
            String dwseStr = taxService.getDwseByTddj(zd.getTddj());
            if(StringUtils.isNotBlank(dwseStr)){
                syxx.setDwse(new BigDecimal(dwseStr));
            }
        }
        if(syxx.getJsbl()==null || BigDecimal.ZERO.equals(syxx.getJsbl())){
            BigDecimal jsbl = new BigDecimal(AppConfig.getProperty("jsbl"));
            syxx.setJsbl(jsbl);
        }

        String xian = "";
        String zhen = "";
        try{
            xian = dwxxService.getDwxxByDwdm(djh.substring(0,6)).getDwmc();
        }catch (Exception e){}
        try {
            zhen = dwxxService.getDwxxByDwdm(djh.substring(0, 9)).getDwmc();
        }catch (Exception e){}
        syxx.setFczlXian(xian);
        syxx.setFczlZhen(zhen);

        model.addAttribute("syxx",syxx);
        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByDjhLike(djh);
        model.addAttribute("tddjList",tddjList);

        return "landtax/ydqc/zd/syxxMenu";
    }

    @RequestMapping("save")
    @ResponseBody
    public Object save(Model model,SwDjSyQuery swDjSyQuery){
        String msg="";
        try{
            zdhcService.saveSwDjSy(swDjSyQuery);
            msg = "保存成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "保存失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    @RequestMapping("del")
    @ResponseBody
    public Object del(Model model,String syId){
        String msg="";
        try{
            taxService.deleteSwDjSy(syId);
            msg = "删除成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "删除失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    /**
     * 工作流办结事件
     * @param model
     * @param proid
     * @return
     * @throws Exception
     */
    @RequestMapping("/wf/end")
    @ResponseBody
    public String commitSyxg(Model model,String proid) throws  Exception{
        //proid即SwHcXmRwRel.rwId
        hcxmService.wfEnd(proid);
        return "";
    }

    @RequestMapping("/sybl/wf/end")
    @ResponseBody
    public String commitSyblSyxg(Model model,String proid) throws  Exception{
        //proid即SwHcXmRwRel.rwId
        hcxmService.wfEndSybl(proid);
        return "";
    }

    /**
     * 工作流删除事件
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("/wf/del")
    @ResponseBody
    public String delSyxg(Model model,String proid) {
        hcxmService.wfDel(proid);
        return "";
    }

    @RequestMapping("/sybl/wf/del")
    @ResponseBody
    public String delSyblSyxg(Model model,String proid) {
        hcxmService.wfDelSybl(proid);
        return "";
    }

    /**
     * 删除宗地核查项目的某个任务
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("delZdhcRw")
    public Object delZdhcRw(Model model,@RequestParam String proid){
        if(StringUtils.isNotBlank(proid))
            zdhcService.delZdhcRw(proid);
        return null;
    }

    @RequestMapping("getZtByGtbdId")
    @ResponseBody
    public Object getZtByGtbdId(Model model,String gtbdId) {
        return zdhcService.getZtByGtbdId(gtbdId);
    }

    @RequestMapping("getTJrws")
    @ResponseBody
    public Object getTJrws(Model model,GtSwTzQuery sSjGtbd) throws  Exception{
        return zdhcService.getTJrws(sSjGtbd);
    }


    @RequestMapping("delWorkflow")
    @ResponseBody
    public Object delWorkflow(Model model,String sgqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            zdhcService.delWorkflow(sgqdm);
            responseMessage.setMsg("删除成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，删除失败");
        }
        return responseMessage;
    }

    @RequestMapping("/wf/turn")
    @ResponseBody
    public void turnWorkflow(Model model,String proid,HttpServletResponse response) throws  Exception{
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);

        String xmlx = swHcXmRwRel.getSwHcXm().getXmlx();
        String djh = "";
        if (Hcxmlx.ZDHC.toString().equals(xmlx)) {
            SSjGtbd sSjGtbd = zdhcService.getGtbdById(swHcXmRwRel.getBdId());
            djh = sSjGtbd.getDjh();
        } else if (Hcxmlx.SYBL.toString().equals(xmlx)) {
            djh = swHcXmRwRel.getBdId();
        }

        //根据djh获取所有税源的核查面积
        HashMap scmjMap = zdhcService.getSyScmjSumByDjh(djh);
        BigDecimal sumScmj = new BigDecimal(String.valueOf(scmjMap.get("SUMSCMJ"))).setScale(2, BigDecimal.ROUND_DOWN);
        Zd zd = zdService.findZdByDjh(djh);
        String syhcmjbl = AppConfig.getProperty("syhcmjxs");
        if (StringUtils.isBlank(syhcmjbl))
            syhcmjbl = "1";

        BigDecimal zdmj = new BigDecimal(0);
        if (zd.getScmjZd() != null)
            zdmj = zd.getScmjZd().multiply(new BigDecimal(syhcmjbl));
        zdmj = zdmj.setScale(2, BigDecimal.ROUND_DOWN);
        String msg = "";
        if(sumScmj.compareTo(zdmj)==-1){
            msg = "核查面积总和与宗地面积不符！请重新核实核查面积！";
        }

        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        out.println(msg);
    }

    @RequestMapping("autoCreateWorkflow")
    @ResponseBody
    public Object autoCreateWorkflow(Model model,String sgqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            zdhcService.autoCreateWorkflow(sgqdm);
            responseMessage.setMsg("下发成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，下发失败");
        }
        return responseMessage;
    }
}
