package cn.gtmap.landtax.web.syhc;
/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Tdqdfs;
import cn.gtmap.landtax.model.dictionary.Tdyt;
import cn.gtmap.landtax.model.query.HcrwQuery;
import cn.gtmap.landtax.model.query.HcxmQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.PlatUtil;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 * .
 * <p/>
 * 核查项目
 * @author shenjian
 * @version V1.0, 2014/8/19
 */
@Controller
@RequestMapping("/syhc/hcxm")
public class HcxmController {
    @Autowired
    HcxmService hcxmService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    ZdService zdService;
    @Autowired
    SwdjtzService swdjtzService;
    @Autowired
    YdqcService ydqcService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    @Qualifier("SysWorkFlowDefineService")
    private SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    SwDjQsService swDjQsService;


    @RequestMapping("dhcxmlb")
    public String xmlb(Model model){
        return "landtax/syhc/hcxm/dhcxmlb";
    }

    @RequestMapping("dhcxmlbJson")
    @ResponseBody
    public Object getDhcxmlb(Model model,Pageable request,HcxmQuery hcxmQuery) {
        Page<SwHcXm> result = hcxmService.findDhcxm(hcxmQuery,request);
        return result;
    }

    @RequestMapping("dhcrwlb")
    public String dhcrwlb(Model model) throws  Exception{

        String zdhcWorkflowDefinId = AppConfig.getProperty("sszd");
        String gdhcWorkflowDefinId = AppConfig.getProperty("gdhc");
        String bphcWorkflowDefinId = AppConfig.getProperty("bphc");
        model.addAttribute("zdhcWorkflowDefinId",zdhcWorkflowDefinId);
        model.addAttribute("gdhcWorkflowDefinId",gdhcWorkflowDefinId);
        model.addAttribute("bphcWorkflowDefinId",bphcWorkflowDefinId);

        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);

        return "landtax/syhc/hcxm/dhcrwlb";
    }

    @RequestMapping("exportExcelTz")
    public String exportExcelTz(HcrwQuery hcrwQuery,HttpServletRequest request) throws Exception {
        try {
            if(StringUtils.isNotBlank(hcrwQuery.getHcxmlx())){
                String excelBegin = hcrwQuery.getExcelBegin();
                if(StringUtils.isBlank(excelBegin)){
                    excelBegin = "0";
                }else{
                    excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
                }
                if(hcrwQuery.getHcxmlx().equals(Hcxmlx.ZDHC.toString())){
                    List zdhcList = hcxmService.getDxfrwList(hcrwQuery);
                    List<String[]> retList = new ArrayList<String[]>();
                    for(int i=(0+Integer.parseInt(excelBegin));i<(zdhcList.size()+Integer.parseInt(excelBegin));i++){
                        String[] tempArr = new String[9];
                        for(int j=0;j<tempArr.length;j++){
                            tempArr[j] = "";
                        }
                        HashMap tempMap = (HashMap)zdhcList.get(i-Integer.parseInt(excelBegin));
                        tempArr[0] = String.valueOf(i + 1);
                        tempArr[1] = String.valueOf(tempMap.get("WORKFLOW_INSTANCE_NAME")==null?"":tempMap.get("WORKFLOW_INSTANCE_NAME"));
                        tempArr[2] = String.valueOf(tempMap.get("DJH")==null?"":tempMap.get("DJH"));
                        tempArr[3] = String.valueOf(tempMap.get("TDYTMC")==null?"":tempMap.get("TDYTMC"));
                        tempArr[4] = String.valueOf(tempMap.get("QLRMC") == null ? "" : tempMap.get("QLRMC"));
                        tempArr[5] = String.valueOf(tempMap.get("TDZL")==null?"":tempMap.get("TDZL"));
                        retList.add(tempArr);
                    }

                    HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
                    ExcelBean eb = new ExcelBean();
                    map.put("group1", retList);// 把retList放入group1中
                    eb.setGroupMap(map);
                    eb.setExcelTemplate("dhcrw_zdhc.xls"); //
                    eb.setExcelXml("dhcrw_zdhc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
                    eb.printExcel(request);
                }else if(hcrwQuery.getHcxmlx().equals(Hcxmlx.GDHC.toString())){
                    List gdhcList = hcxmService.getDxfrwList(hcrwQuery);
                    List<String[]> retList = new ArrayList<String[]>();
                    for(int i=(0+Integer.parseInt(excelBegin));i<(gdhcList.size()+Integer.parseInt(excelBegin));i++){
                        String[] tempArr = new String[9];
                        for(int j=0;j<tempArr.length;j++){
                            tempArr[j] = "";
                        }
                        HashMap tempMap = (HashMap)gdhcList.get(i-Integer.parseInt(excelBegin));
                        tempArr[0] = String.valueOf(i + 1);
                        tempArr[1] = String.valueOf(tempMap.get("WORKFLOW_INSTANCE_NAME")==null?"":tempMap.get("WORKFLOW_INSTANCE_NAME"));
                        String xzqdm = String.valueOf(tempMap.get("XZQDM")==null?"":tempMap.get("XZQDM"));
                        String xzqmc = swDjQsService.parseXzqByDm(xzqdm);
                        tempArr[2] = StringUtils.isNotBlank(xzqmc)?xzqmc:"";
                        String qdfs = String.valueOf(tempMap.get("QDFS")==null?"":tempMap.get("QDFS"));
                        String qdfsmc = Tdqdfs.getMcByDm(qdfs);
                        tempArr[3] = StringUtils.isNotBlank(qdfsmc)?qdfsmc:"";
                        String tdytDm = String.valueOf(tempMap.get("TDYT")==null?"":tempMap.get("TDYT"));
                        String tdytMc = Tdyt.getMcByDm(tdytDm);
                        tempArr[4] = StringUtils.isNotBlank(tdytMc)?tdytMc:"";
                        tempArr[5] = String.valueOf(tempMap.get("YDDW")==null?"":tempMap.get("YDDW"));

                        retList.add(tempArr);
                    }

                    HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
                    ExcelBean eb = new ExcelBean();
                    map.put("group1", retList);// 把retList放入group1中
                    eb.setGroupMap(map);
                    eb.setExcelTemplate("dhcrw_gdhc.xls"); //
                    eb.setExcelXml("dhcrw_gdhc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
                    eb.printExcel(request);

                }else if(hcrwQuery.getHcxmlx().equals(Hcxmlx.BPHC.toString())){
                    List bphcList = hcxmService.getDxfrwList(hcrwQuery);
                    List<String[]> retList = new ArrayList<String[]>();
                    for(int i=(0+Integer.parseInt(excelBegin));i<(bphcList.size()+Integer.parseInt(excelBegin));i++){
                        String[] tempArr = new String[9];
                        for(int j=0;j<tempArr.length;j++){
                            tempArr[j] = "";
                        }
                        HashMap tempMap = (HashMap)bphcList.get(i-Integer.parseInt(excelBegin));
                        tempArr[0] = String.valueOf(i + 1);
                        tempArr[1] = String.valueOf(tempMap.get("WORKFLOW_INSTANCE_NAME")==null?"":tempMap.get("WORKFLOW_INSTANCE_NAME"));
                        String xzqdm = String.valueOf(tempMap.get("XZQDM")==null?"":tempMap.get("XZQDM"));
                        String xzqmc = swDjQsService.parseXzqByDm(xzqdm);
                        tempArr[2] = StringUtils.isNotBlank(xzqmc)?xzqmc:"";
                        tempArr[3] = String.valueOf(tempMap.get("PCMC")==null?"":tempMap.get("PCMC"));
                        tempArr[4] = String.valueOf(tempMap.get("YDDW")==null?"":tempMap.get("YDDW"));

                        retList.add(tempArr);
                    }

                    HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
                    ExcelBean eb = new ExcelBean();
                    map.put("group1", retList);// 把retList放入group1中
                    eb.setGroupMap(map);
                    eb.setExcelTemplate("dhcrw_bphc.xls"); //
                    eb.setExcelXml("dhcrw_bphc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
                    eb.printExcel(request);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("dhcrwlbJson")
    @ResponseBody
    public Object dhcrwlbJson(Model model,Pageable request,HcrwQuery hcrwQuery) {
        Object obj = hcxmService.findDhcrw(hcrwQuery, request);
        return obj;
    }

    @RequestMapping("getActivityListByWorkflowDefinId")
    @ResponseBody
    public Object getActivityListByWorkflowDefinId(String workflowDefinId) throws  Exception{

        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        if(CollectionUtils.isNotEmpty(activityList)){
            activityList.remove(activityList.size()-1);
            return activityList;
        }
        return new ArrayList();
    }

    @RequestMapping("yxfxmlb")
    public String yxfxmlb(Model model){
        return "landtax/syhc/hcxm/yxfxmlb";
    }

    @RequestMapping("yxfxmlbJson")
    @ResponseBody
    public Object getYxfxmlbJson(Model model,Pageable request,HcxmQuery hcxmQuery) {
        Page result = hcxmService.findYxfxmlb(hcxmQuery,request);
        return result;
    }

    @RequestMapping("rwlb")
    public String rwlb(Model model,String hcxmId){
        List<String> hcxmBdIds = hcxmService.findDxfHcxmBdId(hcxmId);
        SwHcXm swHcXm = hcxmService.getHcxmById(hcxmId);
        if(swHcXm.getXmlx().equals(Hcxmlx.ZDHC.toString())){
            List<SSjGtbd> gtbdList = zdhcService.getGtbdById(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("gtbdList",gtbdList);
            return "landtax/syhc/zdhc/hcxm_gtzd_rwlb";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.TDSYHC.toString())){
            List<SwDjTdWbd> swDjTdWbdList = swdjtzService.getSwDjTdWbdByIds(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("swDjTdWbdList",swDjTdWbdList);

            return "landtax/syhc/swdjhc/hcxm_swbd_rwlb";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.FCSYHC.toString())){
            List<SwDjFcWbd> swDjFcWbdList = swdjtzService.getSwDjFcWbdByIds(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("swDjFcWbdList",swDjFcWbdList);
            return "landtax/syhc/swdjhc/hcxm_swbdfc_rwlb";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.SYZDYDQC.toString())){
            Set<SwHcXmRwRel> swHcXmRwRelSet = swHcXm.getSwHcXmRwRelSet();
            List<SwHcXmRwRel> swHcXmRwRelList = new ArrayList<SwHcXmRwRel>(swHcXmRwRelSet);
            List<HashMap<String,Object>> resultList = new ArrayList<HashMap<String, Object>>();
            for(int i=0;i<swHcXmRwRelList.size();i++){
                String djh = swHcXmRwRelList.get(i).getBdId();
                Zd zd = zdService.findZdByDjh(djh);
                HashMap<String,Object> tempMap = new HashMap<String, Object>();
                tempMap.put("djh",zd.getDjh());
                tempMap.put("qlrmc",zd.getQlrmc());
                tempMap.put("tdzl",zd.getTdzl());
                String tdyt = zd.getTdyt();
                String tdytMc = zdService.getTdytMcByTdyt(tdyt);
                tempMap.put("tdytMc",tdytMc);
                tempMap.put("scmj",zd.getScmjZd());
                tempMap.put("BdId",swHcXmRwRelList.get(i).getBdId());
                resultList.add(tempMap);
            }
            model.addAttribute("resultList",resultList);
            return "landtax/ydqc/zd/hcxm_zd_rwlb";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.TDZSYDQC.toString())){
            List<SSjZsydqcTd> sSjZsydqcTdList = ydqcService.getTdZsByIds(hcxmBdIds);
            model.addAttribute("sSjZsydqcTdList",sSjZsydqcTdList);
            return "landtax/ydqc/zs/td_zs_rwlb";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.FCZSYDQC.toString())){
            List<SSjZsydqcFc> sSjZsydqcFcList = ydqcService.getFcZsByIds(hcxmBdIds);
            model.addAttribute("sSjZsydqcFcList",sSjZsydqcFcList);
            return "landtax/ydqc/zs/fc_zs_rwlb";
        }
        return null;
    }



    @RequestMapping("hcqc")
    public String hcqc(Model model,String hcxmId){
        List<String> hcxmBdIds = hcxmService.findAllHcxmBdId(hcxmId);
        SwHcXm swHcXm = hcxmService.getHcxmById(hcxmId);
        if(swHcXm.getXmlx().equals(Hcxmlx.ZDHC.toString())){
            List<SSjGtbd> gtbdList = zdhcService.getGtbdById(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("gtbdList",gtbdList);
            return "landtax/syhc/zdhc/hcxm_gtzd_hcqc";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.TDSYHC.toString())){
            List<SwDjTdWbd> swDjTdWbdList = swdjtzService.getSwDjTdWbdByIds(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("swDjTdWbdList",swDjTdWbdList);
            return "landtax/syhc/swdjhc/hcxm_swbd_hcqc";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.FCSYHC.toString())){
            List<SwDjFcWbd> swDjFcWbdList = swdjtzService.getSwDjFcWbdByIds(hcxmBdIds.toArray(new String[hcxmBdIds.size()]));
            model.addAttribute("swDjFcWbdList",swDjFcWbdList);
            return "landtax/syhc/swdjhc/hcxm_swbdfc_hcqc";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.SYZDYDQC.toString())){
            Set<SwHcXmRwRel> swHcXmRwRelSet = swHcXm.getSwHcXmRwRelSet();
            List<SwHcXmRwRel> swHcXmRwRelList = new ArrayList<SwHcXmRwRel>(swHcXmRwRelSet);
            List<HashMap<String,Object>> resultList = new ArrayList<HashMap<String, Object>>();
            for(int i=0;i<swHcXmRwRelList.size();i++){
                String djh = swHcXmRwRelList.get(i).getBdId();
                Zd zd = zdService.findZdByDjh(djh);
                HashMap<String,Object> tempMap = new HashMap<String, Object>();
                tempMap.put("djh",zd.getDjh());
                tempMap.put("qlrmc",zd.getQlrmc());
                tempMap.put("tdzl",zd.getTdzl());
                String tdyt = zd.getTdyt();
                String tdytMc = zdService.getTdytMcByTdyt(tdyt);
                tempMap.put("tdytMc",tdytMc);
                tempMap.put("scmj",zd.getScmjZd());
                resultList.add(tempMap);
            }
            model.addAttribute("resultList",resultList);
            return "landtax/ydqc/zd/hcxm_zd_hcqc";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.TDZSYDQC.toString())){
            List<SSjZsydqcTd> sSjZsydqcTdList = ydqcService.getTdZsByIds(hcxmBdIds);
            model.addAttribute("sSjZsydqcTdList",sSjZsydqcTdList);
            return "landtax/ydqc/zs/td_zs_hcqc";
        }else if(swHcXm.getXmlx().equals(Hcxmlx.FCZSYDQC.toString())){
            List<SSjZsydqcFc> sSjZsydqcFcList = ydqcService.getFcZsByIds(hcxmBdIds);
            model.addAttribute("sSjZsydqcFcList",sSjZsydqcFcList);
            return "landtax/ydqc/zs/fc_zs_hcqc";
        }
        return null;
    }

    @RequestMapping("taskId")
    @ResponseBody
    public String getHcxmTaskId(Model model,String bdId) {
        String taskId = hcxmService.getHcxmTaskId(bdId);
        return taskId;
    }

    @RequestMapping("allHcxm")
    public String allHcxm(Model model){
        return "landtax/syhc/hcxm/allHcxmlb";
    }

    @RequestMapping("allHcxmJson")
    @ResponseBody
    public Object allHcxmJson(Model model,Pageable request,HcxmQuery hcxmQuery) {
        Page<SwHcXm> result = hcxmService.findAllHcxm(hcxmQuery,request);
        return result;
    }

    @RequestMapping("getRoleListByRwId")
    @ResponseBody
    public Object getRoleListByRwId(Model model,HcrwQuery hcrwQuery) {
        String workflowInstanceId = hcrwQuery.getWorkflowInstanceId();
        List<PfRoleVo> roleList = new ArrayList<PfRoleVo>();
        if(StringUtils.isNotBlank(workflowInstanceId)){
            roleList = hcxmService.getRoleListByRwId(workflowInstanceId);
        }
        return roleList;
    }

    @RequestMapping("getUserListByRoleId")
    @ResponseBody
    public Object getUserListByRoleId(Model model,HcrwQuery hcrwQuery) {
        List<PfUserVo> userList = new ArrayList<PfUserVo>();
        if(StringUtils.isNotBlank(hcrwQuery.getRoleId())){
            userList = sysUserService.getUserListByRole(hcrwQuery.getRoleId());
        }
        return userList;
    }

    @RequestMapping("turnTask")
    @ResponseBody
    public Object turnTask(Model model,HcrwQuery hcrwQuery) throws  Exception{
            ResponseMessage responseMessage = new ResponseMessage();
        try {
            String workflowInstanceId = hcrwQuery.getWorkflowInstanceId();
            String toUserId = hcrwQuery.getUserId();
            if(StringUtils.isNotBlank(workflowInstanceId) && StringUtils.isNotBlank(toUserId)){
                //checkbox转发
                String[] workflowInstanceIdArr = workflowInstanceId.split(",");
                for(int i=0;i<workflowInstanceIdArr.length;i++){
                    if(StringUtils.isNotBlank(workflowInstanceIdArr[i])){
                        String taskid = PlatUtil.getTaskIdByProid(workflowInstanceIdArr[i]);
                        String turnXml = zdhcService.initTurnTaskXml(workflowInstanceIdArr[i], toUserId, taskid);
                        //System.out.println(turnXml);
                        Document doc = DocumentHelper.parseText(turnXml);
                        workFlowService.turnTask(doc, taskid);
                    }

                }

            }else if(StringUtils.isBlank(workflowInstanceId) && StringUtils.isNotBlank(toUserId)){
                //条件转发
                List list = hcxmService.findDhcrwList(hcrwQuery);
                if(CollectionUtils.isNotEmpty(list)){
                    for(int i=0;i<list.size();i++){
                        String tempRwId = String.valueOf(((HashMap)list.get(i)).get("WORKFLOW_INSTANCE_ID"));
                        if(StringUtils.isNotBlank(tempRwId)){
                            String taskid = PlatUtil.getTaskIdByProid(tempRwId);
                            String turnXml = zdhcService.initTurnTaskXml(tempRwId, toUserId, taskid);
                            Document doc = DocumentHelper.parseText(turnXml);
                            workFlowService.turnTask(doc, taskid);
                        }
                    }
                }
            }

            responseMessage.setMsg("转发成功");
        }catch (Exception e){
            responseMessage.setMsg("出现异常，转发失败");
        }
        return responseMessage;
    }




}
