package cn.gtmap.landtax.web.map;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SSjGtbd;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.spring.BaseController;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 * 地图应用
 *
 * @author yang
 * @version V1.0, 14-5-26
 */
@Controller
@RequestMapping("/map")
public class MapController extends BaseController {
    @Autowired
    TaxService taxService;
    @Autowired
    MapService mapService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    SsjGtbdService ssjGtbdService;
    @Autowired
    GeoService geoService;
    @Autowired
    ZdService zdService;

    /**
     *
     * @param model
     * @param xzqdm 行政区代码
     * @param djh 地籍号
     * @param proid 核查工作流项目ID
     * @return
     */
    @RequestMapping("/index")
    public String showMap(Model model,String xzqdm,String djh,String proid) {
        if(StringUtils.isBlank(xzqdm))
            xzqdm = SessionUtil.getCurrentUser().getRegionCode();
        if(xzqdm.length()>6)
            xzqdm = xzqdm.substring(0,6);
        if(AppConfig.getProperty("zsfjdm").equals(xzqdm)){
            xzqdm = xzqdm.substring(0,4);
        }
        Map cityMap = getCityMap(xzqdm);
        List counties = getCounties(xzqdm);
        model.addAttribute("city",cityMap);
        model.addAttribute("counties",counties);
        if(cityMap!=null){  //市级用户
            model.addAttribute("xzqdm",cityMap.get("xzqdm"));
            model.addAttribute("xzqmc",cityMap.get("xzqmc"));
        }else{
            if(counties.size()>0){  //县级
                Map county = (Map)counties.get(0);
                // 尝试获取自己的行政区名称
                for (int i = 0; i < counties.size(); i++) {
                    if (xzqdm.equals(((Map)counties.get(i)).get("xzqdm"))) {
                        county = (Map)counties.get(i);
                        break;
                    }
                }
                model.addAttribute("xzqdm",county.get("xzqdm"));
                model.addAttribute("xzqmc",county.get("xzqmc"));
            }else{  //分局
                String tmpXzqdm = StringUtils.substring(xzqdm,0,6);
                model.addAttribute("xzqdm",tmpXzqdm);
                SDmDwxxCz sDmDwxxCz = dwxxService.getDwxxByDwdm(tmpXzqdm);
                model.addAttribute("xzqmc",sDmDwxxCz==null?"":sDmDwxxCz.getDwmc());
            }
        }
        if(StringUtils.isNotBlank(djh)){
            model.addAttribute("djh",djh);
        }
        if(StringUtils.isNotBlank(proid)){
            String bdId = hcxmService.getHcxmBdIdByWiid(proid);
            if(StringUtils.isNotBlank(bdId)){
                SSjGtbd sSjGtbd = ssjGtbdService.findByBdId(bdId);
                if(sSjGtbd!=null)
                    model.addAttribute("djh",sSjGtbd.getDjh());
            }
        }
        return "landtax/map/map";
    }


    @RequestMapping("/queryMap")
    public String queryMap(Model model) {
        return "landtax/querymap";
    }

    @RequestMapping("/config")
    @ResponseBody
    public Object mapConfig(Model model) throws Exception {
        return mapService.getMapConfig();
    }

    @RequestMapping("/getXzqdmByDjh")
    @ResponseBody
    public Object getXzqdmByDjh(Model model,String djh) throws Exception {
        Zd zd = zdService.findZdByDjh(djh);
        ResponseMessage msg = new ResponseMessage();

        if(zd!=null){
            msg.setMsg(zd.getXzqdm());
        }
        return msg;
    }

    @RequestMapping("/getTddjMc")
    @ResponseBody
    public Object getTddjMc(Model model,String tddjDm) throws Exception {


        String tddjMc = zdService.findTddjByDm(tddjDm);
        ResponseMessage msg = new ResponseMessage();

        if(StringUtils.isNotBlank(tddjMc)){
            msg.setMsg(tddjMc);
        }
        return msg;
    }

    private Map getCityMap(String xzqdm){
        Map cityMap=null;
        if(StringUtils.endsWith(xzqdm,"00"))
            xzqdm = StringUtils.strip(xzqdm,"00");
        SDmDwxxCz sDmDwxxCz = dwxxService.getCityByDwdm(xzqdm);
        if(sDmDwxxCz!=null){
            cityMap = Maps.newHashMap();
            cityMap.put("xzqdm",sDmDwxxCz.getDwdm());
            cityMap.put("xzqmc",sDmDwxxCz.getDwmc());
        }
        return cityMap;
    }
    private List getCounties(String xzqdm){
        List counties = Lists.newArrayList();
        Map countyMap =null;
        if(StringUtils.endsWith(xzqdm,"00"))
            xzqdm = StringUtils.strip(xzqdm,"00");
        List<SDmDwxxCz> sDmDwxxCzList = dwxxService.getUserQxList();
        for(SDmDwxxCz sDmDwxxCz:sDmDwxxCzList){
            countyMap = Maps.newHashMap();
            countyMap.put("xzqdm",sDmDwxxCz.getDwdm());
            countyMap.put("xzqmc",sDmDwxxCz.getDwmc());
            counties.add(countyMap);
        }
        return counties;
    }

    @RequestMapping("/sy")
    public String getSwdjSyXxByDjh(Model model,String djh) {
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByDjh(djh);
        model.addAttribute("syxx",syxx);
        model.addAttribute("djh",djh);
        String userId = SessionUtil.getCurrentUserId();
        model.addAttribute("userId",userId);
        String flag = AppConfig.getProperty("update_able");
        model.addAttribute("flag",flag);
        return "landtax/map/mapSyxxTz";
    }

    /***
     * 新增
     * @return
     */
    @RequestMapping("/geoService/insert")
    @ResponseBody
    public Object zdInsert(String geometry,String qlr,String tdzl,String bjqx,String bjjd,String bjjf,String tdjb) {
        return mapService.insertZd(geometry,qlr,tdzl,bjqx,bjjd,bjjf,tdjb);
    }

    @RequestMapping("/geoService/delete")
    @ResponseBody
    public Object zdDelete(String objectId,String layerName) {
        HashMap resultMap = new HashMap();
        resultMap.put("success",false);
        resultMap.put("msg","删除失败");
        if(geoService.delete(layerName,"is_insert='1' and objectId='"+objectId+"' ",null)){
            resultMap.put("success",true);
            resultMap.put("msg","删除成功");

        }

        return resultMap;

    }

    @RequestMapping("/geoService/update")
    @ResponseBody
    public Object zdUpdate(String qlr,String tdzl,String objectId,String layerName) {
        JSONObject propertiesJsonObj = new JSONObject();
        propertiesJsonObj.put("qlr",qlr);
        propertiesJsonObj.put("tdzl",tdzl);
        String properties = propertiesJsonObj.toJSONString();
        HashMap resultMap = new HashMap();
        resultMap.put("success",false);
        resultMap.put("msg","更新失败");
        if(geoService.update2(layerName, "objectId='"+objectId+"' ", properties, null)){
            resultMap.put("success",true);
            resultMap.put("msg","更新成功");
        }
        return resultMap;
    }
}
