package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 重点税源
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/5
 */
@Controller
@RequestMapping("/zdsy")
public class ZdsyController {
    @Autowired
    TaxService taxService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    DicServiceImpl dicServiceImpl;


    @RequestMapping("")
    public String taxSourceList(Model model) {
        //计算合计
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        swDjSyQuery.setZdsybz("1");
        HashMap result = taxService.getHj(null,swDjSyQuery);
        model.addAttribute("resultMap",result);
        return "landtax/fzjc/zdsy";
    }


    /**
     * 土地重点税源台账
     * @param model
     * @return
     */
    @RequestMapping("td")
    public String lzlghTd(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/zdsyTd";
    }

    @RequestMapping("tdJson")
    @ResponseBody
    public Object getZdsyTd(Model model,SwDjSyQuery swDjSyQuery,Pageable request,String sidx,String sord,String beginPm,String endPm) {
        return taxService.findZdsyTd(swDjSyQuery,request,sidx,sord,beginPm,endPm);
    }

    /**
     * 房产重点税源台账
     * @param model
     * @return
     */
    @RequestMapping("fc")
    public String zdsyFc(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/zdsyFc";
    }

    @RequestMapping("fcJson")
    @ResponseBody
    public Object getZdsyFc(Model model,SwDjSyQuery swDjSyQuery,Pageable request,String sidx,String sord,String beginPm,String endPm) {
        return taxService.findZdsyFc(swDjSyQuery,request,sidx,sord,beginPm,endPm);
    }

    @RequestMapping("setZdsy")
    @ResponseBody
    public Object setZdsy(Model model,String sylx,String tdId,String fcId,SwDjSyQuery swDjSyQuery,String beginPm,String endPm) {
        ResponseMessage msg = new ResponseMessage();
        try{
            taxService.setZdsy(sylx,tdId,fcId,swDjSyQuery,beginPm,endPm);
            if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
                msg.setMsg("已标记为重点税源！");
            }else{
                msg.setMsg("已取消重点税源！");
            }

        }catch (Exception e){
            msg.setMsg("出现异常，标记失败！");
        }
        return msg;
    }

    @RequestMapping("exportExcelTd")
    public String exportExcelTd(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            List<Object> zdsyList = taxService.getZdsyTdList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdsyList.size();i++){
                String[] tempArr = new String[14];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyTd.xls"); //
            eb.setExcelXml("zdsyTd.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelFc")
    public String exportExcelFc(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<Object> zdsyList = taxService.getZdsyFcList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdsyList.size();i++){
                String[] tempArr = new String[15];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyFc.xls"); //
            eb.setExcelXml("zdsyFc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

}
