package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjJbb;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.*;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 税源管理,查询和修改等
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Controller
@RequestMapping("/ts")
public class TaxSourceController{
    @Autowired
    TaxService taxService;
    @Autowired
    private ZdService zdService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    private TjService tjService;
    @Autowired
    SwDjQsService swDjQsService;

    @RequestMapping("")
    public String taxSourceList(Model model,String dw,String bj,String ls,String sc,String msrd,String zdsy,String sycx) {
        model.addAttribute("dw",dw);
        model.addAttribute("bj",bj);
        model.addAttribute("ls",ls);
        model.addAttribute("sc",sc);
        model.addAttribute("msrd",msrd);
        model.addAttribute("zdsy",zdsy);
        model.addAttribute("sycx",sycx);


        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);

        if("true".equals(sycx)){
            //计算合计
            HashMap result = taxService.getHj(null,new SwDjSyQuery());
            model.addAttribute("resultMap",result);
            return "landtax/fzjc/sytz";
        }
        return "landtax/fzjc/sytz_fuc";

    }

    @RequestMapping("hjJson")
    @ResponseBody
    public Object hjJson(String sylx,SwDjSyQuery swDjSyQuery){
        HashMap result = taxService.getHj(sylx,swDjSyQuery);
        return result;
    }


    @RequestMapping("syJson")
    @ResponseBody
    public Object getSwdjSy(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery,GdzysQuery gdzysQuery,SwDjQsQuery swDjQsQuery) {
        if(StringUtils.isBlank(sylx)|| Sylx.TDSY.toString().equals(sylx) )
            return taxService.findSwdjTdMap(swDjSyQuery, request);
        else if(StringUtils.isBlank(sylx)|| Sylx.FCSY.toString().equals(sylx) )
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        else if(StringUtils.isBlank(sylx)|| Sylx.GDZYS.toString().equals(sylx)  ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
                gdzysQuery.setPcXzqdm(xzqdm);
            }
            Object oo = gdzysService.findGdzystz(gdzysQuery, request);
            return oo;
        }

        else if(StringUtils.isBlank(sylx)|| Sylx.QS.toString().equals(sylx) ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
                swDjQsQuery.setXmXzqdm(xzqdm);
            }
            Object obj =  swDjQsService.findQstz(swDjQsQuery, request);
            return obj;
        }

        return null;
    }


    @RequestMapping("exportExcelTz")
    public String exportExcelTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<swdjTzList.size();i++){
                String[] tempArr = new String[20];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i);
                if(sylx.equals(Sylx.TDSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getGlbm();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getTdzl();
                    tempArr[5] = String.valueOf(temp.getScmjZd());

                    tempArr[6] = String.valueOf(temp.getScmj());
                    tempArr[7] = String.valueOf(temp.getMsmj());
                    tempArr[8] = String.valueOf(temp.getYnmj());
                    tempArr[9] = String.valueOf(temp.getDwse());
                    tempArr[10] = String.valueOf(temp.getMsse());
                    tempArr[11] = String.valueOf(temp.getNynseTd());

                    tempArr[12] = temp.getZgkgMc();
                    tempArr[13] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[14] = Sgzt.getMcByDm(sgztDm);
                    String tdyt = temp.getTdsyytDm();
                    tempArr[15] = Tdyt.getMcByDm(tdyt);
                } else if(sylx.equals(Sylx.FCSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getGlbm();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getFczl();

                    tempArr[5] = String.valueOf(temp.getFcyz());
                    tempArr[6] = String.valueOf(temp.getFcyzYs());
                    tempArr[7] = String.valueOf(temp.getFcyzMs());
                    tempArr[8] = String.valueOf(temp.getYnseZy());
                    tempArr[9] = String.valueOf(temp.getNzj());
                    tempArr[10] = String.valueOf(temp.getSl());
                    tempArr[11] = String.valueOf(temp.getYnseCz());
                    tempArr[12] = String.valueOf(temp.getNynseFc());

                    tempArr[13] = temp.getZgkgMc();
                    tempArr[14] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[15] = Sgzt.getMcByDm(sgztDm);
                    String fcyt = temp.getFwxzDm();
                    tempArr[16] = Fwxz.getMcByDm(fcyt);
                } else if(sylx.equals(Sylx.GDZYS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getGlbm();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getPcmc();
                    tempArr[5] = temp.getPwh();
                    tempArr[6] = temp.getPzmj()==null?"":String.valueOf(temp.getPzmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = temp.getNydmj()==null?"":String.valueOf(temp.getNydmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[8] = temp.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getPzsj());
                    tempArr[9] = temp.getPcYddw();
                    tempArr[10] = temp.getGdzysYnse()==null?"":String.valueOf(temp.getGdzysYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getGdzysDwse()==null?"":String.valueOf(temp.getGdzysDwse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getGdzysJspz();
                    tempArr[13] = temp.getGdzysYjne()==null?"":String.valueOf(temp.getGdzysYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getGdzysXbjse()==null?"":String.valueOf(temp.getGdzysXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[15] = temp.getGdzysBz();

                } else if(sylx.equals(Sylx.QS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getGlbm();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getXmmc();
                    tempArr[5] = temp.getXmYddw();
                    tempArr[6] = temp.getGdmj()==null?"":String.valueOf(temp.getGdmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = Tdqdfs.getMcByDm(temp.getQdfs());
                    tempArr[8] = temp.getQdjg()==null?"":String.valueOf(temp.getQdjg().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[9] = temp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getGdsj());
                    tempArr[10] = temp.getQsYnse()==null?"":String.valueOf(temp.getQsYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getQsYjne()==null?"":String.valueOf(temp.getQsYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getQsJspz();
                    tempArr[13] = temp.getQsXbjse()==null?"":String.valueOf(temp.getQsXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getQsBz();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "";
            String excelXml = "";
            if(sylx.equals(Sylx.TDSY.toString())) {
                excelTemplate = "sybjTz_td.xls";
                excelXml = "sybjTz_td.xml";
            } else if(sylx.equals(Sylx.FCSY.toString())) {
                excelTemplate = "sybjTz_fc.xls";
                excelXml = "sybjTz_fc.xml";
            } else if(sylx.equals(Sylx.GDZYS.toString())) {
                excelTemplate = "sybjTz_gdzys.xls";
                excelXml = "sybjTz_gdzysQs.xml";
            } else if(sylx.equals(Sylx.QS.toString())) {
                excelTemplate = "sybjTz_qs.xls";
                excelXml = "sybjTz_Qs.xml";
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelMsTz")
    public String exportExcelMsTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                swDjSyQuery.setIsMsTz(true);
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<swdjTzList.size();i++){
                String[] tempArr = new String[11];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                tempArr[1] = temp.getDjh();
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[2] = String.valueOf(temp.getMsmj());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[2] = String.valueOf(temp.getFcyzMs());
                }
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[3] = String.valueOf(temp.getTdzl());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[3] = String.valueOf(temp.getFczl());
                }
                String tdyt = temp.getTdyt();
                tempArr[4] = Dldm.getMcByDm(tdyt);
                tempArr[5] = temp.getGlbm();
                tempArr[6] = temp.getDbh();
                tempArr[7] = temp.getNsrmc();
                tempArr[8] = temp.getQlrmc();
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[9] = String.valueOf(temp.getScmj());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[9] = String.valueOf(temp.getFczl());
                }
                tempArr[9] = String.valueOf(temp.getScmj());
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            if(sylx.equals(Sylx.TDSY.toString())){
                eb.setExcelTemplate("tdmsTz.xls"); //
            }else if(sylx.equals(Sylx.FCSY.toString())){
                eb.setExcelTemplate("fcmsTz.xls"); //
            }

            eb.setExcelXml("mssyTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    //重点税源台帐导出
    @RequestMapping("exportExcelZdSyTz")
    public String exportExcelZdSyTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<SwDjSyQuery> zdsyList = new ArrayList<SwDjSyQuery>();
            List<String[]> retList = new ArrayList<String[]>();
            if(sylx!=null&&"2".equals(sylx)){
                zdsyList = taxService.getzdsyfcList(param);
                for(int i=0;i<zdsyList.size();i++){
                    String[] tempArr = new String[19];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery tempVo = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i+1);
                    tempArr[1] = tempVo.getDjh();
                    tempArr[2] = tempVo.getDbh();
                    tempArr[3] = tempVo.getGlbm();
                    tempArr[4] = tempVo.getNsrmc();
                    tempArr[5] = tempVo.getTdzl();
                    tempArr[6] = tempVo.getFcyz()==null?"":tempVo.getFcyz().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[7] = tempVo.getFcyzYs()==null?"":tempVo.getFcyzYs().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[8] = tempVo.getFcyzMs()==null?"":tempVo.getFcyzMs().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[9] = tempVo.getYnseZy()==null?"":tempVo.getYnseZy().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[10] = tempVo.getNzj()==null?"":tempVo.getNzj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[11] = tempVo.getSl()==null?"":tempVo.getSl().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[12] = tempVo.getYnseCz()==null?"":tempVo.getYnseCz().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[13] = tempVo.getNynseFc()==null?"":tempVo.getNynseFc().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[14] = tempVo.getZgkgMc();
                    tempArr[15] = tempVo.getSgyMc();
                    tempArr[16] = tempVo.getSgztMc();
                    String sjly="";
                    if(tempVo.getSjly()!=null){
                        if("1".equals(tempVo.getSjly())){
                            sjly = "自动匹配";
                        }else if("2".equals(tempVo.getSjly())){
                            sjly = "人工匹配";
                        }else if("3".equals(tempVo.getSjly())){
                            sjly = "税源核查";
                        }else if("4".equals(tempVo.getSjly())){
                            sjly = "按图匹配";
                        }
                    }
                    tempArr[17] = sjly;
                    tempArr[18] = Dldm.getMcByDm(tempVo.getTdyt());
                    retList.add(tempArr);
                }
            }else if(sylx!=null&&"1".equals(sylx)){
                zdsyList = taxService.getzdsytdList(param);
                for(int i=0;i<zdsyList.size();i++){
                    String[] tempArr = new String[18];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery tempVo = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i+1);
                    tempArr[1] = tempVo.getDjh();
                    tempArr[2] = tempVo.getDbh();
                    tempArr[3] = tempVo.getGlbm();
                    tempArr[4] = tempVo.getNsrmc();
                    tempArr[5] = tempVo.getTdzl();
                    tempArr[6] = tempVo.getScmjZd()==null?"":tempVo.getScmjZd().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[7] = tempVo.getScmj()==null?"":tempVo.getScmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[8] = tempVo.getMsmj()==null?"":tempVo.getMsmj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[9] = tempVo.getYnmj()==null?"":tempVo.getYnmj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[10] = tempVo.getDwse()==null?"":tempVo.getDwse().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[11] = tempVo.getMsse()==null?"":tempVo.getMsse().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[12] = tempVo.getNynseTd()==null?"":tempVo.getNynseTd().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[13] = tempVo.getZgkgMc();
                    tempArr[14] = tempVo.getSgyMc();
                    tempArr[15] = tempVo.getSgztMc();
                    String sjly="";
                    if(tempVo.getSjly()!=null){
                        if("1".equals(tempVo.getSjly())){
                            sjly = "自动匹配";
                        }else if("2".equals(tempVo.getSjly())){
                            sjly = "人工匹配";
                        }else if("3".equals(tempVo.getSjly())){
                            sjly = "税源核查";
                        }else if("4".equals(tempVo.getSjly())){
                            sjly = "按图匹配";
                        }
                    }
                    tempArr[16] = sjly;
                    tempArr[17] = Dldm.getMcByDm(tempVo.getTdyt());
                    retList.add(tempArr);
                }
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            if(sylx.equals(Sylx.TDSY.toString())){
                eb.setExcelTemplate("zdsycxtd.xls"); //
                eb.setExcelXml("zdsycxtd.xml");
            }else if(sylx.equals(Sylx.FCSY.toString())){
                eb.setExcelTemplate("zdsycxfc.xls"); //
                eb.setExcelXml("zdsycxfc.xml");
            }
             // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    @RequestMapping("info")
    public String getSwdjSyXx(Model model,String tdId,String fcId,String djh){
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        if(StringUtils.isNotBlank(djh)){
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
        }
        model.addAttribute("syxx",syxx);
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);

        return "landtax/fzjc/sytzSyxx";
    }

    @RequestMapping("taxMap")
    public String getSwdjSyXxByMap(Model model,String tdId,String fcId,String djh,String noSave){
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        model.addAttribute("syxx",syxx);
        if(StringUtils.isNotBlank(djh)){
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
        }
        if(StringUtils.isBlank(djh)){
            djh=syxx.getDjh();
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/map/mapSyxx";
        }else if(StringUtils.isNotBlank(noSave)){
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/map/mapSyxx";
        }else{
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/fzjc/zdtzSyxx";
        }

    }

    @RequestMapping("history")
    public String getSwdjSyHistory(Model model,String syId, String sylx) {
        if(StringUtils.isNotBlank(syId)){
            SwDjSy swDjSy = taxService.getSwDjSyById(syId);
            model.addAttribute("historyList",swDjSy.getSwDjSyHisSet());
        }

        String resultStr = "";
        String tag = "";
        if(sylx.equals("1")){
            tag = "土地税源修改历史";
        }else if(sylx.equals("2")){
            tag = "房产税源修改历史";
        }else if(sylx.equals("3")){
            tag = "耕地占用税修改历史";
        }else if(sylx.equals("4")){
            tag = "契税修改历史";
        }
        model.addAttribute("title",tag);
        if (sylx.equals("1") || sylx.equals("2")) {
            resultStr = "landtax/fzjc/tdsyxgls";
        } else if (sylx.equals("3")) {
            resultStr = "landtax/fzjc/gdzyssyxgls";
        } else if (sylx.equals("4")) {
            resultStr = "landtax/fzjc/qssyxgls";
        }
        return resultStr;
    }

    @RequestMapping("djh")
    @ResponseBody
    public Object getSwdjSyXxByDjh(Model model,String djh) {
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByDjh(djh);
        return syxx;
    }

    @RequestMapping("addInput")
    public String getZdByDjh(Model model,String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);
        //自动生成土地使用号
        String dbh = taxService.createDbhByDjh(djh);

        String sgyMc = SessionUtil.getCurrentUser().getUsername();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String zgkgDm = taxService.findZgkgDmByRegionCode(regionCode);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(StringUtils.isNotBlank(zgkgDm)){
            swDjSyQuery.setZgkgDm(zgkgDm);
        }
        swDjSyQuery.setDbh(dbh);
        swDjSyQuery.setSgyMc(sgyMc);
        BigDecimal jsbl = new BigDecimal(AppConfig.getProperty("jsbl"));
        swDjSyQuery.setJsbl(jsbl);

        String dwseStr = taxService.getDwseByTddj(zd.getTddj());
        swDjSyQuery.setTddj(zd.getTddj());
        if(StringUtils.isNotBlank(dwseStr)){
            swDjSyQuery.setDwse(new BigDecimal(dwseStr));
        }
        //获取房产坐落县，镇
        String xian = dwxxService.getDwxxByDwdm(djh.substring(0,6)).getDwmc();
        String zhen = dwxxService.getDwxxByDwdm(djh.substring(0,9)).getDwmc();
        swDjSyQuery.setFczlXian(xian);
        swDjSyQuery.setFczlZhen(zhen);
        model.addAttribute("syxx",swDjSyQuery);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByDjhLike(djh);
        model.addAttribute("tddjList",tddjList);
        return "landtax/fzjc/zdtzSyxx";
    }

    @RequestMapping("updateInput")
    public String getSwDjSyxx(Model model,@RequestParam String syId){
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        Zd zd = swDjSy.getZd();
        model.addAttribute("zd",zd);
        model.addAttribute("swDjSy",swDjSy);
        return "landtax/fzjc/zdtzSyxx";
    }

    @RequestMapping("save")
    @ResponseBody
    public Object save(Model model,SwDjSyQuery swDjSyQuery){
        String msg="";
        try{
            String syzt = Syzt.ZC.toString();
            taxService.saveSwDjSyQuery(swDjSyQuery,syzt);
            msg = "保存成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "保存失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    @RequestMapping("getTddjByQx")
    @ResponseBody
    public Object getTddjByQx(Model model,String qx){
        return taxService.getTddjByQx(qx);
    }


    @RequestMapping("findJbbByGlbm")
    @ResponseBody
    public Object findJbbByGlbm(Model model,String query){
        List<SwDjJbbQuery> list = taxService.findJbbByGlbm(query);

        return list;
    }

    @RequestMapping("findAllZdDjh")
    @ResponseBody
    public Object findAllZdDjh(Model model){
        List<ZdQuery> list = zdService.findAllZdDjh();
        return list;
    }

    /**
     * 不走流程的税源删除
     */
    @RequestMapping("delSwDjSyNoWorkflow")
    @ResponseBody
    public Object delSwDjSyNoWorkflow(Model model,String syId){

        String result = "1";
        try{
            taxService.softDelSyDjSy(syId, Syzt.SC.toString());
        }catch (Exception e){
            e.printStackTrace();
            result = "0";
        }
        return result;
    }

    @RequestMapping("parsetdzlBydjh")
    @ResponseBody
    public Object parsetdzlBydjh(Model model,String syId){
        String[] syIds = syId.split(",");
        String[] tdzlMcs = new String[syIds.length];
        for(int i=0;i<syIds.length;i++){

            tdzlMcs[i] = taxService.fandTdzl(syIds[i]);

        }
        return tdzlMcs;
    }

    @RequestMapping("parseJmxz")
    @ResponseBody
    public Object parseJmxz(Model model,String qsJmxzDm){
        String[] qsJmxzDms = qsJmxzDm.split(",");
        String[] tdzlMcs = new String[qsJmxzDms.length];
        for(int i=0;i<qsJmxzDms.length;i++){

            tdzlMcs[i] = Jmxzqs.getMcByDm(qsJmxzDms[i]);

        }
        return tdzlMcs;
    }


    @RequestMapping("parseTdytByDm")
    @ResponseBody
    public Object parseTdytByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Dldm.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parsefcytMcByDm")
    @ResponseBody
    public Object parsefcytMcByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Fwxz.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parsetdsyytMcByDm")
    @ResponseBody
    public Object parsetdsyytMcByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Tdyt.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parseTddjByDm")
    @ResponseBody
    public Object parseTddjByDm(Model model,String dm){
        return taxService.parseTddjByDm(dm);
    }

    @RequestMapping("parseSgztByDm")
    @ResponseBody
    public Object parseSgztByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] sgztMcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempSgztMc = Sgzt.getMcByDm(dms[i]);
            sgztMcs[i] = tempSgztMc;
        }
        return sgztMcs;
    }

    @RequestMapping("initZgswjgSelect")
    @ResponseBody
    public Object initZgswjgSelect(Model model){
        String userId = SessionUtil.getCurrentUserId();
        String regionCode = sysUserService.getRegionCodeByUserId(userId);
        if(regionCode.length()>6){
            regionCode = regionCode.substring(0,6);
        }
        if(StringUtils.isNotBlank(AppConfig.getProperty(regionCode))){
            regionCode = AppConfig.getProperty(regionCode);
        }
        //根据地区码，获取主管税务机关列表
        String whereClause = "where swbmbm like '2"+regionCode+"%'";
        String sql = "select swbmbm,mc from dm_swbm "+whereClause;
        List list = baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
        return list;
    }




    @RequestMapping("findSwDjJbbByGlbm")
    @ResponseBody
    public Object findSwDjJbbByGlbm(Model model,String glbm){
        SwDjJbb swDjJbb =  taxService.findSwDjJbbByGlbm(glbm);

        SwDjSyQuery swdjSyQuery = new SwDjSyQuery();
        if(swDjJbb!=null){
            if(swdjSyQuery!=null)
                BeanUtils.copyProperties(swDjJbb,swdjSyQuery);
        }
        return swdjSyQuery;
    }

    @RequestMapping("printSyxx")
    @ResponseBody
    public void exportSyxx(Model model,HttpServletResponse response,String tdId,String fcId,String djh,String dbh) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        if(StringUtils.isNotBlank(tdId) && StringUtils.isNotBlank(fcId)){
            //根据下拉框代码获取下拉框名称
            //根据税管代码获取税管状态名称
            String sgztDm = syxx.getSgztDm();
            String sgzdMc = Sgzt.getMcByDm(sgztDm);
            syxx.setSgztMc(sgzdMc);
            //根据土地用途代码获取土地用途名称
            String tdyt = syxx.getTdyt();
            String tdytMc = Dldm.getMcByDm(tdyt);
            syxx.setTdytMc(tdytMc);
            //根据土地使用权类型获取土地使用权类型名称
            String tdsyqlx = syxx.getTdsyqlx();
            String tdsyqlxMc = Tdsyqlx.getMcByDm(tdsyqlx);
            syxx.setTdsyqlxMc(tdsyqlxMc);
            //根据主管控管代码获取主管空管名称
            String zgkgDm = syxx.getZgkgDm();
            String sql = "select mc from dm_swbm where swbmbm="+zgkgDm;
            String zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
            syxx.setZgkgMc(zgkgMc);
            //根据登记注册类型代码获取登记注册类型名称
            String zclxDm = syxx.getZclxDm();
            String zclxMc = Zclx.getMcByDm(zclxDm);
            syxx.setZclxMc(zclxMc);
            //根据行业代码获取行业名称
            String hyDm = syxx.getHyDm();
            String hyMc = Hylx.getMcByDm(hyDm);
            syxx.setHyMc(hyMc);
            //根据土地使用状态代码获取土地使用状态名称
            String tdsyztDm = syxx.getTdsyztDm();
            String tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
            syxx.setTdsyztMc(tdsyztMc);
            //根据土地登记代码获取土地登记名称
            String tddj = syxx.getTddj();
            //根据tddj获取名称
            HashMap tddjMap = (HashMap) taxService.getTddjByDm(tddj);
            if(tddjMap != null){
                syxx.setTddjMc(String.valueOf(tddjMap.get("MC")));
            }

            //根据房屋性质代码获取房屋性质名称
            String fwxzDm = syxx.getFwxzDm();
            String fwxzMc = Fwxz.getMcByDm(fwxzDm);
            syxx.setFwxzMc(fwxzMc);
            //根据自用或者租用代码获取名称
            String zyhczDm = syxx.getZyhczDm();
            String zyhczMc = Fwsyzt.getMcByDm(zyhczDm);
            syxx.setZyhczMc(zyhczMc);

            //土地取得方式
            String tdqdfsDm = syxx.getTdqdfsDm();
            String tdqdfsMc = Tdqdfs.getMcByDm(tdqdfsDm);
            syxx.setTdqdfsMc(tdqdfsMc);
            //土地使用用途代码
            String tdsyytDm = syxx.getTdsyytDm();
            String tdsyytMc = Tdyt.getMcByDm(tdsyytDm);
            syxx.setTdsyytMc(tdsyytMc);



        }else{//说明是录入界面打印
            //根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            syxx.setDjh(zd.getDjh());
            //syxx.setDbh(dbh);
            syxx.setTdytMc(Dldm.getMcByDm(zd.getTdyt()));
            syxx.setQlrmc(zd.getQlrmc());
            syxx.setScmjZd(zd.getScmjZd()==null?new BigDecimal(0).setScale(2,RoundingMode.HALF_UP):zd.getScmjZd().setScale(2,RoundingMode.HALF_UP));
            syxx.setTdzl(zd.getTdzl());
        }

        xml.append(xmlBuildHelper.voToXml(syxx));
//        xml.append("<data name=\"AP_FWZDMJ\" type=\"String\">");
//        xml.append((vo.getAP_LFMJ()==null?0:vo.getAP_LFMJ())+(vo.getAP_PFMJ()==null?0:vo.getAP_PFMJ()));
//        xml.append("</data>");
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("getIsYsdlByDm")
    @ResponseBody
    public Object getIsYsdlByDm(Model model,String dm){
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = taxService.getIsYsdlByDm(dm);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping("initDwse")
    @ResponseBody
    public Object initDwse(Model model,String tddj){
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = taxService.getDwseByTddj(tddj);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping("msTaxList")
    public String msTaxList(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        swDjSyQuery.setIsMsTz(true);
        HashMap result = taxService.getHj(null,swDjSyQuery);
        model.addAttribute("resultMap",result);

        return "landtax/fzjc/msTaxList";
    }

    @RequestMapping("MsTaxJson")
    @ResponseBody
    public Object getMsTaxJson(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery) {
        swDjSyQuery.setIsMsTz(true);
        if(StringUtils.isBlank(swDjSyQuery.getXzqdm()))
            swDjSyQuery.setXzqdm(SessionUtil.getCurrentUser().getRegionCode());
        if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm())&&StringUtils.endsWith(swDjSyQuery.getXzqdm(),"00"))
            swDjSyQuery.setXzqdm(StringUtils.strip(swDjSyQuery.getXzqdm(),"00"));
        if(StringUtils.isBlank(sylx)|| Sylx.TDSY.toString().equals(sylx))
            return taxService.findSwdjTdMap(swDjSyQuery,request);
        else
            return taxService.findSwdjFcMap(swDjSyQuery,request);
    }

    //定环比统计
    @RequestMapping("dhbTjfx")
    public String dhbTjfx(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/dhbTjfx";
    }

    @RequestMapping("dhbTjfxIfram")
    public String dhbTjfxIfram(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/dhbTjfxFram";
    }

    @RequestMapping("dhbTjfxJson")
    @ResponseBody
    public Object dhbTjfxJson(SwDjSyQuery swDjSyQuery) {
        return tjService.dhbTjfxJson(swDjSyQuery,null,null);
    }


    /**
     * 房产税定环比
     */
    //定环比统计
    @RequestMapping("fcsDhbTjfx")
    public String fcsDhbTjfx(Model model,SwDjSyQuery swDjSyQuery) {
        UserInfo user = SessionUtil.getCurrentUser();
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/fcsDhbTjfx";
    }

    @RequestMapping("fcsDhbTjfxIfram")
    public String fcsDhbTjfxIfram(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/fcsDhbTjfxFram";
    }

    @RequestMapping("fcsDhbTjfxJson")
    @ResponseBody
    public Object fcsDhbTjfxJson(SwDjSyQuery swDjSyQuery) {
        return tjService.fcsDhbTjfxJson(swDjSyQuery,null,null);
    }



    //税源分析
    @RequestMapping("tdsFx")
    public String tdsFx(Model model) {

        return "landtax/tj/hz/tdsFx";
    }
    @RequestMapping("tdsFxJson")
    @ResponseBody
    public Object tdsFxJson() {
        return tjService.tdsFxJson(null, null);
    }

    @RequestMapping("fcsFx")
    public String fcsFx(Model model) {

        return "landtax/tj/hz/fcsFx";
    }
    @RequestMapping("fcsFxJson")
    @ResponseBody
    public Object fcsFxJson() {
        return tjService.fcsFxJson(null, null);
    }

    @RequestMapping("getSgjgByQx")
    @ResponseBody
    public Object getSgjgByQx(String qx) {
        return taxService.getSgjgByQx(qx);
    }

    @RequestMapping("loginUserInfo")
    @ResponseBody
    public Object loginUserInfo() {
        HashMap loginUserInfo = new HashMap();

        String userName = "";
        String ssfj = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            String regionCode = userInfo.getRegionCode();

            userName = userInfo.getUsername();
            if (regionCode.length() == 8) {
                ssfj = "2" + regionCode + "00";
            }
        }

        loginUserInfo.put("userName", userName);
        loginUserInfo.put("ssfj", ssfj);

        return loginUserInfo;
    }

    @RequestMapping("syJsonForGj")
    @ResponseBody
    public Object syJsonForGj(){
        return  null;
    }

}
