package cn.gtmap.landtax.web;

import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.Gtlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SjgjQuery;
import cn.gtmap.landtax.service.SjgjService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by zhouzhiwei on 2015-8-6.
 */

@Controller
@RequestMapping("/sjgj")
public class SjgjController {
    @Autowired
    private SjgjService sjgjService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private TaxService taxService;

    @RequestMapping("list")
    public String zdList(Model model) {
        return "landtax/sjgj/sjgj";
    }

    @RequestMapping("syJson")
    @ResponseBody
    public Page syJson(Model model, Pageable pageable, SjgjQuery sjgjQuery) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        Page page = null;

        String zlField = "";
        String zhField = "";
        String mcField = "";
        String sjlyField = "";
        if (sjgjQuery.getSylx() == null || sjgjQuery.getSylx().equals("1")) {
            queryConditionList.add(new QueryCondition("swDjTd.tdId is not null"));
            zlField = "swDjTd.tdzl";
            zhField = "swDjTd.tdsyzh";
            mcField = "swDjTd.swDjJbb.nsrmc";
            sjlyField = "swDjTd.sjly";
        } else if (sjgjQuery.getSylx().equals("2")){
            queryConditionList.add(new QueryCondition("swDjFc.fcId is not null"));
            zlField = "swDjFc.fczl";
            zhField = "swDjFc.fczh";
            mcField = "swDjFc.swDjJbb.nsrmc";
            sjlyField = "swDjFc.sjly";
        }

        String gjfs = sjgjQuery.getGjfs();
        if (gjfs == null) {
            gjfs = SjgjQuery.ZDPP;
            sjgjQuery.setMc("1");
        }
        if (gjfs.equals(SjgjQuery.ZDPP)) {
            page = sjgjService.getZdppSyPage(sjgjQuery, pageable);
        } else if (gjfs.equals(SjgjQuery.RGPP)) {
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition(mcField, QueryCondition.LK, sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition(zlField, QueryCondition.LK, sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition(zhField, QueryCondition.LK, sjgjQuery.getZh()));
            }
            queryConditionList.add(new QueryCondition(sjlyField, QueryCondition.EQ, "0"));
            queryConditionList.add(new QueryCondition("syzt", QueryCondition.EQ, "3"));
            page = sjgjService.getSyPage(queryConditionList, pageable, sjgjQuery.getSylx());
        } else if (gjfs.equals(SjgjQuery.QXPP)) {
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition(mcField, QueryCondition.LK, sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition(zlField, QueryCondition.LK, sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition(zhField, QueryCondition.LK, sjgjQuery.getZh()));
            }
            queryConditionList.add(new QueryCondition(sjlyField + " in ('1', '2')"));
            queryConditionList.add(new QueryCondition("syzt", QueryCondition.EQ, "1"));
            page = sjgjService.getSyPage(queryConditionList, pageable, sjgjQuery.getSylx());
        }
        return page;
    }

    @RequestMapping("zdJson")
    @ResponseBody
    public Page zdJson(Model model, Pageable pageable, SjgjQuery sjgjQuery) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        String gjfs = sjgjQuery.getGjfs();
        if (StringUtils.isEmpty(gjfs)) {
            queryConditionList.add(new QueryCondition(" 1=2 "));
        } else if (gjfs.equals(SjgjQuery.ZDPP)) {
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("qlrmc", QueryCondition.EQ, sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition("tdzl", QueryCondition.EQ, sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition("tdzh", QueryCondition.EQ, sjgjQuery.getZh()));
            }
        } else if (gjfs.equals(SjgjQuery.RGPP)) {
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("qlrmc", QueryCondition.LK, sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition("tdzl", QueryCondition.LK, sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition("tdzh", QueryCondition.LK, sjgjQuery.getZh()));
            }
        } else if (gjfs.equals(SjgjQuery.QXPP)) {
            queryConditionList.add(new QueryCondition("djh", QueryCondition.EQ, sjgjQuery.getDjh()));
        }

        return sjgjService.getZdPage(queryConditionList, pageable, sjgjQuery.getSylx());
    }

    @RequestMapping("doGj")
    @ResponseBody
    public Object doGj(Model model, String syId, String djh, String gjfs, String sylx) {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = "";

        SwDjSy swDjSy = baseRepository.get(SwDjSy.class, syId);
        if (swDjSy != null) {
            if (swDjSy.getSwDjTd() != null)
                swDjSy.getSwDjTd().setSjly(gjfs);
            if (swDjSy.getSwDjFc() != null)
                swDjSy.getSwDjFc().setSjly(gjfs);

            if (StringUtils.isEmpty(gjfs)) {
                msg = "未指定挂接方式！";
            } else if (gjfs.equals("1") || gjfs.equals("2")) {
                Zd zd = new Zd();
                zd.setDjh(djh);

                String dbh = taxService.createDbhByDjh(djh);
                swDjSy.setZd(zd);
                swDjSy.setDbh(dbh);
                swDjSy.setSysjly(Gtlx.ZD.toString());
                swDjSy.setSyzt(Syzt.ZC.toString());
                sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "挂接成功！";
            } else if (gjfs.equals("0")) {
                swDjSy.setSysjly(null);
                swDjSy.setZd(null);
                swDjSy.setDbh(null);
                swDjSy.setSyzt(Syzt.LS.toString());
                
                sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "取消挂接成功！";
            } else if (gjfs.equals("4")) {
                sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "标记无法挂接成功！";
            } else {
                msg = "未知挂接方式（" + gjfs + "）！";
            }
        } else {
            msg = "未找到税源信息！";
        }

        responseMessage.setMsg(msg);
        return responseMessage;
    }
}
