package cn.gtmap.landtax.web;

import cn.gtmap.landtax.service.DicService;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
;
import java.util.Map;


/**
 * 字典项
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
@Controller
@RequestMapping("/dic")
public class DicController {
    @Autowired
    DicService dicService;

    @RequestMapping("")
    @ResponseBody
    public Object getDicMap(Model model,String name) throws Exception {
        Map dicMap = Maps.newHashMap();
        if(StringUtils.isNotBlank(name)){
            String[] tmpDicNames = StringUtils.split(name,",");
            for(String tmpDicName:tmpDicNames){
                dicMap.put(tmpDicName,dicService.buildEnumMap(tmpDicName));
            }
        }
        return dicMap;

    }
}
