package cn.gtmap.landtax.util;

import cn.gtmap.landtax.entity.Project;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

@Service("platUtil")
public class PlatUtil implements IPlatUtil {
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    @Qualifier("SysWorkFlowDefineService")
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    WorkFlowXmlUtil workFlowXmlUtil;
    SimpleDateFormat   simpleDateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    /**
     * ����������
     *
     * @param project
     * @param userId
     * @return taskId
     */

    public String createWorkFlowInstance(Project project, String userId,String proName) {

        String taskId = "";
        try {
            String wdid = project.getWdid();
            //判断当前登录用户是否有权限创建该流程
            checkAuthorCreateWorkflow(wdid,userId);
            PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();
            if(StringUtils.isNotBlank(project.getDay()))
                wfVO.setTimeLimit(String.valueOf(project.getDay()));
            if(StringUtils.isNotBlank(project.getCreateTime()))
                wfVO.setCreateTime(simpleDateFormat.parse(project.getCreateTime()));
            else
                wfVO.setCreateTime(Calendar.getInstance().getTime());
            wfVO.setWorkflowIntanceId(project.getProjectId());
            wfVO.setWorkflowDefinitionId(project.getWdid());
            wfVO.setProId(project.getProjectId());
            if (StringUtils.isBlank(project.getProjectName()))  {
                wfVO.setWorkflowIntanceName(proName);
            }else{
               wfVO.setWorkflowIntanceName(project.getProjectName());
            }
            wfVO.setCreateUser(userId);
            wfVO.setRemark(project.getBz());
//            WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService) Container
//                    .getBean("WorkFlowCoreService");

            WorkFlowInfo workFlowInfo = workFlowCoreService
                    .createWorkFlowInstance(wfVO, userId);

            for (PfTaskVo taskVo : workFlowInfo.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)
                        || userId == taskVo.getUserVo().getUserId()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (taskId == null || taskId.equals("")) {
                for (PfTaskVo taskVo : workFlowInfo.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            // taskId = workFlowInfo.getSourceTask().getTaskId();
        } catch (Exception e) {
            System.out.println("创建工作流实例失败");
//            e.printStackTrace();
            throw (RuntimeException)e;
        }
        return taskId;
    }

    private void checkAuthorCreateWorkflow(String wdid, String userId) {
        PfWorkFlowDefineVo pfWorkFlowDefineVo = workFlowDefineService.getWorkFlowDefine(wdid);
        WorkFlowXml workXml = workFlowXmlUtil.getWorkFlowDefineModel(pfWorkFlowDefineVo);
        ActivityModel beginModel = workXml.getActivityList().get(0);
        List<PerformerModel> performerList = beginModel.getPerformerList();
        List<String> performUserIdsList = new ArrayList<String>();
        Boolean flag = false;
        for (PerformerModel performerModel : performerList) {
            if (!performerModel.getUserId().equals("")) {// 参与者是人
                String userid = performerModel.getUserId();
                performUserIdsList.add(userid);
            } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                for(PfUserVo user : users){
                    performUserIdsList.add(user.getUserId());
                }
            } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                        .getRoleId());
                for(PfUserVo user : users){
                    performUserIdsList.add(user.getUserId());
                }
            }
        }

        for(String performUserId : performUserIdsList){
            if(performUserId.equals(userId)){
                flag = true;
                break;
            }
        }
        if(!flag){
            System.out.println("该用户不允许创建该流程");
            throw new RuntimeException("该用户不允许创建该流程");
        }
    }

    @Override
    public void deleteWorkFlowInstance(String proid) throws Exception {
        if(StringUtils.isNotBlank(proid))
            workFlowCoreService.deleteWorkFlowInstance(SessionUtil.getCurrentUserId(),proid);
    }

    /**
     * �޸�ʵ��remark+projectName projectname����Ϊ��
     *
     * @param projectId
     * @param remark
     * @param projectName
     */
    public void editWorkFlowInstance(String projectId, String remark,
                                     String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        if (wfInstanceVo != null) {
            wfInstanceVo.setRemark(remark);
            sysWorkFlowInstanceService.updateWorkFlowInstanceRemark(wfInstanceVo);
            if (!projectName.equals("")) {
                wfInstanceVo.setWorkflowIntanceName(projectName);
                sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
            }
        }
    }

    /**
     * �޸�ʵ�����
     *
     * @param projectId
     * @param projectName
     */
    public void editWorkFlowInstanceName(String projectId, String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        wfInstanceVo.setWorkflowIntanceName(projectName);
        sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
    }


    public String getActivityDesc(String projectId, String activityId) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceService");
        Document document = null;
        try {
            document = DocumentHelper.parseText(sysWorkFlowInstanceService.getWorkflowInstanceXml(projectId));
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Node node1 = root.selectSingleNode("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity[@Id='" + activityId + "']/Description");
        String activityDesc = node1.getText();
        if (activityDesc != null) {
            return activityDesc;
        } else {
            SysTaskService sysTaskService = (SysTaskService) Container.getBean("SysTaskService");
            PfActivityVo pfActivityVo = sysTaskService.getActivity(activityId);
            if (pfActivityVo != null) {
                activityDesc = pfActivityVo.getActivityName();
            }
            return activityDesc;
        }
    }

    /**
     * ��ȡ��ŵ����(��Ŀʱ��)
     *
     * @param wdid
     * @return
     */
    public String getCNQX(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        String cnqx = wfDefineVo.getTimeLimit();
        return cnqx;
    }

    /**
     * ���taskid��ȡ�ʵ�����
     *
     * @param taskId
     * @return activityName
     */
    public String getPfActivityNameByTaskId(String taskId) {
        SysTaskService sysTaskService = (SysTaskService) Container.getBean("SysTaskService");
        String activityName = "";
        if (taskId != null && !taskId.equals("")) {
            PfTaskVo pfTask = sysTaskService.getTask(taskId);
            if (pfTask != null) {
                String activitId = pfTask.getActivityId();
                PfActivityVo pfActivityVo = sysTaskService.getActivity(activitId);
                if (pfActivityVo != null) {
                    activityName = pfActivityVo.getActivityName();
                }
            }
        }
        return activityName;
    }

    /**
     * ���taskid��ȡ�ʵ�����
     *
     * @param taskId
     * @return activityName
     */
    public String getPfacdfIdByTaskId(String taskId) {
        SysTaskService sysTaskService = (SysTaskService) Container.getBean("SysTaskService");
        String activityId = "";
        if (taskId != null && !taskId.equals("")) {
            PfTaskVo pfTask = sysTaskService.getTask(taskId);
            if (pfTask != null) {
                String activitId = pfTask.getActivityId();
                PfActivityVo pfActivityVo = sysTaskService.getActivity(activitId);
                if (pfActivityVo != null) {
                    activityId = pfActivityVo.getActivityDefinitionId();
                }
            }
        }
        return activityId;
    }

    /**
     * ��ȡʵ��ʱ��
     *
     * @param wdid
     * @return
     */
    public String getTimeLimit(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        return wfDefineVo.getTimeLimit();
    }

    /**
     * ��ȡʵ��remark ͨ��projectId
     *
     * @param projectId
     * @return
     */
    public String getWfRemarkByProjectId(String projectId) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceService");
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wfInstanceVo.getWorkflowDefinitionId());
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    /**
     * ͨ����������ID(Wdid) ��ȡ�����������remark
     *
     * @param wdid
     * @return
     */
    public String getWfRemarkByWdid(String wdid) {
        // TODO Auto-generated method stub
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    public String getPfActivityIdByTaskId(String taskId) {
        SysTaskService sysTaskService = (SysTaskService) Container.getBean("SysTaskService");
        String activitId = "";
        if (taskId != null && !taskId.equals("")) {
            PfTaskVo pfTask = sysTaskService.getTask(taskId);
            if (pfTask != null) {
                activitId = pfTask.getActivityId();

            }
        }
        return activitId;
    }

    public List<String> getFileId(String projectId) {
        // TODO Auto-generated method stub
        List<String> listID = new ArrayList<String>();
        try {
            if (projectId != null && !projectId.equals("")) {
                List<com.gtis.fileCenter.model.Node> list = getProjectNode(projectId);
                for (com.gtis.fileCenter.model.Node node : list) {
                    listID.add(node.getId().toString());
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return listID;
    }

    @Override
    public List<String> getFileId(String projectId, String desc) {
        return null;
    }



/*    public List<String> getFileId(String projectId, String desc) {
        // TODO Auto-generated method stub
        List<String> listID = new ArrayList<String>();
        try {
            if (projectId != null && desc != null && !projectId.equals("")) {
                List<com.gtis.fileCenter.model.Node> list = getProjectNode(projectId);
                for (com.gtis.fileCenter.model.Node node : list) {
                    //zdd 一个收件项目多张附件  名称后面自动加数
//					zx名称存在不保存、BUG #3756 【常州】控件上传问题
//					if (node.getDescription()!=null && (node.getDescription().equals(desc) || (node.getDescription().startsWith(desc) && node.getDescription().length()-1==desc.length())))
                    if (node.getDescription() != null && (node.getDescription().equals(desc) || (node.getDescription().startsWith(desc) && CommonUtil.isNumeric(StringUtils.substring(node.getDescription(), node.getDescription().indexOf(desc) + desc.length(), node.getDescription().length())))))
                        listID.add(node.getId().toString());
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return listID;
    }*/

    /**
     * 编辑文件描述和姓名
     *
     * @param fileId
     * @param desc
     * @param projectId
     */
    public void saveNodeDescByProjectId(Integer fileId, String desc, String projectId) {
        try {
            NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
            com.gtis.fileCenter.model.Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                List<String> nodeList = getFileId(projectId, desc);
                if (nodeList.size() > 0) {
                    desc = desc + nodeList.size();
                }

                node.setName(desc + node.getName().substring(node.getName().lastIndexOf("."), node.getName().length()));
                node.setDescription(desc);
                nodeService.save(node);
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }

    public void removeFile(Integer fileId) {
        try {
            NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
            nodeService.remove(fileId);
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }

    public void saveNodeDesc(Integer fileId, String desc) {
        try {
            NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
            com.gtis.fileCenter.model.Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                node.setDescription(desc);
                nodeService.save(node);
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }

    public String getToken() {
        //zdd 数据中心万能的token
        String token = "whosyourdaddy";
        try {
            NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
            Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
            if (space != null)
                token = nodeService.getToken(space);
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return token;
    }

    private List<com.gtis.fileCenter.model.Node> getProjectNode(String projectId) {
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        com.gtis.fileCenter.model.Node tempNode = createFileFolder(space.getId(), projectId);
        List<com.gtis.fileCenter.model.Node> list = nodeService.getAllChildNodes(tempNode.getId());
        return list;
    }

    private com.gtis.fileCenter.model.Node createFileFolder(Integer parentId, String folderNodeName) {
        com.gtis.fileCenter.model.Node tempNode = null;
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        try {
            tempNode = nodeService.getNode(parentId, folderNodeName, true);
        } catch (NodeNotFoundException e) {
            //    		tempNode = new com.gtis.fileCenter.model.Node();
            //    		tempNode.setName(folderNodeName);
            //    		tempNode.setParentId(parentId);
            //    		tempNode = nodeService.save(tempNode);
            e.printStackTrace();
        }
        return tempNode;
    }


    public String getWorkFlowStuffId() {
        // TODO Auto-generated method stub
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        return space.getId().toString();
    }

    public String getProjectFileId(String projectId) {
        // TODO Auto-generated method stub
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        com.gtis.fileCenter.model.Node tempNode = createFileFolder(space.getId(), projectId);
        return tempNode.getId().toString();
    }

    public Integer createFileFolderByclmc(String parentId, String folderNodeName) {
        // TODO Auto-generated method stub
        com.gtis.fileCenter.model.Node tempNode = null;
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        try {
            tempNode = nodeService.getNode(Integer.valueOf(parentId), folderNodeName, true);
            //nodeService.createNode(Integer.valueOf(parentId), folderNodeName);
        } catch (NodeNotFoundException e) {
            e.printStackTrace();
        }
        return tempNode.getId();
    }

    public void updateFileName(String projectId) {
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        com.gtis.fileCenter.model.Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List<com.gtis.fileCenter.model.Node> childNodes = nodeService.getChildNodes(prjNode.getId());
        int i = 0;
        for (com.gtis.fileCenter.model.Node node : childNodes) {
            if (node.getType() == 0) {
                getFilesByFolder(node);
            } else if (node.getType() == 1) {
                String fileType = "";
                if (node.getName().lastIndexOf('.') != -1) {
                    fileType = node.getName().substring(node.getName().lastIndexOf('.'));
                }
                node.setName(prjNode.getName() + (++i) + fileType);
                nodeService.save(node);
            }
        }
    }

    public void getFilesByFolder(com.gtis.fileCenter.model.Node node) {
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        List<com.gtis.fileCenter.model.Node> childNodes = nodeService.getChildNodes(node.getId());
        int i = 0;
        for (com.gtis.fileCenter.model.Node childNode : childNodes) {
            if (childNode.getType() == 0) {
                getFilesByFolder(childNode);
            } else if (childNode.getType() == 1) {
                String fileType = "";
                if (childNode.getName().lastIndexOf('.') != -1) {
                    fileType = childNode.getName().substring(childNode.getName().lastIndexOf('.'));
                }
                childNode.setName(node.getName() + (++i) + fileType);
                nodeService.save(childNode);
            }
        }
    }

    public boolean checkFloder(String projectId,String floderName){
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        com.gtis.fileCenter.model.Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List<com.gtis.fileCenter.model.Node> childNodes = nodeService.getChildNodes(prjNode.getId());
        int i = 0;
        for (com.gtis.fileCenter.model.Node node : childNodes) {
             if(node.getName().equals(floderName)){
                 int filesCounet = nodeService.getAllChildFilesCount(node.getId());
                 if(filesCounet > 0){
                     return true;
                 }
             }
        }
        return false;
    }
    public Integer getFilesCounet(String projectId,String floderName){
        int filesCounet = 0;
        NodeService nodeService = (NodeService) Container.getBean("FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        com.gtis.fileCenter.model.Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List<com.gtis.fileCenter.model.Node> childNodes = nodeService.getChildNodes(prjNode.getId());
        int i = 0;
        for (com.gtis.fileCenter.model.Node node : childNodes) {
            if(node.getName().equals(floderName)){
                 filesCounet = nodeService.getAllChildFilesCount(node.getId());
            }
        }
        return filesCounet;
    }

    /**
     * 根据proid获取taskId
     * @param proid
     * @return
     */
    public static String getTaskIdByProid(String proid){
        String taskid=null;
        try {
            SysTaskService sysTaskService = (SysTaskService)Container.getBean("TaskService");
            List<PfTaskVo> list=sysTaskService.getTaskListByInstance(proid);
            if(list!=null && list.size()>0)
                taskid = list.get(0).getTaskId();
        } catch (Exception e) {
        }
        return taskid;
    }
}
