package cn.gtmap.landtax.support.spring;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Author:  yingxiufeng
 * Project: landtax
 * Date:    2015/4/21 9:35
 * File:    BaseController
 * (c) Copyright gtmap Corp.2015
 */
public class BaseController {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    protected final String RESULT = "result";

    @Autowired
    protected MessageSource message;

    /**
     * 获取message
     *
     * @param key
     * @param param
     * @return
     */
    protected String getMessage(String key, Object... param) {
        return message.getMessage(key, param, Locale.getDefault());
    }

    /**
     * result map
     *
     * @param value
     * @return
     */
    protected Map<String, Object> result(Object value) {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put(RESULT, value);
        return result;
    }

    /**
     * write error to client
     *
     * @param info
     * @param response
     */
    protected void error(String info, HttpServletResponse response) {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", info);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        } catch (IOException e) {
            logger.error(e.getLocalizedMessage());
        }
    }

    /**
     * write result to client
     *
     * @param value
     * @param response
     * @return
     */
    protected void result(Object value, HttpServletResponse response) {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put(RESULT, value);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        } catch (IOException e) {
            logger.error(e.getLocalizedMessage());
        }
    }


}
