package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Dldm;
import cn.gtmap.landtax.model.dictionary.Gtlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Zdlx;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.NoResultException;
import javax.persistence.Query;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/18
 */
@Service
public class ZdServiceImpl implements ZdService {


    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;
    @Transactional(readOnly = true)
    @Override
    public Page<ZdQuery> findZd(ZdQuery zdQuery, Pageable pageable) {
        QZd qZd = QZd.zd;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSSjGtbd qsSjGtbd = QSSjGtbd.sSjGtbd;
        QBean qBean = Projections.bean(ZdQuery.class,qZd.djh,qZd.tdzl,qZd.scmjZd,qZd.qlrmc, qZd.tdyt,qZd.tdytmc);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());

        jpaQuery.from(qZd);
        if(StringUtils.isNotBlank(zdQuery.getZdlx()) && zdQuery.getZdlx().equals(Zdlx.ZSZD.toString())){
            jpaQuery.where(qZd.djh.in(new JPASubQuery().from(qsSjGtbd).where(qsSjGtbd.blzt.eq("1")).list(qsSjGtbd.djh)));
        }
        if(StringUtils.isNotBlank(zdQuery.getGjzt()) && "2".equals(zdQuery.getGjzt())){
            jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
        }

        applyZdQueryPredicates(zdQuery, qZd, jpaQuery);
        return baseRepository.find(jpaQuery,qBean,pageable);

    }

    @Transactional(readOnly = true)
    @Override
    public List<ZdQuery> findAllZdDjh() {
        QZd qZd = QZd.zd;
        QBean qBean = Projections.bean(ZdQuery.class,qZd.djh);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qZd);
        baseRepository.addEntityPath(qZd);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }

    @Transactional(readOnly = true)
    @Override
    public ZdQuery findZdqueryByDjh(String djh) {
        QZd qZd = QZd.zd;
        QBean qBean = Projections.bean(ZdQuery.class,qZd.djh,qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qZd.tdzl);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qZd);
        jpaQuery.where(qZd.djh.eq(djh));
        baseRepository.addEntityPath(qZd);
        return (ZdQuery) baseRepository.get(jpaQuery,qBean);
    }

    @Override
    @Transactional(readOnly = true)
    public Object getSysByDjhs(String djhs) {
        String[] djhsArr = djhs.split(",");
        String[] sysArr = new String[djhsArr.length];


        String sql = "select count(t2.djh) as counts from (select t1.* FROM sw_dj_sy t1 where t1.syzt='1' or t1.syzt is null)t2 group by t2.djh having t2.djh=";
        for(int i=0;i<djhsArr.length;i++){
            Object tempObj = null;
            String query = sql + "'"+djhsArr[i]+"'";
            try {
                tempObj = baseRepository.getEntityManager().createNativeQuery(query).getSingleResult();
            }catch (NoResultException e){
                tempObj = "0";
            }
            sysArr[i] = String.valueOf(tempObj);
        }

        return sysArr;
    }

    @Override
    public Object getSysByGtIds(String ids, String sysjly) {
        String[] idsArr = ids.split(",");
        String[] sysArr = new String[idsArr.length];
        String keyField = "DJH";

        if (sysjly == Gtlx.ZD.toString()) {
            keyField = "DJH";
        }
        else if (sysjly == Gtlx.BP.toString()) {
            keyField = "BP_ID";
        }
        else if (sysjly == Gtlx.GD.toString()) {
            keyField = "GD_ID";
        }
        String sql = "SELECT COUNT(t.SY_ID) FROM SW_DJ_SY t WHERE (t.SYZT='1' OR t.SYZT IS NULL) AND %s='%s' ";
        for(int i=0;i<idsArr.length;i++){
            Object tempObj = null;
            String query = String.format(sql, keyField, idsArr[i]);
            try {
                tempObj = baseRepository.getEntityManager().createNativeQuery(query).getSingleResult();
            }catch (NoResultException e){
                tempObj = "0";
            }
            sysArr[i] = String.valueOf(tempObj);
        }

        return sysArr;
    }

    @Override
    public String TransQueryXzq(String regionCode) {
        if(regionCode.length()>=6){
            regionCode = regionCode.substring(0,6);
        }

        String queryCode = regionCode;

        String sql = "SELECT XZQDM, CXDM FROM S_DM_ZDCXDZB WHERE XZQDM='" + regionCode + "' AND ROWNUM = 1";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap> resultList = query.getResultList();
        if (CollectionUtils.isNotEmpty(resultList)) {
            HashMap resultMap = resultList.get(0);
            queryCode = resultMap.get("CXDM").toString();
        }

        return queryCode;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTdjbByQxLike(String qx) {
        String sql = "select t.dm,t.mc from s_zd_tdjb t where t.dm like '"+qx+"%' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public String getMaxXnzdDjhByJd(String bjjd) {
        String sql = "select max(to_char(t.djh))djh from zd t where t.djh like '"+bjjd+"999999%' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List resultList = query.getResultList();
        if(CollectionUtils.isNotEmpty(resultList)){
            return String.valueOf(((HashMap)resultList.get(0)).get("DJH"));
        }
        return null;
    }

    @Override
    @Transactional(readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List<ZdQuery> findZdList(ZdQuery zdQuery) {
        QZd qZd = QZd.zd;

        QBean qBean = Projections.bean(ZdQuery.class,qZd.djh,qZd.tdzl,qZd.scmjZd,qZd.qlrmc, qZd.tdyt,qZd.tdytmc);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qZd);
        applyZdQueryPredicates(zdQuery,qZd,jpaQuery);
        return (List)baseRepository.dslList(jpaQuery,qBean);


    }

    @Override
    @Transactional
    public String doZdGdGj(String djh, String xmId) {
        String msg= "";
        if(StringUtils.isBlank(djh) || StringUtils.isBlank(xmId)){
            msg = "你选择的宗地或者供地不存在";
        }else{
            Zd zd = baseRepository.get(Zd.class,djh);
            SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class,xmId);
            String zdBlzt = "";
            String zdRwJpql = "from SSjGtbd o where o.djh=?0";
            List<SSjGtbd> sSjGtbdList = baseRepository.getByJpql(zdRwJpql,djh);
            if(CollectionUtils.isNotEmpty(sSjGtbdList)){
                SSjGtbd sSjGtbd = sSjGtbdList.get(0);
                zdBlzt = sSjGtbd.getBlzt();
            }

            String gdBlzt = "";
            String gdRwJpql = "from SwHcXmRwRel o where o.bdId=?0 and o.swHcXm.xmlx=?1";
            List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(gdRwJpql,xmId, Hcxmlx.GDHC.toString());
            if(CollectionUtils.isNotEmpty(swHcXmRwRelList)){
                SwHcXmRwRel swHcXmRwRel = swHcXmRwRelList.get(0);
                gdBlzt = swHcXmRwRel.getBlzt();
            }

            String zdJpql = "from SwDjSy o where o.zd.djh =?0 and (o.syzt is null or o.syzt='1') ";
            String gdJpql = "from SwDjSy o where o.swDjXmxx.xmId=?0 and (o.syzt is null or o.syzt='1')";
            List<SwDjSy> zdsyList = baseRepository.getByJpql(zdJpql,djh);
            List<SwDjSy> gdsyList = baseRepository.getByJpql(gdJpql,xmId);

            if((!djh.contains("999999")) && (StringUtils.isBlank(zdBlzt) || "0".equals(zdBlzt))&&(StringUtils.isBlank(gdBlzt) || "0".equals(gdBlzt))){
                //两个都未办理
                msg = "你选择宗地和供地核查任务都未办理完成";
            }else if( ("1".equals(zdBlzt) || djh.contains("999999")) && (StringUtils.isBlank(gdBlzt) || "0".equals(gdBlzt))){
                //宗地办理，供地未办理
                msg = "挂接成功";
                //宗地供地挂接
                swDjXmxx.setZd(zd);
                baseRepository.update(swDjXmxx);
            }else if((StringUtils.isBlank(zdBlzt) || "0".equals(zdBlzt) && ("1".equals(gdBlzt)))){
                //宗地未办理，供地办理
                if(CollectionUtils.isNotEmpty(gdsyList)){
                    for(int i=0 ;i <gdsyList.size() ;i++){
                        SwDjSy gdsy = gdsyList.get(i);
                        SwDjTd swDjTd = gdsy.getSwDjTd();
                        SwDjFc swDjFc = gdsy.getSwDjFc();
                        gdsy.setSwDjTd(null);
                        gdsy.setSwDjFc(null);
                        baseRepository.update(gdsy);

                        SwDjSy swDjSy = new SwDjSy();
                        swDjSy.setZd(zd);
                        swDjSy.setSyzt("1");
                        String dbh = taxService.createDbhByDjh(zd.getDjh());
                        swDjSy.setDbh(dbh);
                        swDjSy.setSysjly(Gtlx.ZD.toString());
                        swDjSy.setSyId(UUIDGenerator.generate());
                        baseRepository.save(swDjSy);

                        swDjTd.setSwDjSy(swDjSy);
                        swDjFc.setSwDjSy(swDjSy);
                        baseRepository.update(swDjTd);
                        baseRepository.update(swDjFc);
                    }
                }
                msg = "挂接成功";
                //宗地供地挂接
                swDjXmxx.setZd(zd);
                baseRepository.update(swDjXmxx);
            }else if("1".equals(zdBlzt) && "1".equals(gdBlzt)){
                //两个都 已办理
                if(CollectionUtils.isNotEmpty(gdsyList)) {
                    for (int i = 0; i < gdsyList.size(); i++) {
                        SwDjSy gdsy = gdsyList.get(i);
                        taxService.deletSwDjTdByTdId(gdsy.getSwDjTd().getTdId());
                        taxService.deletSwDjFcByFcId(gdsy.getSwDjFc().getFcId());
                    }
                }
                msg = "挂接成功";
                //宗地供地挂接
                swDjXmxx.setZd(zd);
                baseRepository.update(swDjXmxx);
            }



        }
        return msg;
    }

    private void applyZdQueryPredicates(ZdQuery zdQuery,QZd qZd,JPQLQuery jpaQuery){

        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isNotBlank(regionCode)){
            String queryCode = TransQueryXzq(regionCode);
            if (queryCode != null) {
                if (queryCode.length() <= 6) {
                    jpaQuery.where(qZd.sgqdm.isNotEmpty()).where(Expressions.stringPath(qZd, "sgqdm").like(QueryCondition.WILDCARDS + queryCode + QueryCondition.WILDCARDS));
                } else {
                    jpaQuery.where(qZd.sgqdm.isNotEmpty()).where(Expressions.stringPath(qZd, "sgqdm").substring(0, 6).in(queryCode.split(",")));
                }
            }
        }
        if(StringUtils.isNotBlank(zdQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(QueryCondition.WILDCARDS + zdQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(qZd, "qlrmc").like(QueryCondition.WILDCARDS + zdQuery.getQlrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdzl").like(QueryCondition.WILDCARDS + zdQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getTdzh()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdzh").like(QueryCondition.WILDCARDS + zdQuery.getTdzh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getTdyt()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdyt").like(zdQuery.getTdyt()));
        if(StringUtils.isNotBlank(zdQuery.getJf()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(zdQuery.getJf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getJd()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(zdQuery.getJd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getQx()))
            jpaQuery.where(qZd.sgqdm.isNotEmpty()).where(Expressions.stringPath(qZd, "sgqdm").like(zdQuery.getQx() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getZdlx()) && Zdlx.XNZD.toString().equals(zdQuery.getZdlx()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(QueryCondition.WILDCARDS+"999999"+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getZdlx()) && Zdlx.ZSZD.toString().equals(zdQuery.getZdlx()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").notLike(QueryCondition.WILDCARDS+"999999"+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(zdQuery.getIds()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").in(zdQuery.getIds().split(",")));
        if(StringUtils.isNotBlank(zdQuery.getExcelBegin()) && StringUtils.isNotBlank(zdQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(zdQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(zdQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }

    }

    @Override
    public Zd findZdByDjh(String djh) {
        Zd zd = baseRepository.get(Zd.class, djh);
        return zd;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Zd> getZdsByDjhs(String[] djh) {
        QZd qZd =  QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        Integer length  = djh.length;
        if(length>100){
            String[] djh1 = Arrays.copyOfRange(djh, 0, 500);
            String[] djh2 = Arrays.copyOfRange(djh,500,length);
            jpaQuery.from(qZd).where(qZd.djh.in(djh1).or(qZd.djh.in(djh2)));
            return (List)baseRepository.dslList(jpaQuery,qZd);
        }
        jpaQuery.from(qZd).where(qZd.djh.in(djh));
        return (List)baseRepository.dslList(jpaQuery,qZd);
    }

    @Override
    public String getTdytMcByTdyt(String tdyt) {
        Dldm[] dldms = Dldm.values();
        for(int i=0;i<dldms.length;i++){
            if(dldms[i].getDm().equals(tdyt)){
                return dldms[i].getMc();
            }
        }
        return null;
    }


    @Override
    @Transactional(readOnly = true)
    public String findTddjByDm(String tddjDm){
        String msg ="";
        String sql = "select t.dm,t.mc from s_zd_tdjb t where t.dm like '"+tddjDm+"%' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(list.size()>0){
            HashMap tempmap = (HashMap)list.get(0);
            msg = (String)tempmap.get("MC");
        }

        return msg;

    }
}
