package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.YdqcZdQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.quartz.TbSbSjQuartz;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.*;


/**
 * Created by Administrator on 2014/9/2.
 */
@Service
public class YdqcServiceImpl implements YdqcService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    ZdService zdService;
    @Autowired
    HashMap hcjdConfigMap;

    @Override
    @Transactional(readOnly = true)
    public Page findZdList(ZdQuery zdQuery, Pageable pageable) {

        String sql = "select to_char(t4.djh)djh,to_char(t4.qlrmc)qlrmc,to_char(t4.tdzl)tdzl,to_char(t4.tdytmc)tdytmc,t4.scmj as scmj,t3.td_scmj_sum as djzmj,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min from (";
            sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) ";
        sql = addParameter(zdQuery,sql);
        sql += " order by min desc";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null )";
        countSql = addParameter(zdQuery,countSql);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    public List<SwDjSyTemp> findSytzByProid(String proid) {
        String jpql = "from SwDjSyTemp o  where o.rwid=?0";
        return baseRepository.getByJpql(jpql,proid);
    }

    @Override
    @Transactional
    /**
     * 1，把sytemp表数据写入sy主表
     * 2，swHcXmRwRel表设置blzt=1
     * 3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
     * 4，表ydqcRel修改blzt=1
     */
    public void zdYdqcWfEnd(String proid) throws  Exception{
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = swHcXmRwRel.getBdId();
        //1，把sytemp表数据写入sy主表
        String jpql = "from SwDjSyTemp o where o.rwid=?0";
        List<SwDjSyTemp> swDjSyTempList = baseRepository.getByJpql(jpql,proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, swDjSyQuery);
            taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        }
        //2，swHcXmRwRel表设置blzt=1
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);
        //3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }
        //4，表ydqcRel修改blzt=1
        String jpql3 = "update YdqcRel o set o.blzt='1' where o.djh=?0";
        baseRepository.executeJpql(jpql3,djh);

    }

    @Override
    @Transactional
    /**
     * 1，sytemp表删除该任务所有税源信息
     * 2，syhis表删除该任务所有税源信息
     * 3，swHcXmRwRel表删除该任务
     * 4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
     * 5,删除表ydqcRel,根据djh删除
     */
    public void zdYdqcWfDel(String proid) {
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = swHcXmRwRel.getBdId();
        //1，sytemp表删除该任务所有税源信息
        String jpql = "delete from SwDjSyTemp o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //2，syhis表删除该任务所有税源信息
        jpql = "delete from SwDjSyHis o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //3,swHcXmRwRel表删除该任务
        baseRepository.delete(swHcXmRwRel);
        //4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";

        List<SwHcXmRwRel> swHcXmRwRelList =  baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//删除项目
            baseRepository.delete(swHcXm);
        }else{
            String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
            List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
            if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
                swHcXm.setXmybj("1");
                baseRepository.update(swHcXm);
            }
        }
        //5,删除表ydqcRel,根据djh删除
        jpql = "delete from YdqcRel o where o.djh=?0";
        baseRepository.executeJpql(jpql,djh);
    }

    @Override
    @Transactional(readOnly = true)
    public List<Object> getZdydqcTzList(HashMap param) {
        Object obj = param.get("ids");
        ZdQuery zdQuery = (ZdQuery) param.get("zdQuery");

        String sql = "select to_char(t4.djh),to_char(t4.qlrmc),to_char(t4.tdzl),to_char(t4.tdytmc),t4.scmj as scmj,t3.td_scmj_sum as djzmj,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min from (";
        sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  where t2.sgzt_dm='01' and t1.syzt='1' group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel) ";

        if(obj==null) {//导出全部
            sql = addParameter(zdQuery,sql);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t4.djh in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    private StringBuffer addParameter(SbZsQuery sbZsQuery,StringBuffer sql){
        if(StringUtils.isNotBlank(sbZsQuery.getGlbm())){
            sql.append("and glbm like '%").append(sbZsQuery.getGlbm()).append("%' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getNsrmc())){
            sql.append("and nsrmc like '%").append(sbZsQuery.getNsrmc()).append("%' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getZclx())){
            if (sbZsQuery.getZclx().equals(SbZsQuery.ZCLX_QY)) {
                sql.append("and zclx_dm not IN ('710', '720') ");
            } else if (sbZsQuery.getZclx().equals(SbZsQuery.ZCLX_GR)) {
                sql.append("and zclx_dm IN ('710', '720') ");
            }
        }
        if(StringUtils.isNotBlank(sbZsQuery.getQxdm())){
            sql.append("and qxdm = '").append(sbZsQuery.getQxdm()).append("' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getZgkgDm())){
            sql.append("and zgkg_dm = '").append(sbZsQuery.getZgkgDm()).append("' ");
        }
        return sql;
    }

    private StringBuffer getSbListSql(String szdm, SbZsQuery sbZsQuery){
        String ssnf = sbZsQuery.getYear();
        String sssq = sbZsQuery.getSssq();
        StringBuffer sqlBuffer = null;
        String sql = "";
        String table = "";
        int sqEnd = 4;

        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_sbydqc_td";
            sqEnd = 4;
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_sbydqc_fc";
            sqEnd = 2;
        }

        if(StringUtils.isBlank(ssnf) || StringUtils.isBlank(sssq)){
            int sq, sqYear;
            sqYear = Calendar.getInstance().get(Calendar.YEAR);
            sq = Integer.parseInt(CommonUtil.getSssqByNow(szdm));
            if (sq == 1) {
                sq = sqEnd;
                sqYear = sqYear - 1;
            } else {
                sq = sq - 1;
            }

            ssnf = String.valueOf(sqYear);
            sssq = String.valueOf(sq);
        }

        sql =   "select t1.*, t2.activity_name, t2.activity_state " +
                "from ( " +
                "       select t1.*, t2.zgkg_mc, t2.zgkg_dm " +
                "       from " + table + " t1 left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id " +
                "       where t1.ssnf='" + ssnf + "' and t1.sssq='" + sssq + "' and ydtype='" + Ydtype.HCH.toString()+ "' " +
                "   )t1 left join (" +
                "       select * " +
                "       from ( " +
                "           select t.*,rank() over(partition by workflow_instance_id order by finish_time desc ) xh " +
                "           from pf_activity t) " +
                "       where xh ='1' " +
                "   ) t2 on t1.rwid=t2.workflow_instance_id " +
                "where 1=1 ";

        sqlBuffer = new StringBuffer().append(sql);
        sqlBuffer = addParameter(sbZsQuery,sqlBuffer);
        return sqlBuffer;
    }

    @Override
    @Transactional
    public void saveOrUpdateTdSbXgsqb(TdSbXgsqb tdSbXgsqb) throws  Exception{
        String proid = tdSbXgsqb.getProid();
        TdSbXgsqb old = baseRepository.get(TdSbXgsqb.class,proid);
        if(old!=null){//update
            old.setBz(tdSbXgsqb.getBz());
            old.setXgyy(tdSbXgsqb.getXgyy());
            old.setXgrq(new Date());
            old.setHsqk(tdSbXgsqb.getHsqk());
            baseRepository.update(old);
        }else{//save
            tdSbXgsqb.setXgrq(new Date());
            baseRepository.save(tdSbXgsqb);
        }
    }




    private String addParameter(ZdQuery zdQuery,String sql){
        if(StringUtils.isNotBlank(zdQuery.getDjh())){
            sql = sql + " and t4.djh like '"+zdQuery.getDjh().trim()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getQlrmc())){
            sql = sql + " and t4.qlrmc like '%"+zdQuery.getQlrmc()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getTdzl())){
            sql = sql + " and t4.tdzl like '%"+zdQuery.getTdzl()+"%'";
        }
        return sql;
    }

    private StringBuffer sbAddParameter(SwDjSyQuery swDjSyQuery,StringBuffer sql){
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm())){
            sql = sql.append(" and t3.glbm like '%"+swDjSyQuery.getGlbm().trim()+"%' ");
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql = sql.append(" and t5.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%' ");
        }
        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public List<HashMap<String, Object>> sumNynseByGlbm(String szdm, String glbm) {
        StringBuffer sql = new StringBuffer()
                .append("select sum(nvl(t1.nynse,0))as nynse,glbm ");
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sql.append("from sw_dj_td t1 ");
        }else if(szdm.equals(Szdm.FCS.toString())){
            sql.append("from sw_dj_fc t1 ");
        }
            sql.append("left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id  ")
                .append("group by t2.glbm ")
                .append("having glbm= '").append(glbm).append("' ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getZtById(String id,String hcxmlx) {

        StringBuffer sql = new StringBuffer()
                .append("select t1.*,t2.activity_state,t2.activity_name from ");
                if(hcxmlx.equals(Hcxmlx.TDSBJSYDQC.toString())){
                    sql.append("(select t1.* from s_sj_sbydqc_td t1 where t1.tdsbyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.FCSBJSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_SBYDQC_FC t1 where t1.fcsbyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.TDZSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_ZSYDQC_TD t1 where t1.tdzsyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.FCZSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_ZSYDQC_FC t1 where t1.fczsyd_id = '").append(id).append("')t1 ");
                }
                sql.append("left join ")
                .append("(select * from (select t.*,rank() over(partition by workflow_instance_id order by finish_time desc ) xh from pf_activity t )where xh='1')t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        ResponseMessage responseMessage = new ResponseMessage();
        if(CollectionUtils.isNotEmpty(list)){
            HashMap<String,Object> tempMap = list.get(0);
            String activityName = String.valueOf(tempMap.get("ACTIVITY_NAME"));
            String activity_state = String.valueOf(tempMap.get("ACTIVITY_STATE"));
            if(StringUtils.isBlank(activityName) || "null".equalsIgnoreCase(activityName)){
                responseMessage.setMsg("待下发");
            }else if("1".equals(activity_state)){
                responseMessage.setMsg(activityName);
            }else{
                responseMessage.setMsg("任务已办结");
            }
        }
        return responseMessage;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public BigDecimal getTotalTdNynseByProid(String proid) {
        String sql = "select sum(nvl(t.nynse_td,0))nynse_td from sw_dj_sy_temp t where t.rwid='"+proid+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("NYNSE_TD")));
        }
        return null;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public BigDecimal getTotalFcNynseByProid(String proid) {
        String sql = "select sum(nvl(t.nynse_fc,0))nynse_fc from sw_dj_sy_temp t where t.rwid='"+proid+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("NYNSE_FC")));
        }
        return null;

    }

    @Override
    public BigDecimal getRkseByProid(String proid, String szdm, String ssnf, String sssq) {
        String sql = "";
        if (szdm.equals(Szdm.CZTDSYS.toString())) {
            sql = "SELECT NVL(SUM(b.NSE), 0) AS RKSE " +
                    "FROM LOCAL_SB_RKSS b " +
                    "WHERE TO_CHAR(b.FSRQ, 'YYYY')='" + ssnf + "' AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) <= (MOD((TO_NUMBER(" + sssq + ") - 1), 4) + 1) " +
                    "      AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) >= (TRUNC((TO_NUMBER(" + sssq + ") - 1) / 4, 0) + 1) AND b.SZDM='13' " +
                    "      AND b.GLBM IN (SELECT GLBM FROM S_SJ_ZSYDQC_TD WHERE RWID='" + proid + "')";
        } else {
            sql = "SELECT NVL(SUM(b.NSE), 0) AS RKSE " +
                    "FROM LOCAL_SB_RKSS b " +
                    "WHERE TO_CHAR(b.FSRQ, 'YYYY')='" + ssnf + "' AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) <= (MOD((TO_NUMBER(" + sssq + ") - 1), 2) + 1) " +
                    "      AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) >= (TRUNC((TO_NUMBER(" + sssq + ") - 1) / 2, 0) + 1) AND b.SZDM='11' " +
                    "      AND b.GLBM IN (SELECT GLBM FROM S_SJ_ZSYDQC_TD WHERE RWID='" + proid + "')";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("RKSE")));
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Zd> findZdListTz(ZdQuery zdQuery) {
        String sql = "select to_char(t4.djh)djh from (";
        sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) ";
        sql = addParameter(zdQuery,sql);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List djhsList = query.getResultList();
        String[] djhsArr = (String[]) djhsList.toArray(new String[0]);
        return zdService.getZdsByDjhs(djhsArr);
    }


    @Override
    @Transactional(readOnly = true)
    public List<SSjZsydqcTd> getTdZsByIds(List<String> hcxmBdIds) {
        String[] ydids = list2StringArr(hcxmBdIds);
        QSSjZsydqcTd qsSjZsydqcTd = QSSjZsydqcTd.sSjZsydqcTd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjZsydqcTd).where(qsSjZsydqcTd.tdzsydId.in(ydids));
        return (List)baseRepository.dslList(jpaQuery,qsSjZsydqcTd);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SSjZsydqcFc> getFcZsByIds(List<String> hcxmBdIds) {
        String[] ydids =  list2StringArr(hcxmBdIds);
        QSSjZsydqcFc qsSjZsydqcFc = QSSjZsydqcFc.sSjZsydqcFc;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjZsydqcFc).where(qsSjZsydqcFc.fczsydId.in(ydids));
        return (List)baseRepository.dslList(jpaQuery,qsSjZsydqcFc);
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> getzsYearList(String szdm) {
        String  sql = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sql  = "select distinct ssnf from s_sj_zsydqc_td order by ssnf desc";
        }else if(szdm.equals(Szdm.FCS.toString())) {
            sql = "select distinct ssnf from s_sj_zsydqc_fc order by ssnf desc";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        return query.getResultList();
    }

    @Override
    @Transactional
    public Object findZsListJson(SbZsQuery sbZsQuery, String szdm, Pageable pageable) {
        // 检查当前属期是否已经生成疑点数据，若没有，则生成
        checkAndCreateZdydData(sbZsQuery.getYear(), sbZsQuery.getSssq(), szdm);

        StringBuffer sql = getZsListSql(szdm, sbZsQuery);
        sql.append("order by cyje desc");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional
    public void zsYdqcWfEnd(String proid, String szdm) throws  Exception{
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        //1，把sytemp表数据写入sy主表
        String jpql = "from SwDjSyTemp o where o.rwid=?0";
        List<SwDjSyTemp> swDjSyTempList = baseRepository.getByJpql(jpql,proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, swDjSyQuery);
            taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        }
        //2，swHcXmRwRel表设置blzt=1
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);
        //3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }

        String ydqcId = swHcXmRwRel.getBdId();
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            //更新SSjZsydqcTd
            SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcId);
            String glbm = sSjZsydqcTd.getGlbm();
            String sq = sSjZsydqcTd.getSssq();
            List<HashMap<String,Object>> list = sumNynseByGlbm(szdm,glbm);
            if(CollectionUtils.isNotEmpty(list)){
                HashMap<String,Object> map = list.get(0);
                BigDecimal endYjse = map.get("NYNSE")==null? BigDecimal.ZERO:new BigDecimal(String.valueOf(map.get("NYNSE")));
                endYjse = endYjse.divide(new BigDecimal(4)).multiply(new BigDecimal(sq));
                sSjZsydqcTd.setEndYjse(endYjse);
                //EndSbse,EndCybl在办结后 定时任务中修改信息
                baseRepository.update(sSjZsydqcTd);
            }
        }else if (szdm.equals(Szdm.FCS.toString())){
            //更新SSjZsydqcFc
            SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcId);
            String glbm = sSjZsydqcFc.getGlbm();
            String sq = sSjZsydqcFc.getSssq();
            List<HashMap<String,Object>> list = sumNynseByGlbm(szdm,glbm);
            if(CollectionUtils.isNotEmpty(list)){
                HashMap<String,Object> map = list.get(0);
                BigDecimal endYjse = map.get("NYNSE")==null? BigDecimal.ZERO:new BigDecimal(String.valueOf(map.get("NYNSE")));
                endYjse = endYjse.divide(new BigDecimal(2)).multiply(new BigDecimal(sq));
                sSjZsydqcFc.setEndYjse(endYjse);
                //EndSbse,EndCybl在办结后 定时任务中修改信息
                baseRepository.update(sSjZsydqcFc);
            }
        }
    }

    @Override
    @Transactional
    public void zsYdqcWfDel(String proid, String szdm) {
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);

        //1，sytemp表删除该任务所有税源信息
        String jpql = "delete from SwDjSyTemp o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //2，syhis表删除该任务所有税源信息
        jpql = "delete from SwDjSyHis o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);

        if (swHcXmRwRel != null) {
            //3,swHcXmRwRel表删除该任务
            baseRepository.delete(swHcXmRwRel);
            //4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
            SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
            String xmId = swHcXm.getXmId();
            jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";
            List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(jpql, xmId);
            if (CollectionUtils.isEmpty(swHcXmRwRelList)) {//删除项目
                baseRepository.delete(swHcXm);
            } else {
                String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
                List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2, xmId);
                if (CollectionUtils.isEmpty(swHcXmRwRelList2)) {//说明该项目下的所有任务都已经办理完成
                    swHcXm.setXmybj("1");
                    baseRepository.update(swHcXm);
                }
            }

            String ydqcId = swHcXmRwRel.getBdId();
            if (szdm.equals(Szdm.CZTDSYS.toString())) {
                SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class, ydqcId);
                sSjZsydqcTd.setRwid("");
                sSjZsydqcTd.setHsqk("");
                baseRepository.update(sSjZsydqcTd);
            } else if (szdm.equals(Szdm.FCS.toString())) {
                SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class, ydqcId);
                sSjZsydqcFc.setRwid("");
                sSjZsydqcFc.setHsqk("");
                baseRepository.update(sSjZsydqcFc);
            }
        }

        //6删除TdSbXgsqb
        baseRepository.delete(TdSbXgsqb.class,proid);
    }

    @Override
    public StringBuffer getZsListSql(String szdm,SbZsQuery sbZsQuery){
        String ssnf = sbZsQuery.getYear();
        String sssq = sbZsQuery.getSssq();
        StringBuffer sqlBuffer = null;
        String sql = "";
        String table = "";
        int sqEnd = 4;
        String xmlx = "";

        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_zsydqc_td";
            sqEnd = 4;
            xmlx = Hcxmlx.TDZSYDQC.toString();
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_zsydqc_fc";
            sqEnd = 2;
            xmlx = Hcxmlx.FCZSYDQC.toString();
        }

        if(StringUtils.isBlank(ssnf) || StringUtils.isBlank(sssq)){
            int sq, sqYear;
            sqYear = Calendar.getInstance().get(Calendar.YEAR);
            sq = Integer.parseInt(CommonUtil.getSssqByNow(szdm));
            if (sq == 1) {
                sq = sqEnd;
                sqYear = sqYear - 1;
            } else {
                sq = sq - 1;
            }

            ssnf = String.valueOf(sqYear);
            sssq = String.valueOf(sq);
        }

        String[] configArr = (String[]) hcjdConfigMap.get(xmlx);
        sql = "SELECT t1.*, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                "       DECODE(t2.BLZT, " +
                "              '1', '已办结', " +
                "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                "                     NULL, '未下发', " +
                "                     t4.ACTIVITY_NAME " +
                "                     ) " +
                "              ) AS STATUENAME, " +
                "       DECODE(t2.BLZT, " +
                "              '1', '6', " +
                "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                "                     '" + configArr[0] + "', '1', " +
                "                     '" + configArr[1] + "', '2', " +
                "                     '" + configArr[2] + "', '3', " +
                "                     '" + configArr[3] + "', '4', " +
                "                     '" + configArr[4] + "', '5', " +
                "                     '0' " +
                "                     ) " +
                "              ) AS STATUE " +
                "FROM ( " +
                "         SELECT t1.*, t2.ZGKG_MC, t2.ZGKG_DM, t2.ZCLX_DM " +
                "         FROM " + table + " t1 LEFT JOIN SW_DJ_JBB t2 ON t1.JBB_ID=t2.JBB_ID " +
                "         WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "' AND YDTYPE='" + Ydtype.HCH.toString()+ "' " +
                "     ) t1 " +
                "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = '" + xmlx + "')) t2 on t1.RWID = t2.RW_ID " +
                "     LEFT JOIN ( " +
                "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME, t4.ACTIVITY_NAME " +
                "         FROM ( " +
                "             SELECT * " +
                "             FROM PF_ACTIVITY t " +
                "             WHERE t.ACTIVITY_STATE='1' " +
                "             ) t4 " +
                "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                "WHERE 1=1 ";
        String statue = sbZsQuery.getJdlx();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("6")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("0")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and (t4.ACTIVITY_DEFINITION_ID NOT IN ('" + configArr[0] + "', '" + configArr[1] + "', '" + configArr[2] + "', '" + configArr[3] + "', '" + configArr[4] + "') OR t4.ACTIVITY_DEFINITION_ID IS NULL)";
            } else if (statue.equals("1")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = '" + configArr[0] + "' ";
            } else if (statue.equals("2")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= '" + configArr[1] + "' ";
            } else if (statue.equals("3")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= '" + configArr[2] + "' ";
            } else if (statue.equals("4")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= '" + configArr[3] + "' ";
            } else if (statue.equals("5")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= '" + configArr[4] + "' ";
            }
        }

        sqlBuffer = new StringBuffer().append(sql);
        sqlBuffer = addParameter(sbZsQuery,sqlBuffer);
        return sqlBuffer;
    }

    private String[] list2StringArr(List<String> hcxmBdIds){
        if(CollectionUtils.isNotEmpty(hcxmBdIds)){
            String[] result = new String[hcxmBdIds.size()];
            for(int i=0;i<hcxmBdIds.size();i++){
                result[i] = hcxmBdIds.get(i);
            }
            return result;
        }
        return null;
    }

    // 检查当前属期是否已经生成疑点数据，若没有，则生成
    @Transactional
    private void checkAndCreateZdydData(String ssnf, String sssq, String szdm) {
        String table = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_zsydqc_td";
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_zsydqc_fc";
        }

        String sql = "SELECT * FROM " + table + " t1 WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "' AND YDTYPE='" + Ydtype.HCH.toString() + "' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        if (CollectionUtils.isEmpty(query.getResultList())) {
            // 创建疑点数据
            TbSbSjQuartz tbSbSjQuartz = new TbSbSjQuartz();
            if(szdm.equals(Szdm.CZTDSYS.toString())) {
                sql = tbSbSjQuartz.getTdZsYdqcSql(Integer.valueOf(ssnf), (Integer.valueOf(sssq) - 1) / 4 + 1, (Integer.valueOf(sssq) - 1) % 4 + 1, Ydtype.HCH.toString());
            } else if(szdm.equals(Szdm.FCS.toString())) {
                sql = tbSbSjQuartz.getFcZsYdqcSql(Integer.valueOf(ssnf), (Integer.valueOf(sssq) - 1) / 2 + 1, (Integer.valueOf(sssq) - 1) % 2 + 1, Ydtype.HCH.toString());
            }
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    };
}
