package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Service
public class TjServiceImpl implements TjService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    ArrayList tjBaseParamList;

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> lzlgTdListJson(SwDjSyQuery swDjSyQuery, Pageable request) {
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qZd.djh,qSwDjSy.dbh,qZd.tdzl,qSwDjTd.ynmj,qSwDjTd.nynseTd,qSwDjTd.msmj,qSwDjTd.tdId,qSwDjJbb.sgyMc,qSwDjTd.tddj,qSwDjTd.dwse,qSwDjJbb.zgkgMc);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjTd.swDjJbb, qSwDjJbb);
        applyLzlgTdPredicates(swDjSyQuery, qZd, qSwDjJbb, qSwDjSy, qSwDjTd, jpaQuery);
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));

        jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + dwxxService.getUserRegionCode() + QueryCondition.WILDCARDS));
        Page<SwDjSyQuery> page = baseRepository.find(jpaQuery,qBean,request);
        return page;
    }



    private void applyLzlgTdPredicates(SwDjSyQuery swDjSyQuery,QZd qZd,QSwDjJbb qSwDjJbb,QSwDjSy qSwDjSy,QSwDjTd qSwDjTd,JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjSy, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb, "nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
    }

    @Override
    @Transactional
    public Object[] lzlgTdHj(SwDjSyQuery swDjSyQuery) {
        String sql = "select sum(nvl(t.ynmj,0)+nvl(t.msmj,0)),sum(nvl(t.ynmj,0)),sum(nvl(t.nynse,0)),sum(nvl(t.msmj,0)),sum(nvl(t.msmj,0)*nvl(t.dwse,0)) " +
                                "from sw_dj_td t " +
                                "left join sw_dj_sy t2 on t.sy_id=t2.sy_id " +
                                "left join sw_dj_jbb t3 on t3.jbb_id=t.jbb_id where (t2.syzt='"+ Syzt.ZC.toString()+"' or t2.syzt is null) and t.sgzt_dm= '"+Sgzt.LZLGD.toString()+"'";

        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            sql += " and t2.djh like '"+swDjSyQuery.getDjh()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            sql += " and t2.dbh like '"+swDjSyQuery.getDbh()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            sql += " and t.tdzl like '%"+swDjSyQuery.getTdzl()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            sql +=" and t3.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%'";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        Object[] objArr = (Object[]) query.getSingleResult();
        return objArr;
    }

    @Override
    public Object[] lzlgTdHjByTdIds(String ids) {
        String sql = "select sum(nvl(t.ynmj,0)+nvl(t.msmj,0)),sum(nvl(t.ynmj,0)),sum(nvl(t.nynse,0)),sum(nvl(t.msmj,0)),sum(nvl(t.msmj,0)*nvl(t.dwse,0)) " +
                "from sw_dj_td t " +
                "left join sw_dj_sy t2 on t.sy_id=t2.sy_id " +
                "left join sw_dj_jbb t3 on t3.jbb_id=t.jbb_id where 1=1";
        String resultIds = "";
        if(StringUtils.isNotBlank(ids)){
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==ids.split(",").length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql += " and t.td_id in ("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        Object[] objArr = (Object[]) query.getSingleResult();
        return objArr;
    }

    @Override
    public List<SwDjSyQuery> getLzlgTdList(HashMap param) {
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qZd.djh,qSwDjSy.dbh,qSwDjTd.tdzl,qSwDjTd.ynmj,qSwDjTd.nynseTd,qSwDjTd.msmj,qSwDjJbb.sgyMc,qSwDjTd.tddj,qSwDjTd.dwse,qSwDjJbb.zgkgMc);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjTd.swDjJbb, qSwDjJbb);
        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(obj==null){//导出全部
            applyLzlgTdPredicates(swDjSyQuery,qZd,qSwDjJbb,qSwDjSy,qSwDjTd,jpaQuery);
            jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            return (List)baseRepository.dslList(jpaQuery,qBean);

        }else{//checkbox导出
            String ids = String.valueOf(obj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdId").in(idsList));
            //jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));
            return (List)baseRepository.dslList(jpaQuery,qBean);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Object tdExcKzhJson(Pageable request) {
        String sql = getTdExcKzhSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public List getTdSyhzF(){
        String sql = getTdExcKzhSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List  list = query.getResultList();
        return  list;
    }

    private String getTdExcKzhSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.zdmj,t1.ysmj,t1.msmj,t1.nynse,t1.msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200')rkse   " +
                "from ( " +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.zdmj,t.ysmj,t.msmj,t.nynse,t.msse ,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse  " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t1.jbb_id = t4.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)))t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.glbm = t1.glbm where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public Object tdExcKzhAndLzlgJson(Pageable request) {
        String sql = getTdExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getTdSyhzS(){
        String sql = getTdExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String getTdExcKzhAndLzlgSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.zdmj,t1.ysmj,t1.msmj,t1.nynse,t1.msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200')rkse   " +
                "from ( " +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in ('02','03') and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.zdmj,t.ysmj,t.msmj,t.nynse,t.msse ,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse  " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t1.jbb_id = t4.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in('02','03') " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)))t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.glbm = t1.glbm where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }


    @Override
    @Transactional(readOnly = true)
    public Object fcExcKzhJson(Pageable request) {
        String sql = getFcExcKzhJsonSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getFcSyhzF(){
        String sql = getFcExcKzhJsonSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }
    private String getFcExcKzhJsonSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.fcyz,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.ynse_zy,t1.ynse_cz,t1.msse,t1.zy_msse,t1.cz_msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000')rkse  " +
                "from (" +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse " +
                "from sw_dj_fc t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.fcyz,t.fcyz_ys,t.fcyz_ms,t.nzj,t.nynse,t.ynse_zy,t.ynse_cz,t.msse,t.zy_msse,t.cz_msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse  " +
                "from sw_dj_fc t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)) )t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.glbm=t1.glbm" +
                " where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public Object fcExcKzhAndLzlgJson(Pageable request) {
        String sql = getFcExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getFcSyhzS(){
        String sql = getFcExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String getFcExcKzhAndLzlgSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.fcyz,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.ynse_zy,t1.ynse_cz,t1.msse,t1.zy_msse,t1.cz_msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000')rkse  " +
                "from (" +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse " +
                "from sw_dj_fc t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in ('02','03') and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.fcyz,t.fcyz_ys,t.fcyz_ms,t.nzj,t.nynse,t.ynse_zy,t.ynse_cz,t.msse,t.zy_msse,t.cz_msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse  " +
                "from sw_dj_fc t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm in ('02','03') " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)) )t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.glbm=t1.glbm" +
                " where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public Object dhbTjfxJson(SwDjSyQuery swDjSyQuery,StringBuffer listToJson,String regionCode) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, k.SQSCMJ, k.BQSCMJ, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, (k.BQSCMJ-k.SQSCMJ)AS ADDSCMJ, " +
                    "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE, " +
                    "       DECODE(k.SQSCMJ, 0, '--', ROUND((k.BQSCMJ-k.SQSCMJ)/k.SQSCMJ*100, 2)) AS ZZLSCMJ " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE, NVL(t1.SQSCMJ, 0) AS SQSCMJ, NVL(t2.BQSCMJ, 0) AS BQSCMJ " +
                    "      FROM (" +
                    "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                    "             FROM ( " +
                    "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00'  " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00' " +
                    "                  ) t1 " +
                    "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " +length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS SQSCMJ " +
                    "                FROM SW_DJ_TD t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t1 ON d.REGION_CODE=t1.DM " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS BQSCMJ " +
                    "                FROM SW_DJ_TD t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "     ) k";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return listToJson(swDjSyQuery,list,listToJson);

    }



    public String listToJson(SwDjSyQuery swDjSyQuery,List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"sqscmj\":"+"\""+map.get("SQSCMJ")+"\",");
            listToJson.append("\"bqscmj\":"+"\""+map.get("BQSCMJ")+"\",");
            listToJson.append("\"addscmj\":"+"\""+map.get("ADDSCMJ")+"\",");
            listToJson.append("\"zzlscmj\":"+"\""+map.get("ZZLSCMJ")+"\",");
            listToJson.append("\"sqnynse\":"+"\""+map.get("SQNYNSE")+"\",");
            listToJson.append("\"bqnynse\":"+"\""+map.get("BQNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\",");
            listToJson.append("\"zzlnynse\":"+"\""+map.get("ZZLNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                dhbTjfxJson(swDjSyQuery,listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }


    @Override
    @Transactional(readOnly = true)
    public Object fcsDhbTjfxJson(SwDjSyQuery swDjSyQuery,StringBuffer listToJson,String regionCode) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, " +
                    "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE " +
                    "      FROM (" +
                    "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                    "             FROM ( " +
                    "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00' " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00' " +
                    "                  ) t1 " +
                    "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE " +
                    "                FROM SW_DJ_FC t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t1 ON d.REGION_CODE=t1.DM " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE " +
                    "                FROM SW_DJ_FC t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "     ) k";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return fcListToJson(swDjSyQuery,list,listToJson);
    }




    public String fcListToJson(SwDjSyQuery swDjSyQuery,List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"sqnynse\":"+"\""+map.get("SQNYNSE")+"\",");
            listToJson.append("\"bqnynse\":"+"\""+map.get("BQNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\",");
            listToJson.append("\"zzlnynse\":"+"\""+map.get("ZZLNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                fcsDhbTjfxJson(swDjSyQuery,listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

    @Override
    @Transactional(readOnly = true)
    public Object tdsFxJson(StringBuffer listToJson, String regionCode) {
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.SCMJHZ - k.ZGSCMJHZ) AS ADDSCMJ, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE, (k.MJSE - k.ZGMJSE) AS ZJMJSE, " +
                    "       DECODE(k.ZGSCMJHZ, 0, '--', ROUND((k.SCMJHZ-k.ZGSCMJHZ)/k.ZGSCMJHZ*100, 2)) AS ZZLSCMJ " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGSCMJHZ, 0) AS ZGSCMJHZ, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t1.ZGMJSE, 0) AS ZGMJSE, " +
                    "             NVL(t2.SCMJHZ, 0) AS SCMJHZ, NVL(t2.NYNSE, 0) AS NYNSE, NVL(t2.MJSE, 0) AS MJSE " +
                    "      FROM ( " +
                    "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                    "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                    "                   UNION " +
                    "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                    "                   UNION " +
                    "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00') t1 " +
                    "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.OCCUPYAREA, 0)) AS ZGSCMJHZ, SUM(NVL(t1.TAXDUE, 0)) AS ZGNYNSE, SUM(NVL(t1.OCCUPYAREA, 0)*NVL(t1.UNITTAXMONEY, 0)) AS ZGMJSE " +
                    "             FROM TB_REG_TOWNUSETAXREGDETAIL t1 " +
                    "                  LEFT JOIN SW_DJ_JBB t3 ON TO_CHAR(t1.TAXREGCODE)=t3.GLBM " +
                    "             WHERE t1.CHOICEFLAG=1 " +
                    "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length +")) " +
                    "           ) t1 ON d.REGION_CODE=t1.DM " +
                    "           LEFT JOIN ( " +
                    "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.SCMJ,0)) AS SCMJHZ, SUM(NVL(t1.NYNSE,0)) AS NYNSE, SUM(NVL(t1.SCMJ,0)*NVL(t1.DWSE,0)) AS MJSE " +
                    "             FROM SW_DJ_TD t1 " +
                    "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                    "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "      WHERE t1.DM IS NOT NULL " +
                    "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return tdsFxListToJson(list,listToJson);
    }



    public String tdsFxListToJson(List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"scmjhz\":"+"\""+map.get("SCMJHZ")+"\",");
            listToJson.append("\"zgscmjhz\":"+"\""+map.get("ZGSCMJHZ")+"\",");
            listToJson.append("\"addscmj\":"+"\""+map.get("ADDSCMJ")+"\",");
            listToJson.append("\"zzlscmj\":"+"\""+map.get("ZZLSCMJ")+"\",");
            listToJson.append("\"zjmjse\":"+"\""+map.get("ZJMJSE")+"\",");
            listToJson.append("\"nynse\":"+"\""+map.get("NYNSE")+"\",");
            listToJson.append("\"zgnynse\":"+"\""+map.get("ZGNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                tdsFxJson(listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

    @Override
    @Transactional(readOnly = true)
    public Object fcsFxJson(StringBuffer listToJson, String regionCode) {

        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t2.NYNSE, 0) AS NYNSE  " +
                    "      FROM ( " +
                    "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                    "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                    "                   UNION " +
                    "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                    "                   UNION " +
                    "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00') t1 " +
                    "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.TAXDUE, 0)) AS ZGNYNSE  " +
                    "             FROM TB_REG_HOUSEUSETAXITEM t1 " +
                    "                  LEFT JOIN SW_DJ_JBB t3 ON TO_CHAR(t1.TAXREGCODE)=t3.GLBM " +
                    "             WHERE t1.CHOICEFLAG=1 " +
                    "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t1 ON d.REGION_CODE=t1.DM " +
                    "           LEFT JOIN ( " +
                    "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE,0)) AS NYNSE  " +
                    "             FROM SW_DJ_FC t1 " +
                    "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                    "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "      WHERE t1.DM IS NOT NULL " +
                    "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return fcsFxListToJson(list,listToJson);
    }

    @Override
    @Transactional(readOnly = true)
    public Object tdExcZgNsrZsJson(Pageable request) {
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        if (regionCode.length() > 6) {
            regionCode = regionCode.substring(0, 5);
        }

        String sqlZg = "SELECT TO_CHAR(TAXREGCODE) AS ZGKG_DM, " +
                        "       SUM(NVL(TAXFINAL, 0)) AS SNDTDNSE " +
                        "FROM TB_LVY_LEVYDATA " +
                        "WHERE TAXTYPECODE =13 AND LateFeeFlag <> '1' AND TO_CHAR(DECLAREDATE, 'YYYY')=(TO_CHAR(SYSDATE, 'YYYY') - 1) " +
                        "GROUP BY TAXREGCODE";

        String sqlNsr = "SELECT ";
        String sql = "";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public Object fcExcZgNsrZsJson(Pageable request) {
        return null;
    }

    @Override
    public Object tdfcHcjdTjJson(String id, String beginRq, String endRq) {
        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        regionCode = user.getRegionCode();
        String dwCode = regionCode;
        if (dwCode.length() > 6) {
            dwCode = dwCode.substring(0, 6);
        }
        Integer length = 6;

        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank(beginRq))
            beginRq = (sdf.format(dt)).substring(0, 4) + "-01-01";
        if (StringUtils.isBlank(endRq))
            endRq = sdf.format(dt);

        beginRq = beginRq.substring(0, 4) + beginRq.substring(5, 7) + beginRq.substring(8, 10);
        endRq = endRq.substring(0, 4) + endRq.substring(5, 7) + endRq.substring(8, 10);
        String zgDateFilter = "(TO_CHAR(t.DECLAREDATE, 'YYYYMMDD') >= " + beginRq + " AND TO_CHAR(t.DECLAREDATE, 'YYYYMMDD') <=" + endRq + ") ";
        String swDateFilter = "(TO_CHAR(t.LRRQ, 'YYYYMMDD') >= " + beginRq + " AND TO_CHAR(t.LRRQ, 'YYYYMMDD') <=" + endRq + ") ";

        String sqlSw = "SELECT jbb.ZGKG_DM, jbb.JBB_ID, MIN(DECODE(td.LRRQ, NULL, td.UPDATE_DATE, td.LRRQ)) AS LRRQ, " +
                        "      1 AS HCZHS, SUM(DECODE(td.SGZT_DM, '02', 1, 0)) AS LZLGH, " +
                        "       SUM(NVL(td.SCMJ, 0)) AS TDMJ, SUM(NVL(td.YNMJ, 0)) YSTDMJ, SUM(NVL(td.NYNSE, 0)) AS TDYNSE, " +
                        "       SUM(NVL(fc.FCYZ, 0)) AS FCYZ, SUM(NVL(fc.NZJ, 0)) ZJSR, SUM(NVL(fc.NYNSE, 0)) AS FCYNSE " +
                        "FROM SW_DJ_SY sy " +
                        "     LEFT JOIN SW_DJ_TD td ON sy.SY_ID=td.SY_ID " +
                        "     LEFT JOIN SW_DJ_FC fc ON sy.SY_ID=fc.SY_ID " +
                        "     LEFT JOIN SW_DJ_JBB jbb ON td.JBB_ID=jbb.JBB_ID " +
                        "WHERE sy.SYZT = '1' AND td.SGZT_DM IN ('01', '02', '05') AND jbb.ZGKG_DM LIKE '2" +dwCode + "%' " +
                        "GROUP BY jbb.ZGKG_DM, jbb.JBB_ID";
        sqlSw = "SELECT t.*, t1.GLBM, NVL(zgtd.TAXDUE, 0) AS ZGTDYNSE, NVL(zgfc.TAXDUE, 0) AS ZGFCYNSE " +
                "FROM (" + sqlSw + ") t LEFT JOIN SW_DJ_JBB t1 ON t.JBB_ID=t1.JBB_ID " +
                "     LEFT JOIN (SELECT TO_CHAR(TAXREGCODE) AS GLBM, SUM(TAXDUE) AS TAXDUE FROM TB_REG_TOWNUSETAXREGDETAIL WHERE CHOICEFLAG=1 GROUP BY TAXREGCODE) zgtd ON t1.GLBM = zgtd.GLBM " +
                "     LEFT JOIN (SELECT TO_CHAR(TAXREGCODE) AS GLBM, SUM(TAXDUE) AS TAXDUE FROM TB_REG_HOUSEUSETAXITEM WHERE CHOICEFLAG=1 GROUP BY TAXREGCODE) zgfc ON t1.GLBM = zgfc.GLBM " +
                "WHERE " + swDateFilter;
        String sqlZg = "SELECT TO_CHAR(t.TAXREGCODE) AS GLBM, " +
                        "       SUM(DECODE(t.TAXTYPECODE, 13, NVL(t.TAXFINAL, 0), 0)) AS TDNSE, " +
                        "       SUM(DECODE(t.TAXTYPECODE, 11, NVL(t.TAXFINAL, 0), 0)) AS FCNSE " +
                        "FROM TB_LVY_LEVYDATA t " +
                        "WHERE t.TAXTYPECODE IN (11, 13) AND t.LateFeeFlag <> '1' AND " + zgDateFilter + " " +
                        "GROUP BY t.TAXREGCODE";
        String sql = "SELECT DECODE(GROUPING(DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "))), 0, DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ")), '" + dwCode.substring(0, 4) + "HJ') AS DWDM, " +
                        "      SUM(HCZHS) AS TDHCZHS, " +
                        "      SUM(LZLGH) AS TDLZLGH, " +
                        "      TO_CHAR(SUM(TDMJ), 'FM999,999,999,999,990.00') AS TDMJ, " +
                        "      TO_CHAR(SUM(YSTDMJ), 'FM999,999,999,999,990.00') AS YSTDMJ, " +
                        "      TO_CHAR(SUM(TDYNSE), 'FM999,999,999,999,990.00') AS TDYNSE, " +
                        "      SUM(HCZHS) AS FCHCZHS, " +
                        "      SUM(LZLGH) AS FCLZLGH, " +
                        "      TO_CHAR(SUM(FCYZ), 'FM999,999,999,999,990.00') AS FCYZ, " +
                        "      TO_CHAR(SUM(ZJSR), 'FM999,999,999,999,990.00') AS ZJSR, " +
                        "      TO_CHAR(SUM(FCYNSE), 'FM999,999,999,999,990.00') AS FCYNSE, " +
                        "      TO_CHAR(SUM(NVL(TDNSE, 0)), 'FM999,999,999,999,990.00') AS TDNSE, " +
                        "      TO_CHAR(SUM(NVL(FCNSE, 0)), 'FM999,999,999,999,990.00') AS FCNSE, " +
                        "      SUM(DECODE(ZGTDYNSE, NULL, 0, DECODE(SIGN(TDYNSE - ZGTDYNSE), 1, 1, 0))) AS TDSBBSH, " +
                        "      SUM(DECODE(ZGFCYNSE, NULL, 0, DECODE(SIGN(FCYNSE - ZGFCYNSE), 1, 1, 0))) AS FCSBBSH " +
                        "FROM (" + sqlSw + ") sw LEFT JOIN (" + sqlZg + ") zg ON sw.GLBM=zg.GLBM " +
                        "GROUP BY ROLLUP(DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ")))";
        String sqlDw = "SELECT DWDM, DWMC " +
                "FROM S_DM_DWXX_CZ " +
                "UNION " +
                "SELECT SUBSTR(SWBMBM, 2, 8) AS DWDM, MC AS DWMC " +
                "FROM DM_SWBM " +
                "UNION " +
                "SELECT DWDM||'HJ' AS DWDM, '合计' AS DWMC " +
                "FROM S_DM_DWXX_CZ " +
                "WHERE DWJB=0";
        sql = "SELECT t.*, DECODE(t1.DWMC, NULL, t.DWDM, t1.DWMC) AS DWMC " +
                "FROM (" + sql + ") t LEFT JOIN (" + sqlDw + ") t1 ON t.DWDM=t1.DWDM " +
                "WHERE t.DWDM LIKE '" + dwCode + "%'";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<HashMap> resultList = new ArrayList<HashMap>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                resultList.add(tempMap);
            }
        }
        return resultList;
    }

    @Override
    public Object getTjJson(Pageable request, String sqlTag, HashMap queryFilter) {
        String sql = getTjSql(sqlTag);
        if (StringUtils.isBlank(sql)) {
            return null;
        }
        sql = addQueryFilter(sql, queryFilter);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (" + sql + ")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public Object getTjList(String sqlTag, HashMap queryFilter) {
        String sql = getTjSql(sqlTag);
        if (StringUtils.isBlank(sql)) {
            return null;
        }
        sql = addQueryFilter(sql, queryFilter);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();
        return list;
    }

    @Override
    public TjBaseParamVo getTjBaseParam(String tag) {
        TjBaseParamVo tjBaseParam = null;
        String tagValue;
        if (tjBaseParamList != null) {
            for (int i = 0; i < tjBaseParamList.size(); i++) {
                tagValue = ((TjBaseParamVo)tjBaseParamList.get(i)).getTag();
                if (tagValue.equals(tag)) {
                    tjBaseParam = (TjBaseParamVo)tjBaseParamList.get(i);
                    break;
                }
            }
        }
        return tjBaseParam;
    }

    @Override
    @Transactional(readOnly = true)
    public Page getTjJson(Pageable request, String sqlTag, List<QueryCondition> queryConditionList) {
        Page page = null;

        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            Query countQuery = createQuery(sql, queryConditionList, null, true);
            page =  baseRepository.find(query, countQuery, request);
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                page =  baseRepository.find(aclass, queryConditionList, tjBaseParamVo.getOrderBy(), request);
            }
        }

        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public List getTjList(String sqlTag, List<QueryCondition> queryConditionList) {
        List<HashMap<String, Object>> list = null;
        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.getResultList();
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                list =  baseRepository.list(aclass, queryConditionList, tjBaseParamVo.getOrderBy());
            }
        }

        return list;
    }

    @Override
    public String getTjSql(String sqlTag) {
        String sqlBase = "";
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            sqlBase = tjBaseParam.getSql();
        }
        return sqlBase;
    }

    private Class getTjEntityClass(String sqlTag) {
        Class aClass = null;
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            if (StringUtils.isNotEmpty(tjBaseParam.getEntityName())) {
                try {
                    aClass = Class.forName(tjBaseParam.getEntityName());
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return aClass;
    }

    private String addQueryFilter(String sqlBase, HashMap queryFilter) {
        if (StringUtils.isBlank(sqlBase)) {
            return null;
        }

        String filter = "";
        if (queryFilter != null) {
            Map map = queryFilter;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (val != null && !val.toString().isEmpty()) {
                    filter += " AND " + key.toString() + " LIKE '%" + val.toString() + "%'";
                }
            }
        }

        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        regionCode = user.getRegionCode();
        if (regionCode.length() >= 6) {
            filter += " AND XZQDM = '" + regionCode.substring(0, 6) + "'";
        }

        String sqlQuery = "SELECT * FROM (" + sqlBase + ") WHERE 1=1 " + filter;
        return sqlQuery;
    }

    /**
     * 根据sql语句跟查询条件获取Query
     *
     * @param sql
     * @param queryConditions
     * @param orderBy
     * @param isQueryTotal    是否查询记录总数, true 则查询记录总数
     * @return
     */
    @Override
    public Query createQuery(String  sql, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        return createQuery(sql, null, queryConditions, orderBy, isQueryTotal);
    }

    @Override
    public Query createQuery(String  sql, String resultExpression, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        if (StringUtils.isEmpty(resultExpression))
            resultExpression = "*";
        StringBuffer sqlQuery = new StringBuffer("SELECT " + resultExpression + " FROM (" + sql + ") WHERE 1=1");
        if (queryConditions != null && queryConditions.size() > 0) {
            //构造sql语句
            Iterator<QueryCondition> iterator = queryConditions.iterator();
            while (iterator.hasNext()) {
                QueryCondition queryCondition = iterator.next();
                if (queryCondition != null) {
                    if (queryCondition.getOperator().equals(QueryCondition.CUSTOM)) {
                        sqlQuery.append(" AND (").append(queryCondition.getCustomJPQL()).append(")");
                    }
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //如果占位符名称是*.*格式，则换成*_*格式。且：和名称之间不能有空格
                        String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        String operator = queryCondition.getOperator();
                        if (operator.equals(QueryCondition.LLK) || operator.equals(QueryCondition.RLK))
                            operator = QueryCondition.LK;
                        sqlQuery.append(" AND ").append(queryCondition.getField().trim())
                                .append(" ").append(operator).append(":").append(placeholder.trim());
                    }
                }

            }
        }
        if (isQueryTotal) {
            sqlQuery.insert(0, "select count(*) from (").append(")");
        } else if (orderBy != null && !"".equals(orderBy)) {
            sqlQuery.append(" ").append(orderBy);
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sqlQuery.toString());

        if (queryConditions != null && queryConditions.size() > 0) {
            //为参数赋值
            Iterator<QueryCondition> iterator2 = queryConditions.iterator();
            while (iterator2.hasNext()) {
                QueryCondition queryCondition = iterator2.next();
                if (queryCondition != null) {
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //将占位符中的.替换成_
                        String queryConditionField = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        if (queryCondition.getOperator().equals(QueryCondition.LK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.LLK)) {
                            query.setParameter(queryConditionField, queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.RLK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue());
                        } else {
                            query.setParameter(queryConditionField, queryCondition.getValue());
                        }
                    }
                }

            }
        }

        return query;
    }

    public String fcsFxListToJson(List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"nynse\":"+"\""+map.get("NYNSE")+"\",");
            listToJson.append("\"zgnynse\":"+"\""+map.get("ZGNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                fcsFxJson(listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

}
