package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.Project;
import cn.gtmap.landtax.entity.SSjGtbd;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyHis;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * Created by xuchao on 2014/8/22.
 */
@Service
public class SyscServiceImpl implements SyscService{
    private static final String SYSC_PREFIX="税源删除";
    private static final String SYBJ_PREFIX_QS="契税删除";
    private static final String SYBJ_PREFIX_GDZYS="耕地占用税删除";
    private static final String SYSC_WORKFLOW_CONFIG="sysc";
    private static final String SYSC_WORKFLOW_CONFIG_QS="qssc";
    private static final String SYSC_WORKFLOW_CONFIG_GDZYS="gdzyssc";
    @Autowired
    PlatUtil platUtil;
    @Autowired
    TaxService taxService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SsjGtbdService ssjGtbdService;
    @Autowired
    SyxgService syxgService;

    @Override
    @Transactional
    public String createSyscWorkflow(String syId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYSC_PREFIX+swDjSy.getZd().getDjh();
        String taskId = platUtil.createWorkFlowInstance(project,userId,proName);
        if(StringUtils.isNotBlank(taskId)){
            swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
        }
        return taskId;
    }

    @Override
    @Transactional
    public void delSwdjSyByHisId(String proid) {
        //根据proid 获取syId
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        String syId = swDjSyHis.getSwDjSy().getSyId();
        //将税源主表税源状态设置为 删除标记
        taxService.softDelSyDjSy(syId, Syzt.SC.toString());

        //看该宗地是否还有税源,如果没有税源了，修改s_sj_gtbd 表中ppzt和blzt
        String jpql = "from SwDjSy t where t.zd.djh=?0 and t.syzt='1'";
        List<SwDjSy> swDjSyList = baseRepository.getByJpql(jpql,swDjSyHis.getDjh());
        if(CollectionUtils.isEmpty(swDjSyList)){//说明没有税源，此时设置s_sj_gtbd表中ppzt为空，办理状态为空
            SSjGtbd sSjGtbd = ssjGtbdService.findByDjh(swDjSyHis.getDjh());
            sSjGtbd.setPpzt("");
            ssjGtbdService.updateSsjGtbd(sSjGtbd);
        }
    }

    @Override
    @Transactional
    public String createQsSyscWorkflow(String syId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG_QS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYBJ_PREFIX_QS + swDjSy.getSwDjXmxx().getXmmc();

        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
            if(StringUtils.isNotBlank(taskId)){
                swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
            }
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }

        return taskId;
    }

    @Override
    @Transactional
    public String createGdzysSyscWorkflow(String syId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG_GDZYS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYBJ_PREFIX_GDZYS + swDjSy.getSwDjPcxx().getPcmc();

        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
            if(StringUtils.isNotBlank(taskId)){
                swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
            }
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }
        return taskId;
    }

    @Override
    @Transactional
    public void delSwdjSyByHisIdGqs(String proid) {
        //根据proid 获取syId
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        String syId = swDjSyHis.getSwDjSy().getSyId();
        //将税源主表税源状态设置为 删除标记
        taxService.softDelSyDjSy(syId, Syzt.SC.toString());
    }
}
