package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Sjly;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.EntityPath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author yang
 * @version V1.0, 14-7-5
 */
@Service
public class SwdjtzServiceImpl implements SwdjtzService {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    ZdService zdService;
    @Autowired
    DwxxService dwxxService;

    @Override
    @Transactional(readOnly = true)
    public List getSwdjtz(String xzq) {

        int xzqws = 7;   //行政区位数 默认7
        StringBuffer sqlTj = new StringBuffer();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.getRegionCode() != null) { //在创建用户的时候regioncode
            if (userInfo.getRegionCode().length() == 4) {
                if (xzq != null) {
                    if (xzq.length() == 6) {
                        xzqws = 8;
                        sqlTj.append("where SUBSTR(d.zgjg_dm,1," + xzq.length() + ")=" + xzq);
                    } else if (xzq.length() == 8) {
                        xzqws = 10;
                        sqlTj.append("where SUBSTR(d.zgjg_dm,1," + xzq.length() + ")=" + xzq);
                    }
                } else {
                    xzqws = 6;
                    sqlTj.append("where SUBSTR(d.zgjg_dm,1," + userInfo.getRegionCode().length() + ")=" + userInfo.getRegionCode());
                }
            } else if (userInfo.getRegionCode().length() == 6) {
                if (xzq != null) {
                    if (xzq.length() == 8) {
                        xzqws = 10;
                        sqlTj.append("where SUBSTR(d.zgjg_dm,1," + xzq.length() + ")=" + xzq);
                    }
                } else {
                    xzqws = 8;
                    sqlTj.append("where SUBSTR(d.zgjg_dm,1," + userInfo.getRegionCode().length() + ")=" + userInfo.getRegionCode());
                }
            }
        } else {
            return null;
        }
        StringBuffer tzBuffer = new StringBuffer();
        tzBuffer.append("select d.zgjg_dm,(select count(*) from S_SJ_SWBD where SUBSTR(zgjg_dm,2," + xzqws + ")=d.zgjg_dm and bdtype is null) as wpp ,");
        tzBuffer.append("(select count(*) from S_SJ_SWBD where SUBSTR(zgjg_dm,2," + xzqws + ")=d.zgjg_dm and bdtype ='1') as zpp,");
        tzBuffer.append("(select count(*) from S_SJ_SWBD where SUBSTR(zgjg_dm,2," + xzqws + ")=d.zgjg_dm and bdtype ='2') as rpp,");
        tzBuffer.append("(select dwmc from S_DM_SWDWXX where trim(0 from swdm)='2'||d.zgjg_dm ) as xzqname");
        tzBuffer.append(" from (select SUBSTR(t.zgjg_dm,2," + xzqws + ") zgjg_dm from S_SJ_SWBD t group by SUBSTR(t.zgjg_dm,2," + xzqws + ") order by SUBSTR(t.zgjg_dm,2," + xzqws + ")) d");
        tzBuffer.append(" " + sqlTj.toString());
        List list = baseRepository.sql(tzBuffer.toString());
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SSjSwbd> findSyppxxMap(String xzqbh, String lx, Pageable pageable, SwDjSyQuery swDjSyQuery, Sylx lxs) {
        QSSjSwbd qsSjSwbd1 = QSSjSwbd.sSjSwbd;
        QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QZd qZd = QZd.zd;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBeanz = null;


        if (lxs.equals(Sylx.TDSY)) {
            if (lx.equals("1")) {//1表示已匹配数据
                jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd);
                qBeanz = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qZd.djh,qSwDjSy.dbh,qZd.tdzh,qSwDjTd.zdmj,qSwDjJbb.nsrmc,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjTd.nynseTd,qSwDjTd.sjly);
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
            } else {       //其他表示为未匹配
                jpaQuery.from(qSwDjTdWbd, qsSjSwbd1).leftJoin(qSwDjTdWbd.swDjJbbWbd,qSwDjJbbWbd);
                jpaQuery.where(qSwDjTdWbd.sjly.isNull().or(qSwDjTdWbd.sjly.notIn(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString())));
                jpaQuery.where(qSwDjTdWbd.swDjJbbWbd.jbbId.eq(qsSjSwbd1.jbbId));
                qBeanz = Projections.bean(GtSwTzQuery.class, qsSjSwbd1.swbdId, qsSjSwbd1.tdnynse, qsSjSwbd1.fcnynse,
                        qsSjSwbd1.glyDm, qsSjSwbd1.glyMc,  qsSjSwbd1.zgjgDm, qSwDjJbbWbd.zgkgMc, qSwDjTdWbd.djh, qSwDjTdWbd.dbh,
                        qsSjSwbd1.glbm, qSwDjJbbWbd.nsrmc, qsSjSwbd1.jbbId, qsSjSwbd1.qxdm);
            }
        } else {
            if (lx.equals("1")) {//1表示已匹配数据
                jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd);
                qBeanz = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qZd.djh,qSwDjSy.dbh,qZd.tdzh,qSwDjJbb.nsrmc,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.nynseFc,qSwDjFc.sjly);
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
            } else {       //其他表示为未匹配
                jpaQuery.from(qSwDjFcWbd, qsSjSwbd1).leftJoin(qSwDjFcWbd.swDjJbbWbd,qSwDjJbbWbd);
                jpaQuery.where(qSwDjFcWbd.sjly.isNull().or(qSwDjFcWbd.sjly.notIn(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString())));
                jpaQuery.where(qSwDjFcWbd.swDjJbbWbd.jbbId.eq(qsSjSwbd1.jbbId));
                qBeanz = Projections.bean(GtSwTzQuery.class, qsSjSwbd1.swbdId, qsSjSwbd1.tdnynse, qsSjSwbd1.fcnynse,
                        qsSjSwbd1.glyDm, qsSjSwbd1.glyMc,  qsSjSwbd1.zgjgDm, qSwDjJbbWbd.zgkgMc, qSwDjFcWbd.djh, qSwDjFcWbd.dbh,
                        qsSjSwbd1.glbm, qSwDjJbbWbd.nsrmc, qsSjSwbd1.jbbId, qsSjSwbd1.qxdm);
            }
        }
        if (xzqbh != null) {
            int codeLength = xzqbh.length();
             if (codeLength == 6) {
                if (lx.equals("1"))
                    jpaQuery.where(qSwDjJbb.zgkgDm.substring(1, codeLength + 1).eq(xzqbh));
                else
                    jpaQuery.where(qSwDjJbbWbd.zgkgDm.substring(1, codeLength + 1).eq(xzqbh));
            }
            else if (codeLength == 11) {
                if (lx.equals("1"))
                    jpaQuery.where(qSwDjJbb.zgkgDm.substring(0, codeLength).eq(xzqbh));
                else
                    jpaQuery.where(qSwDjJbbWbd.zgkgDm.substring(0, codeLength).eq(xzqbh));
            }
        }
        if(lx.equals("1")){
            if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
                jpaQuery.where(Expressions.stringPath(qSwDjJbb, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
                jpaQuery.where(Expressions.stringPath(qSwDjSy, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
                jpaQuery.where(Expressions.stringPath(qSwDjJbb, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
                jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
                jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        }




        return baseRepository.find(jpaQuery, qBeanz, pageable);

    }

    //******************************************************************未匹配列表
    @Override
    @Transactional(readOnly = true)
    public Page<SSjSwbd> findWppSyMap(String xzqbh, Pageable pageable, SwDjSyQuery swDjSyQuery, Sylx lxs) {
        QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
        QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBeanz = null;
        if (lxs.equals(Sylx.TDSY)) {
            jpaQuery.from(qSwDjTdWbd).leftJoin(qSwDjTdWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjTdWbd.sjly.isNull().or(qSwDjTdWbd.sjly.notIn(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString())));
            jpaQuery.where(qSwDjTdWbd.tdId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.TDSYHC.toString())).list(qSwHcXmRwRel.bdId)));
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(Expressions.stringPath(qSwDjTdWbd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            qBeanz = Projections.bean(GtSwTzQuery.class, qSwDjTdWbd.nynseTd,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjTdWbd.tdId,qSwDjTdWbd.djh, qSwDjTdWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId);
            if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
                jpaQuery.where(Expressions.stringPath(qSwDjTdWbd, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        } else {
            jpaQuery.from(qSwDjFcWbd).leftJoin(qSwDjFcWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjFcWbd.sjly.isNull().or(qSwDjFcWbd.sjly.notIn(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString())));
            jpaQuery.where(qSwDjFcWbd.fcId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.FCSYHC.toString())).list(qSwHcXmRwRel.bdId)));
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(Expressions.stringPath(qSwDjFcWbd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            qBeanz = Projections.bean(GtSwTzQuery.class, qSwDjFcWbd.nynseFc,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjFcWbd.fcId,qSwDjFcWbd.djh, qSwDjFcWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId);
            if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
                jpaQuery.where(Expressions.stringPath(qSwDjFcWbd, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        }


        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        return baseRepository.find(jpaQuery, qBeanz, pageable);
    }

    // 税源数据  1 土地  2房产
    @Override
    @Transactional(readOnly = true)
    public String getSwtzJson(String xzq, StringBuffer stringBuffer, String lx) {
        Boolean firstQuery = false;
        if (xzq == null) {
            xzq = dwxxService.getUserRegionCode();
            firstQuery = true;
        }

        String table = "";
        String tableWbd = "";
        String idField = "";
        String filter = "";
        String groupField = "";
        Boolean canSearchChildren = true;
        if (lx == null || lx.equals("1")) {
            table = "sw_dj_td";
            tableWbd = "sw_dj_td_wbd";
            idField = "td_id";
        }
        else if (lx.equals("2")) {
            table = "sw_dj_fc";
            tableWbd = "sw_dj_fc_wbd";
            idField = "fc_id";
        }
        int codeLength = xzq.length();
        if (codeLength == 2 || codeLength == 0) {
            filter = " 1=1 ";
            groupField = "SJDM";
        }
        else if (codeLength == 4) {
            filter = " SJDM='" + xzq + "' ";
            groupField = "QXDM";

            if (firstQuery) {
                groupField = "SJDM";
            }
        }
        else if (codeLength == 6) {
            filter = " QXDM='" + xzq + "' ";
            groupField = "ZGKG_DM";

            if (firstQuery) {
                groupField = "QXDM";
            }
        }
        else if (codeLength == 11) {
            filter = " ZGKG_DM='" + xzq + "' ";
            groupField = "SGY_DM";
            canSearchChildren = false;

            if (firstQuery) {
                groupField = "ZGKG_DM";
            }
        }

        String tzSql = "SELECT a.DWDM, DJHJ, (ZDPP + RGPP) AS YPPHJ, ZDPP, RGPP, (DJHJ - ZDPP - RGPP - HCPP) AS WPP, " +
                        "ROUND((ZDPP + RGPP + HCPP)/DJHJ*100, 2) AS PPL, DECODE(b.DWMC, NULL, a.DWDM, b.DWMC) AS DWMC, HCPP " +
                        "FROM ( " +
                        "  SELECT " + groupField + " AS DWDM, " +
                        "  COUNT(*) AS DJHJ, SUM(DECODE(SJLY, '1', 1, 0)) AS ZDPP, " +
                        "  SUM(DECODE(SJLY, '2', 1, 0)) AS RGPP, " +
                        "  SUM(DECODE(SJLY, '3', 1, 0)) AS HCPP  " +
                        "  FROM " +
                        "    (SELECT a.SJLY, a." + idField + ", b.JBB_ID, b.ZGKG_DM, b.SGY_DM, SUBSTR(b.ZGKG_DM, 2, 6) AS QXDM, SUBSTR(b.ZGKG_DM, 2, 4) AS SJDM " +
                        "    FROM " + table + " a LEFT JOIN SW_DJ_JBB b ON a.JBB_ID=b.JBB_ID " +
                        "    WHERE b.JBB_ID IS NOT NULL " +
                        "    UNION " +
                        "    SELECT a.SJLY, a." + idField + ", b.JBB_ID, b.ZGKG_DM, b.SGY_DM, SUBSTR(b.ZGKG_DM, 2, 6) AS QXDM, SUBSTR(b.ZGKG_DM, 2, 4) AS SJDM " +
                        "    FROM " + tableWbd + " a LEFT JOIN SW_DJ_JBB_WBD b ON a.JBB_ID=b.JBB_ID " +
                        "    WHERE b.JBB_ID IS NOT NULL AND a." + idField + " NOT IN (SELECT " + idField + " FROM " + table + ")) " +
                        "  WHERE " + filter + " " +
                        "  GROUP BY " + groupField + " " +
                        ") a LEFT JOIN S_DM_SWDWXX b ON a.DWDM=b.SWDM " +
                        "ORDER BY a.DWDM";
        List list = baseRepository.sql(tzSql);
        return listToJson(list, stringBuffer, lx, canSearchChildren);
    }


    public String listToJson(List list, StringBuffer listToJson, String lx, Boolean canSearchChildren) {
        if (listToJson == null) listToJson = new StringBuffer();
        listToJson.append("[");
        UserInfo userInfo = SessionUtil.getCurrentUser();
            String regionCode = userInfo.getRegionCode();
            for (int i = 0; i < list.size(); i++) {
                Object[] object = (Object[]) list.get(i);
            String xzqcode = (String) object[0];
//            if (!xzqcode.startsWith(regionCode))
//                continue;
            if (i > 0 && !listToJson.toString().equals("["))
                listToJson.append(",");
            listToJson.append("{");
            String xzqname = (String) object[7];
            if (xzqname != null && !xzqname.equals("null")) {
                listToJson.append("\"name\":\"" + object[7] + "\",");
            } else {
                listToJson.append("\"name\":\"" + object[0] + "\",");
            }
            listToJson.append("\"counts\":\"" + object[1] + "\",");
            listToJson.append("\"ppcount\":\"" + object[2] + "\",");
            listToJson.append("\"zzpp\":\"" + object[3] + "\",");
            listToJson.append("\"rgpp\":\"" + object[4] + "\",");
            listToJson.append("\"syhc\":\"" + object[8] + "\",");
            listToJson.append("\"wpp\":\"" + object[5] + "\",");
            listToJson.append("\"ppl\":\"" + object[6] + "\",");
            listToJson.append("\"xzqdm\":\"" + object[0] + "\"");

            if (canSearchChildren) {
                listToJson.append(",");
                listToJson.append("\"children\":");
                getSwtzJson(xzqcode, listToJson, lx);
                listToJson.append("");
            }

            listToJson.append("}");

        }
        listToJson.append("]");
        return listToJson.toString();
    }



    //***********************************************************创建工作流
    @Override
    @Transactional
    public String getCreateNewProject(String glbm, Project newProject,String sylx,String hcxmMc,String tdIds,String fcIds) {
        String result = "true";

        //插入hcxm，hcxm_rel两张表
        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("国土税源核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmybj("0");
        if("1".equals(sylx)){
            swHcXm.setXmlx(Hcxmlx.TDSYHC.toString());
        }else if("2".equals(sylx)){
            swHcXm.setXmlx(Hcxmlx.FCSYHC.toString());
        }
        baseRepository.save(swHcXm);
        //根据glbm，获取s_sj_swbd对象
        glbm = glbm.replace("'","");
        String[] glbmArr = glbm.split(",");
        tdIds = tdIds.replace("'","");
        String[] tdIdsArr = tdIds.split(",");
        fcIds = fcIds.replace("'","");
        String[] fcIdsArr = fcIds.split(",");

        if("1".equals(sylx)){
            QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
            JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
            jpaQuery.from(qSwDjTdWbd).where(qSwDjTdWbd.tdId.in(tdIdsArr));
            List<SwDjTdWbd> swDjTdWbdist = (List)baseRepository.dslList(jpaQuery,qSwDjTdWbd);
            for(SwDjTdWbd swDjTdWbd : swDjTdWbdist){
                Project project = new Project();
                String wiid = UUIDGenerator.generate();
                project.setProjectId(wiid);
                String wwid = AppConfig.getProperty("wglsw");
                project.setWdid(wwid);
                platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),swDjTdWbd.getNsrmc());

                SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                swHcXmRwRel.setRwId(wiid);
                swHcXmRwRel.setSwHcXm(swHcXm);
                swHcXmRwRel.setBdId(swDjTdWbd.getTdId());
                swHcXmRwRel.setBlzt("0");
                baseRepository.save(swHcXmRwRel);


            }
        }else if("2".equals(sylx)){
            QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
            JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
            jpaQuery.from(qSwDjFcWbd).where(qSwDjFcWbd.fcId.in(fcIdsArr));
            List<SwDjFcWbd> swDjFcWbdList = (List)baseRepository.dslList(jpaQuery,qSwDjFcWbd);
            for(SwDjFcWbd swDjFcWbd : swDjFcWbdList){
                Project project = new Project();
                String wiid = UUIDGenerator.generate();
                project.setProjectId(wiid);
                String wwid = AppConfig.getProperty("wglsw");
                project.setWdid(wwid);
                platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),swDjFcWbd.getNsrmc());

                SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                swHcXmRwRel.setRwId(wiid);
                swHcXmRwRel.setSwHcXm(swHcXm);
                swHcXmRwRel.setBdId(swDjFcWbd.getFcId());
                swHcXmRwRel.setBlzt("0");
                baseRepository.save(swHcXmRwRel);

            }
        }

        return result;
    }

    @Override
    public List<SSjSwbd> findWppxxJsonProject(Pageable pageable, String proid) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();
        int xzqws = userInfo.getRegionCode().length();
        StringBuffer szbuffer = new StringBuffer();
        szbuffer.append(" SUBSTR(szpq_dm,1," + xzqws + ")='" + regionCode + "'");
        if (proid != null && !proid.equals(""))
            szbuffer.append(" and  proid = '" + proid + "'");
        QueryCondition queryCondition = new QueryCondition(szbuffer.toString());
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(queryCondition);
        List<SSjSwbd> sSjSwbdTempList = baseRepository.list(SSjSwbd.class, queryConditionList);
        // Page<SSjSwbdTemp> page = baseRepository.find(SSjSwbdTemp.class,queryConditionList,"order by glbm",pageable);
        return sSjSwbdTempList;
    }

    @Override
    @Transactional(readOnly = true)
    public String getProjectSwtzJson(String xzq, StringBuffer listToJson) {
        int xzqws = 7;   //行政区位数 默认7
        StringBuffer sqlTj = new StringBuffer();
        if (xzq == null) {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String regionCode = userInfo.getRegionCode();
            xzqws = userInfo.getRegionCode().length();
            if (regionCode != null)
                xzq = regionCode.substring(0, regionCode.length() - 2);
        } else {
            xzqws = xzq.length() + 2;
        }
        StringBuffer tzBuffer = new StringBuffer();
        tzBuffer.append("select k.szpq_dm,(k.wpp+k.ypp) count,k.ypp,k.wpp,round((k.ypp)/(case when  (k.wpp+k.ypp)=0 then 1 else (k.wpp+k.ypp) end)*100,3) ppl,k.xzqname,k.dwjb from(");
        tzBuffer.append("select d.szpq_dm,(select count(*) from S_SJ_SWBD where SUBSTR(szpq_dm,1," + xzqws + ")=d.szpq_dm and  BLZT is not null and istx is null) as wpp ,");
        tzBuffer.append("(select count(*) from S_SJ_SWBD where SUBSTR(szpq_dm,1," + xzqws + ")=d.szpq_dm and  BLZT is not null and istx is not null) as ypp,");
        tzBuffer.append("(select dwmc from S_DM_SWDWXX where dwdm=d.szpq_dm ) as xzqname,");
        tzBuffer.append("(select dwjb from S_DM_SWDWXX where  dwdm=d.szpq_dm ) as dwjb");
        tzBuffer.append(" from (select SUBSTR(t.szpq_dm,1," + xzqws + ") szpq_dm from S_SJ_SWBD t group by SUBSTR(t.szpq_dm,1," + xzqws + ") order by SUBSTR(t.szpq_dm,1," + xzqws + ")) d)k");
        if (xzq != null) {
            tzBuffer.append(" where SUBSTR(k.szpq_dm,1," + (xzqws - 2) + ") = " + xzq);
        }
        List list = baseRepository.sql(tzBuffer.toString());
        return listProjectToJson(list, listToJson);
    }

    @Override
    @Transactional
    public String saveListJson(String json) {
        System.out.println(json);
        JSONArray jsonArray = JSON.parseArray(json);
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject object = (JSONObject) jsonArray.get(i);
            StringBuffer szbuffer = new StringBuffer();
            szbuffer.append(" glbm = " + (String) object.getString("glbm"));
            QueryCondition queryCondition = new QueryCondition(szbuffer.toString());
            List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
            queryConditionList.add(queryCondition);
            SSjSwbd sSjSwbd = (SSjSwbd) baseRepository.getSingleResult(SSjSwbd.class, queryConditionList);
            String djh = (String) object.get("djh");
            String dbh = (String) object.get("dbh");
            if (djh != null && !djh.equals("")) {
                sSjSwbd.setDjh(djh);
                sSjSwbd.setDbh(dbh);
                sSjSwbd.setIstx("已填写");
                baseRepository.save(sSjSwbd);
            } else {
                sSjSwbd.setDjh(null);
                sSjSwbd.setDbh(null);
                sSjSwbd.setIstx(null);
                baseRepository.save(sSjSwbd);
            }
        }
        return "n";
    }


    public String listProjectToJson(List list, StringBuffer listToJson) {
        if (listToJson == null) listToJson = new StringBuffer();
        listToJson.append("[");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();

        for (int i = 0; i < list.size(); i++) {
            Object[] object = (Object[]) list.get(i);
            String xzqcode = (String) object[0];
            if (!xzqcode.startsWith(regionCode))
                continue;
            if (i > 0 && !listToJson.toString().equals("["))
                listToJson.append(",");
            listToJson.append("{");
            String xzqname = (String) object[5];
            if (xzqname != null && !xzqname.equals("null")) {
                listToJson.append("\"name\":\"" + object[5] + "\",");
            } else {
                listToJson.append("\"name\":\"\",");
            }


            listToJson.append("\"counts\":\"" + object[1] + "\",");
            listToJson.append("\"ypp\":\"" + object[2] + "\",");
            listToJson.append("\"wpp\":\"" + object[3] + "\",");
            listToJson.append("\"ppl\":\"" + object[4] + "\",");
            listToJson.append("\"xzqdm\":\"" + object[0] + "\"");
            if (xzqcode.length() < 10) {
                listToJson.append(",");
                listToJson.append("\"children\":");
                getProjectSwtzJson(xzqcode, listToJson);
                listToJson.append("");
            }

            listToJson.append("}");

        }
        listToJson.append("]");
        //  System.out.println(listToJson.toString());
        return listToJson.toString();
    }

    private void getListByGlbm(String glbm, String proid) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if (glbm != null && !glbm.equals("")) {
            StringBuffer szbuffer = new StringBuffer();
            szbuffer.append(" glbm in (" + glbm + ")");
            QueryCondition queryCondition = new QueryCondition(szbuffer.toString());
            queryConditionList.add(queryCondition);
        } else {
            StringBuffer szbuffer = new StringBuffer();
            szbuffer.append(" bdtype  is null and istx is not null");
            QueryCondition queryCondition = new QueryCondition(szbuffer.toString());
            queryConditionList.add(queryCondition);
        }
        List<SSjSwbd> sSjSwbdList = baseRepository.list(SSjSwbd.class, queryConditionList);
        try {
            insertSsjswbd(sSjSwbdList, proid);
        } catch (Exception e) {
            System.out.println("选择核查的列表已经存在！");
        }

    }

    @Transactional
    private void insertSsjswbd(List list, String proid) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SSjSwbd sSjSwbd = (SSjSwbd) list.get(i);
                // SSjSwbdTemp sSjSwbdTemp =    reObject(sSjSwbd,proid);
                if (sSjSwbd != null) {
                    sSjSwbd.setProid(proid);
                    sSjSwbd.setBlzt("0");
                    baseRepository.update(sSjSwbd);
                }
                // baseRepository.save(sSjSwbdTemp);
            }
        }
    }




    @Override
    @Transactional(readOnly = true)
    public Project getProjectInform() {
        String wwid = AppConfig.getProperty("wglsw");
        ;
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wwid);
        Project project = new Project();
        project.setYwlb(wfDefineVo.getBusinessVo().getBusinessName());
        project.setLcmc(wfDefineVo.getWorkflowName());
        project.setProity(wfDefineVo.getPriority());
        project.setDay(wfDefineVo.getTimeLimit() + "");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        project.setJsr(userInfo.getUsername());
        project.setOrgan(userInfo.getLstOragn().get(0).getOrganName());
        project.setCreateTime(simpleDateFormat.format(new Date()));
        return project;
    }

    @Override
    @Transactional
    public void uploadToData(String proid) throws  Exception{
        SwDjTdWbd swDjTdWbd = null;
        SwDjFcWbd swDjFcWbd = null;
        SwHcXmRwRel swHcXmRwRel = null;

        String jpql = "from SwHcXmRwRel where rwId=?0";
        swHcXmRwRel = (SwHcXmRwRel)baseRepository.getUniqueResultByJpql(jpql,proid);
        String bdId = swHcXmRwRel.getBdId();

        swDjTdWbd = baseRepository.get(SwDjTdWbd.class,bdId);

        if(swDjTdWbd==null){
            swDjFcWbd = baseRepository.get(SwDjFcWbd.class,bdId);
        }
        if(swDjTdWbd!=null){
            swDjTdWbd.setSjly(Sjly.SYHC.toString());
            String djh = swDjTdWbd.getDjh();
            String dbh = swDjTdWbd.getDbh();
            SwDjSy tempSy = taxService.findSwDjSyByDjhAndDbh(djh,dbh);
            if(tempSy!=null){
                dbh = taxService.createDbhByDjh(djh);
                swDjTdWbd.setDbh(dbh);
                baseRepository.update(swDjTdWbd);
            }
            Zd zd = baseRepository.get(Zd.class,djh);
            SwDjSy swDjSy = new SwDjSy();
            swDjSy.setDbh(dbh);
            swDjSy.setSyId(UUIDGenerator.generate());
            swDjSy.setSyzt(Syzt.ZC.toString());
            swDjSy.setZd(zd);
            baseRepository.save(swDjSy);

            SwDjJbbWbd swDjJbbWbd = swDjTdWbd.getSwDjJbbWbd();
            SwDjJbb swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjJbbWbd,swDjJbb);
            String glbm = swDjJbb.getGlbm();
            SwDjJbb temp = taxService.findSwDjJbbByGlbm(glbm);
            if(temp==null){
                baseRepository.save(swDjJbb);
            }else{
                baseRepository.update(swDjJbb);
            }

            SwDjTd swDjTd = new SwDjTd();
            BeanUtils.copyProperties(swDjTdWbd,swDjTd);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setSwDjJbb(swDjJbb);
            swDjTd.setSwDjSy(swDjSy);
            baseRepository.save(swDjTd);

        }else if(swDjFcWbd!=null){
            swDjFcWbd.setSjly(Sjly.SYHC.toString());
            String djh = swDjFcWbd.getDjh();
            String dbh = swDjFcWbd.getDbh();
            SwDjSy tempSy = taxService.findSwDjSyByDjhAndDbh(djh,dbh);
            if(tempSy!=null){
                dbh = taxService.createDbhByDjh(djh);
                swDjFcWbd.setDbh(dbh);
                baseRepository.update(swDjFcWbd);
            }

            Zd zd = baseRepository.get(Zd.class,djh);
            SwDjSy swDjSy = new SwDjSy();
            swDjSy.setDbh(dbh);
            swDjSy.setSyId(UUIDGenerator.generate());
            swDjSy.setSyzt(Syzt.ZC.toString());
            swDjSy.setZd(zd);
            baseRepository.save(swDjSy);

            SwDjJbbWbd swDjJbbWbd = swDjFcWbd.getSwDjJbbWbd();
            SwDjJbb swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjJbbWbd,swDjJbb);
            String glbm = swDjJbb.getGlbm();
            SwDjJbb temp = taxService.findSwDjJbbByGlbm(glbm);
            if(temp==null){
                baseRepository.save(swDjJbb);
            }else{
                baseRepository.update(swDjJbb);
            }

            SwDjFc swDjFc = new SwDjFc();
            BeanUtils.copyProperties(swDjFcWbd,swDjFc);
            swDjFc.setSwDjJbb(swDjJbb);
            swDjFc.setSwDjSy(swDjSy);
            swDjFc.setSjly(Sjly.SYHC.toString());
            baseRepository.save(swDjFc);
        }

        //修改hcxm_rel ,hcxm数据
        doUpdHcxmAndHcxmRwRe(proid);

    }

    @Override
    @Transactional
    public void delSwbdProject(String proid) {
        //删除hcxm_rel ,hcxm数据
        deleteHcxmAndHcxmRwRel(proid);

    }

    @Override
    @Transactional(readOnly = true)
    public List<SSjSwbd> getSSjSwbdById(String[] bdIds) {
        QSSjSwbd qsSjSwbd = QSSjSwbd.sSjSwbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjSwbd).where(qsSjSwbd.swbdId.in(bdIds));
        return (List)baseRepository.dslList(jpaQuery,qsSjSwbd);
    }

    @Override
    public List<SwDjTdWbd> getSwDjTdWbdByIds(String[] bdIds) {
        QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjTdWbd).where(qSwDjTdWbd.tdId.in(bdIds));
        return (List)baseRepository.dslList(jpaQuery,qSwDjTdWbd);
    }

    @Override
    public List<SwDjFcWbd> getSwDjFcWbdByIds(String[] bdIds) {
        QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjFcWbd).where(qSwDjFcWbd.fcId.in(bdIds));
        return (List)baseRepository.dslList(jpaQuery,qSwDjFcWbd);
    }

    @Override
    @Transactional(readOnly = true)
    public SSjSwbd findSSjSwbdByProid(String proid) {
        String jpql = "from SSjSwbd o where o.proid=?0";
        return (SSjSwbd) baseRepository.getUniqueResultByJpql(jpql,proid);
    }




    private void deleteHcxmAndHcxmRwRel(String proid){
        String jpql2="from SwHcXmRwRel o where o.rwId=?0";
        SwHcXmRwRel swHcXmRwRel = (SwHcXmRwRel) baseRepository.getUniqueResultByJpql(jpql2,proid);
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        baseRepository.delete(swHcXmRwRel);
        String jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";
        List<SwHcXmRwRel> swHcXmRwRelList =  baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//删除项目
            baseRepository.delete(swHcXm);
        }else{
            String jpql3 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
            List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql3,xmId);
            if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
                swHcXm.setXmybj("1");
                baseRepository.update(swHcXm);
            }
        }
    }

    private void doUpdHcxmAndHcxmRwRe(String proid){

        String jpql="from SwHcXmRwRel o where o.rwId=?0";
        SwHcXmRwRel swHcXmRwRel = (SwHcXmRwRel) baseRepository.getUniqueResultByJpql(jpql,proid);
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);

        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();

        String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(jpql2,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }
    }



    @Override
    @Transactional(readOnly = true)
    public SwDjTdWbd findSwDjTdWbdByJbbId(String jbbId) {
        String jpql = "from SwDjTdWbd where swDjJbbWbd.jbbId=?0";
        return (SwDjTdWbd) baseRepository.getUniqueResultByJpql(jpql,jbbId);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjTdWbd findSwDjTdWbdByProid(String proid) {
        String jpql = "from SwDjTdWbd where proid=?0";
        return (SwDjTdWbd) baseRepository.getUniqueResultByJpql(jpql,proid);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjFcWbd findSwDjFcWbdByJbbId(String jbbId) {
        String jpql = "from SwDjFcWbd where SwDjFcWbd.jbbId=?0";
        return (SwDjFcWbd) baseRepository.getUniqueResultByJpql(jpql,jbbId);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjFcWbd findSwDjFcWbdByProid(String proid) {
        String jpql = "from SwDjFcWbd where proid=?0";
        return (SwDjFcWbd) baseRepository.getUniqueResultByJpql(jpql,proid);
    }

    @Override
    @Transactional
    public void saveDjh(String djh, String tdId,String fcId,String dbh) throws Exception {
        if(StringUtils.isNotBlank(tdId)){
            String jpql = "update SwDjTdWbd o set o.djh=?0,o.dbh=?1 where o.tdId=?2";
            baseRepository.executeJpql(jpql,djh,dbh,tdId);
        }else if(StringUtils.isNotBlank(fcId)){
            String jpql = "update SwDjFcWbd o set o.djh=?0,o.dbh=?1 where o.fcId=?2";
            baseRepository.executeJpql(jpql,djh,dbh,fcId);
        }

    }

    @Override
    @Transactional(readOnly = true)
    public List<GtSwTzQuery> getSwdjTzList(HashMap param) {
        String xzqbh = (String) param.get("xzqbh");
        String sylx = (String) param.get("sylx");
        Object obj =  param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSSjSwbd qsSjSwbd = QSSjSwbd.sSjSwbd;
        QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
        QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBeanz = null;
        if (sylx.equals(Sylx.TDSY.toString())) {
            jpaQuery.from(qSwDjTdWbd).leftJoin(qSwDjTdWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjTdWbd.sjly.isNull().or(qSwDjTdWbd.sjly.eq(Sjly.QRWFATPP.toString())).or(qSwDjTdWbd.sjly.eq(Sjly.QRWFZDPP.toString())).or(qSwDjTdWbd.sjly.eq(Sjly.QRWFRGPP.toString())));
            jpaQuery.where(qSwDjTdWbd.tdId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.TDSYHC.toString())).list(qSwHcXmRwRel.bdId)));
            qBeanz = Projections.bean(GtSwTzQuery.class, qsSjSwbd.swbdId, qsSjSwbd.tdnynse, qsSjSwbd.fcnynse, qsSjSwbd.szpqDm, qsSjSwbd.szpqMc,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qsSjSwbd.bdtype, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjTdWbd.tdId,qSwDjTdWbd.djh, qSwDjTdWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId, qsSjSwbd.qxdm);
            if(obj!=null){//勾选checkbox导出
                String ids = String.valueOf(obj);
                List idsList = Arrays.asList(ids.split(","));
                jpaQuery.where(qSwDjTdWbd.tdId.in(idsList));
            }else{//条件导出
                if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
            }
        } else {
            jpaQuery.from(qSwDjFcWbd).leftJoin(qSwDjFcWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjFcWbd.sjly.isNull().or(qSwDjFcWbd.sjly.eq(Sjly.QRWFATPP.toString())).or(qSwDjFcWbd.sjly.eq(Sjly.QRWFZDPP.toString())).or(qSwDjFcWbd.sjly.eq(Sjly.QRWFRGPP.toString())));
            jpaQuery.where(qSwDjFcWbd.fcId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.TDSYHC.toString())).list(qSwHcXmRwRel.bdId)));

            qBeanz = Projections.bean(GtSwTzQuery.class, qsSjSwbd.swbdId, qsSjSwbd.tdnynse, qsSjSwbd.fcnynse, qsSjSwbd.szpqDm, qsSjSwbd.szpqMc,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qsSjSwbd.bdtype, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjFcWbd.fcId,qSwDjFcWbd.djh, qSwDjFcWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId, qsSjSwbd.qxdm);
            if(obj!=null){//勾选checkbox导出
                String ids = String.valueOf(obj);
                List idsList = Arrays.asList(ids.split(","));
                jpaQuery.where(qSwDjFcWbd.fcId.in(idsList));
            }else{//条件导出
                if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
            }
        }
        if (xzqbh != null) {
            jpaQuery.where(qsSjSwbd.szpqDm.substring(0, xzqbh.length()).eq(xzqbh));
        }
        return (List)baseRepository.dslList(jpaQuery,qBeanz);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SSjSwbd> findYxfSyMap(Pageable pageable,SwDjSyQuery swDjSyQuery, Sylx lxs) {
        QSwDjFcWbd qSwDjFcWbd = QSwDjFcWbd.swDjFcWbd;
        QSwDjTdWbd qSwDjTdWbd = QSwDjTdWbd.swDjTdWbd;
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBeanz = null;
        if (lxs.equals(Sylx.TDSY)) {
            jpaQuery.from(qSwDjTdWbd).leftJoin(qSwDjTdWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjTdWbd.tdId.in(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.TDSYHC.toString())).list(qSwHcXmRwRel.bdId)));

            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(Expressions.stringPath(qSwDjTdWbd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            qBeanz = Projections.bean(GtSwTzQuery.class, qSwDjTdWbd.nynseTd,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjTdWbd.tdId,qSwDjTdWbd.djh, qSwDjTdWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId);
            if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
                jpaQuery.where(Expressions.stringPath(qSwDjTdWbd, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        } else {
            jpaQuery.from(qSwDjFcWbd).leftJoin(qSwDjFcWbd.swDjJbbWbd,qSwDjJbbWbd);
            jpaQuery.where(qSwDjFcWbd.fcId.in(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.TDSYHC.toString())).list(qSwHcXmRwRel.bdId)));
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(Expressions.stringPath(qSwDjFcWbd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            qBeanz = Projections.bean(GtSwTzQuery.class, qSwDjFcWbd.nynseFc,
                    qSwDjJbbWbd.sgyDm, qSwDjJbbWbd.sgyMc, qSwDjJbbWbd.zgkgDm, qSwDjJbbWbd.zgkgMc, qSwDjFcWbd.fcId,qSwDjFcWbd.djh, qSwDjFcWbd.dbh,
                    qSwDjJbbWbd.glbm, qSwDjJbbWbd.nsrmc, qSwDjJbbWbd.jbbId);
            if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
                jpaQuery.where(Expressions.stringPath(qSwDjFcWbd, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "glbm").like(swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd, "nsrmc").like(QueryCondition.WILDCARDS+swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        return baseRepository.find(jpaQuery, qBeanz, pageable);
    }


}
