package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.query.SjgjQuery;
import cn.gtmap.landtax.service.SjgjService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by zhouzhiwei on 2015-8-6.
 */
@Service
public class SjgjServiceImpl implements SjgjService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TjService tjService;

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSy> getSyPage(List<QueryCondition> queryConditionList, Pageable pageable, String sylx) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        String orderBy = "";
        if (sylx == null || sylx.equals("1")) {
            orderBy = "order by swDjTd.swDjJbb.nsrmc, swDjTd.tdzl, swDjTd.tdsyzh";
        } else if (sylx.equals("2")) {
            orderBy = "order by swDjFc.swDjJbb.nsrmc, swDjFc.fczl, swDjFc.fczh";
        } else {
            orderBy = "order by swDjJbb.nsrmc";
        }

        return baseRepository.find(SwDjSy.class, queryConditionList, orderBy, pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSy> getZdppSyPage(SjgjQuery sjgjQuery, Pageable pageable) {
        String sql = "";

        if (sjgjQuery.getSylx() == null || sjgjQuery.getSylx().equals("1")) {
            sql = "SELECT t.*, " +
                    "        t1.NSRMC, t1.FDDBR, t1.GLBM," +
                    "        t2.TDZL, t2.TDSYZH, t2.SCMJ, t2.TD_ID " +
                    "FROM SW_DJ_SY t " +
                    "     LEFT JOIN SW_DJ_TD t2 ON t.SY_ID=t2.SY_ID " +
                    "     LEFT JOIN SW_DJ_JBB t1 ON t2.JBB_ID=t1.JBB_ID " +
                    "WHERE t2.SY_ID IS NOT NULL AND t2.SJLY='0' AND t.SYZT='3' ";

            // 天假过滤条件
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                sql += " AND t1.NSRMC IN (SELECT TO_CHAR(QLRMC) FROM S_SJ_GTBD)";
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                sql += " AND t2.TDZL IN (SELECT TO_CHAR(TDZL) FROM S_SJ_GTBD)";
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                sql += " AND t2.TDSYZH IN (SELECT TO_CHAR(TDSYZH) FROM S_SJ_GTBD)";
            }
            sql += " ORDER BY t1.NSRMC, t2.TDZL, t2.TDSYZH";
        } else if (sjgjQuery.getSylx().equals("2")) {
            sql = "SELECT t.*, " +
                    "        t1.NSRMC, t1.FDDBR, t1.GLBM," +
                    "        t2.FCZL, t2.FCZH, t2.FCMJ, t2.FC_ID " +
                    "FROM SW_DJ_SY t " +
                    "     LEFT JOIN SW_DJ_FC t2 ON t.SY_ID=t2.SY_ID " +
                    "     LEFT JOIN SW_DJ_JBB t1 ON t2.JBB_ID=t1.JBB_ID " +
                    "WHERE t2.SY_ID IS NOT NULL AND t2.SJLY='0' AND t.SYZT='3' ";

            // 天假过滤条件
            if (StringUtils.isNotEmpty(sjgjQuery.getMc())) {
                sql += " AND t1.NSRMC IN (SELECT TO_CHAR(QLRMC) FROM S_SJ_GTBD)";
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getTdzl())) {
                sql += " AND t2.FCZL IN (SELECT TO_CHAR(TDZL) FROM S_SJ_GTBD)";
            }
            if (StringUtils.isNotEmpty(sjgjQuery.getZh())) {
                sql += " AND t2.FCZH IN (SELECT TO_CHAR(TDSYZH) FROM S_SJ_GTBD)";
            }
            sql += " ORDER BY t1.NSRMC, t2.FCZL, t2.FCZH";
        }

        String countSql = "select count(*) from (" + sql + ")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Page page = baseRepository.find(query, countQuery, pageable);

        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>();
        for (int i = 0; i < page.getContent().size(); i++) {
            HashMap hashMap = (HashMap)page.getContent().get(i);
            SwDjSy swDjSy = new SwDjSy();
            SwDjJbb swDjJbb = new SwDjJbb();
            SwDjTd swDjTd = new SwDjTd();
            SwDjFc swDjFc = new SwDjFc();

            if (hashMap.get("SY_ID") != null)
                swDjSy.setSyId(hashMap.get("SY_ID").toString());
            if (hashMap.get("GLBM") != null)
                swDjJbb.setGlbm(hashMap.get("GLBM").toString());
            if (hashMap.get("NSRMC") != null)
                swDjJbb.setNsrmc(hashMap.get("NSRMC").toString());
            if (hashMap.get("FDDBR") != null)
                swDjJbb.setFddbr(hashMap.get("FDDBR").toString());
            if (hashMap.get("TDZL") != null)
                swDjTd.setTdzl(hashMap.get("TDZL").toString());
            if (hashMap.get("TDSYZH") != null)
                swDjTd.setTdsyzh(hashMap.get("TDSYZH").toString());
            if (hashMap.get("SCMJ") != null)
                swDjTd.setScmj(new BigDecimal(hashMap.get("SCMJ").toString()));
            if (hashMap.get("TD_ID") != null)
                swDjTd.setTdId(hashMap.get("TD_ID").toString());
            if (hashMap.get("FCZL") != null)
                swDjFc.setFczl(hashMap.get("FCZL").toString());
            if (hashMap.get("FCZH") != null)
                swDjFc.setFczh(hashMap.get("FCZH").toString());
            if (hashMap.get("FCMJ") != null)
                swDjFc.setFcmj(new BigDecimal(hashMap.get("FCMJ").toString()));
            if (hashMap.get("FC_ID") != null)
                swDjFc.setFcId(hashMap.get("FC_ID").toString());

            swDjTd.setSwDjJbb(swDjJbb);
            swDjFc.setSwDjJbb(swDjJbb);
            swDjSy.setSwDjTd(swDjTd);
            swDjSy.setSwDjFc(swDjFc);
            swDjSyList.add(swDjSy);
        }

        return new PageImpl(swDjSyList, pageable, page.getTotalElements());
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SSjGtbd> getZdPage(List<QueryCondition> queryConditionList, Pageable pageable, String sylx) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        String orderBy = " order by djh, qlrmc, tdzl, tdzh";
        Page page = null;
        page = baseRepository.find(SSjGtbd.class, queryConditionList, orderBy, pageable);
        return page;
    }

    @Override
    @Transactional
    public void updateSwdjSy(SwDjSy swDjSy, String sylx) {
        baseRepository.update(swDjSy);
    }
}
