package cn.gtmap.landtax.service.impl;/**
 * Created by janeshen on 2014/8/21.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.*;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/21
 */
@Service
public class HcxmServiceImpl implements HcxmService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    WorkFlowCoreService workFlowService;

    String tdsbqx = AppConfig.getProperty("tdsbqx");
    String tdsbswjg = AppConfig.getProperty("tdsbswjg");
    String fcsbqx = AppConfig.getProperty("fcsbqx");
    String fcsbswjg= AppConfig.getProperty("fcsbswjg");
    String tdzsqx= AppConfig.getProperty("tdzsqx");
    String tdzsswjg= AppConfig.getProperty("tdzsswjg");
    String fczsqx= AppConfig.getProperty("fczsqx");
    String fczsswjg= AppConfig.getProperty("fczsswjg");

    @Override
    @Transactional
    public void createGtzdHcxm(SwHcXm swHcXm,List<SSjGtbd> gtbdList,String userId) {
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        for(SSjGtbd sSjGtbd:gtbdList){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            String wwid = AppConfig.getProperty("sszd");
            project.setWdid(wwid);
            project.setBz(sSjGtbd.getDjh());
            platUtil.createWorkFlowInstance(project, userId,sSjGtbd.getQlrmc());

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(sSjGtbd.getGtbdId());
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);


            sSjGtbd.setBlzt("0");
            baseRepository.update(sSjGtbd);
        }
    }

    @Override
    @Transactional
    public String createSyblHcxm(SwHcXm swHcXm, Zd zd, String userId) {
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = AppConfig.getProperty("sybl");
        project.setWdid(wwid);
        project.setBz(zd.getDjh());
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, zd.getQlrmc());
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                taskId = "java.lang:" + ((RuntimeException) e).getMessage().substring(0, ((RuntimeException) e).getMessage().length());
                return taskId;
            } else {
                throw new RuntimeException();
            }
        }

        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(UUIDGenerator.generate());
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(zd.getDjh());
        swHcXmRwRel.setBlzt("0");
        baseRepository.save(swHcXmRwRel);

        return  taskId;
    }

    @Override
    @Transactional
    public void deleteHcxm(String hcxmId) throws Exception {
        String jpql = "select rwId from SwHcXmRwRel where hcxmId=?0";
        List<String> rwIds = baseRepository.getByJpql(jpql,hcxmId);
        //删除核查项目对应的工作流项目
        for(String rwId:rwIds){
            platUtil.deleteWorkFlowInstance(rwId);
        }

        //删除核查项目与工作流项目的关系
        jpql = "delete from SwHcXmRwRel where hcxmId=?0";
        baseRepository.executeJpql(jpql,hcxmId);

        //删除核查项目
        baseRepository.delete(SwHcXm.class,hcxmId);
    }

    @Override
    public void delHcXmByXmid(String xmId) {
        //删除核查项目
        baseRepository.delete(SwHcXm.class,xmId);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<SwHcXm> findDhcxm(HcxmQuery hcxmQuery,Pageable pageable) {
        StringBuilder whereClause = new StringBuilder("");
        String userId = SessionUtil.getCurrentUserId();
        if(StringUtils.isNotBlank(hcxmQuery.getXmlx())){
            whereClause.append("where t.xmlx ='"+hcxmQuery.getXmlx()+"'");
        }else
            whereClause.append("where t.xmlx is not null");
        if(!userId.equals("0")){
            whereClause.append(" and t2.USER_ID = '"+userId+"'");
        }
        whereClause.append(" and t.XMYBJ = '0'");


        Query query = baseRepository.getEntityManager().createNativeQuery("select distinct id,t.mc,t.cjr_id,t.xmlx,t.cjrq,t.xmybj from sw_hc_xm t " +
                "left join sw_hc_xm_rw_rel t1 on t.id = t1.hcxm_id " +
                "left join pf_tasklist t2 on t1.rw_id=t2.WORKFLOW_INSTANCE_ID " +
                whereClause,SwHcXm.class);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery("select count(distinct id) from sw_hc_xm t " +
                "left join sw_hc_xm_rw_rel t1 on t.id = t1.hcxm_id " +
                "left join pf_tasklist t2 on t1.rw_id=t2.WORKFLOW_INSTANCE_ID " +
                whereClause);
        return baseRepository.find(query, countQuery, pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwHcXmRwRel> findHcxmRw(String hcxmId) {
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());

        return jpaQuery.from(qSwHcXmRwRel).where(qSwHcXmRwRel.swHcXm.xmId.eq(hcxmId)).list(qSwHcXmRwRel);
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> findAllHcxmBdId(String hcxmId) {
        String whereClause = "where hcxm_id='"+hcxmId+"'";
        String userId = SessionUtil.getCurrentUserId();
        if(!userId.equals("0")){
            whereClause += " and USER_ID = '"+userId+"'";
        }
        String sql = "";
        sql +="select bd_id from sw_hc_xm_rw_rel  left join pf_taskList  on rw_id = WORKFLOW_INSTANCE_ID "+whereClause;
        sql +="union select bd_id from sw_hc_xm_rw_rel  left join pf_taskoverList  on rw_id = WORKFLOW_INSTANCE_ID "+whereClause;
        return baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> findDxfHcxmBdId(String hcxmId) {
        String whereClause = "where hcxm_id='"+hcxmId+"'";

        String userId = SessionUtil.getCurrentUserId();
        if(!userId.equals("0")){
            whereClause += " and USER_ID = '"+userId+"'";
        }
        whereClause += " and blzt='0'";
        String sql = "select bd_id from sw_hc_xm_rw_rel  left join pf_taskList  on rw_id = WORKFLOW_INSTANCE_ID "+whereClause;
        return baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
    }

    @Override
    @Transactional(readOnly = true)
    public SwHcXm getHcxmById(String xmId) {
        return baseRepository.get(SwHcXm.class,xmId);
    }

    @Override
    @Transactional(readOnly = true)
    public String getHcxmTaskId(String bdId) {
        String userId = SessionUtil.getCurrentUserId();

        String sql = "select t1.ASSIGNMENT_ID from sw_hc_xm_rw_rel t " +
                "left join pf_tasklist t1 on t.rw_id = t1.WORKFLOW_INSTANCE_ID " +
                "where t.bd_id='"+bdId+"'";
        if(!userId.equals("0")){
            sql += " and t1.USER_ID = '"+userId+"'";
        }
        return (String)baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult();
    }

    @Override
    @Transactional(readOnly = true)
    public String getHcxmBdIdByWiid(String wiid) {
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qSwHcXmRwRel).where(qSwHcXmRwRel.rwId.eq(wiid)).uniqueResult(qSwHcXmRwRel.bdId);
    }

    @Override
    @Transactional(readOnly = true)
    public SwHcXmRwRel getSwHcXmRwRelByWiid(String wiid) {
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qSwHcXmRwRel).where(qSwHcXmRwRel.rwId.eq(wiid)).uniqueResult(qSwHcXmRwRel);
    }

    @Override
    @Transactional(readOnly = true)
    public SwHcXmRwRel getSwHcXmRwRelByBdId(String bdId) {
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qSwHcXmRwRel).where(qSwHcXmRwRel.bdId.eq(bdId)).uniqueResult(qSwHcXmRwRel);
    }

    @Override
    public SwHcXmRwRel getSwHcXmRwRelByShxrId(String shxrId) {
        return baseRepository.get(SwHcXmRwRel.class,shxrId);
    }

    @Override
    @Transactional
    public void updateSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel) {
        baseRepository.update(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void delHcXmRwRelByShxrId(String shxrId) {
        baseRepository.delete(SwHcXmRwRel.class,shxrId);
    }

    @Override
    @Transactional
    public void wfEnd(String proid) {
        //1,将swDjSy.syzt 设置成1
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        for(SwDjSy swDjsy : swDjSyList){
            SwDjTd tempTd = swDjsy.getSwDjTd();
            tempTd.setSjly(Sjly.SYHC.toString());
            baseRepository.update(tempTd);
            SwDjFc tempFc = swDjsy.getSwDjFc();
            tempFc.setSjly(Sjly.SYHC.toString());
            baseRepository.update(tempFc);
            taxService.softDelSyDjSy(swDjsy.getSyId(), Syzt.ZC.toString());
        }

        //2,将SSjGtbd的ppzt设置成3（税源核查）,blzt设置成1（0：正在办理，1：已办结）
        String bdId = swHcXmRwRel.getBdId();
        SSjGtbd sSjGtbd = baseRepository.get(SSjGtbd.class,bdId);
        sSjGtbd.setPpzt("3");
        sSjGtbd.setBlzt("1");

        baseRepository.update(sSjGtbd);

        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        doUpSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doUpSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void wfDel(String proid) {
        //1,删除swHcXmRwRel下的所有税源，此时税源状态都是3(零时)
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        for(SwDjSy swDjSy : swDjSyList){
            //删除税源
            taxService.deleteSwDjSy(swDjSy.getSyId());
        }

        //2,将SSjGtbd的ppzt设置成 ""（空，表示为挂接税源）,blzt设置成 ""（0：正在办理，1：已办结,""：表示为挂接）
        String bdId = swHcXmRwRel.getBdId();
        SSjGtbd sSjGtbd = baseRepository.get(SSjGtbd.class,bdId);
        sSjGtbd.setBlzt("");
        baseRepository.update(sSjGtbd);

        //3,删除SwHcXmRwRel记录
        doSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doSwHcXm(swHcXmRwRel);

    }

    @Override
    @Transactional
    public void wfEndSybl(String proid) {
        //1,将swDjSy.syzt 设置成1
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        for(SwDjSy swDjsy : swDjSyList){
            SwDjTd tempTd = swDjsy.getSwDjTd();
            tempTd.setSjly(Sjly.SYHC.toString());
            baseRepository.update(tempTd);
            SwDjFc tempFc = swDjsy.getSwDjFc();
            tempFc.setSjly(Sjly.SYHC.toString());
            baseRepository.update(tempFc);
            taxService.softDelSyDjSy(swDjsy.getSyId(), Syzt.ZC.toString());
        }

        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        doUpSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doUpSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void wfDelSybl(String proid) {
        //1,删除swHcXmRwRel下的所有税源，此时税源状态都是3(零时)
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        for(SwDjSy swDjSy : swDjSyList){
            //删除税源
            taxService.deleteSwDjSy(swDjSy.getSyId());
        }

        //3,删除SwHcXmRwRel记录
        doSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void createGtzdYdqcHcxm(SwHcXm swHcXm, List<Zd> zdList) {
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        for(Zd zd:zdList){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            String wwid = AppConfig.getProperty("zdydqc");
            project.setWdid(wwid);

            platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),zd.getQlrmc());

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(zd.getDjh());
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);

            //ydqcrel中插入该宗地记录，并设置relid=djh，设置blzt=‘0’
            YdqcRel ydqcRel = new YdqcRel();
            ydqcRel.setId(UUIDGenerator.generate());
            ydqcRel.setBlzt("0");
            ydqcRel.setDjh(zd.getDjh());
            baseRepository.save(ydqcRel);

            //把该宗地的所有税源列表插入税源历史表
            String jpql = "from SwDjSy o where o.zd.djh =?0 and (o.syzt is null or o.syzt='1') ";

            List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,zd.getDjh());
            String userId = SessionUtil.getCurrentUserId();

            for(SwDjSy swDjSy : swdjSyList){
                //插入历史表,同时插入一条数据进入临时表
                saveSwDjHisZdYdqc(swDjSy, wiid, userId, Czlx.UPDATE.toString());
            }

        }
    }

    @Override
    @Transactional(readOnly = true)
    public SwHcXmRwRel getSwHcXmRwRelByRwid(String rwid) {
        String jpql = "from SwHcXmRwRel o where o.rwId=?0";
        return (SwHcXmRwRel) baseRepository.getUniqueResultByJpql(jpql,rwid);
    }



    //删除SwHcXmRwRel记录
    @Override
    public void doSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel){
        if(swHcXmRwRel!=null && StringUtils.isNotBlank(swHcXmRwRel.getShxrId())){
            delHcXmRwRelByShxrId(swHcXmRwRel.getShxrId());
        }
    }

    //3,判断SwHcXm中是否还有swHcXmRwRel,如果没有，删除hcxm记录
    @Override
    public void doSwHcXm(SwHcXmRwRel swHcXmRwRel){
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";
        List<SwHcXmRwRel> swHcXmRwRelList =  baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//删除项目
            delHcXmByXmid(xmId);
        }else{
            String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
            List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
            if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
                swHcXm.setXmybj("1");
                baseRepository.update(swHcXm);
            }
        }


    }
    @Override
    public void doUpSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel){
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);
    }
    @Override
    public void doUpSwHcXm(SwHcXmRwRel swHcXmRwRel){
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getDxfrwList(HcrwQuery hcrwQuery) {
        List list = new ArrayList();
        if(StringUtils.isNotBlank(hcrwQuery.getIds())){
            String ids = hcrwQuery.getIds();
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(hcrwQuery.getHcxmlx().equals(Hcxmlx.ZDHC.toString())){
                    hcrwQuery.setGtbdId(idsArr[i]);
                }else if(hcrwQuery.getHcxmlx().equals(Hcxmlx.GDHC.toString())){
                    hcrwQuery.setXmId(idsArr[i]);
                }else if(hcrwQuery.getHcxmlx().equals(Hcxmlx.BPHC.toString())){
                    hcrwQuery.setPcId(idsArr[i]);
                }
                String sql = getDhcrwSql(hcrwQuery);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List tempList = query.getResultList();
                if(CollectionUtils.isNotEmpty(tempList))
                    list.add(tempList.get(0));
            }
        }else{
            String sql = getDhcrwSql(hcrwQuery);
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            if(StringUtils.isNotBlank(hcrwQuery.getExcelBegin()) && StringUtils.isNotBlank(hcrwQuery.getExcelEnd())){
                Integer offset = Integer.parseInt(hcrwQuery.getExcelBegin())-1;
                Integer limit = Integer.parseInt(hcrwQuery.getExcelEnd())-offset;
                query.setFirstResult(offset).setMaxResults(limit);
            }
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            return query.getResultList();
        }
        return list;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getHcjdDetailZdhc(String xzqdm,String jdlx,Pageable pageable,GtSwTzQuery sSjGtbd) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.ZDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String sql = getHcjdDetailZdhcSql(xzqdm, configArr, flag, isSgy, jdlx, sSjGtbd, true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getZdhcTJrws(String xzqdm, String jdlx, GtSwTzQuery sSjGtbd)throws  Exception{
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.ZDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String workflowDefinId = AppConfig.getProperty("sszd");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        Map resultMap = new HashMap();
        String wxf = getWxfSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String sjxf = getSjxfSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String qxxf = getQxxfSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String hczzxf = getHczzxfSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String swryxf = getSwryxfSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String qrrk = getQrrkSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        String ybj = getYbjSql(configArr,flag,isSgy,xzqdm,jdlx,sSjGtbd,activityList);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> getHcjdDetailZdhcList(String xzqdm,String jdlx,GtSwTzQuery sSjGtbd) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.ZDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        if(StringUtils.isNotBlank(sSjGtbd.getExcelBegin()) && StringUtils.isNotBlank(sSjGtbd.getExcelEnd())){
            Integer offset = Integer.parseInt(sSjGtbd.getExcelBegin())-1;
            Integer limit = Integer.parseInt(sSjGtbd.getExcelEnd())-offset;
            query.setFirstResult(offset).setMaxResults(limit);
        }
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getHcjdDetailGdhc(String xzqdm, String jdlx, Pageable pageable, SwDjQsQuery swDjQsQuery) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getGdhcTJrws(String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery) throws Exception{
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String workflowDefinId = AppConfig.getProperty("gdhc");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        Map resultMap = new HashMap();
        String wxf = getGdhcWxfSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String sjxf = getGdhcSjxfSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String qxxf = getGdhcQxxfSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String hczzxf = getGdhcHczzxfSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String swryxf = getGdhcSwryxfSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String qrrk = getGdhcQrrkSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        String ybj = getGdhcYbjSql(configArr, flag, isSgy, xzqdm, jdlx, swDjQsQuery, activityList);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> getHcjdDetailGdhcList(String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String sql = getHcjdDetailGdhcSql(xzqdm,configArr,flag,isSgy,jdlx,swDjQsQuery,true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        if(StringUtils.isNotBlank(swDjQsQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjQsQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjQsQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjQsQuery.getExcelEnd())-offset;
            query.setFirstResult(offset).setMaxResults(limit);
        }
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getHcjdDetailBphc(String xzqdm, String jdlx, Pageable pageable, GdzysQuery gdzysQuery) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.BPHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getBphcTJrws(String xzqdm, String jdlx, GdzysQuery gdzysQuery)throws  Exception{
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.BPHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }

        String workflowDefinId = AppConfig.getProperty("bphc");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        Map resultMap = new HashMap();
        String wxf = getBphcWxfSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String sjxf = getBphcSjxfSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String qxxf = getBphcQxxfSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String hczzxf = getBphcHczzxfSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String swryxf = getBphcSwryxfSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String qrrk = getBphcQrrkSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        String ybj = getBphcYbjSql(configArr, flag, isSgy, xzqdm, jdlx, gdzysQuery, activityList);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> getHcjdDetailBphcList(String xzqdm, String jdlx, GdzysQuery gdzysQuery) {
        PfUserVo pfUserVo = sysUserService.getUserVo(xzqdm);
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.BPHC.toString());
        boolean isSgy = false;
        Integer flag = null;

        if(pfUserVo!=null){
            isSgy = true;
        }
        if(StringUtils.isNotBlank(xzqdm) && StringUtils.isNotBlank(jdlx)){
            Integer length = xzqdm.length();
            if(isSgy){
                flag = 3;
            }else{
                if(length==4){//说明是市局用户
                    flag = 0;
                }else if(length==6){//说明是区县管理员
                    flag = 1;
                }else if(length==8 ){//
                    flag = 2;
                }
            }
        }
        String sql = getHcjdDetailBphcSql(xzqdm,configArr,flag,isSgy,jdlx,gdzysQuery,true);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        if(StringUtils.isNotBlank(gdzysQuery.getExcelBegin()) && StringUtils.isNotBlank(gdzysQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(gdzysQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(gdzysQuery.getExcelEnd())-offset;
            query.setFirstResult(offset).setMaxResults(limit);
        }
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Boolean isYbjByProid(String proid) {
        String sql = "select workflow_state from pf_workflow_instance o where o.workflow_instance_id= :proid";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("proid", proid);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap> list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            String blzt = ((HashMap)list.get(0)).get("WORKFLOW_STATE").toString();
            if("2".equals(blzt)){
                return true;
            }
        }
        return false;
    }

    private String getBphcYbjSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = sql + " and t2.blzt='1' ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcQrrkSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcSwryxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcHczzxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcQxxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcSjxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getBphcWxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, GdzysQuery gdzysQuery, List activityList) {
        String sql = getHcjdDetailBphcSql(xzqdm, configArr, flag, isSgy, jdlx, gdzysQuery, false);
        sql = sql + " and t2.blzt is null ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHcjdDetailBphcSql(String xzqdm, String[] configArr, Integer flag, boolean isSgy, String jdlx, GdzysQuery gdzysQuery, Boolean isOrderBy) {
        String sql = "";
        if(isSgy){
            sql = "select t1.rw_id,t3.pc_id,t3.pcmc,t3.pzmj,t3.fgdnydmj,t3.nydmj,t3.jbntmj,t3.gdmj,to_date(to_char(trunc(t3.pzsj),'yyyy-MM-dd'),'yyyy-MM-dd')pzsj,t3.yddw,t3.xzqdm from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t  " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id  " +
                    "join " +
                    "(" +
                    "select * from( " +
                    "select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from  " +
                    "( " +
                    "select user_id,activity_id,begin_time from pf_assignmenthistory t1  " +
                    "union all " +
                    "select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2  " +
                    ")t) where pm=1 "+
                    ")"+
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "left join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "where t6.xmlx='"+Hcxmlx.BPHC.toString()+"' and t5.user_id='"+xzqdm+"'and t2.activity_state in('1','2') and t2.activity_definition_id='"+configArr[flag]+"' ";
            if(Jdlx.YCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='1' ";
            }else if(Jdlx.WCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='0' ";
            }
            sql = sql +")t1  " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join sw_dj_pcxx t3 on t3.pc_id=t2.bd_id ";
        }else{
            sql = "select t1.rw_id,t3.pc_id,t3.pcmc,t3.pzmj,t3.fgdnydmj,t3.nydmj,t3.jbntmj,t3.gdmj,to_date(to_char(trunc(t3.pzsj),'yyyy-MM-dd'),'yyyy-MM-dd')pzsj,t3.yddw,t3.xzqdm   from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "join " +
                    "( " +
                    "     select * from(select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from " +
                    "     ( " +
                    "            select user_id,activity_id,begin_time from pf_assignmenthistory t1 " +
                    "            union all " +
                    "            select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2 " +
                    "      )t) where pm=1 " +
                    ") " +
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                    "join pf_organ t8 on t8.organ_id=t7.organ_id " +
                    "where t6.xmlx='"+Hcxmlx.BPHC.toString()+"'and substr(t8.region_code,1,"+xzqdm.length()+")='"+xzqdm+"' and t2.activity_state in('1','2','3') and t2.activity_definition_id='"+configArr[flag]+"' ";
            if(Jdlx.YCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='1' ";
            }else if(Jdlx.WCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='0' ";
            }
            sql = sql + ")t1 " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join sw_dj_pcxx t3 on t3.pc_id=t2.bd_id ";
        }
        sql = sql + " where 1=1 ";
        sql = addHcjdDetailBphcSqlWhere(sql, gdzysQuery, isOrderBy);
        return sql;
    }

    private String addHcjdDetailBphcSqlWhere(String sql, GdzysQuery gdzysQuery, Boolean isOrderBy) {
        String where = "";
        if(StringUtils.isNotBlank(gdzysQuery.getPcmc()))
            where = where + "and t3.pcmc like '%"+gdzysQuery.getPcmc()+"%' ";
        if(StringUtils.isNotBlank(gdzysQuery.getPcXzqdm()))
            where = where + "and t3.xzqdm = '"+gdzysQuery.getPcXzqdm()+"' ";
        if(StringUtils.isNotBlank(gdzysQuery.getPcYddw()))
            where = where + "and t3.yddw like '%"+gdzysQuery.getPcYddw()+"%' ";
        sql = sql + where;
        if(StringUtils.isNotBlank(gdzysQuery.getIds())){
            String ids = gdzysQuery.getIds();
            String[] idsArr = ids.split(",");
            String idsWhere = CommonUtil.getOracleSQLIn(Arrays.asList(idsArr),500,"t3.pc_id");
            sql = sql + "and "+idsWhere;
        }
        if(isOrderBy){
            //sql = sql + "order by t3.pc_id desc ";
        }
        return sql;
    }

    private String getGdhcYbjSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = sql + " and t2.blzt='1' ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcQrrkSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcSwryxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcHczzxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcQxxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcSjxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getGdhcWxfSql(String[] configArr, Integer flag, boolean isSgy, String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery, List activityList) {
        String sql = getHcjdDetailGdhcSql(xzqdm, configArr, flag, isSgy, jdlx, swDjQsQuery, false);
        sql = sql + " and t2.blzt is null ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHcjdDetailGdhcSql(String xzqdm, String[] configArr, Integer flag, boolean isSgy, String jdlx, SwDjQsQuery swDjQsQuery, Boolean isOrderBy) {
        String sql = "";
        if(isSgy){
            sql = "select t3.xm_id,t3.xmmc,t3.gdmj,t3.qdfs,t3.qdjg,to_date(to_char(trunc(t3.gdsj),'yyyy-MM-dd'),'yyyy-MM-dd')gdsj,t3.tdyt,t3.yddw,t3.xzqdm,t1.rw_id from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t  " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id  " +
                    "join " +
                    "(" +
                    "select * from( " +
                    "select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from  " +
                    "( " +
                    "select user_id,activity_id,begin_time from pf_assignmenthistory t1  " +
                    "union all " +
                    "select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2  " +
                    ")t) where pm=1 "+
                    ")"+
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "left join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "where t6.xmlx='"+Hcxmlx.GDHC.toString()+"' and t5.user_id='"+xzqdm+"'and t2.activity_state in('1','2') and t2.activity_definition_id='"+configArr[flag]+"' ";
            if(Jdlx.YCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='1' ";
            }else if(Jdlx.WCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='0' ";
            }
            sql = sql +")t1  " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join sw_dj_xmxx t3 on t3.xm_id=t2.bd_id ";
        }else{
            sql = "select  t3.xm_id,t3.xmmc,t3.gdmj,t3.qdfs,t3.qdjg,to_date(to_char(trunc(t3.gdsj),'yyyy-MM-dd'),'yyyy-MM-dd')gdsj,t3.tdyt,t3.yddw,t3.xzqdm,t1.rw_id from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "join " +
                    "( " +
                    "     select * from(select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from " +
                    "     ( " +
                    "            select user_id,activity_id,begin_time from pf_assignmenthistory t1 " +
                    "            union all " +
                    "            select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2 " +
                    "      )t) where pm=1 " +
                    ") " +
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                    "join pf_organ t8 on t8.organ_id=t7.organ_id " +
                    "where t6.xmlx='"+Hcxmlx.GDHC.toString()+"'and substr(t8.region_code,1,"+xzqdm.length()+")='"+xzqdm+"' and t2.activity_state in('1','2','3') and t2.activity_definition_id='"+configArr[flag]+"' ";
            if(Jdlx.YCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='1' ";
            }else if(Jdlx.WCL.toString().equals(jdlx)){
                sql = sql + " and t.blzt='0' ";
            }
            sql = sql + ")t1 " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join sw_dj_xmxx t3 on t3.xm_id=t2.bd_id ";
        }
        sql = sql + " where 1=1 ";
        sql = addHcjdDetailGdhcSqlWhere(sql, swDjQsQuery, isOrderBy);
        return sql;
    }

    private String addHcjdDetailGdhcSqlWhere(String sql, SwDjQsQuery swDjQsQuery, Boolean isOrderBy) {
        String where = "";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmmc()))
            where = where + "and t3.xmmc like '%"+swDjQsQuery.getXmmc()+"%' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmXzqdm()))
            where = where + "and t3.xzqdm = '"+swDjQsQuery.getXmXzqdm()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getQdfs()))
            where = where + "and t3.qdfs = '"+swDjQsQuery.getQdfs()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdyt()))
            where = where + "and t3.tdyt = '"+swDjQsQuery.getXmTdyt()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmYddw()))
            where = where + "and t3.yddw like '%"+swDjQsQuery.getXmYddw()+"%' ";
        sql = sql + where;
        if(StringUtils.isNotBlank(swDjQsQuery.getIds())){
            String ids = swDjQsQuery.getIds();
            String[] idsArr = ids.split(",");
            String idsWhere = CommonUtil.getOracleSQLIn(Arrays.asList(idsArr),500,"t3.xm_id");
            sql = sql + "and "+idsWhere;
        }
        if(isOrderBy){
            //sql = sql + "order by t3.xm_id desc ";
        }
        return sql;
    }

    private String getYbjSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = sql + " and t2.blzt='1' ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQrrkSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSwryxfSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHczzxfSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQxxfSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSjxfSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = "select count(*) from ("+sql+")t1 "+
                "left join (select * from pf_activity t where t.activity_state='1')t2 on t2.workflow_instance_id=t1.rw_id " +
                "where t2.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId"))+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getWxfSql(String[] configArr,Integer flag,Boolean isSgy,String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,List activityList) {
        String sql = getHcjdDetailZdhcSql(xzqdm,configArr,flag,isSgy,jdlx,sSjGtbd,false);
        sql = sql + " and t2.blzt is null ";
        sql = "select count(*) from ("+sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }




    private String getHcjdDetailZdhcSql(String xzqdm,String[] configArr,Integer flag,Boolean isSgy,String jdlx,GtSwTzQuery sSjGtbd,Boolean isOrderBy){

        String sql = "";
        if(isSgy){
            sql = "select to_char(t4.djh)djh,t4.scmj,to_char(t4.tdytmc)tdytmc,to_char(t4.tdzl)tdzl,to_char(t4.qlrmc)qlrmc,t3.gtbd_id,t2.rw_id from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t  " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id  " +
                    "join " +
                    "(" +
                    "select * from( " +
                    "select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from  " +
                    "( " +
                    "select user_id,activity_id,begin_time from pf_assignmenthistory t1  " +
                    "union all " +
                    "select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2  " +
                    ")t) where pm=1 "+
                    ")"+
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "left join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "where t6.xmlx='"+Hcxmlx.ZDHC.toString()+"' and t5.user_id='"+xzqdm+"'and t2.activity_state in('1','2') and t2.activity_definition_id='"+configArr[flag]+"' ";
                    if(Jdlx.YCL.toString().equals(jdlx)){
                        sql = sql + " and t.blzt='1' ";
                    }else if(Jdlx.WCL.toString().equals(jdlx)){
                        sql = sql + " and t.blzt='0' ";
                    }
                    sql = sql +")t1  " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join s_sj_gtbd t3 on t3.gtbd_id=t2.bd_id " +
                    "join zd t4 on t4.djh=t3.djh ";
        }else{
            sql = "select to_char(t4.djh)djh,t4.scmj,to_char(t4.tdytmc)tdytmc,to_char(t4.tdzl)tdzl,to_char(t4.qlrmc)qlrmc,t3.gtbd_id,t2.rw_id from " +
                    "( " +
                    "select distinct t.rw_id from sw_hc_xm_rw_rel t " +
                    "join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "join " +
                    "( " +
                    "     select * from(select t.*,rank() over(partition by t.activity_id order by t.begin_time desc)as pm from " +
                    "     ( " +
                    "            select user_id,activity_id,begin_time from pf_assignmenthistory t1 " +
                    "            union all " +
                    "            select t2.user_id,t2.activity_id,begin_time from  pf_assignment t2 " +
                    "      )t) where pm=1 " +
                    ") " +
                    "t5 on t5.activity_id=t2.activity_id  " +
                    "join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                    "join pf_organ t8 on t8.organ_id=t7.organ_id " +
                    "where t6.xmlx='"+Hcxmlx.ZDHC.toString()+"'and substr(t8.region_code,1,"+xzqdm.length()+")='"+xzqdm+"' and t2.activity_state in('1','2','3') and t2.activity_definition_id='"+configArr[flag]+"' ";
                    if(Jdlx.YCL.toString().equals(jdlx)){
                        sql = sql + " and t.blzt='1' ";
                    }else if(Jdlx.WCL.toString().equals(jdlx)){
                        sql = sql + " and t.blzt='0' ";
                    }
                    sql = sql + ")t1 " +
                    "join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "join s_sj_gtbd t3 on t3.gtbd_id=t2.bd_id " +
                    "join zd t4 on t4.djh=t3.djh ";
        }
        sql = sql + " where 1=1 ";
        sql = addHcjdDetailZdhcSqlWhere(sql,sSjGtbd,isOrderBy);
        return sql;
    }
    private String addHcjdDetailZdhcSqlWhere(String sql,GtSwTzQuery sSjGtbd,Boolean isOrderBy){
        if(StringUtils.isNotBlank(sSjGtbd.getDjh())){
            sql = sql + " and t3.djh like '%"+sSjGtbd.getDjh()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getQlrmc())){
            sql = sql + " and t4.qlrmc like '%"+sSjGtbd.getQlrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getTdytDm())){
            sql = sql + " and t4.tdyt = '"+sSjGtbd.getTdytDm()+"' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getTdzl())){
            sql = sql + " and t4.tdzl like '%"+sSjGtbd.getTdzl()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getIds())){
            String ids = sSjGtbd.getIds();
            String[] idsArr = ids.split(",");
            String idsWhere = CommonUtil.getOracleSQLIn(Arrays.asList(idsArr),500,"t3.gtbd_id");
            sql = sql + "and "+idsWhere;
        }
        if(isOrderBy){
            //sql = sql + " order by t3.djh desc ";
        }

        return sql;
    }

    @Override
    @Transactional
    public void saveSwDjHisZdYdqc(SwDjSy swDjSy,String proId,String userId,String czlx) {
        //保存his值
        SwDjSyHis swDjSyHis = swdjSyHisService.setSwDjSyHisBySwDjSy( swDjSy, proId, userId, czlx);
        baseRepository.save(swDjSyHis);
        //保存temp值
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String tdId="";
        String fcId="";
        if(swDjSy.getSwDjTd()!=null){
            tdId = swDjSy.getSwDjTd().getTdId();
        }
        if(swDjSy.getSwDjFc()!=null){
            fcId = swDjSy.getSwDjFc().getFcId();
        }
        SwDjSyQuery swDjSyQuery = taxService.getSwDjSyById(tdId,fcId);
        BeanUtils.copyProperties(swDjSyQuery, swDjSyTemp);
        swDjSyTemp.setProid(UUIDGenerator.generate());
        swDjSyTemp.setSyId(swDjSyHis.getSwDjSy().getSyId());
        swDjSyTemp.setRwid(proId);

        baseRepository.save(swDjSyTemp);
    }

    @Override
    @Transactional
    public void createSbydqcHcxm(SwHcXm swHcXm, String[] ydqcIdArr,String szdm) {
        String wwid = "";
        String proName = "";
        String glbm = "";
        if(Szdm.CZTDSYS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("tdsbydqc");
            proName="土地税申报疑点:";
        }else if(Szdm.FCS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("fcsbydqc");
            proName="房产税申报疑点:";
        }

        baseRepository.save(swHcXm);
        //创建核查任务的工作流项目
        for(int i=0;i<ydqcIdArr.length;i++){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            project.setWdid(wwid);

            if(Szdm.CZTDSYS.toString().equals(szdm)){
                SSjSbydqcTd sSjSbydqcTd = baseRepository.get(SSjSbydqcTd.class,ydqcIdArr[i]);
                proName="土地税申报疑点,管理代码:"+sSjSbydqcTd.getGlbm();
            }else if(Szdm.FCS.toString().equals(szdm)){
                SSjSbydqcFc sSjSbydqcFc = baseRepository.get(SSjSbydqcFc.class,ydqcIdArr[i]);
                proName="房产税申报疑点,管理代码:"+sSjSbydqcFc.getGlbm();
            }

            platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),proName);

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(ydqcIdArr[i]);
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);

            //ydqcrel中插入该宗地记录，并设置relid=djh，设置blzt=‘0’
            YdqcRel ydqcRel = new YdqcRel();
            ydqcRel.setId(UUIDGenerator.generate());
            ydqcRel.setBlzt("0");
            ydqcRel.setRelId(ydqcIdArr[i]);
            baseRepository.save(ydqcRel);


            //把该管理代码的所有税源列表插入税源历史表
            String jpql = "";
            if(szdm.equals(Szdm.CZTDSYS.toString())){
                SSjSbydqcTd sSjSbydqcTd = baseRepository.get(SSjSbydqcTd.class,ydqcIdArr[i]);
                sSjSbydqcTd.setRwid(wiid);
                baseRepository.update(sSjSbydqcTd);
                glbm = sSjSbydqcTd.getGlbm();
                jpql = "from SwDjSy o where o.swDjTd.swDjJbb.glbm =?0 ";
            }else if(szdm.equals(Szdm.FCS.toString())){
                SSjSbydqcFc sSjSbydqcFc = baseRepository.get(SSjSbydqcFc.class,ydqcIdArr[i]);
                sSjSbydqcFc.setRwid(wiid);
                baseRepository.update(sSjSbydqcFc);
                glbm = sSjSbydqcFc.getGlbm();
                jpql = "from SwDjSy o where o.swDjFc.swDjJbb.glbm =?0 ";

            }

            List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,glbm);
            String userId = SessionUtil.getCurrentUserId();
            for(SwDjSy swDjSy : swdjSyList){
                //插入历史表,同时插入一条数据进入临时表
                saveSwDjHisZdYdqc(swDjSy, wiid, userId, Czlx.UPDATE.toString());
            }

        }
    }

    @Override
    @Transactional
    public void createZsydqcHcxm(SwHcXm swHcXm, String[] ydqcIdArr, String szdm) throws Exception{
        String wwid = "";
        String proName = "";
        String glbm = "";
        if(Szdm.CZTDSYS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("tdzsydqc");
            proName="土地税征收疑点:";
        }else if(Szdm.FCS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("fczsydqc");
            proName="房产税征收疑点:";
        }

        baseRepository.save(swHcXm);
        //创建核查任务的工作流项目
        for(int i=0;i<ydqcIdArr.length;i++){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            project.setWdid(wwid);

            String zgkgDm = "";
            if(Szdm.CZTDSYS.toString().equals(szdm)){
                SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcIdArr[i]);
                zgkgDm = sSjZsydqcTd.getSwDjJbb().getZgkgDm();
                proName="土地税征收疑点,管理代码:"+sSjZsydqcTd.getGlbm();
            }else if(Szdm.FCS.toString().equals(szdm)){
                SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcIdArr[i]);
                zgkgDm = sSjZsydqcFc.getSwDjJbb().getZgkgDm();
                proName="房产税征收疑点,管理代码:"+sSjZsydqcFc.getGlbm();
            }

            platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),proName);

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(ydqcIdArr[i]);
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);

            //把该管理代码的所有税源列表插入税源历史表
            String jpql = "";
            if(szdm.equals(Szdm.CZTDSYS.toString())){
                SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcIdArr[i]);
                sSjZsydqcTd.setRwid(wiid);
                baseRepository.update(sSjZsydqcTd);
                glbm = sSjZsydqcTd.getGlbm();
                jpql = "from SwDjSy o where o.swDjTd.swDjJbb.glbm =?0 and syzt='1' ";
            }else if(szdm.equals(Szdm.FCS.toString())){
                SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcIdArr[i]);
                sSjZsydqcFc.setRwid(wiid);
                baseRepository.update(sSjZsydqcFc);
                glbm = sSjZsydqcFc.getGlbm();
                jpql = "from SwDjSy o where o.swDjFc.swDjJbb.glbm =?0 and syzt='1' ";

            }

            List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,glbm);
            String userId = SessionUtil.getCurrentUserId();
            for(SwDjSy swDjSy : swdjSyList){
                //插入历史表,同时插入一条数据进入临时表
                saveSwDjHisZdYdqc(swDjSy, wiid, userId, Czlx.UPDATE.toString());
            }

            //自动转发到区县
            PerformerTaskModel result=getTurnUserList(userId,wiid);
            List<PfUserVo> toUserList = result.getUserList();
            String toUserId = "";
            //根据djh过滤区县转发人
            if(CollectionUtils.isNotEmpty(toUserList)){
                for(PfUserVo pfUserVo : toUserList){
                    String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                    if(regionCode.length()>6){
                        regionCode = regionCode.substring(0,6);
                    }

                    String sgqdm = zgkgDm.substring(1, 7);
                    if(sgqdm.startsWith(regionCode)){
                        toUserId = pfUserVo.getUserId();
                        break;
                    }
                }
            }

            //实现工作流转发
            if(StringUtils.isNotBlank(toUserId)){
                //任务自动转发
                String taskid = PlatUtil.getTaskIdByProid(wiid);
                String turnXml = initTurnTaskXml(wiid,toUserId,taskid);
                Document doc = DocumentHelper.parseText(turnXml);
                workFlowService.turnTask(doc,taskid);

                //转发给组长
                PerformerTaskModel resultZz=getTurnUserList(toUserId,wiid);
                List<PfUserVo> toUserListZz = resultZz.getUserList();
                String toUserIdZz = "";

                //根据sgqdm过滤区县转发人
                if(CollectionUtils.isNotEmpty(toUserListZz)){
                    for(PfUserVo pfUserVo : toUserListZz){
                        for (PfOrganVo pfOrganVo : sysUserService.getOrganListByUser(pfUserVo.getUserId())) {
                            String regionCode = pfOrganVo.getRegionCode();
                            String sgqdm = zgkgDm.substring(1, 9);
                            if (sgqdm.equals(regionCode)) {
                                toUserIdZz = pfUserVo.getUserId();
                                break;
                            }
                        }
                    }
                }
                //实现工作流转发
                if(StringUtils.isNotBlank(toUserIdZz)){
                    //任务自动转发
                    String taskidZz = PlatUtil.getTaskIdByProid(wiid);
                    String turnXmlZz = initTurnTaskXml(wiid,toUserIdZz,taskidZz);
                    //System.out.println(turnXml);
                    Document docZz = DocumentHelper.parseText(turnXmlZz);
                    workFlowService.turnTask(docZz,taskidZz);
                }
            }
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwHcXm> findAllHcxm(HcxmQuery hcxmQuery, Pageable request) {
        String userId = SessionUtil.getCurrentUserId();
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        query.from(qSwHcXm).where(qSwHcXm.cjrId.eq(userId));
        if(StringUtils.isNotBlank(hcxmQuery.getXmlx())){
            query.where(qSwHcXm.xmlx.eq(hcxmQuery.getXmlx()));
        }
        return baseRepository.find(query,qSwHcXm,request);
    }



    private StringBuffer setQx(StringBuffer result,BigDecimal qxzs,SwHcXm swHcXm){
        String hcxmId = swHcXm.getXmId();
        String hcxmLx = swHcXm.getXmlx();
        StringBuffer sql = new StringBuffer()
                .append("select nvl(t1.region_code,t2.region_code)region_code,nvl(t1.whcs,0)whcs,nvl(t2.yhcs,0)yhcs,nvl(t1.organ_name,t2.organ_name)region_name,(nvl(t1.whcs,0)+nvl(t2.yhcs,0))hczs from ")
                .append("( ")
                .append("select t1.region_code,t1.whcs,t2.organ_name from ")
                .append("( ")
                .append("select t.region_code,count(*)as whcs from ")
                .append("( ")
                .append("select t1.*,t2.* from ")
                .append("( ")
                .append("select t2.rwid from ")
                .append("(select t.*  from ydqc_rel t left join sw_hc_xm_rw_rel t3 on t3.bd_id=t.rel_id left join sw_hc_xm t4 on t3.hcxm_id=t4.id where  t4.id='").append(hcxmId).append("' and t.rel_id is not null and t.blzt='0')t1 ");
        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_td t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.tdsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_fc t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.fcsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_td t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.tdzsyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_fc t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.fczsyd_id ");
        }
        sql.append(")t1 ")
                .append("join  ")
                .append("( ")
                .append("select t1.workflow_instance_id,t1.activity_definition_id,t1.user_id,t3.organ_id,t4.organ_name,substr(t4.region_code,1,6)region_code from ")
                .append("( ")
                .append("select  * from( ")
                .append("select distinct t.workflow_instance_id,t.activity_definition_id,nvl(t2.user_id,t5.user_id)as user_id,t.activity_state from pf_activity t ")
                .append("left join pf_assignmenthistory t2 on t.activity_id=t2.activity_id ")
                .append("left join pf_assignment t5 on t.activity_id=t5.activity_id ")
                .append(") ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql .append("where activity_definition_id='").append(tdsbqx).append("' and activity_state in('1','2') ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql .append("where activity_definition_id='").append(fcsbqx).append("' and activity_state in('1','2') ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql .append("where activity_definition_id='").append(tdzsqx).append("' and activity_state in('1','2') ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql .append("where activity_definition_id='").append(fczsqx).append("' and activity_state in('1','2') ");
        }

        sql.append(")t1 ")
                .append("left join pf_user_organ_rel t3 on t3.user_id=t1.user_id ")
                .append("left join pf_organ t4 on t4.organ_id=t3.organ_id ")
                .append(")t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ")
                .append(")t ")
                .append("group by region_code ")
                .append(")t1 ")
                .append("left join pf_organ t2 on t1.region_code=t2.region_code ")
                .append(")t1 ")
                .append("full outer  join ")
                .append("( ")
                .append("select t.region_code,t.yhcs,t2.organ_name from ")
                .append("( ")
                .append("select t.region_code,count(*)as yhcs from ")
                .append("( ")
                .append("select t1.*,t2.* from ")
                .append("( ")
                .append("select t2.rwid from ")
                .append("(select t.*  from ydqc_rel t left join sw_hc_xm_rw_rel t3 on t3.bd_id=t.rel_id left join sw_hc_xm t4 on t3.hcxm_id=t4.id  where t4.id='").append(hcxmId).append("' and t.rel_id is not null and t.blzt='1')t1  ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql .append("join (select t.* from s_sj_sbydqc_td t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.tdsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql .append("join (select t.* from s_sj_sbydqc_fc t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.fcsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql .append("join (select t.* from s_sj_zsydqc_td t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.tdzsyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql .append("join (select t.* from s_sj_zsydqc_fc t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.fczsyd_id ");
        }
        sql.append(")t1 ")
                .append("left join  ")
                .append("( ")
                .append("select  * from( ")
                .append("select distinct t.workflow_instance_id,t.activity_definition_id,t2.user_id,substr(t4.region_code,1,6)region_code,t4.organ_name from pf_activity t ")
                .append("left join pf_assignmenthistory t2 on t.activity_id=t2.activity_id ")
                .append("left join pf_user_organ_rel t3 on t3.user_id=t2.user_id ")
                .append("left join pf_organ t4 on t4.organ_id=t3.organ_id ")
                .append(") ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdsbqx).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fcsbqx).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdzsqx).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fczsqx).append("' ");
        }

        sql.append(")t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ")
                .append(")t ")
                .append("group by region_code ")
                .append(")t ")
                .append("left join pf_organ t2 on t.region_code=t2.region_code ")
                .append(")t2 ")
                .append("on t1.region_code=t2.region_code ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            result.append(",");
            result.append("\"children\":");
            result.append("[");
            BigDecimal tjqxzs = new BigDecimal(0);
            for(int i=0;i<list.size();i++){
                HashMap tempMap = list.get(i);
                BigDecimal hczs = new BigDecimal(String.valueOf(tempMap.get("HCZS")));
                BigDecimal whcx = new BigDecimal(String.valueOf(tempMap.get("WHCS")));
                BigDecimal yhcs = new BigDecimal(String.valueOf(tempMap.get("YHCS")));
                String name = String.valueOf(tempMap.get("REGION_NAME"));
                String regionCode = String.valueOf(tempMap.get("REGION_CODE"));
                BigDecimal hcjd = yhcs.divide(hczs, 4, BigDecimal.ROUND_HALF_UP);
                hcjd =  hcjd.multiply(new BigDecimal(100));
                tjqxzs = tjqxzs.add(hczs);
                result.append("{");
                result.append("\"name\":\""+name+"\",");
                result.append("\"hczs\":\""+hczs+"\",");
                result.append("\"yhcs\":\""+yhcs+"\",");
                result.append("\"whcs\":\""+whcx+"\",");
                result.append("\"hcjd\":\""+hcjd+"\"");
                setSwjg(result,hczs,regionCode,swHcXm);
                result.append("}");
                if(i!=list.size()-1){
                    result.append(",");
                }
            }
            if(qxzs.compareTo(tjqxzs)>0){
                BigDecimal wxfHczs = qxzs.subtract(tjqxzs);
                result.append(",");
                result.append("{");
                result.append("\"name\":\"未下发数\",");
                result.append("\"hczs\":\""+wxfHczs+"\",");
                result.append("\"yhcs\":\""+0+"\",");
                result.append("\"whcs\":\""+wxfHczs+"\",");
                result.append("\"hcjd\":\"0.0000\"");
                result.append("}");
            }

            result.append("]");
        }
        return result;
    }

    private StringBuffer setSwjg(StringBuffer result,BigDecimal swjgzs,String regionCode,SwHcXm swHcxm){
        String hcxmId = swHcxm.getXmId();
        String hcxmLx = swHcxm.getXmlx();

        StringBuffer sql = new StringBuffer()
                .append("select nvl(t1.region_code,t2.region_code)region_code,nvl(t1.whcs,0)whcs,nvl(t2.yhcs,0)yhcs,nvl(t1.organ_name,t2.organ_name)region_name,(nvl(t1.whcs,0)+nvl(t2.yhcs,0))hczs from ")
                .append("( ")
                .append("select t1.region_code,t1.whcs,t2.organ_name from ")
                .append("( ")
                .append("select t.region_code,count(*)as whcs from ")
                .append("( ")
                .append("select t1.*,t2.* from ")
                .append("( ")
                .append("select t2.rwid from ")
                .append("(select t.*  from ydqc_rel t left join sw_hc_xm_rw_rel t3 on t3.bd_id=t.rel_id left join sw_hc_xm t4 on t3.hcxm_id=t4.id  where t4.id='").append(hcxmId).append("' and t.rel_id is not null and t.blzt='0')t1 ");
        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_td t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.tdsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_fc t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.fcsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_td t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.tdzsyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_fc t where t.rwid is not null  ) t2 ")
                    .append("on t1.rel_id = t2.fczsyd_id ");
        }

        sql.append(")t1 ")
                .append("join  ")
                .append("( ")
                .append("select t1.workflow_instance_id,t1.activity_definition_id,t1.user_id,t3.organ_id,t4.organ_name,substr(t4.region_code,1,8)region_code from ")
                .append("( ")
                .append("select  * from( ")
                .append("select distinct t.workflow_instance_id,t.activity_definition_id,nvl(t5.user_id,t2.user_id)as user_id,t.activity_state  from pf_activity t ")
                .append("left join pf_assignmenthistory t2 on t.activity_id=t2.activity_id ")
                .append("left join pf_assignment t5 on t.activity_id=t5.activity_id ")
                .append(") ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdsbswjg).append("'  and activity_state in('1','2')");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fcsbswjg).append("'  and activity_state in('1','2')");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdzsswjg).append("'  and activity_state in('1','2')");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fczsswjg).append("'  and activity_state in('1','2')");
        }


        sql.append(")t1 ")
                .append("left join pf_user_organ_rel t3 on t3.user_id=t1.user_id ")
                .append("left join pf_organ t4 on t4.organ_id=t3.organ_id ")
                .append(")t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ")
                .append(")t ")
                .append("group by region_code having region_code like '").append(regionCode).append("%' ")
                .append(")t1 ")
                .append("left join pf_organ t2 on t1.region_code=t2.region_code ")
                .append(")t1 ")
                .append("full outer  join ")
                .append("( ")
                .append("select t.region_code,t.yhcs,t2.organ_name from ")
                .append("( ")
                .append("select t.region_code,count(*)as yhcs from ")
                .append("( ")
                .append("select t1.*,t2.* from ")
                .append("( ")
                .append("select t2.rwid from ")
                .append("(select t.*  from ydqc_rel t left join sw_hc_xm_rw_rel t3 on t3.bd_id=t.rel_id left join sw_hc_xm t4 on t3.hcxm_id=t4.id where t4.id='").append(hcxmId).append("' and t.rel_id is not null and t.blzt='1')t1  ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_td t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.tdsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("join (select t.* from s_sj_sbydqc_fc t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.fcsbyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_td t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.tdzsyd_id ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("join (select t.* from s_sj_zsydqc_fc t where t.rwid is not null  ) t2  ")
                    .append("on t1.rel_id = t2.fczsyd_id ");
        }


        sql.append(")t1 ")
                .append("left join  ")
                .append("( ")
                .append("select  * from( ")
                .append("select distinct t.workflow_instance_id,t.activity_definition_id,t2.user_id,substr(t4.region_code,1,8)region_code,t4.organ_name from pf_activity t ")
                .append("left join pf_assignmenthistory t2 on t.activity_id=t2.activity_id ")
                .append("left join pf_user_organ_rel t3 on t3.user_id=t2.user_id ")
                .append("left join pf_organ t4 on t4.organ_id=t3.organ_id ")
                .append(") ");

        if(hcxmLx.equals(Hcxmlx.TDSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdsbswjg).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.FCSBJSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fcsbswjg).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.TDZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(tdzsswjg).append("' ");
        }else if(hcxmLx.equals(Hcxmlx.FCZSYDQC.toString())){
            sql.append("where activity_definition_id='").append(fczsswjg).append("' ");
        }



        sql.append(")t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ")
                .append(")t ")
                .append("group by region_code having region_code like '").append(regionCode).append("%' ")
                .append(")t ")
                .append("left join pf_organ t2 on t.region_code=t2.region_code ")
                .append(")t2 ")
                .append("on t1.region_code=t2.region_code ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            result.append(",");
            result.append("\"children\":");
            result.append("[");
            BigDecimal tjswjgzs = new BigDecimal(0);
            for(int i=0;i<list.size();i++){
                HashMap tempMap = list.get(i);
                BigDecimal hczs = new BigDecimal(String.valueOf(tempMap.get("HCZS")));
                BigDecimal whcx = new BigDecimal(String.valueOf(tempMap.get("WHCS")));
                BigDecimal yhcs = new BigDecimal(String.valueOf(tempMap.get("YHCS")));
                String name = String.valueOf(tempMap.get("REGION_NAME"));
                BigDecimal hcjd = yhcs.divide(hczs, 4, BigDecimal.ROUND_HALF_UP);
                hcjd =  hcjd.multiply(new BigDecimal(100));
                tjswjgzs = tjswjgzs.add(hczs);
                result.append("{");
                result.append("\"name\":\""+name+"\",");
                result.append("\"hczs\":\""+hczs+"\",");
                result.append("\"yhcs\":\""+yhcs+"\",");
                result.append("\"whcs\":\""+whcx+"\",");
                result.append("\"hcjd\":\""+hcjd+"\"");
                result.append("}");
                if(i!=list.size()-1){
                    result.append(",");
                }
            }
            if(swjgzs.compareTo(tjswjgzs)>0){
                BigDecimal wxfHczs = swjgzs.subtract(tjswjgzs);
                result.append(",");
                result.append("{");
                result.append("\"name\":\"未下发数\",");
                result.append("\"hczs\":\""+wxfHczs+"\",");
                result.append("\"yhcs\":\""+0+"\",");
                result.append("\"whcs\":\""+wxfHczs+"\",");
                result.append("\"hcjd\":\"0.0000\"");
                result.append("}");
            }

            result.append("]");
        }

        return result;
    }

    /*
    @Override
    @Transactional
    public void createZsTdydqcHcxm(SwHcXm swHcXm, String[] glbmArr, String szdm, String beginDate, String endDate, String jdlx) throws  Exception{
        String wwid = "";
        String proName = "";
        String qclx = "";
        if(Szdm.CZTDSYS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("tdzsydqc");
            proName="土地税征收疑点:";
            qclx = Qclx.TDSZS.toString();
        }else if(Szdm.FCS.toString().equals(szdm)){
            wwid = AppConfig.getProperty("fczsydqc");
            proName="房产税征收疑点:";
            qclx = Qclx.FCSZS.toString();
        }
        baseRepository.save(swHcXm);
        //创建核查任务的工作流项目
        for(int i=0;i<glbmArr.length;i++){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            project.setWdid(wwid);

            platUtil.createWorkFlowInstance(project, SessionUtil.getCurrentUserId(),proName+glbmArr[i]);

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(glbmArr[i]);
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);

            //ydqcrel
            YdqcRel ydqcRel = new YdqcRel();
            ydqcRel.setId(UUIDGenerator.generate());
            ydqcRel.setBlzt("0");
            ydqcRel.setGlbm(glbmArr[i]);
            ydqcRel.setQclx(qclx);
            ydqcRel.setBeginDate(new SimpleDateFormat("yyyy-MM-dd").parse(beginDate));
            ydqcRel.setEndDate(new SimpleDateFormat("yyyy-MM-dd").parse(endDate));
            ydqcRel.setJdlx(jdlx);
            baseRepository.save(ydqcRel);


            //把该管理代码的所有税源列表插入税源历史表
            String jpql = "from SwDjSy o where o.swDjTd.swDjJbb.glbm =?0 ";
            List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,glbmArr[i]);
            String userId = SessionUtil.getCurrentUserId();

            for(SwDjSy swDjSy : swdjSyList){
                //插入历史表,同时插入一条数据进入临时表
                saveSwDjHisZdYdqc(swDjSy, wiid, userId, Czlx.UPDATE.toString());
            }

        }
    }
    */

    @Override
    @Transactional(readOnly = true)
    public Page findYxfxmlb(HcxmQuery hcxmQuery, Pageable pageable) {
        StringBuilder whereClause = new StringBuilder("");
        String userId = SessionUtil.getCurrentUserId();
        if(StringUtils.isNotBlank(hcxmQuery.getXmlx())){
            whereClause.append("where t.xmlx ='"+hcxmQuery.getXmlx()+"' ");
        }else
            whereClause.append("where t.xmlx is not null ");
        if(!userId.equals("0")){
            whereClause.append(" and t2.USER_ID = '"+userId+"' ");
        }
        if(StringUtils.isNotBlank(hcxmQuery.getMc())){
            whereClause.append("and t.mc like '%").append(hcxmQuery.getMc()).append("%' ");
        }
        if(hcxmQuery.getCjrqBegion()!=null){
            whereClause.append("and to_date(to_char(t.cjrq,'yyyy-mm-dd'),'yyyy-mm-dd' )>=to_date('").append(new SimpleDateFormat("yyyy-MM-dd").format(hcxmQuery.getCjrqBegion())).append("','yyyy-mm-dd') ");
        }
        if(hcxmQuery.getCjrqEnd()!=null){
            whereClause.append("and to_date(to_char(t.cjrq,'yyyy-mm-dd'),'yyyy-mm-dd' )<=to_date('").append(new SimpleDateFormat("yyyy-MM-dd").format(hcxmQuery.getCjrqEnd())).append("','yyyy-mm-dd') ");
        }


        Query query = baseRepository.getEntityManager().createNativeQuery("select distinct id,t.mc,t.cjr_id,t.xmlx,t.cjrq,t.xmybj,t2.create_username from sw_hc_xm t " +
                "left join sw_hc_xm_rw_rel t1 on t.id = t1.hcxm_id " +
                "left join pf_taskoverlist t2 on t1.rw_id=t2.WORKFLOW_INSTANCE_ID " +
                whereClause);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery("select count(distinct id) from sw_hc_xm t " +
                "left join sw_hc_xm_rw_rel t1 on t.id = t1.hcxm_id " +
                "left join pf_taskoverlist t2 on t1.rw_id=t2.WORKFLOW_INSTANCE_ID " +
                whereClause);
        return baseRepository.find(query, countQuery, pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public String getHcjd(String hcxmlx, String regionCode, String ssnf, String sssq) {
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);

        UserInfo user = SessionUtil.getCurrentUser();
        regionCode = user.getRegionCode();

        String table = "S_SJ_ZSYDQC_TD";
        String idField = "TDZSYD_ID";
        if (Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "S_SJ_ZSYDQC_FC";
            idField = "FCZSYD_ID";
        }

        String dwSql = "SELECT DWDM, DWMC, DWJB, PDM, ROWNUM AS XH, DXF " +
                "FROM ( " +
                "        SELECT REGION_CODE AS DWDM, ORGAN_NAME as DWMC, ORGAN_NO AS XH, " +
                "               DECODE(LENGTH(REGION_CODE), 4, '', SUBSTR(REGION_CODE, 1, LENGTH(REGION_CODE)-2)) AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 0, 6, 1, 8, 2) AS DWJB, 0 AS DXF " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK IS NULL " +
                "        UNION ALL " +
                "        SELECT REGION_CODE AS DWDM, DECODE(LENGTH(REGION_CODE), 4, '市局待下发', 6, '区县待下发', 8, '分局待下发') as DWMC, " +
                "               DECODE(LENGTH(REGION_CODE), 8, '2', NULL) AS XH, REGION_CODE AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 1, 6, 2, 8, 3) AS DWJB, 1 AS DXF " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK IS NULL " +
                "        UNION ALL " +
                "        SELECT t1.USER_ID AS DWDM, t1.USER_NAME AS DWMC, '1' AS XH, t3.REGION_CODE AS PDM, 3 AS DWJB, 0 AS DXF " +
                "        FROM PF_USER t1 " +
                "             LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                "             LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                "        WHERE t3.REMARK IS NULL AND LENGTH(t3.REGION_CODE)=8 " +
                "        ORDER BY DWJB, XH " +
                "     ) t " +
                "START WITH DXF=0 AND DWDM='" + regionCode + "' " +
                "CONNECT BY (PDM=PRIOR DWDM AND DWJB - 1 = PRIOR DWJB) " +
                "ORDER SIBLINGS BY t.XH";
        String rwSql = "SELECT * " +
                "FROM (SELECT SUM(t1.ZS) AS ZS, SUM(t1.YCL) as YCL, SUM(t1.ZS - t1.YCL) as WCL, t2.DWDM, t2.DXF " +
                "      FROM ( " +
                "              SELECT DISTINCT t.RW_ID, 1 AS ZS, DECODE(t1.WORKFLOW_STATE, '2', 1, 0) AS YCL " +
                "              FROM SW_HC_XM_RW_REL t " +
                "              JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID=t1.WORKFLOW_INSTANCE_ID " +
                "              JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID=t2.WORKFLOW_INSTANCE_ID " +
                "              JOIN SW_HC_XM t3 ON t.HCXM_ID=t3.ID " +
                "              JOIN " + table + " zs ON t.BD_ID=zs." + idField + " " +
                "              WHERE t3.XMLX='" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1', '2', '3' ) " +
                "                     AND zs.SSNF='" + ssnf + "' AND zs.SSSQ='" + sssq + "'" +
                "            ) t1 " +
                "            JOIN " +
                "            ( " +
                "              SELECT DISTINCT t2.WORKFLOW_INSTANCE_ID, " +
                "                     DECODE(t2.ACTIVITY_DEFINITION_ID, " +
                "                            '" + configArr[0] + "', SUBSTR(t5.REGION_CODE, 1, 4), " +
                "                            '" + configArr[1] + "', SUBSTR(t5.REGION_CODE, 1, 6), " +
                "                            '" + configArr[2] + "', SUBSTR(t5.REGION_CODE, 1, 8), " +
                "                            '" + configArr[3] + "', t3.USER_ID " +
                "                           ) AS DWDM, " +
                "                     DECODE(t2.ACTIVITY_DEFINITION_ID, " +
                "                            '" + configArr[0] + "', DECODE(ISXF, 1, 0, 1), " +
                "                            '" + configArr[1] + "', DECODE(ISXF, 1, 0, 1), " +
                "                            '" + configArr[2] + "', DECODE(ISXF, 1, 0, 1), " +
                "                            '" + configArr[3] + "', 0 " +
                "                           ) AS DXF " +
                "              FROM ( " +
                "                      SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "                      FROM ( " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 1 AS ISXF " +
                "                              FROM PF_ASSIGNMENTHISTORY " +
                "                              UNION ALL " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 1 AS ISXF " +
                "                              FROM PF_ASSIGNMENT " +
                "                            ) t " +
                "                      UNION " +
                "                      SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "                      FROM ( " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 0 AS ISXF " +
                "                              FROM PF_ASSIGNMENT " +
                "                            ) t " +
                "                    ) t1 " +
                "                    LEFT JOIN PF_ACTIVITY t2 ON t1.ACTIVITY_ID=t2.ACTIVITY_ID " +
                "                    LEFT JOIN PF_USER t3 ON t1.USER_ID=t3.USER_ID " +
                "                    LEFT JOIN PF_USER_ORGAN_REL t4 on t1.USER_ID=t4.USER_ID " +
                "                    LEFT JOIN PF_ORGAN t5 on t4.ORGAN_ID=t5.ORGAN_ID " +
                "                    WHERE t1.PM=1 AND t2.ACTIVITY_STATE IN ('1', '2', '3') " +
                "            ) t2 ON t1.RW_ID=t2.WORKFLOW_INSTANCE_ID " +
                "       GROUP BY t2.DWDM, t2.DXF " +
                "     )";
        String sql = "SELECT t1.DWDM, t1.DWMC, t1.DWJB, t1.DXF, NVL(t2.YCL,0) AS YCL, NVL(t2.WCL,0) AS WCL, NVL(t2.ZS,0) AS ZS, DECODE(NVL(t2.ZS,0), 0, 0, ROUND(NVL(t2.YCL,0)/NVL(t2.ZS,0)*100,3)) AS CLL " +
                "FROM (" + dwSql + ") t1 " +
                "     LEFT JOIN (" + rwSql + ") t2 ON (t2.DWDM = t1.DWDM AND t2.DXF=t1.DXF) " +
                "ORDER BY t1.XH";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return listToJson(list);
    }

    private String listToJson(List list) {
        StringBuffer listToJson = new StringBuffer();
        int firstDwjb = -1;
        int lastDwjb = -1;
        int curDwjb = -1;
        Boolean bFirst = true;
        for(int i=0; i<list.size(); i++){
            HashMap map = (HashMap)list.get(i);

            curDwjb = Integer.valueOf(String.valueOf(map.get("DWJB")));
            if (bFirst) {   // 开始
                bFirst = false;
                firstDwjb = curDwjb;
                lastDwjb = curDwjb;
                listToJson.append("[{");
            } else {
                if (firstDwjb == -1) {  // 记录第一个级别
                    firstDwjb = curDwjb;
                    listToJson.append("[{");
                }

                if (curDwjb < lastDwjb) { // 上一个单位级别结束
                    while (lastDwjb > curDwjb) {
                        listToJson.append("}]");
                        lastDwjb--;
                    }
                    listToJson.append(",");
                    listToJson.append("},{");
                } else if (curDwjb == lastDwjb) { // 继续当前单位级别
                    listToJson.append("},{");
                } else if (curDwjb > lastDwjb) { // 进入下一单位级别
                    listToJson.append(",");
                    listToJson.append("\"children\":[{");
                    lastDwjb = curDwjb;
                }
            }

            listToJson.append("\"name\":"+"\""+map.get("DWMC")+"\",");
            listToJson.append("\"zs\":"+"\""+map.get("ZS")+"\",");
            listToJson.append("\"ycl\":"+"\""+map.get("YCL")+"\",");
            listToJson.append("\"wcl\":"+"\""+map.get("WCL")+"\",");
            listToJson.append("\"cll\":"+"\""+map.get("CLL")+"\",");
            listToJson.append("\"xzqdm\":"+"\""+map.get("DWDM")+"\",");
            listToJson.append("\"dxf\":"+"\""+map.get("DXF")+"\"");
        }
        while (curDwjb >= firstDwjb) { //结束
            listToJson.append("}]");
            curDwjb--;
        }
        return listToJson.toString();
    }

    @Override
    @Transactional(readOnly = true)
    public String getCljd(String hcxmlx, String regionCode, String ssnf, String sssq) {
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);

        UserInfo user = SessionUtil.getCurrentUser();
        regionCode = user.getRegionCode();

        String table = "S_SJ_ZSYDQC_TD";
        String idField = "TDZSYD_ID";
        if (Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "S_SJ_ZSYDQC_FC";
            idField = "FCZSYD_ID";
        }

        String dwSql = "SELECT DWDM, DWMC, DWJB, PDM, ROWNUM AS XH " +
                "FROM ( " +
                "        SELECT REGION_CODE AS DWDM, ORGAN_NAME as DWMC, ORGAN_NO AS XH, " +
                "               DECODE(LENGTH(REGION_CODE), 4, '', SUBSTR(REGION_CODE, 1, LENGTH(REGION_CODE)-2)) AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 0, 6, 1, 8, 2) AS DWJB " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK IS NULL " +
                "        UNION ALL " +
                "        SELECT REGION_CODE||'9999' AS DWDM, DECODE(LENGTH(REGION_CODE), 4, '市局未下发', 6, '区县未下发', 8, '分局未下发') as DWMC, " +
                "               DECODE(LENGTH(REGION_CODE), 8, '2', NULL) AS XH, REGION_CODE AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 1, 6, 2, 8, 3) AS DWJB " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK IS NULL " +
                "        UNION ALL " +
                "        SELECT t1.USER_ID AS DWDM, t1.USER_NAME AS DWMC, '1' AS XH, t3.REGION_CODE AS PDM, 3 AS DWJB " +
                "        FROM PF_USER t1 " +
                "             LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                "             LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                "        WHERE t3.REMARK IS NULL AND LENGTH(t3.REGION_CODE)=8 " +
                "        ORDER BY DWJB, XH " +
                "     ) t " +
                "START WITH DWDM = '" + regionCode + "' " +
                "CONNECT BY PDM=PRIOR DWDM " +
                "ORDER SIBLINGS BY t.XH";
        String rwSql = "SELECT * " +
                "FROM (SELECT SUM(t1.ZS) AS ZS, SUM(t1.YHCS) as YHCS, SUM(t1.YSHFJZ) as YSHFJZ, t2.DWDM " +
                "      FROM ( " +
                "              SELECT DISTINCT t.RW_ID, 1 AS ZS, " +
                "                                MAX(DECODE(t2.ACTIVITY_STATE, '2', DECODE(t2.ACTIVITY_DEFINITION_ID, '" + configArr[3] + "', 1, 0))) AS YHCS, " +
                "                                MAX(DECODE(t2.ACTIVITY_STATE, '2', DECODE(t2.ACTIVITY_DEFINITION_ID, '" + configArr[4] + "', 1, 0))) AS YSHFJZ " +
                "              FROM SW_HC_XM_RW_REL t " +
                "              JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID=t1.WORKFLOW_INSTANCE_ID " +
                "              JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID=t2.WORKFLOW_INSTANCE_ID " +
                "              JOIN SW_HC_XM t3 ON t.HCXM_ID=t3.ID " +
                "              JOIN " + table + " zs ON t.BD_ID=zs." + idField + " " +
                "              WHERE t3.XMLX='" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1', '2', '3' ) " +
                "                     AND zs.SSNF='" + ssnf + "' AND zs.SSSQ='" + sssq + "'" +
                "              GROUP BY t.RW_ID " +
                "            ) t1 " +
                "            JOIN " +
                "            ( " +
                "              SELECT DISTINCT t2.WORKFLOW_INSTANCE_ID, " +
                "                     DECODE(t2.ACTIVITY_DEFINITION_ID, " +
                "                            '" + configArr[0] + "', SUBSTR(t5.REGION_CODE, 1, 4)||DECODE(ISXF, 1, '', '9999'), " +
                "                            '" + configArr[1] + "', SUBSTR(t5.REGION_CODE, 1, 6)||DECODE(ISXF, 1, '', '9999'), " +
                "                            '" + configArr[2] + "', SUBSTR(t5.REGION_CODE, 1, 8)||DECODE(ISXF, 1, '', '9999'), " +
                "                            '" + configArr[3] + "', t3.USER_ID " +
                "                           ) AS DWDM " +
                "              FROM ( " +
                "                      SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "                      FROM ( " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 1 AS ISXF " +
                "                              FROM PF_ASSIGNMENTHISTORY " +
                "                              UNION ALL " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 1 AS ISXF " +
                "                              FROM PF_ASSIGNMENT " +
                "                            ) t " +
                "                      UNION " +
                "                      SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "                      FROM ( " +
                "                              SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME, 0 AS ISXF " +
                "                              FROM PF_ASSIGNMENT " +
                "                            ) t " +
                "                    ) t1 " +
                "                    LEFT JOIN PF_ACTIVITY t2 ON t1.ACTIVITY_ID=t2.ACTIVITY_ID " +
                "                    LEFT JOIN PF_USER t3 ON t1.USER_ID=t3.USER_ID " +
                "                    LEFT JOIN PF_USER_ORGAN_REL t4 on t1.USER_ID=t4.USER_ID " +
                "                    LEFT JOIN PF_ORGAN t5 on t4.ORGAN_ID=t5.ORGAN_ID " +
                "                    WHERE t1.PM=1 AND t2.ACTIVITY_STATE IN ('1', '2', '3') " +
                "            ) t2 ON t1.RW_ID=t2.WORKFLOW_INSTANCE_ID " +
                "       GROUP BY t2.DWDM " +
                "     )";
        String sql = "SELECT t1.DWDM, t1.DWMC, t1.DWJB, NVL(t2.YHCS,0) AS YHCS, NVL(t2.YSHFJZ,0) AS YSHFJZ, NVL(t2.ZS,0) AS ZS, DECODE(NVL(t2.ZS,0), 0, 0, ROUND(NVL(t2.YSHFJZ,0)/NVL(t2.ZS,0)*100,2)) AS CLL " +
                "FROM (" + dwSql + ") t1 " +
                "     LEFT JOIN (" + rwSql + ") t2 ON t2.DWDM = t1.DWDM " +
                "ORDER BY t1.XH";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return listCljdToJson(list);
    }

    private String listCljdToJson(List list) {
        StringBuffer listToJson = new StringBuffer();
        int firstDwjb = -1;
        int lastDwjb = -1;
        int curDwjb = -1;
        Boolean bFirst = true;
        for(int i=0; i<list.size(); i++){
            HashMap map = (HashMap)list.get(i);

            curDwjb = Integer.valueOf(String.valueOf(map.get("DWJB")));
            if (bFirst) {   // 开始
                bFirst = false;
                firstDwjb = curDwjb;
                lastDwjb = curDwjb;
                listToJson.append("[{");
            } else {
                if (firstDwjb == -1) {  // 记录第一个级别
                    firstDwjb = curDwjb;
                    listToJson.append("[{");
                }

                if (curDwjb < lastDwjb) { // 上一个单位级别结束
                    while (lastDwjb > curDwjb) {
                        listToJson.append("}]");
                        lastDwjb--;
                    }
                    listToJson.append(",");
                    listToJson.append("},{");
                } else if (curDwjb == lastDwjb) { // 继续当前单位级别
                    listToJson.append("},{");
                } else if (curDwjb > lastDwjb) { // 进入下一单位级别
                    listToJson.append(",");
                    listToJson.append("\"children\":[{");
                    lastDwjb = curDwjb;
                }
            }

            listToJson.append("\"name\":"+"\""+map.get("DWMC")+"\",");
            listToJson.append("\"zs\":"+"\""+map.get("ZS")+"\",");
            listToJson.append("\"yhcs\":"+"\""+map.get("YHCS")+"\",");
            listToJson.append("\"yshfjz\":"+"\""+map.get("YSHFJZ")+"\",");
            listToJson.append("\"cll\":"+"\""+map.get("CLL")+"\"");
        }
        while (curDwjb >= firstDwjb) { //结束
            listToJson.append("}]");
            curDwjb--;
        }
        return listToJson.toString();
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getWclYclTzJson(Pageable pageable, String hcxmlx, String xzqdm, String xflx, String cllx, String ssnf, String sssq) {
        String qxCode, fjCode, sgyCode;
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);
        qxCode = configArr[1];
        fjCode = configArr[2];
        sgyCode = configArr[3];

        String cllxFilter = " 1=1 ";
        if ("0".equals(cllx)) {
            cllxFilter = " 1=1 ";
        } if ("1".equals(cllx)) {
            cllxFilter = " (t1.WORKFLOW_STATE IS NULL OR t1.WORKFLOW_STATE <> 2) ";
        } else if ("2".equals(cllx)) {
            cllxFilter = " t1.WORKFLOW_STATE=2 ";
        } else if ("3".equals(cllx)) {
            cllxFilter = " t2.ACTIVITY_STATE=2 AND t2.ACTIVITY_DEFINITION_ID=" + configArr[3] + " ";
        } else if ("4".equals(cllx)) {
            cllxFilter = " t.BLZT='1' ";
        }

        String table = "";
        String keyField = "";
        String selectField = "";
        if (Hcxmlx.TDZSYDQC.toString().equals(hcxmlx) || Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "(SELECT t1.*, t2.ZGKG_MC FROM S_SJ_ZSYDQC_TD t1 LEFT JOIN SW_DJ_JBB t2 ON t1.GLBM=t2.GLBM WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "')";
            keyField = "TDZSYD_ID";
            selectField = "t9.glbm,t9.nsrmc,t9.zgkg_mc,t9.yjse as nynse, t9.rkse, t9.cyje, decode(t9.yjse, null, null, round((yjse-nvl(rkse,0))/yjse*100, 2)) as cybl";
        } else if (Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "(SELECT t1.*, t2.ZGKG_MC FROM S_SJ_ZSYDQC_FC t1 LEFT JOIN SW_DJ_JBB t2 ON t1.GLBM=t2.GLBM WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "')";
            keyField = "FCZSYD_FC";
            selectField = "t9.glbm,t9.nsrmc,t9.zgkg_mc,t9.yjse as nynse, t9.rkse, t9.cyje, decode(t9.yjse, null, null, round((yjse-nvl(rkse,0))/yjse*100, 2)) as cybl";
        }

        String filter = "";
        if (xflx == null || xflx.equals("0")) {
            if (xzqdm == null || xzqdm.length() < 6) {
                filter = "";
            } else if (xzqdm.length() <= 6) {
                filter = " AND t2.SSQX_DM LIKE '" + xzqdm + "%'";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%'";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        } else {
            if (xzqdm == null || xzqdm.length() < 6) {
                filter = " AND t2.SSQX_DM IS NULL ";
            } else if (xzqdm.length() <= 6) {
                filter = " AND t2.SSQX_DM LIKE '" + xzqdm + "%' AND t2.SSFJ_DM IS NULL";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%' AND t2.SSSGY_DM IS NULL";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        }

        String sql = "";
        sql = "SELECT t1.*, t2.* " +
                "FROM ( " +
                "      SELECT DISTINCT t.RW_ID," + selectField + " " +
                "      FROM SW_HC_XM_RW_REL t " +
                "           JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID=t1.WORKFLOW_INSTANCE_ID " +
                "           JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID=t2.WORKFLOW_INSTANCE_ID " +
                "           JOIN SW_HC_XM t3 ON t.HCXM_ID=t3.ID " +
                "           LEFT JOIN " + table + " t9 ON t9." + keyField + "=t.BD_ID " +
                "      WHERE t3.XMLX='" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1', '2', '3') AND " + cllxFilter + " " +
                "    ) t1 " +
                "    JOIN ( " +
                "      SELECT MAX(t1.ASSIGNMENT_ID) AS TASKID, t2.WORKFLOW_INSTANCE_ID, WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.ORGAN_NAME, NULL))) AS SSQX, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.ORGAN_NAME, NULL))) AS SSFJ, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', t3.USER_NAME)) AS SSSGY, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', t3.USER_ID)) AS SSSGY_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.REGION_CODE, NULL))) AS SSFJ_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.REGION_CODE, NULL))) AS SSQX_DM " +
                "      FROM ( " +
                "            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "            FROM ( " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENTHISTORY " +
                "                  UNION ALL " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENT " +
                "                 ) t " +
                "           ) t1 " +
                "           LEFT JOIN PF_ACTIVITY t2 ON t1.ACTIVITY_ID=t2.ACTIVITY_ID " +
                "           LEFT JOIN PF_USER t3 ON t1.USER_ID=t3.USER_ID " +
                "           LEFT JOIN PF_USER_ORGAN_REL t4 on t1.USER_ID=t4.USER_ID " +
                "           LEFT JOIN PF_ORGAN t5 on t4.ORGAN_ID=t5.ORGAN_ID " +
                "      WHERE t1.PM=1 AND t2.ACTIVITY_STATE IN ('1', '2', '3') " +
                "      GROUP BY t2.WORKFLOW_INSTANCE_ID " +
                "    ) t2 ON t1.RW_ID=t2.WORKFLOW_INSTANCE_ID " +
                "WHERE 1=1 " + filter;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (" + sql + ")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);

        Page page = baseRepository.find(query, countQuery, pageable);
        return page;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap<String, Object>> getWclYclTzExportJson(String hcxmlx, String xflx, String xzqdm, String cllx, String ssnf, String sssq) {
        String qxCode, fjCode, sgyCode;
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);
        qxCode = configArr[1];
        fjCode = configArr[2];
        sgyCode = configArr[3];

        String cllxFilter = " 1=1 ";
        if ("0".equals(cllx)) {
            cllxFilter = " 1=1 ";
        } if ("1".equals(cllx)) {
            cllxFilter = " (t1.WORKFLOW_STATE IS NULL OR t1.WORKFLOW_STATE <> 2) ";
        } else if ("2".equals(cllx)) {
            cllxFilter = " t1.WORKFLOW_STATE=2 ";
        } else if ("3".equals(cllx)) {
            cllxFilter = " t2.ACTIVITY_STATE=2 AND t2.ACTIVITY_DEFINITION_ID=" + configArr[3] + " ";
        } else if ("4".equals(cllx)) {
            cllxFilter = " t.BLZT='1' ";
        }

        String table = "";
        String keyField = "";
        String selectField = "";
        if (Hcxmlx.TDZSYDQC.toString().equals(hcxmlx) || Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "(SELECT t1.*, t2.ZGKG_MC FROM S_SJ_ZSYDQC_TD t1 LEFT JOIN SW_DJ_JBB t2 ON t1.GLBM=t2.GLBM WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "')";
            keyField = "TDZSYD_ID";
            selectField = "t9.glbm,t9.nsrmc,t9.zgkg_mc,t9.yjse as nynse, t9.rkse, t9.cyje, decode(t9.yjse, null, null, round((yjse-nvl(rkse,0))/yjse*100, 2)) as cybl";
        } else if (Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            table = "(SELECT t1.*, t2.ZGKG_MC FROM S_SJ_ZSYDQC_FC t1 LEFT JOIN SW_DJ_JBB t2 ON t1.GLBM=t2.GLBM WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "')";
            keyField = "FCZSYD_FC";
            selectField = "t9.glbm,t9.nsrmc,t9.zgkg_mc,t9.yjse as nynse, t9.rkse, t9.cyje, decode(t9.yjse, null, null, round((yjse-nvl(rkse,0))/yjse*100, 2)) as cybl";
        }

        String filter = "";
        if (xflx == null || xflx.equals("0")) {
            if (xzqdm == null || xzqdm.length() < 6) {
                filter = "";
            } else if (xzqdm.length() <= 6) {
                filter = " AND t2.SSQX_DM LIKE '" + xzqdm + "%'";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%'";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        } else {
            if (xzqdm == null || xzqdm.length() < 6) {
                filter = " AND t2.SSQX_DM IS NULL ";
            } else if (xzqdm.length() <= 6) {
                filter = " AND t2.SSQX_DM LIKE '" + xzqdm + "%' AND t2.SSFJ_DM IS NULL";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%' AND t2.SSSGY_DM IS NULL";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        }

        String sql = "";
        sql = "SELECT t1.*, t2.* " +
                "FROM ( " +
                "      SELECT DISTINCT t.RW_ID," + selectField + " " +
                "      FROM SW_HC_XM_RW_REL t " +
                "           JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID=t1.WORKFLOW_INSTANCE_ID " +
                "           JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID=t2.WORKFLOW_INSTANCE_ID " +
                "           JOIN SW_HC_XM t3 ON t.HCXM_ID=t3.ID " +
                "           LEFT JOIN " + table + " t9 ON t9." + keyField + "=t.BD_ID " +
                "      WHERE t3.XMLX='" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1', '2', '3') AND " + cllxFilter + " " +
                "    ) t1 " +
                "    JOIN ( " +
                "      SELECT MAX(t1.ASSIGNMENT_ID) AS TASKID, t2.WORKFLOW_INSTANCE_ID, WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.ORGAN_NAME, NULL))) AS SSQX, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.ORGAN_NAME, NULL))) AS SSFJ, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', t3.USER_NAME)) AS SSSGY, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', t3.USER_ID)) AS SSSGY_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.REGION_CODE, NULL))) AS SSFJ_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.REGION_CODE, NULL))) AS SSQX_DM " +
                "      FROM ( " +
                "            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "            FROM ( " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENTHISTORY " +
                "                  UNION ALL " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENT " +
                "                 ) t " +
                "           ) t1 " +
                "           LEFT JOIN PF_ACTIVITY t2 ON t1.ACTIVITY_ID=t2.ACTIVITY_ID " +
                "           LEFT JOIN PF_USER t3 ON t1.USER_ID=t3.USER_ID " +
                "           LEFT JOIN PF_USER_ORGAN_REL t4 on t1.USER_ID=t4.USER_ID " +
                "           LEFT JOIN PF_ORGAN t5 on t4.ORGAN_ID=t5.ORGAN_ID " +
                "      WHERE t1.PM=1 AND t2.ACTIVITY_STATE IN ('1', '2', '3') " +
                "      GROUP BY t2.WORKFLOW_INSTANCE_ID " +
                "    ) t2 ON t1.RW_ID=t2.WORKFLOW_INSTANCE_ID " +
                "WHERE 1=1 " + filter;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);

        List<HashMap<String, Object>> list = null;
        try {
            list = query.getResultList();
        } catch (Exception e) {

        }
        return list;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public SwHcXmRwRel getSwHcXmRwRelByXmlxAndBdId(String xmlx, String bdId) {
        String swHcXmRwRelJpql = "from SwHcXmRwRel t where t.swHcXm.xmlx=?0 and t.bdId=?1";
        SwHcXmRwRel swHcXmRwRel = (SwHcXmRwRel) baseRepository.getUniqueResultByJpql(swHcXmRwRelJpql, Hcxmlx.ZDHC.toString(), bdId);
        return swHcXmRwRel;
    }

    private String getDhcrwSql(HcrwQuery hcrwQuery){
        String sql = "";
        String userId = SessionUtil.getCurrentUserId();
        if(Hcxmlx.ZDHC.toString().equals(hcrwQuery.getHcxmlx())){
            sql = "select t1.WORKFLOW_INSTANCE_ID,t1.WORKFLOW_INSTANCE_NAME,t1.BEGIN_TIME,t1.ACTIVITY_NAME,t1.ASSIGNMENT_ID," +
                    "t2.activity_definition_id," +
                    "t4.djh,t4.gtbd_id, " +
                    "to_char(t5.TDYTMC)TDYTMC,to_char(t5.qlrmc)qlrmc,to_char(t5.TDZL)TDZL "+
                    "from pf_tasklist t1 " +
                    " join pf_activity t2 on t2.activity_id=t1.ACTIVITY_ID " +
                    " join sw_hc_xm_rw_rel t3 on t3.rw_id=t1.WORKFLOW_INSTANCE_ID " +
                    " join s_sj_gtbd t4 on t4.gtbd_id=t3.bd_id " +
                    " join zd t5 on t4.djh=t5.djh "+
                    " join sw_hc_xm t6 on t6.id=t3.hcxm_id "+
                    " where 1=1 and t6.xmlx='"+Hcxmlx.ZDHC.toString()+"' and t1.user_id='"+userId+"' ";
            sql = sql + "and t2.activity_definition_id='"+hcrwQuery.getActivityDefinitionId()+"' ";
            if(StringUtils.isNotBlank(hcrwQuery.getDjh())){
                sql = sql + "and t4.djh like '%"+hcrwQuery.getDjh()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getTdyt())){
                sql = sql + "and t5.tdyt='"+hcrwQuery.getTdyt()+"' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getQlrmc())){
                sql = sql + "and t5.qlrmc like '%"+hcrwQuery.getQlrmc()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getTdzl())){
                sql = sql + "and t5.TDZL like '%"+hcrwQuery.getTdzl()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getGtbdId())){
                sql = sql + "and t4.gtbd_id='"+hcrwQuery.getGtbdId()+"' ";
            }

            //sql = sql + "order by t4.djh desc ";
        }else if (Hcxmlx.GDHC.toString().equals(hcrwQuery.getHcxmlx())){
            sql = "select t1.WORKFLOW_INSTANCE_ID,t1.WORKFLOW_INSTANCE_NAME,t1.BEGIN_TIME,t1.ACTIVITY_NAME,t1.ASSIGNMENT_ID," +
                    "t2.activity_definition_id," +
                    "t4.xzqdm,t4.xmmc,t4.qdfs,t4.tdyt,t4.yddw,t4.xm_id " +
                    "from pf_tasklist t1 " +
                    " join pf_activity t2 on t2.activity_id=t1.ACTIVITY_ID " +
                    " join sw_hc_xm_rw_rel t3 on t3.rw_id=t1.WORKFLOW_INSTANCE_ID " +
                    " join sw_dj_xmxx t4 on t4.xm_id=t3.bd_id " +
                    " join sw_hc_xm t5 on t5.id=t3.hcxm_id "+
                    " where 1=1 and t5.xmlx='"+Hcxmlx.GDHC.toString()+"' and t1.user_id='"+userId+"' ";
            sql = sql + "and t2.activity_definition_id='"+hcrwQuery.getActivityDefinitionId()+"' ";
            if(StringUtils.isNotBlank(hcrwQuery.getXmXzqdm())){
                sql = sql + "and t4.xzqdm='"+hcrwQuery.getXmXzqdm()+"' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getXmmc())){
                sql = sql +"and t4.xmmc like '%"+hcrwQuery.getXmmc()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getQdfs())){
                sql = sql + "and t4.qdfs='"+hcrwQuery.getQdfs()+"' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getXmTdyt())){
                sql = sql + "and t4.tdyt='"+hcrwQuery.getXmTdyt()+"' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getXmYddw())){
                sql = sql + "and t4.yddw like '%"+hcrwQuery.getXmYddw()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getXmId())){
                sql = sql +"and t4.xm_id='"+hcrwQuery.getXmId()+"' ";
            }
            //sql = sql +"order by t4.xm_id desc ";
        }else if(Hcxmlx.BPHC.toString().equals(hcrwQuery.getHcxmlx())){
            sql = "select t1.WORKFLOW_INSTANCE_ID,t1.WORKFLOW_INSTANCE_NAME,t1.BEGIN_TIME,t1.ACTIVITY_NAME,t1.ASSIGNMENT_ID," +
                    "t2.activity_definition_id," +
                    "t4.pc_id,t4.pcmc,t4.yddw,t4.xzqdm " +
                    "from pf_tasklist t1 " +
                    " join pf_activity t2 on t2.activity_id=t1.ACTIVITY_ID " +
                    " join sw_hc_xm_rw_rel t3 on t3.rw_id=t1.WORKFLOW_INSTANCE_ID " +
                    " join sw_dj_pcxx t4 on t4.pc_id=t3.bd_id " +
                    " join sw_hc_xm t5 on t5.id=t3.hcxm_id "+
                    " where 1=1 and t5.xmlx='"+Hcxmlx.BPHC.toString()+"' and t1.user_id='"+userId+"' ";
            sql = sql + "and t2.activity_definition_id='"+hcrwQuery.getActivityDefinitionId()+"' ";

            if(StringUtils.isNotBlank(hcrwQuery.getPcXzqdm())){
                sql = sql +"and t4.xzqdm='"+hcrwQuery.getPcXzqdm()+"' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getPcmc())){
                sql = sql +"and t4.pcmc like '%"+hcrwQuery.getPcmc()+"%' ";
            }
            if(StringUtils.isNotBlank(hcrwQuery.getPcYddw())){
                sql = sql + "and t4.yddw like '%"+hcrwQuery.getPcYddw()+"%' ";
            }
            //sql = sql +"order by t4.pc_id desc ";
        }
        return sql;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object findDhcrw(HcrwQuery hcrwQuery, Pageable pageable) {
        if(StringUtils.isNotBlank(hcrwQuery.getHcxmlx()) &&StringUtils.isNotBlank(hcrwQuery.getActivityDefinitionId())){
            String sql = getDhcrwSql(hcrwQuery);
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
            Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
            Page page =  baseRepository.find(query, countQuery, pageable);
            return page;
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List findDhcrwList(HcrwQuery hcrwQuery) {
        if(StringUtils.isNotBlank(hcrwQuery.getHcxmlx()) &&StringUtils.isNotBlank(hcrwQuery.getActivityDefinitionId())){
            String sql = getDhcrwSql(hcrwQuery);
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List list = query.getResultList();
            return list;
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object syncHcjdRootJson(String hcxmlx,String id) {

        Integer flag = null;
        String regionCode = "";
        Boolean isSgy = false;
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        //判断当前登陆人是否是税管员
        if(user.getRegionCode().length()==8 && (StringUtils.isBlank(sysUserService.getUserVo(userId).getRemark()) || sysUserService.getUserVo(userId).getRemark().indexOf("zuzhang")!=-1)){
            isSgy = true;
        }

        Integer length = null;

        String organId = "";
        if(StringUtils.isNotBlank(id)){
            regionCode = id;
            length  = regionCode.length()+2;
        }else{

            regionCode = user.getRegionCode();
            length = regionCode.length();
        }

        if(length==4){//说明是市局用户
            flag = 0;
        }else if(length==6){//说明是区县管理员
            flag = 1;
        }else if(length==8 ){//
            flag = 2;
        }else if(length>8){
            flag = 3;
            //根据regionCode获取organId
            List<PfOrganVo> organList = sysUserService.getOrganByRegionCode(regionCode);
            if(CollectionUtils.isNotEmpty(organList)){
                organId = organList.get(0).getOrganId();
            }
        }
        String sql = "";
        if(!isSgy){
            if(flag==3){//说明是普通税务人员
                sql = "SELECT k.XZQDM, k.DWMC, k.USER_ID, " +
                        "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                        "FROM ( " +
                        "      SELECT d.USER_ID, d.USER_NAME, d.REGION_CODE AS XZQDM, d.USER_NAME AS DWMC, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                        "      FROM (SELECT TO_CHAR(t1.USER_ID) AS USER_ID, TO_CHAR(t1.USER_NAME) AS USER_NAME, t3.REGION_CODE, t3.ORGAN_NAME " +
                        "            FROM PF_USER t1 " +
                        "                 LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                        "                 LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                        "            WHERE t3.ORGAN_ID IS NOT NULL AND t3.ORGAN_ID = '" + organId + "' " +
                        "           ) d " +
                        "           LEFT JOIN ( " +
                        "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY  " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  from  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY t5.USER_ID " +
                        "           ) t ON d.USER_ID=t.DM " +
                        "           LEFT JOIN ( " +
                        "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY t5.USER_ID " +
                        "           ) t2 ON d.USER_ID=t2.DM " +
                        "      ) k " +
                        "ORDER BY k.XZQDM ";
            }else{//说明有子节点
                sql = "SELECT k.XZQDM, k.DWMC, k.ORGAN_ID, " +
                        "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                        "FROM ( " +
                        "      SELECT d.REGION_CODE AS XZQDM, d.ORGAN_NAME AS DWMC, d.ORGAN_ID, d.ORGAN_NO, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                        "      FROM (SELECT t1.ORGAN_ID,t1.REGION_CODE,t1.ORGAN_NAME,t1.ORGAN_NO " +
                        "            FROM PF_ORGAN t1 " +
                        "            WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " AND t1.REMARK IS NULL " +
                        "           ) d " +
                        "           LEFT JOIN ( " +
                        "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY  " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                        "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                        "           ) t ON d.REGION_CODE=t.DM " +
                        "           LEFT JOIN ( " +
                        "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                        "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                        "           ) t2 ON d.REGION_CODE=t2.DM " +
                        "      ) k " +
                        "ORDER BY k.XZQDM ";
            }
        }else {
            flag = 3;
            List<PfOrganVo> organList = sysUserService.getOrganByRegionCode(regionCode);
            if (CollectionUtils.isNotEmpty(organList)) {
                organId = organList.get(0).getOrganId();
            }
            sql = "SELECT k.XZQDM, k.DWMC, k.USER_ID, " +
                    "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                    "FROM ( " +
                    "      SELECT d.USER_ID, d.USER_NAME, d.REGION_CODE AS XZQDM, d.USER_NAME AS DWMC, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                    "      FROM (SELECT TO_CHAR(t1.USER_ID) AS USER_ID, TO_CHAR(t1.USER_NAME) AS USER_NAME, t3.REGION_CODE, t3.ORGAN_NAME " +
                    "            FROM PF_USER t1 " +
                    "                 LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                    "                 LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                    "            WHERE t3.ORGAN_ID IS NOT NULL AND t3.ORGAN_ID = '" + organId + "' " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY  " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  from  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY t5.USER_ID " +
                    "           ) t ON d.USER_ID=t.DM " +
                    "           LEFT JOIN ( " +
                    "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  from  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY t5.USER_ID " +
                    "           ) t2 ON d.USER_ID=t2.DM " +
                    "      ) k " +
                    "ORDER BY k.XZQDM ";
        }


        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setName(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setYcl(String.valueOf(tempMap.get("YCL")));
                tempGrid.setWcl(String.valueOf(tempMap.get("WCL")));
                tempGrid.setCll(String.valueOf(tempMap.get("CLL")));
                tempGrid.setXzqdm(String.valueOf(tempMap.get("XZQDM")));
                if(StringUtils.isNotBlank(tempGrid.getXzqdm()) && (length>8 || isSgy)){
                    tempGrid.setXzqdm(String.valueOf(tempMap.get("USER_ID")));
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);

            }
        }
        return resultList;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public Object zsydHcjdRootJson(String hcxmlx, String id) {
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();

        //判断当前登陆人是否是税管员
        Boolean isSgy = false;
        if(user.getRegionCode().length() == 8 && (StringUtils.isBlank(sysUserService.getUserVo(userId).getRemark()) || sysUserService.getUserVo(userId).getRemark().indexOf("zuzhang") != -1)){
            isSgy = true;
        }

        Integer length = null;
        String organId = "";
        String regionCode = "";
        if(StringUtils.isNotBlank(id)){
            regionCode = id;
            length  = regionCode.length() + 2;
        }else{
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }

        Integer flag = null;
        if (length == 4) { // 市局用户
            flag = 0;
        }else if (length == 6) { // 区县管理员
            flag = 1;
        }else if (length == 8 && !isSgy) { // 税务所所长
            flag = 2;
        }else if (length > 8 || isSgy) { // 税管员
            flag = 3;
            //根据regionCode获取organId
            List<PfOrganVo> organList = sysUserService.getOrganByRegionCode(regionCode);
            if (CollectionUtils.isNotEmpty(organList)) {
                organId = organList.get(0).getOrganId();
            }
        }

        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);
        String sql = "";
        if (flag == 3) { // 普通税务人员
            sql = "SELECT k.XZQDM, k.DWMC, k.USER_ID, " +
                    "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                    "FROM ( " +
                    "      SELECT d.USER_ID, d.USER_NAME, d.REGION_CODE AS XZQDM, d.USER_NAME AS DWMC, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                    "      FROM (SELECT TO_CHAR(t1.USER_ID) AS USER_ID, TO_CHAR(t1.USER_NAME) AS USER_NAME, t3.REGION_CODE, t3.ORGAN_NAME " +
                    "            FROM PF_USER t1 " +
                    "                 LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                    "                 LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                    "            WHERE t3.ORGAN_ID IS NOT NULL AND t3.ORGAN_ID = '" + organId + "' " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY  " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  from  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY t5.USER_ID " +
                    "           ) t ON d.USER_ID=t.DM " +
                    "           LEFT JOIN ( " +
                    "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY t5.USER_ID " +
                    "           ) t2 ON d.USER_ID=t2.DM " +
                    "      ) k " +
                    "ORDER BY k.XZQDM ";
        } else { // 有子节点
            sql = "SELECT k.XZQDM, k.DWMC, k.ORGAN_ID, " +
                    "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE AS XZQDM, d.ORGAN_NAME AS DWMC, d.ORGAN_ID, d.ORGAN_NO, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                    "      FROM (SELECT t1.ORGAN_ID,t1.REGION_CODE,t1.ORGAN_NAME,t1.ORGAN_NO " +
                    "            FROM PF_ORGAN t1 " +
                    "            WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " AND t1.REMARK IS NULL " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY  " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                    "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                    "           ) t ON d.REGION_CODE=t.DM " +
                    "           LEFT JOIN ( " +
                    "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "              FROM SW_HC_XM_RW_REL t " +
                    "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                    "                   LEFT JOIN ( " +
                    "                      SELECT * " +
                    "                      FROM ( " +
                    "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                    "                            FROM ( " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM PF_ASSIGNMENTHISTORY " +
                    "                                  UNION ALL " +
                    "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                    "                                  FROM  PF_ASSIGNMENT " +
                    "                                  ) t " +
                    "                           ) " +
                    "                      WHERE PM=1 " +
                    "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                    "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                    "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                    "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                    "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                    "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "      ) k " +
                    "ORDER BY k.XZQDM ";
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if (CollectionUtils.isNotEmpty(list)) {
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setName(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setYcl(String.valueOf(tempMap.get("YCL")));
                tempGrid.setWcl(String.valueOf(tempMap.get("WCL")));
                tempGrid.setCll(String.valueOf(tempMap.get("CLL")));
                tempGrid.setXzqdm(String.valueOf(tempMap.get("XZQDM")));
                if (StringUtils.isNotBlank(tempGrid.getXzqdm()) && flag == 3) { // 税管员
                    tempGrid.setXzqdm(String.valueOf(tempMap.get("USER_ID")));
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);
            }
        }
        return resultList;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object syncHctzZdRootJson(String id) {
        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        regionCode = user.getRegionCode();

        Integer length = 6;
        Boolean EndNode = false;
        String dwCode = "";
        if(StringUtils.isNotBlank(id)){
            dwCode = id;

            if (dwCode.length() == 4) {
                length = dwCode.length() + 2;
            }
            else {
                length = dwCode.length() + 3;
            }
        }else{
            dwCode = regionCode;
            if (dwCode.length() > 6)
                dwCode = dwCode.substring(0, 5);
            length = dwCode.length();
        }
        if (length >= 9)
            EndNode = true;

        String sqlSy = "SELECT DJH, COUNT(DJH) AS HCHJ, SUM(DECODE(td.SGZT_DM, '01', 1, 0)) AS KGH, SUM(DECODE(td.SGZT_DM, '02', 1, 0)) AS LZLGH, " +
                        "       SUM(DECODE(td.SGZT_DM, '03', 1, 0)) AS KZHSYH, SUM(DECODE(td.SGZT_DM, '04', 1, 0)) AS GR, " +
                        "       SUM(DECODE(td.SGZT_DM, '05', 1, 0)) AS JGDW, SUM(NVL(td.NYNSE, 0)) AS TDYNSE, SUM(NVL(fc.NYNSE, 0)) AS FCYNSE " +
                        "FROM SW_DJ_SY sy " +
                        "     LEFT JOIN SW_DJ_TD td ON sy.SY_ID=td.SY_ID " +
                        "     LEFT JOIN SW_DJ_FC fc ON sy.SY_ID=fc.SY_ID " +
                        "WHERE sy.SYZT = '1' AND td.SGZT_DM IS NOT NULL AND DJH IS NOT NULL " +
                        "GROUP BY DJH";
        String sqlZd = "SELECT TO_CHAR(DJH) AS DJH, 1 AS ZDS " +
                        "FROM ZD " +
                        "WHERE DJH LIKE '" + dwCode + "%'";
        String sql = "SELECT SUBSTR(zd.DJH, 1, " + String.valueOf(length) + ") AS DWDM, SUM(zd.ZDS) AS ZDS, SUM(DECODE(sy.DJH, NULL, 0, 1)) AS YHCZDS, SUM(DECODE(sy.DJH, NULL, 1, 0)) AS WHCZDS, " +
                        "      SUM(NVL(sy.HCHJ, 0)) AS HCHJ, SUM(NVL(sy.KGH, 0)) AS KGH, SUM(NVL(sy.LZLGH, 0)) AS LZLGH, SUM(NVL(sy.KZHSYH, 0)) AS KZHSYH, " +
                        "      SUM(NVL(sy.GR, 0)) AS GR, SUM(NVL(sy.JGDW, 0)) AS JGDW, SUM(NVL(sy.TDYNSE, 0)) AS TDYNSE, SUM(NVL(sy.FCYNSE, 0)) AS FCYNSE " +
                        "FROM (" + sqlZd + ") zd LEFT JOIN (" + sqlSy + ") sy ON zd.DJH=sy.DJH " +
                        "GROUP BY SUBSTR(zd.DJH, 1, " + String.valueOf(length) + ")";
        sql = "SELECT t.*, DECODE(t1.DWMC, NULL, t.DWDM, t1.DWMC) AS DWMC " +
                "FROM (" + sql + ") t LEFT JOIN S_DM_DWXX_CZ t1 ON t.DWDM=t1.DWDM";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DicTreeGridHcTz> resultList = new ArrayList<DicTreeGridHcTz>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DicTreeGridHcTz tempGrid = new DicTreeGridHcTz();
                tempGrid.setDwmc(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setDwdm(String.valueOf(tempMap.get("DWDM")));
                if(EndNode){
                    tempGrid.setState("open");
                }

                tempGrid.setZds(Integer.valueOf(String.valueOf(tempMap.get("ZDS"))));
                tempGrid.setYhczds(Integer.valueOf(String.valueOf(tempMap.get("YHCZDS"))));
                tempGrid.setWhczds(Integer.valueOf(String.valueOf(tempMap.get("WHCZDS"))));
                tempGrid.setHchj(Integer.valueOf(String.valueOf(tempMap.get("HCHJ"))));
                tempGrid.setKgh(Integer.valueOf(String.valueOf(tempMap.get("KGH"))));
                tempGrid.setLzlgh(Integer.valueOf(String.valueOf(tempMap.get("LZLGH"))));
                tempGrid.setGr(Integer.valueOf(String.valueOf(tempMap.get("GR"))));
                tempGrid.setJgdw(Integer.valueOf(String.valueOf(tempMap.get("JGDW"))));
                tempGrid.setKzhsyh(Integer.valueOf(String.valueOf(tempMap.get("KZHSYH"))));
                tempGrid.setTdynse(Double.valueOf(String.valueOf(tempMap.get("TDYNSE"))));
                tempGrid.setFcynse(Double.valueOf(String.valueOf(tempMap.get("FCYNSE"))));

                resultList.add(tempGrid);

            }
        }
        return resultList;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object syncHctzSwRootJson(String id) {
        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        regionCode = user.getRegionCode();

        Integer length = 6;
        Boolean EndNode = false;
        String dwCode = "";
        if(StringUtils.isNotBlank(id)){
            dwCode = id;
            length  = dwCode.length() + 2;
        }else{
            dwCode = regionCode;
            if (dwCode.length() > 6)
                dwCode = dwCode.substring(0, 5);
            length = dwCode.length();
        }
        if (length >= 8)
            EndNode = true;

        String sqlSw = "SELECT ZGKG_DM, SUM(NSRHJ) AS NSRHJ, SUM(DECODE(SIGN(TDYNSE + FCYNSE), 1, 1, 0)) AS YSHS, " +
                        "       SUM(HCHJ) AS HCHJ, SUM(KGH) AS KGH, SUM(LZLGH) AS LZLGH, SUM(KZHSYH) AS KZHSYH, " +
                        "       SUM(GR) AS GR, SUM(JGDW) AS JGDW, SUM(TDYNSE) AS TDYNSE, SUM(FCYNSE) AS FCYNSE " +
                        "FROM ( " +
                        "    SELECT jbb.ZGKG_DM, jbb.JBB_ID, 1 AS NSRHJ, COUNT(jbb.JBB_ID) AS HCHJ, " +
                        "           SUM(DECODE(td.SGZT_DM, '01', 1, 0)) AS KGH, SUM(DECODE(td.SGZT_DM, '02', 1, 0)) AS LZLGH, " +
                        "           SUM(DECODE(td.SGZT_DM, '03', 1, 0)) AS KZHSYH, SUM(DECODE(td.SGZT_DM, '04', 1, 0)) AS GR, " +
                        "           SUM(DECODE(td.SGZT_DM, '05', 1, 0)) AS JGDW, SUM(NVL(td.NYNSE, 0)) AS TDYNSE, SUM(NVL(fc.NYNSE, 0)) AS FCYNSE " +
                        "    FROM SW_DJ_SY sy " +
                        "         LEFT JOIN SW_DJ_TD td ON sy.SY_ID=td.SY_ID " +
                        "         LEFT JOIN SW_DJ_FC fc ON sy.SY_ID=fc.SY_ID " +
                        "         LEFT JOIN SW_DJ_JBB jbb ON td.JBB_ID=jbb.JBB_ID " +
                        "    WHERE sy.SYZT = '1' AND td.SGZT_DM IS NOT NULL AND jbb.ZGKG_DM LIKE '2" + dwCode + "%' " +
                        "    GROUP BY jbb.ZGKG_DM, jbb.JBB_ID) " +
                        "GROUP BY ZGKG_DM";
        String sqlZg = "SELECT TO_CHAR(MANAGEDEPTCODE) AS ZGKG_DM, " +
                        "       SUM(DECODE(TAXTYPECODE, 13, NVL(TAXFINAL, 0), 0)) AS SNDTDNSE, " +
                        "       SUM(DECODE(TAXTYPECODE, 11, NVL(TAXFINAL, 0), 0)) AS SNDFCNSE " +
                        "FROM TB_LVY_LEVYDATA " +
                        "WHERE TAXTYPECODE IN (11, 13) AND LateFeeFlag <> '1' AND TO_CHAR(DECLAREDATE, 'YYYY')=(TO_CHAR(SYSDATE, 'YYYY') - 1) " +
                        "GROUP BY MANAGEDEPTCODE";
        String sql = "SELECT SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ") AS DWDM, " +
                        "      SUM(NSRHJ) AS NSRHJ, SUM(YSHS) AS YSHS, SUM(HCHJ) AS HCHJ, SUM(KGH) AS KGH, SUM(LZLGH) AS LZLGH, SUM(KZHSYH) AS KZHSYH, " +
                        "      SUM(GR) AS GR, SUM(JGDW) AS JGDW, SUM(TDYNSE) AS TDYNSE, SUM(FCYNSE) AS FCYNSE, " +
                        "     SUM(NVL(SNDTDNSE, 0)) AS SNDTDNSE, SUM(NVL(SNDFCNSE, 0)) AS SNDFCNSE " +
                        "FROM (" + sqlSw + ") sw LEFT JOIN (" + sqlZg + ") zg ON sw.ZGKG_DM=zg.ZGKG_DM " +
                        "GROUP BY SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ")";
        String sqlDw = "SELECT DWDM, DWMC " +
                        "FROM S_DM_DWXX_CZ " +
                        "UNION " +
                        "SELECT SUBSTR(SWBMBM, 2, 8) AS DWDM, MC AS DWMC " +
                        "FROM DM_SWBM";
        sql = "SELECT t.*, DECODE(t1.DWMC, NULL, t.DWDM, t1.DWMC) AS DWMC, " +
                "      ROUND(DECODE(t.NSRHJ, 0, 0, t.HCHJ / t.NSRHJ) * 100, 2) AS YSHSBL, " +
                "      ROUND(DECODE(t.SNDTDNSE, 0, 0, (t.TDYNSE - t.SNDTDNSE) / t.SNDTDNSE) * 100, 2) AS TDZZBL, " +
                "      ROUND(DECODE(t.SNDFCNSE, 0, 0, (t.FCYNSE - t.SNDFCNSE) / t.SNDFCNSE) * 100, 2) AS FCZZBL " +
                "FROM (" + sql + ") t LEFT JOIN (" + sqlDw + ") t1 ON t.DWDM=t1.DWDM";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DicTreeGridHcTz> resultList = new ArrayList<DicTreeGridHcTz>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DicTreeGridHcTz tempGrid = new DicTreeGridHcTz();
                tempGrid.setDwmc(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setDwdm(String.valueOf(tempMap.get("DWDM")));
                if(EndNode){
                    tempGrid.setState("open");
                }

                tempGrid.setNsrhj(Integer.valueOf(String.valueOf(tempMap.get("NSRHJ"))));
                tempGrid.setYshs(Integer.valueOf(String.valueOf(tempMap.get("YSHS"))));
                tempGrid.setHchj(Integer.valueOf(String.valueOf(tempMap.get("HCHJ"))));
                tempGrid.setKgh(Integer.valueOf(String.valueOf(tempMap.get("KGH"))));
                tempGrid.setLzlgh(Integer.valueOf(String.valueOf(tempMap.get("LZLGH"))));
                tempGrid.setGr(Integer.valueOf(String.valueOf(tempMap.get("GR"))));
                tempGrid.setJgdw(Integer.valueOf(String.valueOf(tempMap.get("JGDW"))));
                tempGrid.setKzhsyh(Integer.valueOf(String.valueOf(tempMap.get("KZHSYH"))));
                tempGrid.setTdynse(Double.valueOf(String.valueOf(tempMap.get("TDYNSE"))));
                tempGrid.setSndtdnse(Double.valueOf(String.valueOf(tempMap.get("SNDTDNSE"))));
                tempGrid.setFcynse(Double.valueOf(String.valueOf(tempMap.get("FCYNSE"))));
                tempGrid.setSndfcnse(Double.valueOf(String.valueOf(tempMap.get("SNDFCNSE"))));
                tempGrid.setYshsbl(Double.valueOf(String.valueOf(tempMap.get("YSHSBL"))));
                tempGrid.setTdzzbl(Double.valueOf(String.valueOf(tempMap.get("TDZZBL"))));
                tempGrid.setFczzbl(Double.valueOf(String.valueOf(tempMap.get("FCZZBL"))));

                resultList.add(tempGrid);

            }
        }
        return resultList;
    }


    @Override
    public List getRoleListByRwId(String workflowInstanceId) {
        List<PfRoleVo> roleList = new ArrayList<PfRoleVo>();
        String userId = SessionUtil.getCurrentUserId();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(workflowInstanceId);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);

                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                       if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel.getRoleId());
                            roleList.add(roleVo);
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return roleList;
    }

    @Override
    public PerformerTaskModel getTurnUserList(String userId,String proid) throws  Exception{
        PerformerTaskModel result=new PerformerTaskModel();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(proid);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        if (!performerModel.getUserId().equals("")) {// 参与者是人
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = sysUserService.getUserVo(userid);
                            List<PfOrganVo> organs=sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(organs.get(0).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                        } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                            List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo=sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo!=null){
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for(PfUserVo vo:users){
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                        } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                                    .getRoleId());
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel
                                    .getRoleId());
                            result.setName(roleVo.getRoleName());
                            result.setId(roleVo.getRoleId());
                            for(PfUserVo vo:users){
                                result.getUserList().add(vo);
                            }
                            result.setType("Role");
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }
    @Override
    public String initTurnTaskXml(String proid,String userId,String taskid)throws Exception{
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo=info.getTransInfo();
        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = lstTrans.get(0).getDefineId();
            WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);

            List<PerformerModel> performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0){
                String roleId = "";
                List<PfRoleVo> roleList = sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (StringUtils.isNotBlank(performerModel.getRoleId())){
                        boolean isok = false;
                        for (PfRoleVo roleVo : roleList){
                            if (StringUtils.equals(performerModel.getRoleId(),roleVo.getRoleId())){
                                roleId = performerModel.getRoleId();
                                isok = true;
                                break;
                            }
                        }
                        if (isok){
                            break;
                        }
                    }
                }

                String activityRelType = "";
                if (transInfo.getTransType().equalsIgnoreCase("and"))
                    activityRelType = "and";
                else
                    activityRelType = "or";

                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement += " SendSMS= \"false\"";
                activitysElement += ">";
                String activityElement = "<Activity ";
                activityElement += " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement += " RoleId=\"" + roleId + "\"";
                userInfoElement += " Id=\"" + userId + "\">";
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
                activityElement += "</Activity>";
                activitysElement += activityElement;

                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement += "</text>";
                remarkElement += remarkTextElement + "</ReMark>";
                activitysElement += remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }
}
