package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjJbbQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
public interface TaxService {

    public List<SwDjJbb> findAllSwDjJbb();

    /**
     * 获取到所有税源
     * @param pageable
     * @return
     */
    public Page<Map<String,Object>> findSwdjSyMap(Pageable pageable);

    /**
     * 获取到土地税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page<SwDjSyQuery> findSwdjTdMap(SwDjSyQuery swDjSyQuery,Pageable pageable);

    /**
     * 获取到房产税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page<SwDjSyQuery> findSwdjFcMap(SwDjSyQuery swDjSyQuery,Pageable pageable);

    /**
     * 获取到漏征漏管的土地税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page<SwDjSyQuery> findLzlghTd(SwDjSyQuery swDjSyQuery,Sgzt sgzt,Pageable pageable);

    /**
     * 获取到漏征漏管的房产税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page<SwDjSyQuery> findLzlghFc(SwDjSyQuery swDjSyQuery,Sgzt sgzt,Pageable pageable);

    /**
     * 获取到重点的土地税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page findZdsyTd(SwDjSyQuery swDjSyQuery,Pageable pageable,String sort,String dir,String beginPm,String endPm);

    /**
     * 获取到重点的房产税源
     * @param swDjSyQuery
     * @param pageable
     * @return
     */
    public Page<SwDjSyQuery> findZdsyFc(SwDjSyQuery swDjSyQuery,Pageable pageable,String sort,String dir,String beginPm,String endPm);

    /**
     * 根据Id获取税源信息
     * @param tdId
     * @param fcId
     * @return
     */
    public SwDjSyQuery getSwDjSyById(String tdId, String fcId);
    public SwDjSyQuery getSwDjSyBySyId(String syId);

    public SwDjTd getSwDjTdById(String tdId);

    public SwDjFc getSwDjFcById(String fcId);

    /**
     * 根据djh获取税源信息
     * @param djh
     * @return
     */
    public List<SwDjSyQuery> getSwDjSyByDjh(String djh);

    public SwDjSy getSwDjSyById(String syId);

    public void saveSwDjSy(SwDjSy swDjSy);

    public void deleteSwDjSy(String syId);

    //根据管理代码获取基本表信息
    public SwDjJbb findSwDjJbbByGlbm(String glbm);

    public void saveSwDjSyQuery(SwDjSyQuery swDjSyQuery,String syzt) throws  Exception;

    //根据地籍号，生成土地使用号
    public String createDbhByDjh(String djh);

    //根据管理编码唯一确定基本表
    public List<SwDjJbbQuery> findJbbByGlbm(String glbm);

    public void updateSwDjTd(SwDjTd swDjTd);

    public void updateSwDjFc(SwDjFc swDjFc);

    public void createSwDjFc(SwDjFc swDjFc);

    /**
     * 修改税源状态
     * @param syId
     */
    public void softDelSyDjSy(String syId,String syzt);

    public SwDjSy findSwDjSyByDjhAndDbh(String djh,String dbh);

    public List<Object> getZdsyTdList(HashMap param);
    public List<Object> getZdsyFcList(HashMap param);

    List<SwDjSyQuery> getSwdjTzList(HashMap param);


    String getIsYsdlByDm(String dm);

    String getDwseByTddj(String tddj);


    List<SwDjSyQuery> getSwDjSyByGlbm(String glbm,String szdm);

    List<HashMap<String,Object>> getSbSyxxListByGlbm(SbZsQuery sbZsQuery,String szdm);

    List<SwDjSyQuery> getFcSwDjSyByGlbm(String glbm);

    List<SwDjSyQuery> getFcSbSyxxListByGlbm(String glbm);

    public SwDjSyQuery setZgxtSet(String glbm,SwDjSyQuery swDjSyQuery);

    Object getSwjgByQx(String qx);

    List<HashMap<String,Object>> getZsSyxxListByGlbm(SbZsQuery sbZsQuery, String szdm);

    BigDecimal getSumScmjByDjh(String djh);

    HashMap getHj(String sylx,SwDjSyQuery swDjSyQuery);

    //税源台帐获取宗地数
    public Object getSyZdCount(String sylx,SwDjSyQuery swDjSyQuery);
    //税源户数，同一个管理代码算一户
    public Object getSyhsCount(String sylx,SwDjSyQuery swDjSyQuery);
    //计算控管户户数
    public Object getKghCount(String sylx,SwDjSyQuery swDjSyQuery);
    //计算漏征漏管户数
    public Object getLzlghCount(String sylx,SwDjSyQuery swDjSyQuery);
    //计算可转化税源户数
    public Object getKzhsyCount(String sylx,SwDjSyQuery swDjSyQuery);
    //计算机关单位户数
    public Object getJgdwCount(String sylx,SwDjSyQuery swDjSyQuery);
    //计算个人户数
    public Object getGrCount(String sylx,SwDjSyQuery swDjSyQuery);

    //统计某个行业类型的年应纳税额
    public Object tjNynseByHylx(String[] queryHydm,String sylx,String nf);

    void setZdsy(String sylx,String tdId, String fcId,SwDjSyQuery swDjSyQuery,String beginPm,String endPm);
    public Object getHjmjAndFcyz(String sylx, SwDjSyQuery swDjSyQuery);
    //根据区县获取所有税管机关
    public Object getSgjgByQx(String qx);
    //统计某个区的的年应纳税额
    List<Map<String,Object>> tjNynseByQx(String sylx,String[] queryDwdm,String nf);
    //统计税源变化分析
    List<Map<String,Object>> tjSybhfx(String sylx, String nf);
    //获得耕地占用税税源
    Object findSwDjGdzysMap(SwDjSyQuery swDjSyQuery, Pageable request);
    //获得契税税源
    Object findSwDjQsMap(SwDjSyQuery swDjSyQuery, Pageable request);

    String findZgkgDmByRegionCode(String regionCode);

    List getTddjByDjhLike(String djh);
    List getTddjByQx(String qx);
    Object getTddjByDm(String dm);

    Zd getTddjByDjh(String djh);

    List getTddjByXzqdm(String xmXzqdm);

    List<SwDjSyQuery> getSwDjSyByXmId(String xmId);

    List<SwDjSyQuery> getSwDjSyByPcId(String pcId);

    Object parseTddjByDm(String dm);

    //重点税源fc
    List getzdsyfcList(HashMap param);

    //重点税源td
    List getzdsytdList(HashMap param);

    void deletSwDjTdByTdId(String tdId);

    void deletSwDjFcByFcId(String fcId);

    public String fandTdzl(String syId);




}
