package cn.gtmap.landtax.quartz;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Nsrzt;
import cn.gtmap.landtax.model.dictionary.Sssq;
import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.dictionary.Ydtype;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 14-12-5.
 */

public class TbSbSjQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;

    /**
     *
     * 每天晚上23：:5分执行
     * 将征管系统表“sb_yzss”，税种代码是“诚征土地使用税”，“房产税”的数据抽出到我们系统表"local_sb_yzss"中
     * 将征管系统表“sb_rkss”，税种代码是“诚征土地使用税”，“房产税”的数据抽出到我们系统表"local_sb_rkss"中
     * 将s_sj_sbydqc_td,s_sj_sbydqc_fc,s_sj_zsydqc_td,s_sj_zsydqc_fc中已经办结了的 并且END_SBSE处理后申报税额是空的，这些数据进行更新
     */
    @Transactional
    public void execute() throws  Exception{

//        //******************************************************************************抽取申报数据
//        logger.info("*******************************executeStoreSb开始");
//        executeStoreSb();
//        logger.info("*******************************executeStoreSb结束");
        //******************************************************************************抽取征收数据
        logger.info("*******************************executeStoreZs开始");
        executeStoreZs();
        logger.info("*******************************executeStoreZs结束");


        //*******************************************************************************工作流事件滞后处理
//        //土地申报
//        executeTdSbWfEnd();
//        //土地申报
//        executeFcSbWfEnd();
        //土地征收
        executeTdZsWfEnd();
        //房产征收
        executeFcZsWfEnd();
    }
    private void executeTdSbWfEnd() {
        Query query;
        String sql = "";

        // 更新处理后入库税额
        sql =   "UPDATE S_SJ_ZSYDQC_TD a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(SUM(b.NSE), 0) " +
                "    FROM LOCAL_SB_YZSS b " +
                "    WHERE TO_CHAR(b.FSRQ, 'YYYY')=a.SSNF AND (TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 < (MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1) " +
                "          AND b.SZDM='13' AND a.GLBM=b.GLBM) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM YDQC_REL c WHERE c.BLZT='1' AND a.TDZSYD_ID=c.REL_ID)";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_ZSYDQC_TD SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    private void executeFcSbWfEnd(){
        //房产申报
        Query query;
        String sql = "";

        // 更新处理后入库税额
        sql =   "UPDATE S_SJ_SBYDQC_FC a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(SUM(b.NSE), 0) " +
                "    FROM LOCAL_SB_YZSS b " +
                "    WHERE TO_CHAR(b.FSRQ, 'YYYY')=a.SSNF AND (TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 < (MOD((TO_NUMBER(a.SSSQ) - 1), 2) + 1) " +
                "          AND b.SZDM='11' AND a.GLBM=b.GLBM) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM YDQC_REL c WHERE c.BLZT='1' AND a.FCZSYD_ID=c.REL_ID)";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_SBYDQC_FC SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    private void executeTdZsWfEnd(){
        //土地征收
        Query query;
        String sql = "";

        // 一年分几个属期的变量
        String sqCount = "4";
        // 本期所属税款表到式的分变量表达式
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'MM')) - 1) / 12 * :sqCount) + 2)";
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqCount) + 2)";
        String ydEndNfsq = "(a.SSNF * :sqCount + (MOD((TO_NUMBER(a.SSSQ) - 1), :sqCount) + 1))";
        String ydStartNfsq = "(a.SSNF * :sqCount + (TRUNC((TO_NUMBER(a.SSSQ) - 1) / :sqCount, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "b.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":sqCount", sqCount);

        // 更新处理后入库税额
        sql =   "UPDATE S_SJ_ZSYDQC_TD a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(ROUND(SUM(" + bqSkExp + "), 2), 0) " +
                "    FROM LOCAL_SB_RKSS b " +
                "    WHERE TO_CHAR(b.FSRQ, 'YYYY')=a.SSNF AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) <= (MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1) " +
                "           AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) >= (TRUNC((TO_NUMBER(a.SSSQ) - 1) / 4, 0) + 1) AND b.SZDM='13' AND a.GLBM=b.GLBM) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM SW_HC_XM_RW_REL c WHERE c.BLZT='1' AND a.RWID=c.RW_ID)";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_ZSYDQC_TD SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    private void executeFcZsWfEnd(){
        //房产征收
        Query query;
        String sql = "";

        // 一年分几个属期的变量
        String sqCount = "2";
        // 本期所属税款表到式的分变量表达式
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'MM')) - 1) / 12 * :sqCount) + 1)";
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqCount) + 1)";
        String ydEndNfsq = "(a.SSNF * :sqCount + (MOD((TO_NUMBER(a.SSSQ) - 1), :sqCount) + 1))";
        String ydStartNfsq = "(a.SSNF * :sqCount + (TRUNC((TO_NUMBER(a.SSSQ) - 1) / :sqCount, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "b.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":sqCount", sqCount);

        // 更新处理后入库税额
        sql =   "UPDATE S_SJ_ZSYDQC_FC a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(ROUND(SUM(" + bqSkExp + "), 2), 0) " +
                "    FROM LOCAL_SB_RKSS b " +
                "    WHERE TO_CHAR(b.FSRQ, 'YYYY')=a.SSNF AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) <= (MOD((TO_NUMBER(a.SSSQ) - 1), 2) + 1) " +
                "           AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) >= (TRUNC((TO_NUMBER(a.SSSQ) - 1) / 2, 0) + 1) AND b.SZDM='11' AND a.GLBM=b.GLBM) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM SW_HC_XM_RW_REL c WHERE c.BLZT='1' AND a.RWID=c.RW_ID)";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_ZSYDQC_FC SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    private void executeStoreSb() throws  Exception {
        //删除表"local_sb_yzss"中数据
        //String delJpql = "delete from SbYzss";
        //baseRepository.executeJpql(delJpql);


        //读取征管系统数据
        String sql = "";
        sql =   "INSERT INTO LOCAL_SB_YZSS (SB_NUM, GLBM, FSRQ, NSE, SZDM) " +
                "SELECT a.DECLAREDATAID AS SB_NUM, a.TaxRegCode AS GLBM, a.DECLAREDATE AS FSRQ, a.TAXFINAL AS RKSE, TRIM(a.TaxTypeCode) AS SZDM " +
                "FROM TB_LVY_DECLAREDATA a LEFT JOIN LOCAL_SB_YZSS b ON a.DECLAREDATAID=b.SB_NUM " +
                "WHERE a.TaxRegCode NOT LIKE 'T%'  AND a.TaxTypeCode IN (11, 13) AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                "      AND b.SB_NUM IS NULL";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    private void executeStoreZs() throws  Exception{
        //删除表"local_sb_rkss"中数据
        //String delRkssJpql = "delete from SbRkss";
        //baseRepository.executeJpql(delRkssJpql);
        //读取征管系统数据
        String sql = "";
        sql =   "INSERT INTO LOCAL_SB_RKSS (SB_NUM, GLBM, FSRQ, NSE, SZDM, TAXTERMBEGIN, TAXTERMEND) " +
                "SELECT a.LEVYDATAID AS SB_NUM, a.TaxRegCode AS GLBM, a.DECLAREDATE AS FSRQ, a.TAXFINAL AS RKSE, TRIM(a.TaxTypeCode) AS SZDM, TAXTERMBEGIN, TAXTERMEND " +
                "FROM TB_LVY_LEVYDATA a LEFT JOIN LOCAL_SB_YZSS b ON a.LEVYDATAID=b.SB_NUM " +
                "WHERE a.LateFeeFlag <> '1' AND a.TaxRegCode NOT LIKE 'T%'  AND a.TaxTypeCode IN (11, 13) AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                "      AND b.SB_NUM IS NULL";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

   //******************************************************************************************************************************************************************************************
    /**
     * 5月1日 至 10月31日每晚23点 执行该任务
     * 当前时间月份在 5-9之间生成上半年清册（期间只生成一次，多次执行是判断是否生成），
     * 当前时间月份是10生成下半年清册，
     * 任务：
     * 1，生成申报土地疑点清册
     * 2，生成申报房产疑点清册
     * 3，生成征收土地疑点清册
     * 4，生成征收房产疑点清册
     */

    @Transactional
    public void createYdqc(){

        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(Calendar.MONTH)+1;
        int year = calendar.get(Calendar.YEAR);
        //*************************************************创建土地申报疑点清册
        logger.info("*******************************createTdSbYdqc开始");
        createTdSbYdqc(year,month);
        logger.info("*******************************createTdSbYdqc结束");
        //*************************************************创建土地申报疑点清册
        logger.info("*******************************createFcSbYdqc开始");
        createFcSbYdqc(year,month);
        logger.info("*******************************createFcSbYdqc结束");
        //*************************************************创建土地征收疑点清册
        logger.info("*******************************createTdZsYdqc开始");
        createTdZsYdqc(year,month);
        logger.info("*******************************createTdZsYdqc结束");
        //*************************************************创建房产征收疑点清册
        logger.info("*******************************createFcZsYdqc开始");
        createFcZsYdqc(year,month);
        logger.info("*******************************createFcZsYdqc结束");
    }

    private void createTdSbYdqc(int year ,int month){
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.CZTDSYS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = 4;
            sqYear = year - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getTdSbYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            sql = getTdSbYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.WHCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }
    private void createFcSbYdqc(int year, int month){
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.FCS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = 2;
            sqYear = year - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getFcSbYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            sql = getFcSbYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.WHCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }
    private void createTdZsYdqc(int year, int month){
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.CZTDSYS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = 4;
            sqYear = year - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getTdZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            sql = getTdZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.WHCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }
    private void createFcZsYdqc(int year,int month){
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.FCS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = 2;
            sqYear = year - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getFcZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            sql = getFcZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.WHCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }

    private String getTdSbYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int sqTotal = 4;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);

        String sql = "";

        if (ydType == Ydtype.HCH.toString()) {
            sql =   "INSERT INTO S_SJ_SBYDQC_TD(JBB_ID, GLBM, YNMJ, YJSE, SBSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, TDSBYD_ID, YDTYPE) " +
                    "SELECT a.*, b.TDDJ, c.NSRMC, c.SGY_DM AS SGYDM, c.ZGKG_DM AS SSJG, SUBSTR(c.ZGKG_DM, 2, 6) AS QXDM, '%d' AS SSNF, '%s' AS SSSQ, SYS_GUID() AS TDSBYD_ID, '%s' AS YDTYPE " +
                    "FROM ( " +
                    "      SELECT a.*, SBSE, (NVL(YJSE, 0) - NVL(SBSE, 0)) AS CYJE, " +
                    "             ROUND(DECODE(SIGN(NVL(YJSE, 0)), 1, (NVL(YJSE, 0) - NVL(SBSE, 0))/YJSE * 100, 0), 2) AS CYBL " +
                    "      FROM ( " +
                    "          SELECT c.JBB_ID, c.GLBM, SUM(YNMJ) AS YNMJ, SUM(NYNSE) / %d * %d AS YJSE " +
                    "          FROM SW_DJ_TD a LEFT JOIN SW_DJ_JBB c ON a.JBB_ID = c.JBB_ID " +
                    "          WHERE c.GLBM IS NOT NULL AND LENGTH(c.GLBM) = 9 " +
                    "          GROUP BY c.GLBM, c.JBB_ID " +
                    "        ) a LEFT JOIN ( " +
                    "          SELECT TaxRegCode, SUM(TAXFINAL) AS SBSE " +
                    "          FROM TB_LVY_DECLAREDATA " +
                    "          WHERE TaxTypeCode = %s AND (TO_CHAR(DECLAREDATE, 'YYYYMM') >= '%s' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= '%s') " +
                    "          GROUP BY TaxRegCode " +
                    "        ) b ON a.GLBM = b.TaxRegCode " +
                    "    ) a LEFT JOIN ( " +
                    "      SELECT JBB_ID, WM_CONCAT(DISTINCT TDDJ) AS TDDJ " +
                    "      FROM SW_DJ_TD " +
                    "      WHERE JBB_ID IN (SELECT JBB_ID FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) AND TDDJ IS NOT NULL AND TRIM(TDDJ) <> '' " +
                    "      GROUP BY JBB_ID " +
                    "    ) b ON a.JBB_ID = b.JBB_ID LEFT JOIN ( " +
                    "      SELECT * FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 " +
                    "    ) c ON a.JBB_ID = c.JBB_ID " +
                    "WHERE a.GLBM IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 MINUS SELECT GLBM FROM S_SJ_SBYDQC_TD WHERE SSSQ = '%s' AND SSNF = '%d') " +
                    "      AND (NOT (NVL(YJSE, 0) > 0 AND ABS(NVL(CYBL, 0)) < 0.01)) AND (NOT (NVL(YJSE, 0) <= 0 AND NVL(SBSE, 0) <= 0))";
            sql = String.format(sql, year, sssq, Ydtype.HCH.toString(), sqTotal, sqCount, Szdm.CZTDSYS.toString(), startRq, endRq, sssq, year);
        }
        else if (ydType == Ydtype.WHCH.toString()) {
            sql =   "INSERT INTO S_SJ_SBYDQC_TD(JBB_ID, GLBM, YNMJ, YJSE, SBSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, TDSBYD_ID, YDTYPE) " +
                    "SELECT NULL AS JBB_ID, GLBM, NULL AS YNMJ, NULL AS YJSE, SBSE, NULL AS CYJE, NULL AS CYBL, NULL AS TDDJ, NSRMC, NULL AS SGYDM, " +
                    "       LevyCode AS SSJG, SUBSTR(LevyCode, 2, 6) AS QXDM, '%d' AS SSNF, '%s' AS SSSQ, SYS_GUID() AS TDSBYD_ID, '%s' AS YDTYPE " +
                    "FROM ( " +
                    "       SELECT a.TaxRegCode GLBM, b.TaxPayerName NSRMC, b.LevyCode, SUM(a.TAXFINAL) AS SBSE " +
                    "       FROM TB_LVY_DECLAREDATA a LEFT JOIN tb_reg_taxpayerbasicinfo b " +
                    "       ON a.TaxRegCode=b.TaxRegCode " +
                    "       WHERE (TO_CHAR(DECLAREDATE, 'YYYYMM') >= '%s' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= '%s')' " +
                    "            AND a.TaxRegCode NOT LIKE 'T%%'  AND a.TaxTypeCode=%s " +
                    "            AND a.TaxRegCode NOT IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) " +
                    "            AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                    "       GROUP BY a.TaxRegCode, b.TaxPayerName, b.LevyCode " +
                    "     ) " +
                    "WHERE GLBM NOT IN (SELECT GLBM FROM S_SJ_SBYDQC_TD WHERE SSSQ = '%s' AND SSNF = '%d')";
            sql = String.format(sql, year, sssq, Ydtype.WHCH.toString(), startRq, endRq, Szdm.CZTDSYS.toString(), sssq, year);
        }

        return sql;
    }
    private String getFcSbYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int sqTotal = 2;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String sql = "";

        if (ydType == Ydtype.HCH.toString()) {
            sql =   "INSERT INTO S_SJ_SBYDQC_FC(JBB_ID, GLBM, YSZJ, YSYZ, YJSE, SBSE, CYJE, CYBL, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, FCSBYD_ID, YDTYPE) " +
                    "SELECT a.*, c.NSRMC, c.SGY_DM AS SGYDM, c.ZGKG_DM AS SSJG, SUBSTR(c.ZGKG_DM, 2, 6) AS QXDM, '%d' AS SSNF, '%s' AS SSSQ, SYS_GUID() AS FCSBYD_ID, '%s' AS YDTYPE " +
                    "FROM ( " +
                    "      SELECT a.*, SBSE, (NVL(YJSE, 0) - NVL(SBSE, 0)) AS CYJE, " +
                    "             ROUND(DECODE(SIGN(NVL(YJSE, 0)), 1, (NVL(YJSE, 0) - NVL(SBSE, 0))/YJSE * 100, 0), 2) AS CYBL " +
                    "      FROM ( " +
                    "          SELECT c.JBB_ID, c.GLBM, SUM(a.YNSE_CZ) AS YSZJ, SUM(a.FCYZ_YS) AS YSYZ, SUM(NYNSE) / %d * %d AS YJSE " +
                    "          FROM SW_DJ_FC a LEFT JOIN SW_DJ_JBB c ON a.JBB_ID = c.JBB_ID " +
                    "          WHERE c.GLBM IS NOT NULL AND LENGTH(c.GLBM) = 9 " +
                    "          GROUP BY c.GLBM, c.JBB_ID " +
                    "        ) a LEFT JOIN ( " +
                    "          SELECT TB_LVY_DECLAREDATA, SUM(TAXFINAL) AS SBSE " +
                    "          FROM tb_lvy_levydata " +
                    "          WHERE TaxTypeCode = %s AND (TO_CHAR(DECLAREDATE, 'YYYYMM') >= '%s' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= '%s') " +
                    "          GROUP BY TaxRegCode " +
                    "        ) b ON a.GLBM = b.TaxRegCode " +
                    "    ) a LEFT JOIN ( " +
                    "      SELECT * FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 " +
                    "    ) c ON a.JBB_ID = c.JBB_ID " +
                    "WHERE a.JBB_ID IN (SELECT JBB_ID FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 MINUS SELECT JBB_ID FROM S_SJ_SBYDQC_FC WHERE SSSQ = '%s' AND SSNF = '%d') " +
                    "      AND (NOT (NVL(YJSE, 0) > 0 AND ABS(NVL(CYBL, 0)) < 0.01)) AND (NOT (NVL(YJSE, 0) <= 0 AND NVL(SBSE, 0) <= 0))";
            sql = String.format(sql, year, sssq, Ydtype.HCH.toString(), sqTotal, sqCount, Szdm.FCS.toString(), startRq, endRq, sssq, year);
        }
        else if (ydType == Ydtype.WHCH.toString()) {
            sql =   "INSERT INTO S_SJ_SBYDQC_FC(JBB_ID, GLBM, YSZJ, YSYZ, YJSE, SBSE, CYJE, CYBL, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, FCSBYD_ID, YDTYPE) " +
                    "SELECT NULL AS JBB_ID, GLBM, NULL AS YSZJ, NULL AS YSYZ, NULL AS YJSE, SBSE, NULL AS CYJE, NULL AS CYBL, NSRMC, NULL AS SGYDM, " +
                    "       LevyCode AS SSJG, SUBSTR(LevyCode, 2, 6) AS QXDM, '%d' AS SSNF, '%s' AS SSSQ, SYS_GUID() AS FCSBYD_ID, '%s' AS YDTYPE " +
                    "FROM ( " +
                    "       SELECT a.TaxRegCode GLBM, b.TaxPayerName NSRMC, b.LevyCode, SUM(a.TAXFINAL) AS SBSE " +
                    "       FROM TB_LVY_DECLAREDATA a LEFT JOIN tb_reg_taxpayerbasicinfo b " +
                    "       ON a.TaxRegCode=b.TaxRegCode " +
                    "       WHERE (TO_CHAR(DECLAREDATE, 'YYYYMM') >= '%s' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= '%s') " +
                    "            AND a.TaxRegCode NOT LIKE 'T%%'  AND a.TaxTypeCode=%s " +
                    "            AND a.TaxRegCode NOT IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) " +
                    "            AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                    "       GROUP BY a.TaxRegCode, b.TaxPayerName, b.LevyCode " +
                    "     ) " +
                    "WHERE GLBM NOT IN (SELECT GLBM FROM S_SJ_SBYDQC_FC WHERE SSSQ = '%s' AND SSNF = '%d')";
            sql = String.format(sql, year, sssq, Ydtype.WHCH.toString(), startRq, endRq, Szdm.FCS.toString(), sssq, year);
        }

        return sql;
    }
    public String getTdZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int sqTotal = 4;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        if (ydType == Ydtype.HCH.toString()) {
            sql =   "INSERT INTO S_SJ_ZSYDQC_TD(JBB_ID, GLBM, YNMJ, YJSE, RKSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, TDZSYD_ID, YDTYPE) " +
                    "SELECT a.*, b.TDDJ, c.NSRMC, c.SGY_DM AS SGYDM, c.ZGKG_DM AS SSJG, SUBSTR(c.ZGKG_DM, 2, 6) AS QXDM, ':year' AS SSNF, ':sssq' AS SSSQ, SYS_GUID() AS TDZSYD_ID, ':ydtype' AS YDTYPE " +
                    "FROM ( " +
                    "      SELECT a.*, RKSE, (NVL(YJSE, 0) - NVL(RKSE, 0)) AS CYJE, " +
                    "             ROUND(DECODE(SIGN(NVL(YJSE, 0)), 1, (NVL(YJSE, 0) - NVL(RKSE, 0))/YJSE * 100, 0), 2) AS CYBL " +
                    "      FROM ( " +
                    "          SELECT c.JBB_ID, c.GLBM, SUM(YNMJ) AS YNMJ, SUM(NYNSE) / :sqTotal * :sqCount AS YJSE " +
                    "          FROM SW_DJ_TD a LEFT JOIN SW_DJ_JBB c ON a.JBB_ID = c.JBB_ID LEFT JOIN SW_DJ_SY d ON a.SY_ID = d.SY_ID " +
                    "          WHERE c.GLBM IS NOT NULL AND LENGTH(c.GLBM) = 9 AND d.SY_ID IS NOT NULL AND d.SYZT='1' " +
                    "          GROUP BY c.GLBM, c.JBB_ID " +
                    "        ) a LEFT JOIN ( " +
                    "          SELECT TaxRegCode, ROUND(SUM(TAXFINAL / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                    "          FROM ( " +
                    "                SELECT TaxRegCode, t.TAXFINAL, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqTotal) + 2) AS ENDNFSQ, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqTotal) + 2) AS STARTNFSQ " +
                    "                FROM tb_lvy_levydata t " +
                    "                WHERE TaxTypeCode = :szdm AND (TO_CHAR(DECLAREDATE, 'YYYYMM') >= ':startRq' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= ':endRq') AND LateFeeFlag <> '1' " +
                    "               ) " +
                    "          GROUP BY TaxRegCode " +
                    "        ) b ON a.GLBM = b.TaxRegCode " +
                    "    ) a LEFT JOIN ( " +
                    "      SELECT JBB_ID, WM_CONCAT(DISTINCT TDDJ) AS TDDJ " +
                    "      FROM SW_DJ_TD " +
                    "      WHERE JBB_ID IN (SELECT JBB_ID FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) AND TDDJ IS NOT NULL AND TRIM(TDDJ) <> '' " +
                    "      GROUP BY JBB_ID " +
                    "    ) b ON a.JBB_ID = b.JBB_ID LEFT JOIN ( " +
                    "      SELECT * FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 " +
                    "    ) c ON a.JBB_ID = c.JBB_ID " +
                    "WHERE a.GLBM IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 MINUS SELECT GLBM FROM S_SJ_ZSYDQC_TD WHERE SSSQ = ':sssq' AND SSNF = ':year') " +
                    "      AND (NOT (NVL(YJSE, 0) > 0 AND ABS(NVL(CYBL, 0)) < 0.01)) AND (NOT (NVL(YJSE, 0) <= 0 AND NVL(RKSE, 0) <= 0))";
        }
        else if (ydType == Ydtype.WHCH.toString()) {
            sql =   "INSERT INTO S_SJ_ZSYDQC_TD(JBB_ID, GLBM, YNMJ, YJSE, RKSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, TDZSYD_ID, YDTYPE) " +
                    "SELECT NULL AS JBB_ID, GLBM, NULL AS YNMJ, NULL AS YJSE, RKSE, NULL AS CYJE, NULL AS CYBL, NULL AS TDDJ, NSRMC, NULL AS SGYDM, " +
                    "       LevyCode AS SSJG, SUBSTR(LevyCode, 2, 6) AS QXDM, ':year' AS SSNF, ':sssq' AS SSSQ, SYS_GUID() AS TDZSYD_ID, ':ydtype' AS YDTYPE " +
                    "FROM ( " +
                    "       SELECT a.TaxRegCode GLBM, b.TaxPayerName NSRMC, b.LevyCode, " +
                    "              ROUND(SUM(TAXFINAL / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, :endNfSq) - GREATEST(STARTNFSQ, :startNfSq)), -1, 0,  LEAST(ENDNFSQ, :endNfSq) - GREATEST(STARTNFSQ, :startNfSq) + 1)), 2) AS RKSE " +
                    "          FROM ( " +
                    "                SELECT TaxRegCode, t.TAXFINAL, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqTotal) + 2) AS ENDNFSQ, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqTotal) + 2) AS STARTNFSQ " +
                    "                FROM tb_lvy_levydata t " +
                    "               ) a " +
                    "            LEFT JOIN tb_reg_taxpayerbasicinfo b " +
                    "       ON a.TaxRegCode=b.TaxRegCode " +
                    "       WHERE (TO_CHAR(DECLAREDATE, 'YYYYMM') >= ':startRq' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= ':endRq') AND LateFeeFlag <> '1' " +
                    "            AND a.TaxRegCode NOT LIKE 'T%'  AND a.TaxTypeCode=:szdm " +
                    "            AND a.TaxRegCode NOT IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) " +
                    "            AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                    "       GROUP BY a.TaxRegCode, b.TaxPayerName, b.LevyCode " +
                    "     ) " +
                    "WHERE GLBM NOT IN (SELECT GLBM FROM S_SJ_ZSYDQC_TD WHERE SSSQ = ':sssq' AND SSNF = ':year')";
        }
        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sssq", String.valueOf(sssq));
        sql = sql.replaceAll(":ydtype", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":szdm", Szdm.CZTDSYS.toString());
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);

        return sql;
    }
    public String getFcZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int sqTotal = 2;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        if (ydType == Ydtype.HCH.toString()) {
            sql =   "INSERT INTO S_SJ_ZSYDQC_FC(JBB_ID, GLBM, YSZJ, YSYZ, YJSE, RKSE, CYJE, CYBL, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, FCZSYD_ID, YDTYPE) " +
                    "SELECT a.*, c.NSRMC, c.SGY_DM AS SGYDM, c.ZGKG_DM AS SSJG, SUBSTR(c.ZGKG_DM, 2, 6) AS QXDM, ':year' AS SSNF, ':sssq' AS SSSQ, SYS_GUID() AS FCZSYD_ID, ':ydtype' AS YDTYPE " +
                    "FROM ( " +
                    "      SELECT a.*, RKSE, (NVL(YJSE, 0) - NVL(RKSE, 0)) AS CYJE, " +
                    "             ROUND(DECODE(SIGN(NVL(YJSE, 0)), 1, (NVL(YJSE, 0) - NVL(RKSE, 0))/YJSE * 100, 0), 2) AS CYBL " +
                    "      FROM ( " +
                    "          SELECT c.JBB_ID, c.GLBM, SUM(a.YNSE_CZ) AS YSZJ, SUM(a.FCYZ_YS) AS YSYZ, SUM(NYNSE) / :sqTotal * :sqCount AS YJSE " +
                    "          FROM SW_DJ_FC a LEFT JOIN SW_DJ_JBB c ON a.JBB_ID = c.JBB_ID LEFT JOIN SW_DJ_SY d ON a.SY_ID = d.SY_ID " +
                    "          WHERE c.GLBM IS NOT NULL AND LENGTH(c.GLBM) = 9 AND d.SY_ID IS NOT NULL AND d.SYZT='1' " +
                    "          GROUP BY c.GLBM, c.JBB_ID " +
                    "        ) a LEFT JOIN ( " +
                    "          SELECT TaxRegCode, ROUND(SUM(TAXFINAL / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                    "          FROM ( " +
                    "                SELECT TaxRegCode, t.TAXFINAL, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ " +
                    "                FROM tb_lvy_levydata t " +
                    "                WHERE TaxTypeCode = :szdm AND (TO_CHAR(DECLAREDATE, 'YYYYMM') >= ':startRq' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= ':endRq') AND LateFeeFlag <> '1' " +
                    "               ) " +
                    "          GROUP BY TaxRegCode " +
                    "        ) b ON a.GLBM = b.TaxRegCode " +
                    "    ) a LEFT JOIN ( " +
                    "      SELECT * FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 " +
                    "    ) c ON a.JBB_ID = c.JBB_ID " +
                    "WHERE a.JBB_ID IN (SELECT JBB_ID FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9 MINUS SELECT JBB_ID FROM S_SJ_ZSYDQC_FC WHERE SSSQ = ':sssq' AND SSNF = ':year') " +
                    "      AND (NOT (NVL(YJSE, 0) > 0 AND ABS(NVL(CYBL, 0)) < 0.01)) AND (NOT (NVL(YJSE, 0) <= 0 AND NVL(RKSE, 0) <= 0))";
        }
        else if (ydType == Ydtype.WHCH.toString()) {
            sql =   "INSERT INTO S_SJ_ZSYDQC_FC(JBB_ID, GLBM, YSZJ, YSYZ, YJSE, RKSE, CYJE, CYBL, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, FCZSYD_ID, YDTYPE) " +
                    "SELECT NULL AS JBB_ID, GLBM, NULL AS YSZJ, NULL AS YSYZ, NULL AS YJSE, RKSE, NULL AS CYJE, NULL AS CYBL, NSRMC, NULL AS SGYDM, " +
                    "       LevyCode AS SSJG, SUBSTR(LevyCode, 2, 6) AS QXDM, ':year' AS SSNF, ':sssq' AS SSSQ, SYS_GUID() AS FCZSYD_ID, ':ydtype' AS YDTYPE " +
                    "FROM ( " +
                    "       SELECT a.TaxRegCode GLBM, b.TaxPayerName NSRMC, b.LevyCode, " +
                    "              ROUND(SUM(TAXFINAL / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, :endNfSq) - GREATEST(STARTNFSQ, :startNfSq)), -1, 0,  LEAST(ENDNFSQ, :endNfSq) - GREATEST(STARTNFSQ, :startNfSq) + 1)), 2) AS RKSE " +
                    "          FROM ( " +
                    "                SELECT TaxRegCode, t.TAXFINAL, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqTotal) + 2) AS ENDNFSQ, " +
                    "                       (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqTotal) + 2) AS STARTNFSQ " +
                    "                FROM tb_lvy_levydata t " +
                    "               ) " +
                    "            LEFT JOIN tb_reg_taxpayerbasicinfo b " +
                    "       ON a.TaxRegCode=b.TaxRegCode " +
                    "       WHERE (TO_CHAR(DECLAREDATE, 'YYYYMM') >= ':startRq' AND TO_CHAR(DECLAREDATE, 'YYYYMM') <= ':endRq') AND LateFeeFlag <> '1' " +
                    "            AND a.TaxRegCode NOT LIKE 'T%'  AND a.TaxTypeCode=:szdm " +
                    "            AND a.TaxRegCode NOT IN (SELECT GLBM FROM SW_DJ_JBB WHERE GLBM IS NOT NULL AND LENGTH(GLBM) = 9) " +
                    "            AND LENGTH(TRIM(a.TaxRegCode)) = 9 " +
                    "       GROUP BY a.TaxRegCode, b.TaxPayerName, b.LevyCode " +
                    "     ) " +
                    "WHERE GLBM NOT IN (SELECT GLBM FROM S_SJ_ZSYDQC_FC WHERE SSSQ = ':sssq' AND SSNF = ':year')";
        }
        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sssq", String.valueOf(sssq));
        sql = sql.replaceAll(":ydtype", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":szdm", Szdm.FCS.toString());
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);

        return sql;
    }

}
