package cn.gtmap.landtax.print;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

import cn.gtmap.landtax.util.CommonUtil;
import org.apache.commons.lang.StringUtils;

import com.gtis.util.*;

public class VoXml {
	private Object vo = null;
	private HashMap<String, String> map = null;

	public VoXml() {
	}
	public VoXml(Object vo) {
		this.vo = vo;
	}

	public String getXMLData() {
		String retvalue = getXML();
		return retvalue;
	}
	
	public String getXMLDataByHashMap() {
		String retvalue = getXMLByHashMap();
		return retvalue;
	}
	
	private String getXMLByHashMap(){
		StringBuffer sb = new StringBuffer();
		try {
			if (map != null) {
				Iterator it = map.entrySet().iterator();
				while (it.hasNext()) {
					Entry entry = (Entry) it.next();
					Object key = entry.getKey();
					if (key != null && StringUtils.isNotBlank(key.toString())) {
						Object value = entry.getValue();
						String name = "";
						if (value != null && StringUtils.isNotBlank(value.toString())) {
							name = value.toString();
						}
						if(name.indexOf(">")>-1||name.indexOf("<")>-1){
							StringBuffer sbName= new StringBuffer();
							for(int i=0;i<name.length();i++){
								if(name.charAt(i)=='<'){
									sbName.append('＜');
								}else if(name.charAt(i)=='>'){
									sbName.append('＞');
								}else{
									sbName.append(name.charAt(i));
								}
							}
							name=sbName.toString();
						}
						if (name.equals("0") || name.equals("0.0")) {
							name = "";
						}
						String datastr = "<data name=\"" + key.toString().trim() + "\" type=\"String\">" + name + "</data>";
						sb.append(datastr);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();
	}

	/**
	 * 获取对象所有的字段
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private List getFields() {
		List list = new ArrayList();
		Field[] ffields = vo.getClass().getDeclaredFields();
		int fieldcount = ffields.length;
		for (int i = 0; i < fieldcount; i++) {
			Field aField = ffields[i];
			String fieldname = aField.getName();
			/** 将字段前字母小写更新为大写* */
			fieldname = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
			list.add(fieldname);
		}
		return list;
	}

	/** 将VO中的数据转换成XML格式* */
	private String getXML() {

		StringBuffer sb = new StringBuffer();
		List list = getFields();
		Iterator it = list.iterator();
		while (it.hasNext()) {
			String fieldname = (String) it.next();
			String methodname = "get" + fieldname;
			Method method = getMethod(methodname);
			/** 如果方法存在，则进行下一步处理* */
			if (method != null) {
				String datastr = "";
				String fieldtype = getFiledType(method);
				String name = getValue(method, fieldtype.trim());
				if(name.indexOf(">")>-1||name.indexOf("<")>-1){
					StringBuffer sbName= new StringBuffer();
					for(int i=0;i<name.length();i++){
						if(name.charAt(i)=='<'){
							sbName.append('＜');
						}else if(name.charAt(i)=='>'){
							sbName.append('＞');
						}else{
							sbName.append(name.charAt(i));
						}
					}
					name=sbName.toString();
				}
				datastr = "<data name=\"" + fieldname.trim() + "\" type=\"String\">" + name + "</data>";
				sb.append(datastr);
			}
		}

		return sb.toString();
	}

	/** 获取方法* */
	private Method getMethod(String methodName) {
		Method method = null;
		try {
			method = vo.getClass().getDeclaredMethod(methodName, new Class[] {});
		} catch (Exception e) {
			methodName = "get"+methodName.substring(3,4).toLowerCase()+methodName.substring(4,methodName.length());
			try {
				method = vo.getClass().getDeclaredMethod(methodName, new Class[] {});
			} catch (Exception e2) {
				e.printStackTrace();
			}
		}
		return method;
	}

	/** 获取值* */
	private String getValue(Method method, String fieldtype) {
		String retvalue = null;
		Object retobj = null;
		try {
			retobj = method.invoke(vo, null);
		} catch (Exception e) {
			e.printStackTrace();
		}

		if (retobj == null)
			retvalue = "";
		else if (fieldtype.equals("String"))
			retvalue = (String) retobj;
		else if (fieldtype.equals("int")) {
			int temp = (Integer) retobj;
			retvalue = Integer.toString(temp);
		} else if (fieldtype.equals("Boolean")) {
			Boolean temp = (Boolean) retobj;
			retvalue = Boolean.toString(temp);
		} else if (fieldtype.equals("float")) {
			float temp = (Float) retobj;
			retvalue = Float.toString(temp);
		} else if (fieldtype.equalsIgnoreCase("double")) {
			double temp = (Double) retobj;
			if (temp == 0) 
				retvalue = "";
			else
				retvalue = CommonUtil.DoubleToString(temp, 4, false);
		} else if (fieldtype.equals("BigDecimal")) {
			BigDecimal temp = (BigDecimal) retobj;
			retvalue = temp.toString();
		} else if (fieldtype.equals("Long")) {
			long temp = (Long) retobj;
			retvalue = Long.toString(temp);
		} else if (fieldtype.equals("short")) {
			short temp = (Short) retobj;
			retvalue = Short.toString(temp);
		} else if (fieldtype.equals("byte")) {
			byte temp = (Byte) retobj;
			retvalue = Byte.toString(temp);
		} else if (fieldtype.equals("Integer")) {
			Integer tempInt = (Integer) retobj;
			retvalue = String.valueOf(tempInt.intValue());
		} else if (fieldtype.equals("Date")) {
			SimpleDateFormat sdf;
			Date tempInt = (Date) retobj;
			int hours = tempInt.getHours();
			if (hours>0){
				sdf = new SimpleDateFormat("yyyy年MM月dd日HH:mm");
//				if (hours>12){
//					tempInt.setHours(hours - 12);
//					sdf = new SimpleDateFormat("yyyy年MM月dd日 下午hh:mm");
//				}
//				else
//				sdf = new SimpleDateFormat("yyyy年MM月dd日 上午hh:mm");	
			}
			else{
				sdf = new SimpleDateFormat("yyyy年MM月dd日");
			}
			retvalue = String.valueOf(sdf.format(tempInt));
		} else {
			retvalue = "";
		}

		return retvalue;
	}

	/** 获取字段类型* */
	private String getFiledType(Method method) {
		String fieldtype = method.getReturnType().toString();
		int pos = fieldtype.lastIndexOf(".");
		if (pos > 0)
			fieldtype = fieldtype.substring(pos + 1);
		return fieldtype;
	}

	public void setMap(HashMap<String, String> map) {
		this.map = map;
	}
	
//	public static void main(String[] args){
//		String str="aaa";
//		
//		str.replace("aa", "b");
//		System.out.println(str);
//	}
	
}
