package cn.gtmap.landtax.model.query;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 税源查询类
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/4
 */
public class SwDjSyQuery {
    //基本的Id和主键
    private String syId;
    private String jbbId;
    private String tdId;
    private String fcId;
    private String gdId;
    private String bpId;

    //税源基本信息
    private String sysjly;
    private String djh;
    private String dbh;
    private String syzt;
    private String tdyt;
    private String tdytMc;
    private String qlrmc;
    private String tdzh;
    private BigDecimal scmjZd;
    private String czrmc;
    private String czrzjhm;
    private String fczl;
    private String tdzl;
    private String zdsybz;
    private String msbz;
    private String sgztDm;
    private String sgztMc;
    private String bz;
    private String ishc;

    //纳税人基本信息
    private String glbm;
    private String nsrmc;
    private String zgkgDm;
    private String zgkgMc;
    private String sgkgMc;
    private String sgyDm;
    private String sgyMc;
    private String fddbr;
    private String lxdh;
    private String zclxDm;
    private String zclxMc;
    private String hyDm;
    private String hyMc;
    private String zcdz;

    //土地数据
    private String tdsyztDm;
    private String tdsyztMc;
    private BigDecimal fzmj;
    private BigDecimal scmj;
    private String tddj;
    private String tddjMc;
    private BigDecimal msmj;
    private BigDecimal ynmj;
    private BigDecimal dwse;
    private BigDecimal nynseTd;
    private String tdsyqlx;
    private String tdsyqlxMc;
    private BigDecimal zdmj;
    private BigDecimal msse;
    private String tdsyzh;
    private String tdqdfsDm;
    private String tdqdfsMc;
    private String tdsyytDm;
    private String tdsyytMc;
    private BigDecimal dj;
    private BigDecimal qdsyqzfje;
    private BigDecimal tdkfcb;
    private Date csqdsj;
    private Date syqzzsj;
    private String tdjmxzdm;

    //房产数据
    private String fczh;
    private BigDecimal fcmj;
    private String fwxzDm;
    private String fwxzMc;
    private String zyhczDm;
    private String zyhczMc;
    private BigDecimal fwjz;
    private BigDecimal tdjz;
    private BigDecimal fssbjz;
    private BigDecimal fcyz;
    private BigDecimal fcyzYs;
    private BigDecimal fcyzMs;
    private BigDecimal ynseZy;
    private BigDecimal ynseCz;
    private BigDecimal nzj;
    private BigDecimal nynseFc;
    private BigDecimal sl;
    private String xzqdm;
    private BigDecimal qzczfcmj;

    private String shxrId;

    private String qx;
    private String jd;
    private String jf;
    private BigDecimal nynseTdBegin;
    private BigDecimal nynseTdEnd;
    private BigDecimal nynseFcBegin;
    private BigDecimal nynseFcEnd;
    private BigDecimal czfcyz;
    private BigDecimal jsbl;
    private String fcjmxzdm;

    //免税认定土地,房产
    //土地
    private String tdMsrdId;
    private Date tdMssjBegin;
    private Date tdMssjEnd;
    private String tdBlzt;
    private BigDecimal tdSqMsmj;
    private BigDecimal tdRdhSyysmj;
    private BigDecimal tdRdhNynse;
    private String tdMsyy;
    private Date tdBjTime;
    private String tdRwId;
    //房产
    private String fcMsrdId;
    private Date fcMssjBegin;
    private Date fcMssjEnd;
    private String fcBlzt;
    private BigDecimal fcSqMsyz;
    private BigDecimal fcRdhSyysyz;
    private BigDecimal fcRdhNynse;
    private String fcMsyy;
    private Date fcBjTime;
    private String fcRwId;
    private String sjly;
    private String gtzdbyzyy;
    private String fczlXian;
    private String fczlZhen;
    private String fczlLu;
    private String fczlHao;
    private String fczlDong;
    private String fczlDy;
    private String fczlLou;
    private String fczlShi;


    //征管系统数据
    //sb_rkss 入库税收表
    private BigDecimal tdyjne;//土地已缴纳额
    private BigDecimal tdqje;//土地欠缴额
    private BigDecimal tdqjbl;//土地欠缴比列
    private BigDecimal fcyjne;//房产已缴纳额
    private BigDecimal fcqje;//房产欠缴额
    private BigDecimal fcqjbl;//房产欠缴比列

    private BigDecimal nynse;
    private BigDecimal sbse;
    private BigDecimal cyje;

    //征管系统数据
    //sb_yzss 申报税收表
    private String sbNum;
    private Date fsrq;//申报日期
    private String szdm;//税种代码
    private BigDecimal nse;//应纳税额

    //是否是免税台帐
    private Boolean isMsTz;//

    private Date sqUpdateDateBegin;
    private Date sqUpdateDateEnd;
    private Date bqUpdateDateBegin;
    private Date bqUpdateDateEnd;


    //批次信息
    private String pcId;
    private String pcmc;
    private String pwh;
    private BigDecimal pzmj;
    private BigDecimal nydmj;
    private Date pzsj;
    private String pcYddw;
    private String pcXzqdm;
    private String pcTdzl;
    //项目信息
    private String xmId;
    private String xmmc;
    private BigDecimal gdmj;
    private String qdfs;
    private BigDecimal qdjg;
    private Date gdsj;
    private String xmTdyt;
    private String xmTdytMc;
    private String xmYddw;
    private String xmXzqdm;
    private String xmTdzl;
    //耕地占用税信息
    private String gdzysId;
    private String gdzysSzly;
    private BigDecimal gdzysYnse;
    private BigDecimal gdzysDwse;
    private String gdzysJmxz;
    private String gdzysJspz;
    private BigDecimal gdzysYjne;
    private BigDecimal gdzysXbjse;
    private String gdzysBz;
    private Date gdzysLrrq;
    private String gdzysHclx;
    private String gdzysZt;
    private BigDecimal gdzysJmse;
    //契税信息
    private String qsId;
    private String qsSzly;
    private BigDecimal qsYnse;
    private BigDecimal qsYjne;
    private String qsJmxz;
    private String qsJspz;
    private BigDecimal qsXbjse;
    private String qsBz;
    private Date qsLrrq;
    private String qsHclx;
    private String qsZt;
    private Date xgrqBegin;
    private Date xgrqEnd;
    private BigDecimal qsJmse;

    private String hclx;
    private String gjzt;
    private Boolean isZdsy;//用于判断是不是重点税源

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public String getJbbId() {
        return jbbId;
    }

    public void setJbbId(String jbbId) {
        this.jbbId = jbbId;
    }

    public String getTdId() {
        return tdId;
    }

    public void setTdId(String tdId) {
        this.tdId = tdId;
    }

    public String getFcId() {
        return fcId;
    }

    public void setFcId(String fcId) {
        this.fcId = fcId;
    }

    public String getGdId() {
        return gdId;
    }

    public void setGdId(String gdId) {
        this.gdId = gdId;
    }

    public String getBpId() {
        return bpId;
    }

    public void setBpId(String bpId) {
        this.bpId = bpId;
    }

    public String getSysjly() {
        return sysjly;
    }

    public void setSysjly(String sysjly) {
        this.sysjly = sysjly;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public String getSgztDm() {
        return sgztDm;
    }

    public void setSgztDm(String sgztDm) {
        this.sgztDm = sgztDm;
    }

    public String getFddbr() {
        return fddbr;
    }

    public void setFddbr(String fddbr) {
        this.fddbr = fddbr;
    }

    public String getFczl() {
        return fczl;
    }

    public void setFczl(String fczl) {
        this.fczl = fczl;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getZdsybz() {
        return zdsybz;
    }

    public void setZdsybz(String zdsybz) {
        this.zdsybz = zdsybz;
    }

    public String getMsbz() {
        return msbz;
    }

    public void setMsbz(String msbz) {
        this.msbz = msbz;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }


    public BigDecimal getScmjZd() {
        return scmjZd;
    }

    public void setScmjZd(BigDecimal scmjZd) {
        this.scmjZd = scmjZd;
    }

    public String getCzrmc() {
        return czrmc;
    }

    public void setCzrmc(String czrmc) {
        this.czrmc = czrmc;
    }

    public String getCzrzjhm() {
        return czrzjhm;
    }

    public void setCzrzjhm(String czrzjhm) {
        this.czrzjhm = czrzjhm;
    }

    public String getZgkgDm() {
        return zgkgDm;
    }

    public void setZgkgDm(String zgkgDm) {
        this.zgkgDm = zgkgDm;
    }

    public String getSgkgMc() {
        return sgkgMc;
    }

    public void setSgkgMc(String sgkgMc) {
        this.sgkgMc = sgkgMc;
    }

    public String getSgyDm() {
        return sgyDm;
    }

    public void setSgyDm(String sgyDm) {
        this.sgyDm = sgyDm;
    }

    public String getSgyMc() {
        return sgyMc;
    }

    public void setSgyMc(String sgyMc) {
        this.sgyMc = sgyMc;
    }

    public String getLxdh() {
        return lxdh;
    }

    public void setLxdh(String lxdh) {
        this.lxdh = lxdh;
    }

    public String getZclxDm() {
        return zclxDm;
    }

    public void setZclxDm(String zclxDm) {
        this.zclxDm = zclxDm;
    }

    public String getZclxMc() {
        return zclxMc;
    }

    public void setZclxMc(String zclxMc) {
        this.zclxMc = zclxMc;
    }

    public String getHyDm() {
        return hyDm;
    }

    public void setHyDm(String hyDm) {
        this.hyDm = hyDm;
    }

    public String getHyMc() {
        return hyMc;
    }

    public void setHyMc(String hyMc) {
        this.hyMc = hyMc;
    }

    public String getZcdz() {
        return zcdz;
    }

    public void setZcdz(String zcdz) {
        this.zcdz = zcdz;
    }

    public String getTdsyztDm() {
        return tdsyztDm;
    }

    public void setTdsyztDm(String tdsyztDm) {
        this.tdsyztDm = tdsyztDm;
    }

    public BigDecimal getFzmj() {
        return fzmj;
    }

    public void setFzmj(BigDecimal fzmj) {
        this.fzmj = fzmj;
    }

    public String getTddj() {
        return tddj;
    }

    public void setTddj(String tddj) {
        this.tddj = tddj;
    }

    public BigDecimal getMsmj() {
        return msmj;
    }

    public void setMsmj(BigDecimal msmj) {
        this.msmj = msmj;
    }

    public BigDecimal getYnmj() {
        return ynmj;
    }

    public void setYnmj(BigDecimal ynmj) {
        this.ynmj = ynmj;
    }

    public BigDecimal getDwse() {
        return dwse;
    }

    public void setDwse(BigDecimal dwse) {
        this.dwse = dwse;
    }

    public BigDecimal getNynseTd() {
        return nynseTd;
    }

    public void setNynseTd(BigDecimal nynseTd) {
        this.nynseTd = nynseTd;
    }

    public BigDecimal getNynseFc() {
        return nynseFc;
    }

    public void setNynseFc(BigDecimal nynseFc) {
        this.nynseFc = nynseFc;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public BigDecimal getFcmj() {
        return fcmj;
    }

    public void setFcmj(BigDecimal fcmj) {
        this.fcmj = fcmj;
    }

    public String getFwxzDm() {
        return fwxzDm;
    }

    public void setFwxzDm(String fwxzDm) {
        this.fwxzDm = fwxzDm;
    }

    public String getZyhczDm() {
        return zyhczDm;
    }

    public void setZyhczDm(String zyhczDm) {
        this.zyhczDm = zyhczDm;
    }

    public BigDecimal getFwjz() {
        return fwjz;
    }

    public void setFwjz(BigDecimal fwjz) {
        this.fwjz = fwjz;
    }

    public BigDecimal getTdjz() {
        return tdjz;
    }

    public void setTdjz(BigDecimal tdjz) {
        this.tdjz = tdjz;
    }

    public BigDecimal getFssbjz() {
        return fssbjz;
    }

    public void setFssbjz(BigDecimal fssbjz) {
        this.fssbjz = fssbjz;
    }

    public BigDecimal getFcyz() {
        return fcyz;
    }

    public void setFcyz(BigDecimal fcyz) {
        this.fcyz = fcyz;
    }

    public BigDecimal getFcyzYs() {
        return fcyzYs;
    }

    public void setFcyzYs(BigDecimal fcyzYs) {
        this.fcyzYs = fcyzYs;
    }

    public BigDecimal getFcyzMs() {
        return fcyzMs;
    }

    public void setFcyzMs(BigDecimal fcyzMs) {
        this.fcyzMs = fcyzMs;
    }

    public BigDecimal getYnseZy() {
        return ynseZy;
    }

    public void setYnseZy(BigDecimal ynseZy) {
        this.ynseZy = ynseZy;
    }

    public BigDecimal getYnseCz() {
        return ynseCz;
    }

    public void setYnseCz(BigDecimal ynseCz) {
        this.ynseCz = ynseCz;
    }

    public BigDecimal getNzj() {
        return nzj;
    }

    public void setNzj(BigDecimal nzj) {
        this.nzj = nzj;
    }

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public String getXzqdm() {
        return xzqdm;
    }

    public void setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
    }

    public String getSyzt() {
        return syzt;
    }

    public void setSyzt(String syzt) {
        this.syzt = syzt;
    }

    public String getZgkgMc() {
        return zgkgMc;
    }

    public void setZgkgMc(String zgkgMc) {
        this.zgkgMc = zgkgMc;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTdsyqlx(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public String getShxrId() {
        return shxrId;
    }

    public void setShxrId(String shxrId) {
        this.shxrId = shxrId;
    }

    public String getSgztMc() {
        return sgztMc;
    }

    public void setSgztMc(String sgztMc) {
        this.sgztMc = sgztMc;
    }

    public String getTdytMc() {
        return tdytMc;
    }

    public void setTdytMc(String tdytMc) {
        this.tdytMc = tdytMc;
    }

    public String getTdsyqlxMc() {
        return tdsyqlxMc;
    }

    public void setTdsyqlxMc(String tdsyqlxMc) {
        this.tdsyqlxMc = tdsyqlxMc;
    }

    public String getTdsyztMc() {
        return tdsyztMc;
    }

    public void setTdsyztMc(String tdsyztMc) {
        this.tdsyztMc = tdsyztMc;
    }

    public String getTddjMc() {
        return tddjMc;
    }

    public void setTddjMc(String tddjMc) {
        this.tddjMc = tddjMc;
    }

    public String getFwxzMc() {
        return fwxzMc;
    }

    public void setFwxzMc(String fwxzMc) {
        this.fwxzMc = fwxzMc;
    }

    public String getZyhczMc() {
        return zyhczMc;
    }

    public void setZyhczMc(String zyhczMc) {
        this.zyhczMc = zyhczMc;
    }

    public String getQx() {
        return qx;
    }

    public void setQx(String qx) {
        this.qx = qx;
    }

    public BigDecimal getNynseTdBegin() {
        return nynseTdBegin;
    }

    public void setNynseTdBegin(BigDecimal nynseTdBegin) {
        this.nynseTdBegin = nynseTdBegin;
    }

    public BigDecimal getNynseTdEnd() {
        return nynseTdEnd;
    }

    public void setNynseTdEnd(BigDecimal nynseTdEnd) {
        this.nynseTdEnd = nynseTdEnd;
    }

    public BigDecimal getNynseFcBegin() {
        return nynseFcBegin;
    }

    public void setNynseFcBegin(BigDecimal nynseFcBegin) {
        this.nynseFcBegin = nynseFcBegin;
    }

    public BigDecimal getNynseFcEnd() {
        return nynseFcEnd;
    }

    public void setNynseFcEnd(BigDecimal nynseFcEnd) {
        this.nynseFcEnd = nynseFcEnd;
    }

    public String getTdMsrdId() {
        return tdMsrdId;
    }

    public void setTdMsrdId(String tdMsrdId) {
        this.tdMsrdId = tdMsrdId;
    }

    public Date getTdMssjBegin() {
        return tdMssjBegin;
    }

    public void setTdMssjBegin(Date tdMssjBegin) {
        this.tdMssjBegin = tdMssjBegin;
    }

    public Date getTdMssjEnd() {
        return tdMssjEnd;
    }

    public void setTdMssjEnd(Date tdMssjEnd) {
        this.tdMssjEnd = tdMssjEnd;
    }

    public String getTdBlzt() {
        return tdBlzt;
    }

    public void setTdBlzt(String tdBlzt) {
        this.tdBlzt = tdBlzt;
    }

    public BigDecimal getTdSqMsmj() {
        return tdSqMsmj;
    }

    public void setTdSqMsmj(BigDecimal tdSqMsmj) {
        this.tdSqMsmj = tdSqMsmj;
    }

    public BigDecimal getTdRdhSyysmj() {
        return tdRdhSyysmj;
    }

    public void setTdRdhSyysmj(BigDecimal tdRdhSyysmj) {
        this.tdRdhSyysmj = tdRdhSyysmj;
    }

    public BigDecimal getTdRdhNynse() {
        return tdRdhNynse;
    }

    public void setTdRdhNynse(BigDecimal tdRdhNynse) {
        this.tdRdhNynse = tdRdhNynse;
    }

    public String getTdMsyy() {
        return tdMsyy;
    }

    public void setTdMsyy(String tdMsyy) {
        this.tdMsyy = tdMsyy;
    }

    public Date getTdBjTime() {
        return tdBjTime;
    }

    public void setTdBjTime(Date tdBjTime) {
        this.tdBjTime = tdBjTime;
    }

    public String getTdRwId() {
        return tdRwId;
    }

    public void setTdRwId(String tdRwId) {
        this.tdRwId = tdRwId;
    }

    public String getFcMsrdId() {
        return fcMsrdId;
    }

    public void setFcMsrdId(String fcMsrdId) {
        this.fcMsrdId = fcMsrdId;
    }

    public Date getFcMssjBegin() {
        return fcMssjBegin;
    }

    public void setFcMssjBegin(Date fcMssjBegin) {
        this.fcMssjBegin = fcMssjBegin;
    }

    public Date getFcMssjEnd() {
        return fcMssjEnd;
    }

    public void setFcMssjEnd(Date fcMssjEnd) {
        this.fcMssjEnd = fcMssjEnd;
    }

    public String getFcBlzt() {
        return fcBlzt;
    }

    public void setFcBlzt(String fcBlzt) {
        this.fcBlzt = fcBlzt;
    }

    public BigDecimal getFcSqMsyz() {
        return fcSqMsyz;
    }

    public void setFcSqMsyz(BigDecimal fcSqMsyz) {
        this.fcSqMsyz = fcSqMsyz;
    }

    public BigDecimal getFcRdhSyysyz() {
        return fcRdhSyysyz;
    }

    public void setFcRdhSyysyz(BigDecimal fcRdhSyysyz) {
        this.fcRdhSyysyz = fcRdhSyysyz;
    }

    public BigDecimal getFcRdhNynse() {
        return fcRdhNynse;
    }

    public void setFcRdhNynse(BigDecimal fcRdhNynse) {
        this.fcRdhNynse = fcRdhNynse;
    }

    public String getFcMsyy() {
        return fcMsyy;
    }

    public void setFcMsyy(String fcMsyy) {
        this.fcMsyy = fcMsyy;
    }

    public Date getFcBjTime() {
        return fcBjTime;
    }

    public void setFcBjTime(Date fcBjTime) {
        this.fcBjTime = fcBjTime;
    }

    public String getFcRwId() {
        return fcRwId;
    }

    public void setFcRwId(String fcRwId) {
        this.fcRwId = fcRwId;
    }

    public BigDecimal getSl() {
        return sl;
    }

    public void setSl(BigDecimal sl) {
        this.sl = sl;
    }

    public String getSjly() {
        return sjly;
    }

    public void setSjly(String sjly) {
        this.sjly = sjly;
    }

    public BigDecimal getZdmj() {
        return zdmj;
    }

    public void setZdmj(BigDecimal zdmj) {
        this.zdmj = zdmj;
    }

    public String getIshc() {
        return ishc;
    }

    public void setIshc(String ishc) {
        this.ishc = ishc;
    }

    public String getGtzdbyzyy() {
        return gtzdbyzyy;
    }

    public void setGtzdbyzyy(String gtzdbyzyy) {
        this.gtzdbyzyy = gtzdbyzyy;
    }



    public String getJd() {
        return jd;
    }

    public void setJd(String jd) {
        this.jd = jd;
    }

    public String getJf() {
        return jf;
    }

    public void setJf(String jf) {
        this.jf = jf;
    }

    public BigDecimal getTdyjne() {
        return tdyjne;
    }

    public void setTdyjne(BigDecimal tdyjne) {
        this.tdyjne = tdyjne;
    }

    public BigDecimal getTdqje() {
        return tdqje;
    }

    public void setTdqje(BigDecimal tdqje) {
        this.tdqje = tdqje;
    }

    public BigDecimal getTdqjbl() {
        return tdqjbl;
    }

    public void setTdqjbl(BigDecimal tdqjbl) {
        this.tdqjbl = tdqjbl;
    }

    public BigDecimal getFcyjne() {
        return fcyjne;
    }

    public void setFcyjne(BigDecimal fcyjne) {
        this.fcyjne = fcyjne;
    }

    public BigDecimal getFcqje() {
        return fcqje;
    }

    public void setFcqje(BigDecimal fcqje) {
        this.fcqje = fcqje;
    }

    public BigDecimal getFcqjbl() {
        return fcqjbl;
    }

    public void setFcqjbl(BigDecimal fcqjbl) {
        this.fcqjbl = fcqjbl;
    }

    public BigDecimal getNynse() {
        return nynse;
    }

    public void setNynse(BigDecimal nynse) {
        this.nynse = nynse;
    }

    public BigDecimal getSbse() {
        return sbse;
    }

    public void setSbse(BigDecimal sbse) {
        this.sbse = sbse;
    }

    public BigDecimal getCyje() {
        return cyje;
    }

    public void setCyje(BigDecimal cyje) {
        this.cyje = cyje;
    }

    public String getSbNum() {
        return sbNum;
    }

    public void setSbNum(String sbNum) {
        this.sbNum = sbNum;
    }

    public Date getFsrq() {
        return fsrq;
    }

    public void setFsrq(Date fsrq) {
        this.fsrq = fsrq;
    }

    public String getSzdm() {
        return szdm;
    }

    public void setSzdm(String szdm) {
        this.szdm = szdm;
    }

    public BigDecimal getNse() {
        return nse;
    }

    public void setNse(BigDecimal nse) {
        this.nse = nse;
    }

    public Boolean getIsMsTz() {
        return isMsTz;
    }

    public void setIsMsTz(Boolean isMsTz) {
        this.isMsTz = isMsTz;
    }

    public Date getSqUpdateDateBegin() {
        return sqUpdateDateBegin;
    }

    public void setSqUpdateDateBegin(Date sqUpdateDateBegin) {
        this.sqUpdateDateBegin = sqUpdateDateBegin;
    }

    public Date getSqUpdateDateEnd() {
        return sqUpdateDateEnd;
    }

    public void setSqUpdateDateEnd(Date sqUpdateDateEnd) {
        this.sqUpdateDateEnd = sqUpdateDateEnd;
    }

    public Date getBqUpdateDateBegin() {
        return bqUpdateDateBegin;
    }

    public void setBqUpdateDateBegin(Date bqUpdateDateBegin) {
        this.bqUpdateDateBegin = bqUpdateDateBegin;
    }

    public Date getBqUpdateDateEnd() {
        return bqUpdateDateEnd;
    }

    public void setBqUpdateDateEnd(Date bqUpdateDateEnd) {
        this.bqUpdateDateEnd = bqUpdateDateEnd;
    }

    public BigDecimal getMsse() {
        return msse;
    }

    public void setMsse(BigDecimal msse) {
        this.msse = msse;
    }

    public String getTdsyzh() {
        return tdsyzh;
    }

    public void setTdsyzh(String tdsyzh) {
        this.tdsyzh = tdsyzh;
    }

    public String getTdqdfsDm() {
        return tdqdfsDm;
    }

    public void setTdqdfsDm(String tdqdfsDm) {
        this.tdqdfsDm = tdqdfsDm;
    }

    public String getTdqdfsMc() {
        return tdqdfsMc;
    }

    public void setTdqdfsMc(String tdqdfsMc) {
        this.tdqdfsMc = tdqdfsMc;
    }

    public String getTdsyytDm() {
        return tdsyytDm;
    }

    public void setTdsyytDm(String tdsyytDm) {
        this.tdsyytDm = tdsyytDm;
    }

    public String getTdsyytMc() {
        return tdsyytMc;
    }

    public void setTdsyytMc(String tdsyytMc) {
        this.tdsyytMc = tdsyytMc;
    }

    public BigDecimal getDj() {
        return dj;
    }

    public void setDj(BigDecimal dj) {
        this.dj = dj;
    }

    public BigDecimal getQdsyqzfje() {
        return qdsyqzfje;
    }

    public void setQdsyqzfje(BigDecimal qdsyqzfje) {
        this.qdsyqzfje = qdsyqzfje;
    }

    public BigDecimal getTdkfcb() {
        return tdkfcb;
    }

    public void setTdkfcb(BigDecimal tdkfcb) {
        this.tdkfcb = tdkfcb;
    }

    public Date getCsqdsj() {
        return csqdsj;
    }

    public void setCsqdsj(Date csqdsj) {
        this.csqdsj = csqdsj;
    }

    public Date getSyqzzsj() {
        return syqzzsj;
    }

    public void setSyqzzsj(Date syqzzsj) {
        this.syqzzsj = syqzzsj;
    }

    public String getTdjmxzdm() {
        return tdjmxzdm;
    }

    public void setTdjmxzdm(String tdjmxzdm) {
        this.tdjmxzdm = tdjmxzdm;
    }

    public BigDecimal getCzfcyz() {
        return czfcyz;
    }

    public void setCzfcyz(BigDecimal czfcyz) {
        this.czfcyz = czfcyz;
    }

    public BigDecimal getJsbl() {
        return jsbl;
    }

    public void setJsbl(BigDecimal jsbl) {
        this.jsbl = jsbl;
    }

    public String getFcjmxzdm() {
        return fcjmxzdm;
    }

    public void setFcjmxzdm(String fcjmxzdm) {
        this.fcjmxzdm = fcjmxzdm;
    }

    public String getPcId() {
        return pcId;
    }

    public void setPcId(String pcId) {
        this.pcId = pcId;
    }

    public String getPcmc() {
        return pcmc;
    }

    public void setPcmc(String pcmc) {
        this.pcmc = pcmc;
    }

    public String getPwh() {
        return pwh;
    }

    public void setPwh(String pwh) {
        this.pwh = pwh;
    }

    public BigDecimal getPzmj() {
        return pzmj;
    }

    public void setPzmj(BigDecimal pzmj) {
        this.pzmj = pzmj;
    }

    public BigDecimal getNydmj() {
        return nydmj;
    }

    public void setNydmj(BigDecimal nydmj) {
        this.nydmj = nydmj;
    }

    public Date getPzsj() {
        return pzsj;
    }

    public void setPzsj(Date pzsj) {
        this.pzsj = pzsj;
    }

    public String getPcYddw() {
        return pcYddw;
    }

    public void setPcYddw(String pcYddw) {
        this.pcYddw = pcYddw;
    }

    public String getPcXzqdm() {
        return pcXzqdm;
    }

    public void setPcXzqdm(String pcXzqdm) {
        this.pcXzqdm = pcXzqdm;
    }

    public String getXmId() {
        return xmId;
    }

    public void setXmId(String xmId) {
        this.xmId = xmId;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public BigDecimal getGdmj() {
        return gdmj;
    }

    public void setGdmj(BigDecimal gdmj) {
        this.gdmj = gdmj;
    }

    public String getQdfs() {
        return qdfs;
    }

    public void setQdfs(String qdfs) {
        this.qdfs = qdfs;
    }

    public BigDecimal getQdjg() {
        return qdjg;
    }

    public void setQdjg(BigDecimal qdjg) {
        this.qdjg = qdjg;
    }

    public Date getGdsj() {
        return gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    public String getXmTdyt() {
        return xmTdyt;
    }

    public void setXmTdyt(String xmTdyt) {
        this.xmTdyt = xmTdyt;
    }

    public String getXmYddw() {
        return xmYddw;
    }

    public void setXmYddw(String xmYddw) {
        this.xmYddw = xmYddw;
    }

    public String getXmXzqdm() {
        return xmXzqdm;
    }

    public void setXmXzqdm(String xmXzqdm) {
        this.xmXzqdm = xmXzqdm;
    }

    public String getGdzysId() {
        return gdzysId;
    }

    public void setGdzysId(String gdzysId) {
        this.gdzysId = gdzysId;
    }

    public String getGdzysSzly() {
        return gdzysSzly;
    }

    public void setGdzysSzly(String gdzysSzly) {
        this.gdzysSzly = gdzysSzly;
    }

    public BigDecimal getGdzysYnse() {
        return gdzysYnse;
    }

    public void setGdzysYnse(BigDecimal gdzysYnse) {
        this.gdzysYnse = gdzysYnse;
    }

    public BigDecimal getGdzysDwse() {
        return gdzysDwse;
    }

    public void setGdzysDwse(BigDecimal gdzysDwse) {
        this.gdzysDwse = gdzysDwse;
    }

    public String getGdzysJmxz() {
        return gdzysJmxz;
    }

    public void setGdzysJmxz(String gdzysJmxz) {
        this.gdzysJmxz = gdzysJmxz;
    }

    public String getGdzysJspz() {
        return gdzysJspz;
    }

    public void setGdzysJspz(String gdzysJspz) {
        this.gdzysJspz = gdzysJspz;
    }

    public BigDecimal getGdzysYjne() {
        return gdzysYjne;
    }

    public void setGdzysYjne(BigDecimal gdzysYjne) {
        this.gdzysYjne = gdzysYjne;
    }

    public BigDecimal getGdzysXbjse() {
        return gdzysXbjse;
    }

    public void setGdzysXbjse(BigDecimal gdzysXbjse) {
        this.gdzysXbjse = gdzysXbjse;
    }

    public String getGdzysBz() {
        return gdzysBz;
    }

    public void setGdzysBz(String gdzysBz) {
        this.gdzysBz = gdzysBz;
    }

    public Date getGdzysLrrq() {
        return gdzysLrrq;
    }

    public void setGdzysLrrq(Date gdzysLrrq) {
        this.gdzysLrrq = gdzysLrrq;
    }

    public String getQsId() {
        return qsId;
    }

    public void setQsId(String qsId) {
        this.qsId = qsId;
    }

    public String getQsSzly() {
        return qsSzly;
    }

    public void setQsSzly(String qsSzly) {
        this.qsSzly = qsSzly;
    }

    public BigDecimal getQsYnse() {
        return qsYnse;
    }

    public void setQsYnse(BigDecimal qsYnse) {
        this.qsYnse = qsYnse;
    }

    public BigDecimal getQsYjne() {
        return qsYjne;
    }

    public void setQsYjne(BigDecimal qsYjne) {
        this.qsYjne = qsYjne;
    }

    public String getQsJmxz() {
        return qsJmxz;
    }

    public void setQsJmxz(String qsJmxz) {
        this.qsJmxz = qsJmxz;
    }

    public String getQsJspz() {
        return qsJspz;
    }

    public void setQsJspz(String qsJspz) {
        this.qsJspz = qsJspz;
    }

    public BigDecimal getQsXbjse() {
        return qsXbjse;
    }

    public void setQsXbjse(BigDecimal qsXbjse) {
        this.qsXbjse = qsXbjse;
    }

    public String getQsBz() {
        return qsBz;
    }

    public void setQsBz(String qsBz) {
        this.qsBz = qsBz;
    }

    public Date getQsLrrq() {
        return qsLrrq;
    }

    public void setQsLrrq(Date qsLrrq) {
        this.qsLrrq = qsLrrq;
    }

    public String getGdzysHclx() {
        return gdzysHclx;
    }

    public void setGdzysHclx(String gdzysHclx) {
        this.gdzysHclx = gdzysHclx;
    }

    public String getQsHclx() {
        return qsHclx;
    }

    public void setQsHclx(String qsHclx) {
        this.qsHclx = qsHclx;
    }

    public String getGdzysZt() {
        return gdzysZt;
    }

    public void setGdzysZt(String gdzysZt) {
        this.gdzysZt = gdzysZt;
    }

    public String getQsZt() {
        return qsZt;
    }

    public void setQsZt(String qsZt) {
        this.qsZt = qsZt;
    }

    public BigDecimal getQzczfcmj() {
        return qzczfcmj;
    }

    public void setQzczfcmj(BigDecimal qzczfcmj) {
        this.qzczfcmj = qzczfcmj;
    }

    public String getFczlXian() {
        return fczlXian;
    }

    public void setFczlXian(String fczlXian) {
        this.fczlXian = fczlXian;
    }

    public String getFczlZhen() {
        return fczlZhen;
    }

    public void setFczlZhen(String fczlZhen) {
        this.fczlZhen = fczlZhen;
    }

    public String getFczlLu() {
        return fczlLu;
    }

    public void setFczlLu(String fczlLu) {
        this.fczlLu = fczlLu;
    }

    public String getFczlHao() {
        return fczlHao;
    }

    public void setFczlHao(String fczlHao) {
        this.fczlHao = fczlHao;
    }

    public String getFczlDong() {
        return fczlDong;
    }

    public void setFczlDong(String fczlDong) {
        this.fczlDong = fczlDong;
    }

    public String getFczlDy() {
        return fczlDy;
    }

    public void setFczlDy(String fczlDy) {
        this.fczlDy = fczlDy;
    }

    public String getFczlLou() {
        return fczlLou;
    }

    public void setFczlLou(String fczlLou) {
        this.fczlLou = fczlLou;
    }

    public String getFczlShi() {
        return fczlShi;
    }

    public void setFczlShi(String fczlShi) {
        this.fczlShi = fczlShi;
    }

    public String getXmTdzl() {
        return xmTdzl;
    }

    public void setXmTdzl(String xmTdzl) {
        this.xmTdzl = xmTdzl;
    }

    public String getXmTdytMc() {
        return xmTdytMc;
    }

    public void setXmTdytMc(String xmTdytMc) {
        this.xmTdytMc = xmTdytMc;
    }

    public String getPcTdzl() {
        return pcTdzl;
    }

    public void setPcTdzl(String pcTdzl) {
        this.pcTdzl = pcTdzl;
    }

    public Date getXgrqBegin() {
        return xgrqBegin;
    }

    public void setXgrqBegin(Date xgrqBegin) {
        this.xgrqBegin = xgrqBegin;
    }

    public Date getXgrqEnd() {
        return xgrqEnd;
    }

    public void setXgrqEnd(Date xgrqEnd) {
        this.xgrqEnd = xgrqEnd;
    }

    public BigDecimal getGdzysJmse() {
        return gdzysJmse;
    }

    public void setGdzysJmse(BigDecimal gdzysJmse) {
        this.gdzysJmse = gdzysJmse;
    }

    public BigDecimal getQsJmse() {
        return qsJmse;
    }

    public void setQsJmse(BigDecimal qsJmse) {
        this.qsJmse = qsJmse;
    }

    public String getHclx() {
        return hclx;
    }

    public void setHclx(String hclx) {
        this.hclx = hclx;
    }

    public String getGjzt() {
        return gjzt;
    }

    public void setGjzt(String gjzt) {
        this.gjzt = gjzt;
    }

    public Boolean getIsZdsy() {
        return isZdsy;
    }

    public void setIsZdsy(Boolean isZdsy) {
        this.isZdsy = isZdsy;
    }
}

