package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 城镇土地用途
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/12/5
 */
public enum  Tdyt {
    GY("01", "工业"),
    SY("02", "商业"),
    JZ("03", "居住"),
    ZH("04", "综合"),
    KFYT("05", "房地产开发企业的开发用地"),
    QT("06", "其他");

    private String dm;
    private String mc;

    private Tdyt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }


    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    @Override
    public String toString() {
        return dm;
    }
    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdyt[] tdyts = Tdyt.values();
            for(int i=0;i<tdyts.length;i++){
                if(tdyts[i].getDm().equals(StringUtils.trim(dm))){
                    return tdyts[i].getMc();
                }
            }
        }
        return null;
    }
}
