package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Tdsyzt {
    ZYJY("01", "自用经营"),
    ZYFJY("02", "自用非经营"),
    CZ("03", "出租"),
    QT("04", "其他"),
    BFZYCZ("05", "部分自用部分出租");
    private String dm;
    private String mc;

    private Tdsyzt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdsyzt[] Tdsyzts = Tdsyzt.values();
            for(int i=0;i<Tdsyzts.length;i++){
                if(Tdsyzts[i].getDm().equals(StringUtils.trim(dm))){
                    return Tdsyzts[i].getMc();
                }
            }
        }
        return null;
    }
}
