package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Tdjb {

    YIDD("1", "一等地"),
    ERDD("2", "二等地"),
    SANDD("3", "三等地"),
    SIDD("4", "四等地"),
    WUDD("5", "五等地"),
    LIUDD("6", "六等地"),
    QIDD("7", "七等地"),
    BADD("8", "八等地"),
    JIUDD("9", "九等地");
    private String dm;
    private String mc;

    private Tdjb(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdjb[] Tdjbs = Tdjb.values();
            for(int i=0;i<Tdjbs.length;i++){
                if(Tdjbs[i].getDm().equals(StringUtils.trim(dm))){
                    return Tdjbs[i].getMc();
                }
            }
        }
        return null;
    }


}
