package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
public enum Nsrzt {
    DJ("10", "登记"),
    ZC("20", "正常"),
    TY("30", "停业"),
    FZC("40", "非正常"),
    ZX("50", "注销"),
    LSNSR("70", "临时纳税人"),
    SWJG("81", "税务机构"),
    TSNSR("99", "特殊纳税人");
    private String dm;
    private String mc;

    private Nsrzt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Nsrzt[] Byzyys = Nsrzt.values();
            for(int i=0;i<Byzyys.length;i++){
                if(Byzyys[i].getDm().equals(StringUtils.trim(dm))){
                    return Byzyys[i].getMc();
                }
            }
        }
        return null;
    }
}
