package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 税源状态
 * Created by xuchao on 2014/8/22.
 */
public enum Jmxzqs {

    DM15011602("15011602","玉树地震灾后恢复重建-财税〔2010〕59号"),
    DM15011603("15011603","支持舟曲灾后恢复重建-财税〔2010〕107号"),
    DM15011604("15011604","支持芦山地震灾后恢复重建-财税〔2013〕58号"),
    DM15011605("15011605","真落实抗震救灾及灾后重建-财税〔2008〕62号"),
    DM15011701("15011701","调整房地产交易环节-财税〔2008〕137号"),
    DM15011702("15011702","调整房地产市场若干税收政策-财税字〔1999〕210号"),
    DM15011703("15011703","公有制单位职工首次购买住房-财税〔2000〕130号"),
    DM15011704("15011704","国有土地使用权出让-财税〔2004〕134号"),
    DM15011705("15011705","廉租住房经济适用住房和住房租赁-财税〔2008〕24号"),
    DM15011706("15011706","免征军建离退休干部住房移交地方政府管理-财税字〔2000〕176号"),
    DM15011707("15011707","支持公共租赁住房建设和运营-财税〔2010〕88号"),
    DM15011708("15011708","自然人与其个人独资企业或一人有限责任公司之间土地房屋权属划转一-财税〔2008〕142号"),
    DM15011709("15011709","调整房地产财税交易环节契税个人所得税优惠政策-〔2010〕94号"),
    DM15011710("15011710","契税暂行条例-国务院令〔1997〕第224号"),
    DM15011712("15011712","棚户区改造-财税〔2013〕101号"),
    DM15033301("15033301","青藏铁路公司运营期间-财税〔2007〕11号"),
    DM15052501("15052501","中国邮政集团公司邮政速递物流业务重组改制过程-财税〔2010〕92号"),
    DM15052504("15052504","中国联合网络通信集团有限公司重组过程-财税〔2010〕87号"),
    DM15052505("15052505","企业事业单位改制重组-财税〔2012〕4号"),
    DM15052506("15052506","中国邮政储蓄银行改制上市-财税〔2013〕53号"),
    DM15059901("15059901","企业改制重组若干契税政策- 财税〔2008〕175号"),
    DM15081501("15081501","外国银行分行改制为外商独资-财税〔2007〕45号"),
    DM15083901("15083901","4家资产管理公司接收资本金项下的资产-财税〔2003〕21号"),
    DM15083902("15083902","中国信达等4家金融资产管理-财税〔2001〕10号"),
    DM15083905("15083905","中国信达资产管理股份有限公司等4家金融资产管理公司-财税〔2013〕56号"),
    DM15092301("15092301","农村饮水安全工程建设运营- 财税〔2012〕30号"),
    DM15101401("15101401","教育税收政策-财税〔2004〕39号"),
    DM15101402("15101402","社会力量办学-财税〔2001〕156号"),
    DM15129901("15129901","房屋土地权属由夫妻一方所有变更为夫妻双方共有-财税〔2011〕82号"),
    DM15129902("15129902","企业以售后回租方式进行融资-财税〔2012〕82号"),
    DM15129903("15129903","契税暂行条例-国务院令〔1997〕第224号"),
    DM15129904("15129904","廉租住房经济适用住房和住房租赁- 财税〔2008〕24号"),
    DM15129999("15129999","其他"),
    DM15129998("15129998","条例规定免税");

    private String dm;
    private String mc;

    private Jmxzqs(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getDm() {
        return dm;
    }

    public void setDm(String dm) {
        this.dm = dm;
    }

    public String getMc() {
        return mc;
    }

    public void setMc(String mc) {
        this.mc = mc;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Jmxzqs[] Jmxzqss = Jmxzqs.values();
            for(int i=0;i<Jmxzqss.length;i++){
                if(Jmxzqss[i].getDm().equals(StringUtils.trim(dm))){
                    return Jmxzqss[i].getMc();
                }
            }
        }
        return null;
    }
}
