package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 是否税源核查
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Hclx {
    SDHC("01", "实地核查"),
    ATHC("02", "案头核查");
    private String dm;
    private String mc;

    private Hclx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }
    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }
    @Override
    public String toString() {
        return dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Hclx[] Ishcs = Hclx.values();
            for(int i=0;i<Ishcs.length;i++){
                if(Ishcs[i].getDm().equals(StringUtils.trim(dm))){
                    return Ishcs[i].getMc();
                }
            }
        }
        return null;
    }
}
