package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/4/16
 */
public enum Gtlx {
    ZD("1", "宗地"),
    GD("2", "供地"),
    BP("3", "报批");
    private String dm;
    private String mc;

    private Gtlx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm) {
        if (StringUtils.isNotBlank(dm)) {
            Gtlx[] gtlxs = Gtlx.values();
            for (int i = 0; i < gtlxs.length; i++) {
                if (gtlxs[i].getDm().equals(StringUtils.trim(dm))) {
                    return gtlxs[i].getMc();
                }
            }
        }
        return null;
    }
}
