package cn.gtmap.landtax.entity;

import cn.gtmap.landtax.util.QueryCondition;

import java.util.List;


public class TjBaseParamVo implements Comparable<TjBaseParamVo> {
    /**
     * 标识符
     */
	private String tag;

    /**
     * 统计报表查询数据的sql语句
     */
	private String sql;

    /**
     * 查询实体类的className，跟sql二选一即可
     * 不建议使用实体类统计报表时允许数据导出，效率太低
     */
    private String entityName;

    /**
     * 针对实体类查询数据的过滤条件配制
     */
    private List<QueryCondition> queryConditionList;

    /**
     * 查询实体类用的排序
     */
    private String orderBy;

    /**
     * 报表的列配置文件，jqGrid的配置文件
     */
    private String colJson;

    /**
     * 报表名称
     */
    private String reportName;

    /**
     * 导出Excel的模板文件
     * 已废弃，打印直接设置参数needExport为true
     */
    private String excelTemplate;

    /**
     * 导出Excel格式配置文件路径
     * 已废弃，打印直接设置参数needExport为true
     */
    private String excelXml;

    /**
     * 顶部查询页面配置文件路径
     */
    private String headPageFile;

    /**
     * 导出Excel时导出的数据列
     * 已废弃，打印直接设置参数needExport为true
     */
    private String exportFieldList;

    /**
     * 是否需要导出，true为支持导出，false不支持导出
     */
    private boolean needExport;    // 是否需要导出

    /**
     * 统计图表的配置参数
     */
    private List<ChartBaseParamVo> chartBaseParamVoList; // 统计图配置参数

    /**
     * 该参数用来控制是否一页显示所有记录
     * true表示一页显示所有记录
     * false表示分页显示记录，默认false
     * */
    private boolean allRowShowOnePage;

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getSql() {
        return sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getEntityName() {
        return entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public List<QueryCondition> getQueryConditionList() {
        return queryConditionList;
    }

    public void setQueryConditionList(List<QueryCondition> queryConditionList) {
        this.queryConditionList = queryConditionList;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getColJson() {
        return colJson;
    }

    public void setColJson(String colJson) {
        this.colJson = colJson;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getExcelTemplate() {
        return excelTemplate;
    }

    public void setExcelTemplate(String excelTemplate) {
        this.excelTemplate = excelTemplate;
    }

    public String getExcelXml() {
        return excelXml;
    }

    public void setExcelXml(String excelXml) {
        this.excelXml = excelXml;
    }

    public String getHeadPageFile() {
        return headPageFile;
    }

    public void setHeadPageFile(String headPageFile) {
        this.headPageFile = headPageFile;
    }

    public String getExportFieldList() {
        return exportFieldList;
    }

    public void setExportFieldList(String exportFieldList) {
        this.exportFieldList = exportFieldList;
    }

    public boolean isNeedExport() {
        return needExport;
    }

    public void setNeedExport(boolean needExport) {
        this.needExport = needExport;
    }

    public List<ChartBaseParamVo> getChartBaseParamVoList() {
        return chartBaseParamVoList;
    }

    public void setChartBaseParamVoList(List<ChartBaseParamVo> chartBaseParamVoList) {
        this.chartBaseParamVoList = chartBaseParamVoList;
    }

    public boolean isAllRowShowOnePage() {
        return allRowShowOnePage;
    }

    public void setAllRowShowOnePage(boolean allRowShowOnePage) {
        this.allRowShowOnePage = allRowShowOnePage;
    }

    /**
	 * 参数显示数据
	 * @return
    */
	public TjBaseParamVo() {
		super();
	}

	public int compareTo(TjBaseParamVo arg0) {
		if (arg0 == null) {
			return 1;
		}else {
			return this.getTag().compareTo(arg0.getTag());
		}

	}
}
