package cn.gtmap.landtax.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税源临时表
 * Created by Administrator on 2014/8/26.
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY_TEMP")
public class SwDjSyTemp implements Serializable {

    //基本的Id和主键
    @Id
    @Column
    private String  proid;
    @Column
    private String syId;
    @Column
    private String jbbId;
    @Column
    private String tdId;
    @Column
    private String fcId;
    @Column
    private String gdId;
    @Column
    private String bpId;
    @Column(name="sjly")
    private String sysjly;

    //税源基本信息
    @Column
    private String djh;
    @Column
    private String dbh;
    @Column
    private String syzt;
    @Column
    private String tdyt;
    @Column
    private String qlrmc;
    @Column(name = "tdzh")
    private String tdsyzh;
    @Column
    private BigDecimal scmjZd;
    @Column
    private String czrmc;
    @Column
    private String czrzjhm;
    @Column
    private String fczl;
    @Column
    private String tdzl;
    @Column
    private String zdsybz;
    @Column
    private String msbz;
    @Column
    private String sgztDm;
    @Column
    private String bz;

    //纳税人基本信息
    @Column
    private String glbm;
    @Column
    private String nsrmc;
    @Column
    private String zgkgDm;
    @Column
    private String zgkgMc;
    @Column
    private String sgyDm;
    @Column
    private String sgyMc;
    @Column
    private String fddbr;
    @Column
    private String lxdh;
    @Column
    private String zclxDm;
    @Column
    private String zclxMc;
    @Column
    private String hyDm;
    @Column
    private String hyMc;
    @Column
    private String zcdz;

    //土地数据
    @Column
    private String tdsyztDm;
    @Column
    private BigDecimal fzmj;
    @Column
    private BigDecimal scmj;
    @Column
    private String tddj;
    @Column
    private BigDecimal msmj;
    @Column
    private BigDecimal ynmj;
    @Column
    private BigDecimal dwse;
    @Column
    private BigDecimal nynseTd;
    @Column
    private String tdsyqlx;

    @Column
    private String gtzdbyzyy;

    //房产数据
    @Column
    private String fczh;
    @Column
    private BigDecimal fcmj;
    @Column
    private String fwxzDm;
    @Column
    private String zyhczDm;
    @Column
    private BigDecimal fwjz;
    @Column
    private BigDecimal tdjz;
    @Column
    private BigDecimal fssbjz;
    @Column
    private BigDecimal fcyz;
    @Column
    private BigDecimal fcyzYs;
    @Column
    private BigDecimal fcyzMs;
    @Column
    private BigDecimal ynseZy;
    @Column
    private BigDecimal ynseCz;
    @Column
    private BigDecimal nzj;
    @Column
    private BigDecimal nynseFc;
    @Column
    private String xzqdm;
    @Column
    private String rwid;
    @Column
    private Date tdMssjBegin;
    @Column
    private Date tdMssjEnd;
    @Column
    private String tdMsyy;
    @Column
    private Date fcMssjBegin;
    @Column
    private Date fcMssjEnd;
    @Column
    private String fcMsyy;
    @Column
    private String ishc;//是否进行了税源核查(0:为何查。1：已核查)
    @Column
    private BigDecimal sl;

    @Column
    private String byzyy;

    @Column
    private String tdqdfsDm;//土地取得方式
    @Column
    private String tdsyytDm;//土地使用用途代码
    @Column
    private BigDecimal dj;
    @Column
    private BigDecimal qdsyqzfje;
    @Column
    private BigDecimal tdkfcb;
    @Column
    private Date csqdsj;
    @Column
    private Date syqzzsj;
    @Column
    private String tdjmxzdm;
    @Column
    private BigDecimal czfcyz;
    @Column
    private BigDecimal jsbl;
    @Column
    private String fcjmxzdm;
    @Column
    private String fczlXian;
    @Column
    private String fczlZhen;
    @Column
    private String fczlLu;
    @Column
    private String fczlHao;
    @Column
    private String fczlDong;
    @Column
    private String fczlDy;
    @Column
    private String fczlLou;
    @Column
    private String fczlShi;


    //耕地占用税信息
    @Column
    private String gdzysId;
    @Column
    private String gdzysSzly;
    @Column
    private BigDecimal gdzysYnse;
    @Column
    private BigDecimal gdzysDwse;
    @Column
    private String gdzysJmxz;
    @Column
    private BigDecimal gdzysJmse;
    @Column
    private String gdzysJspz;
    @Column
    private BigDecimal gdzysYjne;
    @Column
    private BigDecimal gdzysXbjse;
    @Column
    private String gdzysBz;
    @Column
    private Date gdzysLrrq;
    @Column
    private String gdzysHclx;

    //契税信息
    @Column
    private String qsId;
    @Column
    private String qsSzly;
    @Column
    private BigDecimal qsYnse;
    @Column
    private BigDecimal qsYjne;
    @Column
    private String qsJmxz;
    @Column
    private BigDecimal qsJmse;
    @Column
    private String qsJspz;
    @Column
    private BigDecimal qsXbjse;
    @Column
    private String qsBz;
    @Column
    private Date qsLrrq;
    @Column
    private String qsHclx;
    @Column
    private String pcTdzl;


    public String getGdId() {
        return gdId;
    }

    public void setGdId(String gdId) {
        this.gdId = gdId;
    }

    public String getBpId() {
        return bpId;
    }

    public void setBpId(String bpId) {
        this.bpId = bpId;
    }

    public String getSysjly() {
        return sysjly;
    }

    public void setSysjly(String sysjly) {
        this.sysjly = sysjly;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public String getJbbId() {
        return jbbId;
    }

    public void setJbbId(String jbbId) {
        this.jbbId = jbbId;
    }

    public String getTdId() {
        return tdId;
    }

    public void setTdId(String tdId) {
        this.tdId = tdId;
    }

    public String getFcId() {
        return fcId;
    }

    public void setFcId(String fcId) {
        this.fcId = fcId;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public String getSgztDm() {
        return sgztDm;
    }

    public void setSgztDm(String sgztDm) {
        this.sgztDm = sgztDm;
    }

    public String getFddbr() {
        return fddbr;
    }

    public void setFddbr(String fddbr) {
        this.fddbr = fddbr;
    }

    public String getFczl() {
        return fczl;
    }

    public void setFczl(String fczl) {
        this.fczl = fczl;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getZdsybz() {
        return zdsybz;
    }

    public void setZdsybz(String zdsybz) {
        this.zdsybz = zdsybz;
    }

    public String getMsbz() {
        return msbz;
    }

    public void setMsbz(String msbz) {
        this.msbz = msbz;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }


    public BigDecimal getScmjZd() {
        return scmjZd;
    }

    public void setScmjZd(BigDecimal scmjZd) {
        this.scmjZd = scmjZd;
    }

    public String getCzrmc() {
        return czrmc;
    }

    public void setCzrmc(String czrmc) {
        this.czrmc = czrmc;
    }

    public String getCzrzjhm() {
        return czrzjhm;
    }

    public void setCzrzjhm(String czrzjhm) {
        this.czrzjhm = czrzjhm;
    }

    public String getZgkgDm() {
        return zgkgDm;
    }

    public void setZgkgDm(String zgkgDm) {
        this.zgkgDm = zgkgDm;
    }

    public String getSgyDm() {
        return sgyDm;
    }

    public void setSgyDm(String sgyDm) {
        this.sgyDm = sgyDm;
    }

    public String getSgyMc() {
        return sgyMc;
    }

    public void setSgyMc(String sgyMc) {
        this.sgyMc = sgyMc;
    }

    public String getLxdh() {
        return lxdh;
    }

    public void setLxdh(String lxdh) {
        this.lxdh = lxdh;
    }

    public String getZclxDm() {
        return zclxDm;
    }

    public void setZclxDm(String zclxDm) {
        this.zclxDm = zclxDm;
    }

    public String getZclxMc() {
        return zclxMc;
    }

    public void setZclxMc(String zclxMc) {
        this.zclxMc = zclxMc;
    }

    public String getHyDm() {
        return hyDm;
    }

    public void setHyDm(String hyDm) {
        this.hyDm = hyDm;
    }

    public String getHyMc() {
        return hyMc;
    }

    public void setHyMc(String hyMc) {
        this.hyMc = hyMc;
    }

    public String getZcdz() {
        return zcdz;
    }

    public void setZcdz(String zcdz) {
        this.zcdz = zcdz;
    }

    public String getTdsyztDm() {
        return tdsyztDm;
    }

    public void setTdsyztDm(String tdsyztDm) {
        this.tdsyztDm = tdsyztDm;
    }

    public BigDecimal getFzmj() {
        return fzmj;
    }

    public void setFzmj(BigDecimal fzmj) {
        this.fzmj = fzmj;
    }

    public String getTddj() {
        return tddj;
    }

    public void setTddj(String tddj) {
        this.tddj = tddj;
    }

    public BigDecimal getMsmj() {
        return msmj;
    }

    public void setMsmj(BigDecimal msmj) {
        this.msmj = msmj;
    }

    public BigDecimal getYnmj() {
        return ynmj;
    }

    public void setYnmj(BigDecimal ynmj) {
        this.ynmj = ynmj;
    }

    public BigDecimal getDwse() {
        return dwse;
    }

    public void setDwse(BigDecimal dwse) {
        this.dwse = dwse;
    }

    public BigDecimal getNynseTd() {
        return nynseTd;
    }

    public void setNynseTd(BigDecimal nynseTd) {
        this.nynseTd = nynseTd;
    }

    public BigDecimal getNynseFc() {
        return nynseFc;
    }

    public void setNynseFc(BigDecimal nynseFc) {
        this.nynseFc = nynseFc;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public BigDecimal getFcmj() {
        return fcmj;
    }

    public void setFcmj(BigDecimal fcmj) {
        this.fcmj = fcmj;
    }

    public String getFwxzDm() {
        return fwxzDm;
    }

    public void setFwxzDm(String fwxzDm) {
        this.fwxzDm = fwxzDm;
    }

    public String getZyhczDm() {
        return zyhczDm;
    }

    public void setZyhczDm(String zyhczDm) {
        this.zyhczDm = zyhczDm;
    }

    public BigDecimal getFwjz() {
        return fwjz;
    }

    public void setFwjz(BigDecimal fwjz) {
        this.fwjz = fwjz;
    }

    public BigDecimal getTdjz() {
        return tdjz;
    }

    public void setTdjz(BigDecimal tdjz) {
        this.tdjz = tdjz;
    }

    public BigDecimal getFssbjz() {
        return fssbjz;
    }

    public void setFssbjz(BigDecimal fssbjz) {
        this.fssbjz = fssbjz;
    }

    public BigDecimal getFcyz() {
        return fcyz;
    }

    public void setFcyz(BigDecimal fcyz) {
        this.fcyz = fcyz;
    }

    public BigDecimal getFcyzYs() {
        return fcyzYs;
    }

    public void setFcyzYs(BigDecimal fcyzYs) {
        this.fcyzYs = fcyzYs;
    }

    public BigDecimal getFcyzMs() {
        return fcyzMs;
    }

    public void setFcyzMs(BigDecimal fcyzMs) {
        this.fcyzMs = fcyzMs;
    }

    public BigDecimal getYnseZy() {
        return ynseZy;
    }

    public void setYnseZy(BigDecimal ynseZy) {
        this.ynseZy = ynseZy;
    }

    public BigDecimal getYnseCz() {
        return ynseCz;
    }

    public void setYnseCz(BigDecimal ynseCz) {
        this.ynseCz = ynseCz;
    }

    public BigDecimal getNzj() {
        return nzj;
    }

    public void setNzj(BigDecimal nzj) {
        this.nzj = nzj;
    }

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public String getXzqdm() {
        return xzqdm;
    }

    public void setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
    }

    public String getSyzt() {
        return syzt;
    }

    public void setSyzt(String syzt) {
        this.syzt = syzt;
    }

    public String getZgkgMc() {
        return zgkgMc;
    }

    public void setZgkgMc(String zgkgMc) {
        this.zgkgMc = zgkgMc;
    }

    public String getTdsyzh() {
        return tdsyzh;
    }

    public void setTdsyzh(String tdsyzh) {
        this.tdsyzh = tdsyzh;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTdsyqlx(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getRwid() {
        return rwid;
    }

    public void setRwid(String rwid) {
        this.rwid = rwid;
    }

    public Date getTdMssjBegin() {
        return tdMssjBegin;
    }

    public void setTdMssjBegin(Date tdMssjBegin) {
        this.tdMssjBegin = tdMssjBegin;
    }

    public Date getTdMssjEnd() {
        return tdMssjEnd;
    }

    public void setTdMssjEnd(Date tdMssjEnd) {
        this.tdMssjEnd = tdMssjEnd;
    }

    public String getTdMsyy() {
        return tdMsyy;
    }

    public void setTdMsyy(String tdMsyy) {
        this.tdMsyy = tdMsyy;
    }

    public Date getFcMssjBegin() {
        return fcMssjBegin;
    }

    public void setFcMssjBegin(Date fcMssjBegin) {
        this.fcMssjBegin = fcMssjBegin;
    }

    public Date getFcMssjEnd() {
        return fcMssjEnd;
    }

    public void setFcMssjEnd(Date fcMssjEnd) {
        this.fcMssjEnd = fcMssjEnd;
    }

    public String getFcMsyy() {
        return fcMsyy;
    }

    public void setFcMsyy(String fcMsyy) {
        this.fcMsyy = fcMsyy;
    }

    public String getIshc() {
        return ishc;
    }

    public void setIshc(String ishc) {
        this.ishc = ishc;
    }

    public BigDecimal getSl() {
        return sl;
    }

    public void setSl(BigDecimal sl) {
        this.sl = sl;
    }

    public String getByzyy() {
        return byzyy;
    }

    public void setByzyy(String byzyy) {
        this.byzyy = byzyy;
    }



    public String getTdqdfsDm() {
        return tdqdfsDm;
    }

    public void setTdqdfsDm(String tdqdfsDm) {
        this.tdqdfsDm = tdqdfsDm;
    }

    public String getTdsyytDm() {
        return tdsyytDm;
    }

    public void setTdsyytDm(String tdsyytDm) {
        this.tdsyytDm = tdsyytDm;
    }

    public BigDecimal getDj() {
        return dj;
    }

    public void setDj(BigDecimal dj) {
        this.dj = dj;
    }

    public BigDecimal getQdsyqzfje() {
        return qdsyqzfje;
    }

    public void setQdsyqzfje(BigDecimal qdsyqzfje) {
        this.qdsyqzfje = qdsyqzfje;
    }

    public BigDecimal getTdkfcb() {
        return tdkfcb;
    }

    public void setTdkfcb(BigDecimal tdkfcb) {
        this.tdkfcb = tdkfcb;
    }

    public Date getCsqdsj() {
        return csqdsj;
    }

    public void setCsqdsj(Date csqdsj) {
        this.csqdsj = csqdsj;
    }

    public Date getSyqzzsj() {
        return syqzzsj;
    }

    public void setSyqzzsj(Date syqzzsj) {
        this.syqzzsj = syqzzsj;
    }

    public String getTdjmxzdm() {
        return tdjmxzdm;
    }

    public void setTdjmxzdm(String tdjmxzdm) {
        this.tdjmxzdm = tdjmxzdm;
    }

    public BigDecimal getCzfcyz() {
        return czfcyz;
    }

    public void setCzfcyz(BigDecimal czfcyz) {
        this.czfcyz = czfcyz;
    }

    public BigDecimal getJsbl() {
        return jsbl;
    }

    public void setJsbl(BigDecimal jsbl) {
        this.jsbl = jsbl;
    }

    public String getFcjmxzdm() {
        return fcjmxzdm;
    }

    public void setFcjmxzdm(String fcjmxzdm) {
        this.fcjmxzdm = fcjmxzdm;
    }

    public String getGdzysId() {
        return gdzysId;
    }

    public void setGdzysId(String gdzysId) {
        this.gdzysId = gdzysId;
    }

    public String getGdzysSzly() {
        return gdzysSzly;
    }

    public void setGdzysSzly(String gdzysSzly) {
        this.gdzysSzly = gdzysSzly;
    }

    public BigDecimal getGdzysYnse() {
        return gdzysYnse;
    }

    public void setGdzysYnse(BigDecimal gdzysYnse) {
        this.gdzysYnse = gdzysYnse;
    }

    public BigDecimal getGdzysDwse() {
        return gdzysDwse;
    }

    public void setGdzysDwse(BigDecimal gdzysDwse) {
        this.gdzysDwse = gdzysDwse;
    }

    public String getGdzysJmxz() {
        return gdzysJmxz;
    }

    public void setGdzysJmxz(String gdzysJmxz) {
        this.gdzysJmxz = gdzysJmxz;
    }

    public String getGdzysJspz() {
        return gdzysJspz;
    }

    public void setGdzysJspz(String gdzysJspz) {
        this.gdzysJspz = gdzysJspz;
    }

    public BigDecimal getGdzysYjne() {
        return gdzysYjne;
    }

    public void setGdzysYjne(BigDecimal gdzysYjne) {
        this.gdzysYjne = gdzysYjne;
    }

    public BigDecimal getGdzysXbjse() {
        return gdzysXbjse;
    }

    public void setGdzysXbjse(BigDecimal gdzysXbjse) {
        this.gdzysXbjse = gdzysXbjse;
    }

    public String getGdzysBz() {
        return gdzysBz;
    }

    public void setGdzysBz(String gdzysBz) {
        this.gdzysBz = gdzysBz;
    }

    public Date getGdzysLrrq() {
        return gdzysLrrq;
    }

    public void setGdzysLrrq(Date gdzysLrrq) {
        this.gdzysLrrq = gdzysLrrq;
    }

    public String getGdzysHclx() {
        return gdzysHclx;
    }

    public void setGdzysHclx(String gdzysHclx) {
        this.gdzysHclx = gdzysHclx;
    }

    public String getQsId() {
        return qsId;
    }

    public void setQsId(String qsId) {
        this.qsId = qsId;
    }

    public String getQsSzly() {
        return qsSzly;
    }

    public void setQsSzly(String qsSzly) {
        this.qsSzly = qsSzly;
    }

    public BigDecimal getQsYnse() {
        return qsYnse;
    }

    public void setQsYnse(BigDecimal qsYnse) {
        this.qsYnse = qsYnse;
    }

    public BigDecimal getQsYjne() {
        return qsYjne;
    }

    public void setQsYjne(BigDecimal qsYjne) {
        this.qsYjne = qsYjne;
    }

    public String getQsJmxz() {
        return qsJmxz;
    }

    public void setQsJmxz(String qsJmxz) {
        this.qsJmxz = qsJmxz;
    }

    public String getQsJspz() {
        return qsJspz;
    }

    public void setQsJspz(String qsJspz) {
        this.qsJspz = qsJspz;
    }

    public BigDecimal getQsXbjse() {
        return qsXbjse;
    }

    public void setQsXbjse(BigDecimal qsXbjse) {
        this.qsXbjse = qsXbjse;
    }

    public String getQsBz() {
        return qsBz;
    }

    public void setQsBz(String qsBz) {
        this.qsBz = qsBz;
    }

    public Date getQsLrrq() {
        return qsLrrq;
    }

    public void setQsLrrq(Date qsLrrq) {
        this.qsLrrq = qsLrrq;
    }

    public String getQsHclx() {
        return qsHclx;
    }

    public void setQsHclx(String qsHclx) {
        this.qsHclx = qsHclx;
    }

    public String getFczlXian() {
        return fczlXian;
    }

    public void setFczlXian(String fczlXian) {
        this.fczlXian = fczlXian;
    }

    public String getFczlZhen() {
        return fczlZhen;
    }

    public void setFczlZhen(String fczlZhen) {
        this.fczlZhen = fczlZhen;
    }

    public String getFczlLu() {
        return fczlLu;
    }

    public void setFczlLu(String fczlLu) {
        this.fczlLu = fczlLu;
    }

    public String getFczlHao() {
        return fczlHao;
    }

    public void setFczlHao(String fczlHao) {
        this.fczlHao = fczlHao;
    }

    public String getFczlDong() {
        return fczlDong;
    }

    public void setFczlDong(String fczlDong) {
        this.fczlDong = fczlDong;
    }

    public String getFczlDy() {
        return fczlDy;
    }

    public void setFczlDy(String fczlDy) {
        this.fczlDy = fczlDy;
    }

    public String getFczlLou() {
        return fczlLou;
    }

    public void setFczlLou(String fczlLou) {
        this.fczlLou = fczlLou;
    }

    public String getFczlShi() {
        return fczlShi;
    }

    public void setFczlShi(String fczlShi) {
        this.fczlShi = fczlShi;
    }

    public String getGtzdbyzyy() {
        return gtzdbyzyy;
    }

    public void setGtzdbyzyy(String gtzdbyzyy) {
        this.gtzdbyzyy = gtzdbyzyy;
    }

    public String getPcTdzl() {
        return pcTdzl;
    }

    public void setPcTdzl(String pcTdzl) {
        this.pcTdzl = pcTdzl;
    }

    public BigDecimal getGdzysJmse() {
        return gdzysJmse;
    }

    public void setGdzysJmse(BigDecimal gdzysJmse) {
        this.gdzysJmse = gdzysJmse;
    }

    public BigDecimal getQsJmse() {
        return qsJmse;
    }

    public void setQsJmse(BigDecimal qsJmse) {
        this.qsJmse = qsJmse;
    }
}
