package cn.gtmap.landtax.entity;

import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税源信息修改历史表
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/11
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY_HIS")
public class SwDjSyHis {
    @Id
    @Column
    private String syhisId;

    @ManyToOne(cascade = CascadeType.REFRESH,fetch = FetchType.LAZY)
    @JoinColumn(name="SY_ID")
    private SwDjSy swDjSy;

    @Column
    private String djh;
    @Column
    private String dbh;
    @Column
    private String gdId;
    @Column
    private String bpId;
    @Column
    private String sjly;
    @Column
    private String glbm;
    @Column
    private String jbbNsrmc;
    @Column
    private String jbbZgkgDm;

    @Column
    private String jbbSgyDm;

    @Column
    private String jbbFddbr;
    @Column
    private String jbbLxdh;
    @Column
    private String jbbZclxDm;

    @Column
    private String jbbHyDm;

    @Column
    private String jbbZcdz;
    @Column
    private String tdTdzl;
    @Column
    private BigDecimal tdZdmj;
    @Column
    private BigDecimal tdYnmj;
    @Column
    private BigDecimal tdDwse;
    @Column
    private BigDecimal tdNynse;
    @Column
    private String tdTddj;
    @Column
    private String tdTdsyzh;
    @Column
    private String tdBz;
    @Column
    private String tdCzrmc;
    @Column
    private String tdCzrzjhm;
    @Column
    private Date tdLrrq;
    @Column
    private BigDecimal tdMsmj;
    @Column
    private BigDecimal tdMsse;
    @Column
    private BigDecimal tdDwseMs;
    @Column
    private BigDecimal tdFzmj;
    @Column
    private BigDecimal tdScmj;
    @Column
    private String tdTdsyztDm;
    @Column
    private String tdTdsyztMc;
    @Column
    private String gtzdbyzyy;
    @Column
    private String tdSgztDm;
    @Column
    private String tdSgztMc;
    @Column
    private String tdSjly;
    @Column
    private String tdZdsybz;
    @Column
    private String tdMsbz;
    @Column
    private BigDecimal fcFcyz;
    @Column
    private BigDecimal fcSl;
    @Column
    private BigDecimal fcNzj;
    @Column
    private BigDecimal fcZjSl;
    @Column
    private BigDecimal fcYnse;
    @Column
    private BigDecimal fcFcyzMs;
    @Column
    private BigDecimal fcNynse;
    @Column
    private String fcFczh;
    @Column
    private String fcCzrmc;
    @Column
    private Date fcLrrq;
    @Column
    private String fcCzrzjhm;
    @Column
    private BigDecimal fcFcyzYs;
    @Column
    private String fcFczl;
    @Column
    private String fcBz;
    @Column
    private BigDecimal fcFwjz;
    @Column
    private BigDecimal fcTdjz;
    @Column
    private BigDecimal fcFssbjz;
    @Column
    private BigDecimal fcFcmj;
    @Column
    private BigDecimal fcYnseZy;
    @Column
    private BigDecimal fcYnseCz;
    @Column
    private String fcFwxzDm;
    @Column
    private String fcFwxzMc;
    @Column
    private String fcZyhczDm;
    @Column
    private String fcZyhczMc;
    @Column
    private String fcSgztDm;
    @Column
    private String fcSgztMc;
    @Column
    private String fcSjly;
    @Column
    private String fcZdsybz;
    @Column
    private String fcMsbz;
    @Column
    private Date xgrq;
    @Column
    private String userid;

    @Column
    private String czlx;
    @Column
    private String xgyy;
    @Column
    private String rwid;
    @Column
    private Date tdMssjBegin;
    @Column
    private Date tdMssjEnd;
    @Column
    private String tdMsyy;
    @Column
    private Date fcMssjBegin;
    @Column
    private Date fcMssjEnd;
    @Column
    private String fcMsyy;
    @Column
    private String ishc;//是否进行了税源核查(0:为何查。1：已核查)

    @Column
    private String byzyy;


    private String tdqdfsDm;//土地取得方式

    @Column
    private String tdsyytDm;//土地使用用途代码

    @Column
    private BigDecimal dj;
    @Column
    private BigDecimal qdsyqzfje;
    @Column
    private BigDecimal tdkfcb;
    @Column
    private Date csqdsj;
    @Column
    private Date syqzzsj;
    @Column
    private String tdjmxzdm;

    @Column
    private BigDecimal czfcyz;
    @Column
    private BigDecimal jsbl;
    @Column
    private String fcjmxzdm;

    //耕地占用税信息
    @Column
    private String gdzysId;
    @Column
    private String gdzysSzly;
    @Column
    private BigDecimal gdzysYnse;
    @Column
    private BigDecimal gdzysDwse;
    @Column
    private String gdzysJmxz;
    @Column
    private BigDecimal gdzysJmse;
    @Column
    private String gdzysJspz;
    @Column
    private BigDecimal gdzysYjne;
    @Column
    private BigDecimal gdzysXbjse;
    @Column
    private String gdzysBz;
    @Column
    private Date gdzysLrrq;
    @Column
    private String gdzysHclx;


    //契税信息
    @Column
    private String qsId;
    @Column
    private String qsSzly;
    @Column
    private BigDecimal qsYnse;
    @Column
    private BigDecimal qsYjne;
    @Column
    private String qsJmxz;
    @Column
    private BigDecimal qsJmse;
    @Column
    private String qsJspz;
    @Column
    private BigDecimal qsXbjse;
    @Column
    private String qsBz;
    @Column
    private Date qsLrrq;
    @Column
    private String qsHclx;
    @Column
    private String fczlXian;
    @Column
    private String fczlZhen;
    @Column
    private String fczlLu;
    @Column
    private String fczlHao;
    @Column
    private String fczlDong;
    @Column
    private String fczlDy;
    @Column
    private String fczlLou;
    @Column
    private String fczlShi;






    public String getSyhisId() {
        return syhisId;
    }

    public void setSyhisId(String syhisId) {
        this.syhisId = syhisId;
    }

    public SwDjSy getSwDjSy() {
        return swDjSy;
    }

    public void setSwDjSy(SwDjSy swDjSy) {
        this.swDjSy = swDjSy;
    }



    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public String getGdId() {
        return gdId;
    }

    public void setGdId(String gdId) {
        this.gdId = gdId;
    }

    public String getBpId() {
        return bpId;
    }

    public void setBpId(String bpId) {
        this.bpId = bpId;
    }

    public String getSjly() {
        return sjly;
    }

    public void setSjly(String sjly) {
        this.sjly = sjly;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public String getJbbNsrmc() {
        return jbbNsrmc;
    }

    public void setJbbNsrmc(String jbbNsrmc) {
        this.jbbNsrmc = jbbNsrmc;
    }

    public String getJbbZgkgDm() {
        return jbbZgkgDm;
    }

    public void setJbbZgkgDm(String jbbZgkgDm) {
        this.jbbZgkgDm = jbbZgkgDm;
    }



    public String getJbbSgyDm() {
        return jbbSgyDm;
    }

    public void setJbbSgyDm(String jbbSgyDm) {
        this.jbbSgyDm = jbbSgyDm;
    }



    public String getJbbFddbr() {
        return jbbFddbr;
    }

    public void setJbbFddbr(String jbbFddbr) {
        this.jbbFddbr = jbbFddbr;
    }

    public String getJbbZclxDm() {
        return jbbZclxDm;
    }

    public void setJbbZclxDm(String jbbZclxDm) {
        this.jbbZclxDm = jbbZclxDm;
    }



    public String getJbbHyDm() {
        return jbbHyDm;
    }

    public void setJbbHyDm(String jbbHyDm) {
        this.jbbHyDm = jbbHyDm;
    }



    public String getJbbZcdz() {
        return jbbZcdz;
    }

    public void setJbbZcdz(String jbbZcdz) {
        this.jbbZcdz = jbbZcdz;
    }

    public String getTdTdzl() {
        return tdTdzl;
    }

    public void setTdTdzl(String tdTdzl) {
        this.tdTdzl = tdTdzl;
    }

    public BigDecimal getTdZdmj() {
        return tdZdmj;
    }

    public void setTdZdmj(BigDecimal tdZdmj) {
        this.tdZdmj = tdZdmj;
    }

    public BigDecimal getTdYnmj() {
        return tdYnmj;
    }

    public void setTdYnmj(BigDecimal tdYnmj) {
        this.tdYnmj = tdYnmj;
    }

    public BigDecimal getTdDwse() {
        return tdDwse;
    }

    public void setTdDwse(BigDecimal tdDwse) {
        this.tdDwse = tdDwse;
    }

    public BigDecimal getTdNynse() {
        return tdNynse;
    }

    public void setTdNynse(BigDecimal tdNynse) {
        this.tdNynse = tdNynse;
    }

    public String getTdTddj() {
        return tdTddj;
    }

    public void setTdTddj(String tdTddj) {
        this.tdTddj = tdTddj;
    }

    public String getTdTdsyzh() {
        return tdTdsyzh;
    }

    public void setTdTdsyzh(String tdTdsyzh) {
        this.tdTdsyzh = tdTdsyzh;
    }

    public String getTdBz() {
        return tdBz;
    }

    public void setTdBz(String tdBz) {
        this.tdBz = tdBz;
    }

    public String getTdCzrmc() {
        return tdCzrmc;
    }

    public void setTdCzrmc(String tdCzrmc) {
        this.tdCzrmc = tdCzrmc;
    }

    public String getTdCzrzjhm() {
        return tdCzrzjhm;
    }

    public void setTdCzrzjhm(String tdCzrzjhm) {
        this.tdCzrzjhm = tdCzrzjhm;
    }

    public Date getTdLrrq() {
        return tdLrrq;
    }

    public void setTdLrrq(Date tdLrrq) {
        this.tdLrrq = tdLrrq;
    }

    public BigDecimal getTdMsmj() {
        return tdMsmj;
    }

    public void setTdMsmj(BigDecimal tdMsmj) {
        this.tdMsmj = tdMsmj;
    }

    public BigDecimal getTdMsse() {
        return tdMsse;
    }

    public void setTdMsse(BigDecimal tdMsse) {
        this.tdMsse = tdMsse;
    }

    public BigDecimal getTdDwseMs() {
        return tdDwseMs;
    }

    public void setTdDwseMs(BigDecimal tdDwseMs) {
        this.tdDwseMs = tdDwseMs;
    }

    public BigDecimal getTdFzmj() {
        return tdFzmj;
    }

    public void setTdFzmj(BigDecimal tdFzmj) {
        this.tdFzmj = tdFzmj;
    }

    public BigDecimal getTdScmj() {
        return tdScmj;
    }

    public void setTdScmj(BigDecimal tdScmj) {
        this.tdScmj = tdScmj;
    }

    public String getTdTdsyztDm() {
        return tdTdsyztDm;
    }

    public void setTdTdsyztDm(String tdTdsyztDm) {
        this.tdTdsyztDm = tdTdsyztDm;
    }

    public String getTdTdsyztMc() {
        return tdTdsyztMc;
    }

    public void setTdTdsyztMc(String tdTdsyztMc) {
        this.tdTdsyztMc = tdTdsyztMc;
    }

    public String getTdSjly() {
        return tdSjly;
    }

    public void setTdSjly(String tdSjly) {
        this.tdSjly = tdSjly;
    }

    public String getTdZdsybz() {
        return tdZdsybz;
    }

    public void setTdZdsybz(String tdZdsybz) {
        this.tdZdsybz = tdZdsybz;
    }

    public String getTdMsbz() {
        return tdMsbz;
    }

    public void setTdMsbz(String tdMsbz) {
        this.tdMsbz = tdMsbz;
    }

    public BigDecimal getFcFcyz() {
        return fcFcyz;
    }

    public void setFcFcyz(BigDecimal fcFcyz) {
        this.fcFcyz = fcFcyz;
    }

    public BigDecimal getFcSl() {
        return fcSl;
    }

    public void setFcSl(BigDecimal fcSl) {
        this.fcSl = fcSl;
    }

    public BigDecimal getFcNzj() {
        return fcNzj;
    }

    public void setFcNzj(BigDecimal fcNzj) {
        this.fcNzj = fcNzj;
    }

    public BigDecimal getFcZjSl() {
        return fcZjSl;
    }

    public void setFcZjSl(BigDecimal fcZjSl) {
        this.fcZjSl = fcZjSl;
    }

    public BigDecimal getFcYnse() {
        return fcYnse;
    }

    public void setFcYnse(BigDecimal fcYnse) {
        this.fcYnse = fcYnse;
    }

    public BigDecimal getFcFcyzMs() {
        return fcFcyzMs;
    }

    public void setFcFcyzMs(BigDecimal fcFcyzMs) {
        this.fcFcyzMs = fcFcyzMs;
    }

    public BigDecimal getFcNynse() {
        return fcNynse;
    }

    public void setFcNynse(BigDecimal fcNynse) {
        this.fcNynse = fcNynse;
    }

    public String getFcFczh() {
        return fcFczh;
    }

    public void setFcFczh(String fcFczh) {
        this.fcFczh = fcFczh;
    }

    public String getFcCzrmc() {
        return fcCzrmc;
    }

    public void setFcCzrmc(String fcCzrmc) {
        this.fcCzrmc = fcCzrmc;
    }

    public Date getFcLrrq() {
        return fcLrrq;
    }

    public void setFcLrrq(Date fcLrrq) {
        this.fcLrrq = fcLrrq;
    }

    public String getFcCzrzjhm() {
        return fcCzrzjhm;
    }

    public void setFcCzrzjhm(String fcCzrzjhm) {
        this.fcCzrzjhm = fcCzrzjhm;
    }

    public BigDecimal getFcFcyzYs() {
        return fcFcyzYs;
    }

    public void setFcFcyzYs(BigDecimal fcFcyzYs) {
        this.fcFcyzYs = fcFcyzYs;
    }

    public String getFcFczl() {
        return fcFczl;
    }

    public void setFcFczl(String fcFczl) {
        this.fcFczl = fcFczl;
    }

    public String getFcBz() {
        return fcBz;
    }

    public void setFcBz(String fcBz) {
        this.fcBz = fcBz;
    }

    public BigDecimal getFcFwjz() {
        return fcFwjz;
    }

    public void setFcFwjz(BigDecimal fcFwjz) {
        this.fcFwjz = fcFwjz;
    }

    public BigDecimal getFcTdjz() {
        return fcTdjz;
    }

    public void setFcTdjz(BigDecimal fcTdjz) {
        this.fcTdjz = fcTdjz;
    }

    public BigDecimal getFcFssbjz() {
        return fcFssbjz;
    }

    public void setFcFssbjz(BigDecimal fcFssbjz) {
        this.fcFssbjz = fcFssbjz;
    }

    public BigDecimal getFcFcmj() {
        return fcFcmj;
    }

    public void setFcFcmj(BigDecimal fcFcmj) {
        this.fcFcmj = fcFcmj;
    }

    public BigDecimal getFcYnseZy() {
        return fcYnseZy;
    }

    public void setFcYnseZy(BigDecimal fcYnseZy) {
        this.fcYnseZy = fcYnseZy;
    }

    public BigDecimal getFcYnseCz() {
        return fcYnseCz;
    }

    public void setFcYnseCz(BigDecimal fcYnseCz) {
        this.fcYnseCz = fcYnseCz;
    }

    public String getFcFwxzDm() {
        return fcFwxzDm;
    }

    public void setFcFwxzDm(String fcFwxzDm) {
        this.fcFwxzDm = fcFwxzDm;
    }

    public String getFcFwxzMc() {
        return fcFwxzMc;
    }

    public void setFcFwxzMc(String fcFwxzMc) {
        this.fcFwxzMc = fcFwxzMc;
    }

    public String getFcZyhczDm() {
        return fcZyhczDm;
    }

    public void setFcZyhczDm(String fcZyhczDm) {
        this.fcZyhczDm = fcZyhczDm;
    }

    public String getFcZyhczMc() {
        return fcZyhczMc;
    }

    public void setFcZyhczMc(String fcZyhczMc) {
        this.fcZyhczMc = fcZyhczMc;
    }

    public String getFcSgztDm() {
        return fcSgztDm;
    }

    public void setFcSgztDm(String fcSgztDm) {
        this.fcSgztDm = fcSgztDm;
    }

    public String getFcSgztMc() {
        return fcSgztMc;
    }

    public void setFcSgztMc(String fcSgztMc) {
        this.fcSgztMc = fcSgztMc;
    }

    public String getFcSjly() {
        return fcSjly;
    }

    public void setFcSjly(String fcSjly) {
        this.fcSjly = fcSjly;
    }

    public String getFcZdsybz() {
        return fcZdsybz;
    }

    public void setFcZdsybz(String fcZdsybz) {
        this.fcZdsybz = fcZdsybz;
    }

    public String getFcMsbz() {
        return fcMsbz;
    }

    public void setFcMsbz(String fcMsbz) {
        this.fcMsbz = fcMsbz;
    }

    public Date getXgrq() {
        return xgrq;
    }

    public void setXgrq(Date xgrq) {
        this.xgrq = xgrq;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }



    public String getCzlx() {
        return czlx;
    }

    public void setCzlx(String czlx) {
        this.czlx = czlx;
    }

    public String getGtzdbyzyy() {
        return gtzdbyzyy;
    }

    public void setGtzdbyzyy(String gtzdbyzyy) {
        this.gtzdbyzyy = gtzdbyzyy;
    }

    public String getTdSgztDm() {
        return tdSgztDm;
    }

    public void setTdSgztDm(String tdSgztDm) {
        this.tdSgztDm = tdSgztDm;
    }

    public String getTdSgztMc() {
        return tdSgztMc;
    }

    public void setTdSgztMc(String tdSgztMc) {
        this.tdSgztMc = tdSgztMc;
    }

    public String getJbbLxdh() {
        return jbbLxdh;
    }

    public void setJbbLxdh(String jbbLxdh) {
        this.jbbLxdh = jbbLxdh;
    }

    public String getXgyy() {
        return xgyy;
    }

    public void setXgyy(String xgyy) {
        this.xgyy = xgyy;
    }

    public String getRwid() {
        return rwid;
    }

    public void setRwid(String rwid) {
        this.rwid = rwid;
    }

    public Date getTdMssjBegin() {
        return tdMssjBegin;
    }

    public void setTdMssjBegin(Date tdMssjBegin) {
        this.tdMssjBegin = tdMssjBegin;
    }

    public Date getTdMssjEnd() {
        return tdMssjEnd;
    }

    public void setTdMssjEnd(Date tdMssjEnd) {
        this.tdMssjEnd = tdMssjEnd;
    }

    public String getTdMsyy() {
        return tdMsyy;
    }

    public void setTdMsyy(String tdMsyy) {
        this.tdMsyy = tdMsyy;
    }

    public Date getFcMssjBegin() {
        return fcMssjBegin;
    }

    public void setFcMssjBegin(Date fcMssjBegin) {
        this.fcMssjBegin = fcMssjBegin;
    }

    public Date getFcMssjEnd() {
        return fcMssjEnd;
    }

    public void setFcMssjEnd(Date fcMssjEnd) {
        this.fcMssjEnd = fcMssjEnd;
    }

    public String getFcMsyy() {
        return fcMsyy;
    }

    public void setFcMsyy(String fcMsyy) {
        this.fcMsyy = fcMsyy;
    }

    public String getIshc() {
        return ishc;
    }

    public void setIshc(String ishc) {
        this.ishc = ishc;
    }

    public String getByzyy() {
        return byzyy;
    }

    public void setByzyy(String byzyy) {
        this.byzyy = byzyy;
    }



    public String getTdqdfsDm() {
        return tdqdfsDm;
    }

    public void setTdqdfsDm(String tdqdfsDm) {
        this.tdqdfsDm = tdqdfsDm;
    }

    public String getTdsyytDm() {
        return tdsyytDm;
    }

    public void setTdsyytDm(String tdsyytDm) {
        this.tdsyytDm = tdsyytDm;
    }

    public BigDecimal getDj() {
        return dj;
    }

    public void setDj(BigDecimal dj) {
        this.dj = dj;
    }

    public BigDecimal getQdsyqzfje() {
        return qdsyqzfje;
    }

    public void setQdsyqzfje(BigDecimal qdsyqzfje) {
        this.qdsyqzfje = qdsyqzfje;
    }

    public BigDecimal getTdkfcb() {
        return tdkfcb;
    }

    public void setTdkfcb(BigDecimal tdkfcb) {
        this.tdkfcb = tdkfcb;
    }

    public Date getCsqdsj() {
        return csqdsj;
    }

    public void setCsqdsj(Date csqdsj) {
        this.csqdsj = csqdsj;
    }

    public Date getSyqzzsj() {
        return syqzzsj;
    }

    public void setSyqzzsj(Date syqzzsj) {
        this.syqzzsj = syqzzsj;
    }

    public String getTdjmxzdm() {
        return tdjmxzdm;
    }

    public void setTdjmxzdm(String tdjmxzdm) {
        this.tdjmxzdm = tdjmxzdm;
    }

    public BigDecimal getCzfcyz() {
        return czfcyz;
    }

    public void setCzfcyz(BigDecimal czfcyz) {
        this.czfcyz = czfcyz;
    }

    public BigDecimal getJsbl() {
        return jsbl;
    }

    public void setJsbl(BigDecimal jsbl) {
        this.jsbl = jsbl;
    }

    public String getFcjmxzdm() {
        return fcjmxzdm;
    }

    public void setFcjmxzdm(String fcjmxzdm) {
        this.fcjmxzdm = fcjmxzdm;
    }

    public String getGdzysId() {
        return gdzysId;
    }

    public void setGdzysId(String gdzysId) {
        this.gdzysId = gdzysId;
    }

    public String getGdzysSzly() {
        return gdzysSzly;
    }

    public void setGdzysSzly(String gdzysSzly) {
        this.gdzysSzly = gdzysSzly;
    }

    public BigDecimal getGdzysYnse() {
        return gdzysYnse;
    }

    public void setGdzysYnse(BigDecimal gdzysYnse) {
        this.gdzysYnse = gdzysYnse;
    }

    public BigDecimal getGdzysDwse() {
        return gdzysDwse;
    }

    public void setGdzysDwse(BigDecimal gdzysDwse) {
        this.gdzysDwse = gdzysDwse;
    }

    public String getGdzysJmxz() {
        return gdzysJmxz;
    }

    public void setGdzysJmxz(String gdzysJmxz) {
        this.gdzysJmxz = gdzysJmxz;
    }

    public String getGdzysJspz() {
        return gdzysJspz;
    }

    public void setGdzysJspz(String gdzysJspz) {
        this.gdzysJspz = gdzysJspz;
    }

    public BigDecimal getGdzysYjne() {
        return gdzysYjne;
    }

    public void setGdzysYjne(BigDecimal gdzysYjne) {
        this.gdzysYjne = gdzysYjne;
    }

    public BigDecimal getGdzysXbjse() {
        return gdzysXbjse;
    }

    public void setGdzysXbjse(BigDecimal gdzysXbjse) {
        this.gdzysXbjse = gdzysXbjse;
    }

    public String getGdzysBz() {
        return gdzysBz;
    }

    public void setGdzysBz(String gdzysBz) {
        this.gdzysBz = gdzysBz;
    }

    public Date getGdzysLrrq() {
        return gdzysLrrq;
    }

    public void setGdzysLrrq(Date gdzysLrrq) {
        this.gdzysLrrq = gdzysLrrq;
    }

    public String getGdzysHclx() {
        return gdzysHclx;
    }

    public void setGdzysHclx(String gdzysHclx) {
        this.gdzysHclx = gdzysHclx;
    }

    public String getQsId() {
        return qsId;
    }

    public void setQsId(String qsId) {
        this.qsId = qsId;
    }

    public String getQsSzly() {
        return qsSzly;
    }

    public void setQsSzly(String qsSzly) {
        this.qsSzly = qsSzly;
    }

    public BigDecimal getQsYnse() {
        return qsYnse;
    }

    public void setQsYnse(BigDecimal qsYnse) {
        this.qsYnse = qsYnse;
    }

    public BigDecimal getQsYjne() {
        return qsYjne;
    }

    public void setQsYjne(BigDecimal qsYjne) {
        this.qsYjne = qsYjne;
    }

    public String getQsJmxz() {
        return qsJmxz;
    }

    public void setQsJmxz(String qsJmxz) {
        this.qsJmxz = qsJmxz;
    }

    public String getQsJspz() {
        return qsJspz;
    }

    public void setQsJspz(String qsJspz) {
        this.qsJspz = qsJspz;
    }

    public BigDecimal getQsXbjse() {
        return qsXbjse;
    }

    public void setQsXbjse(BigDecimal qsXbjse) {
        this.qsXbjse = qsXbjse;
    }

    public String getQsBz() {
        return qsBz;
    }

    public void setQsBz(String qsBz) {
        this.qsBz = qsBz;
    }

    public Date getQsLrrq() {
        return qsLrrq;
    }

    public void setQsLrrq(Date qsLrrq) {
        this.qsLrrq = qsLrrq;
    }

    public String getQsHclx() {
        return qsHclx;
    }

    public void setQsHclx(String qsHclx) {
        this.qsHclx = qsHclx;
    }

    public String getFczlXian() {
        return fczlXian;
    }

    public void setFczlXian(String fczlXian) {
        this.fczlXian = fczlXian;
    }

    public String getFczlZhen() {
        return fczlZhen;
    }

    public void setFczlZhen(String fczlZhen) {
        this.fczlZhen = fczlZhen;
    }

    public String getFczlLu() {
        return fczlLu;
    }

    public void setFczlLu(String fczlLu) {
        this.fczlLu = fczlLu;
    }

    public String getFczlHao() {
        return fczlHao;
    }

    public void setFczlHao(String fczlHao) {
        this.fczlHao = fczlHao;
    }

    public String getFczlDong() {
        return fczlDong;
    }

    public void setFczlDong(String fczlDong) {
        this.fczlDong = fczlDong;
    }

    public String getFczlDy() {
        return fczlDy;
    }

    public void setFczlDy(String fczlDy) {
        this.fczlDy = fczlDy;
    }

    public String getFczlLou() {
        return fczlLou;
    }

    public void setFczlLou(String fczlLou) {
        this.fczlLou = fczlLou;
    }

    public String getFczlShi() {
        return fczlShi;
    }

    public void setFczlShi(String fczlShi) {
        this.fczlShi = fczlShi;
    }

    public BigDecimal getGdzysJmse() {
        return gdzysJmse;
    }

    public void setGdzysJmse(BigDecimal gdzysJmse) {
        this.gdzysJmse = gdzysJmse;
    }

    public BigDecimal getQsJmse() {
        return qsJmse;
    }

    public void setQsJmse(BigDecimal qsJmse) {
        this.qsJmse = qsJmse;
    }
}

