package cn.gtmap.landtax.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 国土数据比对结果表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "LOCAL_SB_RKSS")
public class SbRkss implements Serializable {
    @Id
    @Column
    private String sbNum;
    @Column
    private Date fsrq;
    @Column
    private String szdm;
    @Column
    private String glbm;//管理编码
    @Column
    private BigDecimal nse;
    @Column
    private Date gxrq;//更新日期


    public String getSbNum() {
        return sbNum;
    }

    public void setSbNum(String sbNum) {
        this.sbNum = sbNum;
    }

    public Date getFsrq() {
        return fsrq;
    }

    public void setFsrq(Date fsrq) {
        this.fsrq = fsrq;
    }

    public BigDecimal getNse() {
        return nse;
    }

    public void setNse(BigDecimal nse) {
        this.nse = nse;
    }

    public String getSzdm() {
        return szdm;
    }

    public void setSzdm(String szdm) {
        this.szdm = szdm;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }
}
