/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.gtmapserver.web;

import com.gtis.gtmapserver.gwc.Wms;
import com.gtis.gtmapserver.model.ArcgisLayer;
import com.gtis.gtmapserver.service.LayerManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.geowebcache.arcgis.layer.ArcGISCacheLayer;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.service.OWSException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"console"})
public class ConsoleController {
    @Autowired
    private LayerManager layerManager;
    @Autowired
    private TileLayerDispatcher tileLayerDispatcher;
    @Autowired
    private GridSetBroker gridSetBroker;

    @RequestMapping(method={RequestMethod.GET})
    public String index(Model model) {
        model.addAttribute("tab", (Object)"console");
        List layers = this.layerManager.getLayers();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (TileLayer layer : layers) {
            map.put(layer.getName(), layer instanceof ArcGISCacheLayer);
        }
        model.addAttribute("als", map);
        model.addAttribute("layers", (Object)layers);
        return "console";
    }

    @RequestMapping(value={"reload"})
    public String reload() {
        this.layerManager.reload();
        return "redirect:/console";
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public String edit(Model model, ArcgisLayer arcgisLayer) {
        try {
            this.layerManager.saveLayer(arcgisLayer);
            this.success(model);
        }
        catch (IOException e) {
            this.failed(model, e.getMessage());
            model.addAttribute("layer", (Object)arcgisLayer);
            return "edit";
        }
        return "redirect:/console";
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.GET})
    public String doEdit0(Model model) {
        return this.doEdit(model, null);
    }

    @RequestMapping(value={"edit/{id}"})
    public String doEdit(Model model, @PathVariable String id) {
        model.addAttribute("layer", (Object)(StringUtils.isBlank((String)id) ? new ArcgisLayer() : new ArcgisLayer((ArcGISCacheLayer)this.layerManager.getLayer(id))));
        return "edit";
    }

    @RequestMapping(value={"remove/{id}"})
    public String remove(@PathVariable String id) {
        this.layerManager.removeLayer(id);
        return "redirect:/console";
    }

    @RequestMapping(value={"start/{id}"})
    public String start(RedirectAttributes ra, @PathVariable String id) {
        try {
            this.layerManager.startLayer(id);
        }
        catch (RuntimeException e) {
            ra.addFlashAttribute("msg", (Object)e.getMessage());
        }
        return "redirect:/console";
    }

    @RequestMapping(value={"stop/{id}"})
    public String stop(@PathVariable String id) {
        this.layerManager.stopLayer(id);
        return "redirect:/console";
    }

    @ResponseBody
    @RequestMapping(value={"wms/{id}"})
    public void wms(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TileLayer layer = this.layerManager.getLayer(id);
        if (layer == null || !layer.isEnabled()) {
            throw new OWSException(400, "InvalidParameterValue", "LAYERS", "Layer '" + id + "' is disabled");
        }
        Wms.makeMap((TileLayerDispatcher)this.tileLayerDispatcher, (GridSetBroker)this.gridSetBroker, (String)id, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected Model success(Model model) {
        return model.addAttribute("ret", (Object)true);
    }

    protected Model failed(Model model, String msg) {
        model.addAttribute("msg", (Object)msg);
        return model.addAttribute("ret", (Object)false);
    }
}

