/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.gtmapserver.service.impl;

import com.gtis.gtmapserver.model.ArcgisLayer;
import com.gtis.gtmapserver.service.LayerManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.arcgis.layer.ArcGISCacheLayer;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerManagerImpl
implements LayerManager {
    public static final Logger LOG = LoggerFactory.getLogger(LayerManagerImpl.class);
    @Autowired
    private XMLConfiguration configuration;
    @Autowired
    private GridSetBroker gridSetBroker;

    public List<TileLayer> getLayers() {
        ArrayList<TileLayer> tls = new ArrayList<TileLayer>(this.configuration.getTileLayers());
        Collections.sort(tls);
        return tls;
    }

    public TileLayer getLayer(String layerId) {
        return this.configuration.getTileLayer(layerId);
    }

    public void removeLayer(String layerId) {
        this.configuration.removeLayer(layerId);
        this.doSave();
    }

    public TileLayer saveLayer(ArcgisLayer layer) throws IOException {
        if (StringUtils.isBlank((String)layer.getId())) {
            throw new IOException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!layer.getPath().endsWith("/conf.xml")) {
            layer.setPath(layer.getPath() + "/conf.xml");
        }
        TileLayer tl = this.configuration.getTileLayer(layer.getId());
        if (!layer.getId().equals(layer.getSrcId()) && tl != null) {
            throw new IOException("\u6b64\u540d\u79f0\u5df2\u88ab\u4f7f\u7528");
        }
        File file = new File(layer.getPath());
        if (!file.exists()) {
            throw new IOException("\u4e0d\u5b58\u5728\u7684\u8def\u5f84");
        }
        ArcGISCacheLayer al = StringUtils.isEmpty((String)layer.getSrcId()) ? new ArcGISCacheLayer() : (ArcGISCacheLayer)this.configuration.getTileLayer(layer.getSrcId());
        al.setName(layer.getId());
        al.setTilingScheme(file);
        al.setLayerBounds(layer.toBoundingBox());
        al.setOrder(layer.getOrder());
        if (StringUtils.isEmpty((String)layer.getSrcId())) {
            this.configuration.addLayer((TileLayer)al);
        } else {
            this.configuration.modifyLayer(tl);
        }
        this.doSave();
        return al;
    }

    public void stopLayer(String layerId) {
        this.getLayer(layerId).setEnabled(false);
        this.doSave();
    }

    public void startLayer(String layerId) {
        File f;
        TileLayer tl = this.configuration.getTileLayer(layerId);
        if (tl instanceof ArcGISCacheLayer && !(f = ((ArcGISCacheLayer)tl).getTilingScheme()).exists()) {
            throw new RuntimeException("Arcgis\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6 [" + f.getAbsolutePath() + "]\u4e0d\u5b58\u5728");
        }
        tl.setEnabled(true);
        this.configuration.modifyLayer(tl);
        this.doSave();
    }

    public void reload() {
        try {
            this.configuration.initialize(this.gridSetBroker);
        }
        catch (GeoWebCacheException e) {
            LOG.error("Error to reload configuration", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doSave() {
        try {
            this.configuration.save();
        }
        catch (Exception e) {
            LOG.error("Error to save configuration", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

