$(function () {
    //加载弹出层
    layui.use(['form','element'],
        function() {
            layer = layui.layer;
            element = layui.element;
            //注意：导航 依赖 element 模块，否则无法进行功能性操作
            //获取所有的菜单
            $.ajax({
                type:"GET",
                url:"/oa/meetroom/getParentMeun",
                dataType:"json",
                success:function(data){
                    console.log(data);
                    //先添加所有的主菜单
                    $.each(data,function(i,obj){
                        var content='<li>';
                        content+='<a _href="/oa/meetroomApply/goCalendarMeeting?roomId='+obj.roomId+'&roomName='+obj.roomName+'"><cite>'+obj.roomName+'</cite><i class="iconfont nav_right">&#xe697;</i></a>';
                        content+='</li>';
                        $("#nav").append(content);
                    });
                    element.init();

                    $('.left-nav #nav li').click(function (event) {
                        var url = $(this).children('a').attr('_href');
                        var title = $(this).find('cite').html();
                        var index  = $('.left-nav #nav li').index($(this));

                        for (var i = 0; i <$('.x-iframe').length; i++) {
                            if($('.x-iframe').eq(i).attr('tab-id')==index+1){
                                tab.tabChange(index+1);
                                event.stopPropagation();
                                return;
                            }
                        };
                        tab.tabAdd(title,url,index+1);
                        tab.tabChange(index+1);
                        event.stopPropagation();
                    });
                },
                error:function(jqXHR){
                }
            });
        });

    //触发事件
    var tab = {
        tabAdd: function(title,url,id){
            //新增一个Tab项
            element.tabAdd('xbs_tab', {
                title: title
                ,content: '<iframe tab-id="'+id+'" frameborder="0" src="'+url+'" scrolling="yes" class="x-iframe"></iframe>'
                ,id: id
            })
        }
        ,tabDelete: function(othis){
            //删除指定Tab项
            element.tabDelete('xbs_tab', '44'); //删除：“商品管理”
            othis.addClass('layui-btn-disabled');
        }
        ,tabChange: function(id){
            //切换到指定Tab项
            element.tabChange('xbs_tab', id); //切换到：用户管理
        }
    };
    tableCheck = {
        init:function  () {
            $(".layui-form-checkbox").click(function(event) {
                if($(this).hasClass('layui-form-checked')){
                    $(this).removeClass('layui-form-checked');
                    if($(this).hasClass('header')){
                        $(".layui-form-checkbox").removeClass('layui-form-checked');
                    }
                }else{
                    $(this).addClass('layui-form-checked');
                    if($(this).hasClass('header')){
                        $(".layui-form-checkbox").addClass('layui-form-checked');
                    }
                }

            });
        },
        getData:function  () {
            var obj = $(".layui-form-checked").not('.header');
            var arr=[];
            obj.each(function(index, el) {
                arr.push(obj.eq(index).attr('data-id'));
            });
            return arr;
        }
    }

    //开启表格多选
    tableCheck.init();
    $('.container .left_open i').click(function(event) {
        if($('.left-nav').css('left')=='0px'){
            $('.left-nav').animate({left: '-221px'}, 100);
            $('.page-content').animate({left: '0px'}, 100);
            $('.page-content-bg').hide();
        }else{
            $('.left-nav').animate({left: '0px'}, 100);
            $('.page-content').animate({left: '221px'}, 100);
            if($(window).width()<768){
                $('.page-content-bg').show();
            }
        }

    });
    $('.page-content-bg').click(function(event) {
        $('.left-nav').animate({left: '-221px'}, 100);
        $('.page-content').animate({left: '0px'}, 100);
        $(this).hide();
    });
    $('.layui-tab-close').click(function(event) {
        $('.layui-tab-title li').eq(0).find('i').remove();
    });

    //左侧菜单效果
    // $('#content').bind("click",function(event){
    var allUrl = '/oa/meetroomApply/goCalendarMeeting?roomId=&roomName=';
    var allContent = "<iframe src='"+allUrl+"'frameborder=\"0\" scrolling=\"yes\" class=\"x-iframe\"></iframe>";
    $("#showAll").append(allContent);
})



