/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.util;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class SessionUtil {
    @Autowired
    UserManagerClient userManagerClient;
    private static final UserDto guest = new UserDto();

    public UserDto getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            String username = authentication.getName();
            return this.userManagerClient.getUserDetailByUsername(username);
        }
        return null;
    }

    public String getCurrentUserId() {
        UserDto user = this.getCurrentUser();
        return user != null ? user.getId() : null;
    }

    @Deprecated
    public static String getUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return "";
    }

    public static String getCurTime() {
        String result = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 ");
        result = tempDate.format(cal.getTime());
        result = result + " \u661f\u671f" + SessionUtil.getChineseDayOfWeek(cal.get(7));
        return result;
    }

    public static String getChineseDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
            case 1: {
                return "\u65e5";
            }
        }
        return "";
    }

    static {
        guest.setAdmin(1);
        guest.setUsername("guest");
        guest.setId("guest");
    }
}

