/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Reimbursement;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReimbursementPage;
import com.gtis.oa.service.ReimbursementService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reimbursement"})
public class ReimbursementController {
    @Autowired
    private ReimbursementService reimbursementService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, String view) {
        Reimbursement reimbursement = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            reimbursement = (Reimbursement)((Object)this.reimbursementService.getById((Serializable)((Object)processInsId)));
        }
        if (reimbursement == null) {
            reimbursement = new Reimbursement();
            reimbursement.setReimId(processInsId);
            reimbursement.setApplyTime(new Date());
            reimbursement.setApplyPeople(CommonUtil.getUser().getAlias());
            reimbursement.setApplyUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
            this.reimbursementService.save((Object)reimbursement);
        }
        model.addAttribute("view", (Object)view);
        model.addAttribute("reimbursement", (Object)reimbursement);
        return "officeapply/reimbursement/reimbursement_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/reimbursement/reimbursement_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(ReimbursementPage reimbursementPage, long page, long limit) {
        reimbursementPage.setCurrent(page);
        reimbursementPage.setSize(limit);
        IPage<Reimbursement> reimbursementIPage = this.reimbursementService.findByPage(reimbursementPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", reimbursementIPage.getRecords());
        resultMap.put("count", reimbursementIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Reimbursement> save(Reimbursement reimbursement) {
        return new ResponseMessage<Reimbursement>((Boolean)this.reimbursementService.saveOrUpdate((Object)reimbursement), reimbursement);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Reimbursement> delete(String[] ids) {
        return new ResponseMessage<Reimbursement>(this.reimbursementService.removeByIds(Arrays.asList(ids)));
    }
}

