/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Outgoing;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.OutgoingPage;
import com.gtis.oa.service.OutgoingService;
import com.gtis.oa.util.CommonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/outgoing"})
public class OutgoingController {
    @Autowired
    OutgoingService outgoingService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, int outType, String view) {
        Outgoing outgoing = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", processInsId);
            map.put("outType", outType);
            outgoing = this.outgoingService.findByMap(map);
        }
        if (outgoing == null) {
            outgoing = new Outgoing();
            outgoing.setId(processInsId);
            outgoing.setApplyDate(new Date());
            outgoing.setOutType(outType);
            outgoing.setPeopleId(CommonUtil.getUserId());
            outgoing.setPeopleName(CommonUtil.getUser().getAlias());
            outgoing.setPeopleUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
        }
        model.addAttribute("outgoing", (Object)outgoing);
        model.addAttribute("view", (Object)view);
        if (outType == 1) {
            return "officeapply/outgoing/outgoing_edit";
        }
        if (outType == 2) {
            return "officeapply/outgoing/bussiness_out_edit";
        }
        if (outType == 3) {
            return "officeapply/outgoing/goout_edit";
        }
        return null;
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, int outType, String type) {
        model.addAttribute("outType", (Object)outType);
        model.addAttribute("type", (Object)type);
        if (outType == 1) {
            return "officeapply/outgoing/outgoing_list";
        }
        if (outType == 2) {
            return "officeapply/outgoing/bussiness_out_list";
        }
        if (outType == 3) {
            return "officeapply/outgoing/goout_list";
        }
        return null;
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(OutgoingPage outgoingPage, long page, long limit) {
        outgoingPage.setCurrent(page);
        outgoingPage.setSize(limit);
        IPage<Outgoing> outgoingIPage = this.outgoingService.findByPage(outgoingPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", outgoingIPage.getRecords());
        resultMap.put("count", outgoingIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Outgoing> save(Outgoing outgoing) {
        return new ResponseMessage<Outgoing>((Boolean)this.outgoingService.saveOrUpdate((Object)outgoing), outgoing);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Outgoing> delete(String[] ids) {
        return new ResponseMessage<Outgoing>(this.outgoingService.removeByIds(Arrays.asList(ids)));
    }
}

