/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Meetroom;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetroomPage;
import com.gtis.oa.service.MeetroomService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/meetroom"})
public class MeetroomController {
    @Autowired
    MeetroomService meetroomService;

    @RequestMapping(value={"/list"})
    public String list(Model model) {
        return "management/meet/meetroom_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(MeetroomPage meetroomPage, long page, long limit) {
        meetroomPage.setCurrent(page);
        meetroomPage.setSize(limit);
        IPage<Meetroom> meetroomIPage = this.meetroomService.findByPage(meetroomPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", meetroomIPage.getRecords());
        resultMap.put("count", meetroomIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/index"})
    public String index(Model model, String roomId) {
        Meetroom meetroom = null;
        if (StringUtils.isNotBlank((String)roomId)) {
            meetroom = (Meetroom)((Object)this.meetroomService.getById((Serializable)((Object)roomId)));
        }
        if (meetroom == null) {
            meetroom = new Meetroom();
            meetroom.setRoomId(roomId);
        }
        model.addAttribute("meetroom", (Object)meetroom);
        return "management/meet/meetroom_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Meetroom> save(Meetroom meetroom) {
        ResponseMessage<Meetroom> a = null;
        try {
            if (StringUtils.isNotBlank((String)meetroom.getRoomId())) {
                a = new ResponseMessage<Meetroom>((Boolean)this.meetroomService.updateById((Object)meetroom), meetroom);
            } else {
                meetroom.setRoomId(UUID.hex32());
                a = new ResponseMessage<Meetroom>((Boolean)this.meetroomService.save((Object)meetroom), meetroom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Meetroom> delete(String[] ids) {
        return new ResponseMessage<Meetroom>(this.meetroomService.removeByIds(Arrays.asList(ids)));
    }

    @RequestMapping(value={"/getParentMeun"})
    @ResponseBody
    public List<Meetroom> getParentMeun() {
        MeetroomPage meetroomPage = new MeetroomPage();
        IPage<Meetroom> list = this.meetroomService.findByPage(meetroomPage);
        List meetroomList = list.getRecords();
        return meetroomList;
    }
}

