/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Car;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.CarPage;
import com.gtis.oa.service.CarService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/car"})
public class CarController {
    @Autowired
    CarService carService;

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/useCar/car_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(CarPage carPage, long page, long limit) {
        carPage.setCurrent(page);
        carPage.setSize(limit);
        IPage<Car> carIPage = this.carService.findByPage(carPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", carIPage.getRecords());
        resultMap.put("count", carIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/index"})
    public String indexCar(Model model, String id, String view) {
        Car car = null;
        if (StringUtils.isNotBlank((String)id)) {
            car = (Car)((Object)this.carService.getById((Serializable)((Object)id)));
        }
        if (car == null) {
            car = new Car();
            car.setCarId(UUID.hex32());
        }
        model.addAttribute("car", (Object)car);
        model.addAttribute("view", (Object)view);
        return "officeapply/useCar/car_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Car> save(Car car) {
        return new ResponseMessage<Car>((Boolean)this.carService.saveOrUpdate((Object)car), car);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Car> delete(String[] ids) {
        return new ResponseMessage<Car>(this.carService.removeByIds(Arrays.asList(ids)));
    }
}

