/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.config;

import freemarker.template.TemplateModelException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FreemarkerConfig {
    static Logger logger = LoggerFactory.getLogger(FreemarkerConfig.class);
    @Autowired
    freemarker.template.Configuration configuration;
    @Value(value="${app.base}")
    private String base;
    @Value(value="${app.storage}")
    private String storage;

    @PostConstruct
    public void setCfg() {
        try {
            this.configuration.setSharedVariable("base", (Object)this.base);
            this.configuration.setSharedVariable("storage", (Object)this.storage);
            this.configuration.setClassicCompatible(true);
            this.configuration.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
            this.configuration.setDateFormat("yyyy-MM-dd");
            this.configuration.setTimeFormat("HH:mm:ss");
            this.configuration.setNumberFormat("0.##");
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setURLEscapingCharset("UTF-8");
        }
        catch (TemplateModelException e) {
            e.printStackTrace();
        }
    }
}

