/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.config;

import com.google.common.collect.Sets;
import com.gtis.oa.common.spring.DateToStringConverter;
import com.gtis.oa.common.utils.ConversionService;
import com.gtis.oa.common.utils.StringToDateConverter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

@Configuration
public class BeanResolverConfiguer
extends WebMvcConfigurerAdapter {
    @Autowired
    SqlSessionTemplate sqlSessionTemplate;

    @Bean
    public SimpleMappingExceptionResolver getSimpleMappingExceptionResolver() {
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        simpleMappingExceptionResolver.setDefaultErrorView("common/500");
        simpleMappingExceptionResolver.setExceptionAttribute("ex");
        simpleMappingExceptionResolver.setDefaultStatusCode(500);
        Properties statusCodes = new Properties();
        statusCodes.put("common/500", "500");
        statusCodes.put("common/404", "404");
        simpleMappingExceptionResolver.setStatusCodes(statusCodes);
        Properties mappings = new Properties();
        mappings.put("java.lang.Exception", "500");
        simpleMappingExceptionResolver.setExceptionMappings(mappings);
        return simpleMappingExceptionResolver;
    }

    @Bean
    public ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
        ConfigurableWebBindingInitializer configurableWebBindingInitializer = new ConfigurableWebBindingInitializer();
        configurableWebBindingInitializer.setConversionService((org.springframework.core.convert.ConversionService)this.getConversionService());
        return configurableWebBindingInitializer;
    }

    @Bean
    public ConversionService getConversionService() {
        HashSet converters = Sets.newHashSet();
        ConversionService conversionService = new ConversionService();
        converters.add(new DateToStringConverter());
        converters.add(new StringToDateConverter());
        conversionService.setConverters((Set)converters);
        return conversionService;
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

