<@com.html title="车辆列表" import="viewList,list,screen" />
<body class="gtmap">
<#if type=="view">
    <@toolbar show=""/>
<#else>
    <@toolbar show="del"/>
</#if>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm">
                            <div onclick="loadInfo()"><i class="iconfont icon-sousuo" ></i>搜索</div>
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    车牌号：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="carNo" id="carNo" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    驾驶员：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="driverName" id="driverName" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="tablebox">
        <#if type=="view">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    车辆列表
                </div>
            </div>
        </#if>
            <div id="table1">
            </div>
        </div>
    </div>
</div>
</body>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/car/findByPage',
                dataType: "json",
                where: {
                    "carNo": $("#carNo").val(),
                    "driverName": $("#driverName").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'carId', title: 'carId', width: '3%', fixed: 'left', hide: true}
                    , {field: 'carNo', title: '车牌号', width: '10%',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.carId + "')";
                                return "<a style=\"color:#08c\" onclick=\"" + funStr + "\">"+d.carNo+"</a>"
                            }}
                    , {field: 'driverName', title: '驾驶员', width: '15%'}
                    , {field: 'carType', title: '车型', width: '15%'}
                    , {field: 'peopleNum', title: '可容纳人数', width: '10%'}
                    , {field: 'carCode', title: '状态', width: '10%'}
                    , {field: 'remark', title: '备注', width: '37%'}
                ]],
                page: true
            });
        };

        window.goViewProject=function(id){
            x_admin_show("编辑车辆信息","${base}/car/index?view=true&id="+id,"600","450");
        };

        window.deleteAsset = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].carId);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/car/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除地块）
        $("#del").click(function (e) {
            deleteAsset();
        });

        //初始化查询
        loadInfo();
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        });
        function initHeight(flag){
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+32+30;
            console.log(vheight);
            if(flag=="init"){
                var bodyHeight=client().height-$(".gt-toolbar").height()-18;
                $(".gtmap-body").height(bodyHeight);
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
