<@com.html title="收文列表" import="viewList,list,screen" />
<body class="gtmap">
<@toolbar show="archive"/>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm">
                            <div onclick="loadInfo()"><i class="iconfont icon-sousuo" ></i>搜索</div>
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    标题：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="receiveTitle" id="receiveTitle" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    密级：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <select name="emergency" id="emergency" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                    <option value=""></option>
                                    <option value="普通">普通</option>
                                    <option value="内部">内部</option>
                                    <option value="秘密">秘密</option>
                                    <option value="机密">机密</option>
                                    <option value="绝密">绝密</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    来文类别：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <select name="receiveType" id="receiveType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                    <option value=""></option>
                                    <option value="普通来文">普通来文</option>
                                    <option value="国土资源厅来文">国土资源厅来文</option>
                                    <option value="中央、省级来文">中央、省级来文</option>
                                    <option value="市人民政府来文">市人民政府来文</option>
                                    <option value="市各委、办、局来文">市各委、办、局来文</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="more-form">
                    <div class="gt-new-form-item">
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        来文单位：
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="fromUnit" id="fromUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        收文编号：
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <select name="receiveName" id="receiveName" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="连自然资收字">连自然资收字</option>
                                        <option value="连自然资监强执">连自然资监强执</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        公开范围：
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <select name="publishType" id="publishType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="内网公开">内网公开</option>
                                        <option value="不公开">不公开</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </form>
            <div class="menu-more" data-flag="down">
                显示更多筛选条件
            </div>
        </div>
        <div class="tablebox">
        <#if type=="view">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    收文列表
                </div>
            </div>

        </#if>
            <div id="table1">
            </div>
        </div>
    </div>
</div>




</body>

<script type="text/html" id="barDemo">
    <a class="layui-btn layui-btn-xs">新增</a>
    <a class="layui-btn layui-btn-xs layui-btn-primary" lay-event="edit">编辑</a>
    <a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>

</script>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/receive/findByPage',
                dataType: "json",
                where: {
                    "receiveTitle": $("#receiveTitle").val(),
                    "fromUnit": $("#fromUnit").val(),
                    "emergency": $("#emergency").val(),
                    "receiveType": $("#receiveType").val(),
                    "receiveName": $("#receiveName").val(),
                    "publishType": $("#publishType").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'receiveId', title: 'id', width: '3%', fixed: 'left', hide: true}
                    , {field: 'receiveTitle', title: '标题', width: '47%',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.receiveId + "')";
                                return "<a style=\"color:#08c\" onclick=\"" + funStr + "\">"+d.receiveTitle+"</a>"
                            }}
                    , {field: 'fromUnit', title: '来文单位', width: '17%'}
                    , {field: 'receiveDate', title: '收文日期', width: '10%',templet:"<div>{{layui.util.toDateString(d.receiveDate*1000,'yyyy-MM-dd')}}</div>"}
                    , {field: 'emergency', title: '密级', width: '10%'}
                    , {field: 'receiveType', title: '来文类别', width: '13%'}
                ]],
                page: true
            });
        };

        //跳往编辑页面
        window.goViewProject = function (id) {
            window.open("${base}/receive/index?view=true&processInsId="+id);
        };

        //初始化查询
        loadInfo();
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        })
        function initHeight(flag){
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+32+30;
            console.log(vheight);
            if(flag=="init"){
                var bodyHeight=client().height-$(".gt-toolbar").height()-18;
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
