﻿<@com.html title="人员选择" import="layui,jquery1.8,ztree,font"/>
<style>
    html, body {
        overflow-x:hidden;
        margin: 0;
        padding: 0px;
        height: 100%;
        background-color: #ffffff!important;
        box-sizing: border-box;
    }
    .ztree * {
        font-size: 14px!important;
    }

    .zTreeSearch input {
        width: 120px;
        height: 24px;
        line-height: 24px;
        vertical-align: middle;
    }

    .zTreeSearch span.iconfont {
        vertical-align: middle;
        font-size: 20px;
        cursor: pointer;
        visibility: hidden;
    }

    .iconfont {
        -webkit-text-stroke-width: 0;
    }
    .left{
        left: 0;
        right: auto;
    }
    .row {
        display: table;
        width: 100%;
        box-sizing: border-box;
        zoom: 1;
    }

    .qd {
        color: #fff;
        background-color: #5a98de;
        border-color: #5a98de;
        border-radius: 4px;
        overflow: hidden;
        padding: 4px 12px;
    }

    .qx {
        background-color: #e6e6e6;
        border-color: #e6e6e6;
        border-radius: 4px;
        overflow: hidden;
        padding: 4px 12px;
    }
    .ztree li span.button.iconfont {
        line-height: 21px;
        background-image: none;
        display: none;
        width: 0;
        height: 21px;
    }
</style>

    <form id="layui-form" method="post" id="selectUserForm">
        <div class="layui-layout layui-layout-admin">
            <input type="hidden" name="linkId" value="${linkId!}" id="linkId" >
            <input type="hidden" name="peopleId" value="${peopleId!}" id="peopleId" >
            <div class="layui-row layui-col-space15">
                <div class="layui-col-sm3 layui-col-md3">
                    <div>
                        <div style="height: 10px"></div>
                        <div class="zTreeSearch" id="zTree_zTreeSearch">
                            <input type="text" class="layui-input" name="department" placeholder="请输入" autocomplete="off" style="display:inline-block;">
                            <button type="button" class="layui-btn layui-btn-xs"><i class="icon iconfont icon-search">搜索</i></button>
                            <span class="zTree-search-tip"></span>
                            <span class="icon iconfont icon-shangyibu" title="上一个"></span>
                            <span class="icon iconfont icon-xiayibu" title="下一个"></span>
                        </div>
                        <div style="height: 10px"></div>
                        <div id="treeDiv" style="height: 210px;">
                            <div id="treeUserListDiv" class="left" style="height: 100%; width: 100%; float: left; overflow:auto;">
                                <ul id="zTree" class="ztree" style="height: 100%;"></ul>
                            </div>
                        </div>
                    </div>
                </div>


        <div class="row" style="padding-bottom: 10px;overflow:hidden;">
            <div style="text-align:center;">
                <div style="width: 100%">
                    <button id="btnSave" class="qd" type="button"> 确定</button>&nbsp;&nbsp;&nbsp;&nbsp;
                    <button id="btnCancel" class="qx" type="button"  data-dismiss="modal" >取消</button>
                </div>
            </div>
        </div>
    </form>

<script>
    layui.use(['jquery', 'form'], function () {
        var form = layui.form;
        //initZTree();
    });

    var zTree_setting = {
        async: {
            enable: true,
            url: "/oa/promulgator/getUserZtree",
            type: 'get',
            autoParam: ["id"]
        },
        view: {
            addHoverDom: false,
            removeHoverDom: false,
            selectedMulti: true
        },
        check: {
            enable: true,
            chkStyle: 'checkbox'
        },
        data: {
            simpleData: {
                enable: true,
                idKey: "id",   //节点数据中保存唯一标识的属性名称
                pIdKey: "pId",    //节点数据中保存其父节点唯一标识的属性名称
                rootPId: -1  //用于修正根节点父节点数据，即 pIdKey 指定的属性值
            },
            key: {
                name: "name"  //zTree 节点数据保存节点名称的属性名称  默认值："name"
            }
        },
        callback: {
            beforeRemove: false

            ,onAsyncSuccess: zTree_onAsyncSuccess
           // ,onClick: zTreeOnClick
           // ,onCheck: onCheck

        }
    };

    var zTree_zNodes = [];

    // 如果该用户的节点数据尚未加载出来，将用户id放到这个节点中，等数据加载完后，选中节点并删除这里面的记录
    var unCkeckedUserId = [];
    var waitCheckUserId = "";
    var userCheckListLoadOver = false;
    var treeUserList;

    var zTree_zTree, zTree_rMenu;
    $(document).ready(function () {
        $.fn.zTree.init($("#zTree"), zTree_setting, zTree_zNodes);
        zTree_zTree = $.fn.zTree.getZTreeObj("zTree");
        zTree_rMenu = $("#zTree_rMenu");
        treeUserList = $.fn.zTree.init($("#zTree"), zTree_setting, zTree_zNodes);
    });

    // 勾选上次已选择的用户
    function checkSelectedUser(linkId) {
        $.ajax({
            type: 'post',
            url: "/oa/promulgator/getUserListDataByLinkId",
            data: {linkId: linkId},
            dataType: 'json',
            success: function (data) {
                if (data) {
                    userCheckListLoadOver = true;
                    for (var i = 0, l = data.length; i < l; i++) {
                        unCkeckedUserId.push(data[i].id);
                    }
                }

                if (userCheckListLoadOver == true) {
                    checkUser();
                }
            }
        });
    }

    // 只要在勾选前存在未加载完的节点数据，则循环
    function checkUser() {
        for (var l = unCkeckedUserId.length, i = l - 1; i >= 0; i--) {
            var treeNode = treeUserList.getNodeByParam("id", unCkeckedUserId[i], null);
            if (treeNode) {
                treeUserList.checkNode(treeNode, true, true);
                unCkeckedUserId.pop(unCkeckedUserId[i]);
            }
        }

        if (waitCheckUserId.length > 0) {
            chechUserByUserId(waitCheckUserId);
        }
    }

    // 选中指定的用户
    function chechUserByUserId(userId) {
        var treeNode = treeUserList.getNodeByParam("id", userId, null);
        if (treeNode) {
            treeUserList.checkAllNodes(false);
            treeUserList.checkNode(treeNode, true, true);
        } else {
            waitCheckUserId = userId;
        }
        //$("#btnOk").click();
    }

    /**
     * 异步加载成功事件
     */
    function zTree_onAsyncSuccess(event, treeId) {
        //展开之最底层孩子节点
        var treeObj = $.fn.zTree.getZTreeObj("zTree");
        var node = treeObj.getNodes()[0];
        var childNodes = treeObj.transformToArray(node);
        zTree_childrenShow(childNodes, treeObj);
    }

    window.zTree_childrenShow = function (childNodes, treeObj) {
        if (null != childNodes[0].children && 0 != childNodes[0].children.length) {
            var childNodes = childNodes[0].children;
            zTree_childrenShow(childNodes, treeObj);
        } else {
            treeObj.selectNode(childNodes[0]);
            //zTreeOnClick(null, null, childNodes[0]);
            $("#" + childNodes[0].tId + "_a").click();
        }
        checkSelectedUser("${linkId!}");
    };

    $("#zTree_zTreeSearch input").on("keyup change", function () {
        zTree_searchText();
    });
    $("#zTree_zTreeSearch button").click(function () {
        zTree_searchText();
    });
    $("#btnCancel").click(function () {
        //window.parent.location.reload();
        var index = parent.layer.getFrameIndex(window.name);
        parent.layer.close(index);
    });

    $("#btnSave").click(function () {
            var data = getUserSelectSaveData();
        $.ajax({
            type: 'post',
            url: "/oa/promulgator/save",
            data: data,
            dataType: 'json',
            success: function (data) {
                if (data) {
                    //window.parent.location.reload();
                    //传值到父页面
                    var mans = getMans();
                    //此id动态获取业务表单的人员字段
                    var peopleId = $("#peopleId").val();
                    parent.$('#'+peopleId).val(mans);
                    var index = parent.layer.getFrameIndex(window.name);
                    parent.layer.close(index);
                } else {
                    alert("保存人员失败！");
                }
            }
        });
    });

    // 获取选择的人员传值到父页面
    function getMans() {
        var mans = "";
        var nodes = $.fn.zTree.getZTreeObj("zTree").getCheckedNodes(true);
        for (var i = 0; i < nodes.length; i++) {
            if (!nodes[i].isParent) {
                if (mans==""){
                    mans += nodes[i].name;
                }else {
                    mans += ","+nodes[i].name;
                }
            }
        }
        return mans;
    }
    // 获取选择的人员的保存数据
    function getUserSelectSaveData() {
        var data = {};
        var linkId = $("#linkId").val();
        var nodes = $.fn.zTree.getZTreeObj("zTree").getCheckedNodes(true);
        var promulgatorList = [];
        for(var i = 0;i< nodes.length; i++){
            if(!nodes[i].isParent){
                var obj = {};
                obj["participantId"] = nodes[i].id;
                obj["peopleName"] = nodes[i].name;
                obj["organId"] = nodes[i].pId;
                promulgatorList.push(obj);
            }
        }
        data["linkId"] = "${linkId!}";
        data["promulgatorListJson"] = JSON.stringify(promulgatorList);

        return data;
    }

    var zTree_nodeList = [];
    function zTree_searchText () {
        var text = $("#zTree_zTreeSearch input").val();
        if ($.trim(text) == "") {
            $("#zTree_zTreeSearch .zTree-search-tip").html("");
            $("#zTree_zTreeSearch span.iconfont").css("visibility", "hidden");
            return;
        }

        zTree_nodeList = zTree_zTree.getNodesByParamFuzzy("name", text);
        if (zTree_nodeList.length == 0) {
            $("#zTree_zTreeSearch .zTree-search-tip").html("搜不到");
            $("#zTree_zTreeSearch span.iconfont").css("visibility", "hidden");
            return;
        }

        $("#zTree_zTreeSearch span.iconfont").css("visibility", "visible");
        zTree_selectNode(0);
    }

    // 选中指定下标节点
    function zTree_selectNode (index) {
        if (index == -1) {
            index = zTree_nodeList.length - 1;
        } else if (index == zTree_nodeList.length) {
            index = 0;
        }

        $("#zTree_zTreeSearch .zTree-search-tip").html(index + 1 + "/" + zTree_nodeList.length);
        zTree_zTree.selectNode(zTree_nodeList[index]);
        $("#" + zTree_nodeList[index].tId + "_a").click();
    }

    // 上一个
    $("#zTree_zTreeSearch .icon-shangyibu").click(function () {
        var index = parseInt($("#zTree_zTreeSearch .zTree-search-tip").html().split("/")[0]);
        zTree_selectNode(--index - 1);
    });

    // 下一个
    $("#zTree_zTreeSearch .icon-xiayibu").click(function () {
        var index = parseInt($("#zTree_zTreeSearch .zTree-search-tip").html().split("/")[0]);
        zTree_selectNode(--index + 1);
    });
</script>
