 var ajaxCaller = {
	shouldDebug: true,

	getXML: function(url,xml,callbackFunction) {
		this._callServer(url, xml,"GET",false, callbackFunction);
	},
	postXML: function(url, xml, callbackFunction) {
		this._callServer(url, xml,"POST",false, callbackFunction);
	},
	_callServer:function(url,xml,requestMethod,expectingXML,callbackFunction){

		var xReq=this._createXMLHttpRequest();
		if (xReq){

			xReq.open(requestMethod, url, true);
			xReq.onreadystatechange = function() {
				ajaxCaller._onResponseStateChange(xReq,expectingXML,callbackFunction);
			}
			xReq.setRequestHeader("Content-Type","text/xml");
			xReq.send(xml);
		}
	},
	 _onResponseStateChange: function(xReq,expectingXML,callbackFunction) {
		if (xReq.readyState < 4) { //Still waiting
		  return;
		}
		if (xReq.readyState == 4) { //Transmit to actual callback
			var content=expectingXML ? xReq.responseXML : xReq.responseText;
			callbackFunction(content);
		}
	},
	_createXMLHttpRequest:function(){
		if (window.XMLHttpRequest){
			return new XMLHttpRequest();
		}else if (window.ActiveXObject) {
			return new ActiveXObject('Microsoft.XMLHTTP');
		} else {
			this._error("Could not create XMLHttpRequest on this browser");
			return null;
		}
	},
	 _error: function(message) {
      if (this.shouldDebug) {
        alert("AjaxJS ERROR:\n\n" + message);
      }
	}
};

/*
 * Returns an new XMLHttpRequest object, or false if the browser
 * doesn't support it
 */
function newXMLHttpRequest() {

  var xmlreq = false;

  // Create XMLHttpRequest object in non-Microsoft browsers
  if (window.XMLHttpRequest) {
    xmlreq = new XMLHttpRequest();

  } else if (window.ActiveXObject) {

    try {
      // Try to create XMLHttpRequest in later versions
      // of Internet Explorer

      xmlreq = new ActiveXObject("Msxml2.XMLHTTP");

    } catch (e1) {

      // Failed to create required ActiveXObject

      try {
        // Try version supported by older versions
        // of Internet Explorer

        xmlreq = new ActiveXObject("Microsoft.XMLHTTP");

      } catch (e2) {

        // Unable to create an XMLHttpRequest by any means
        xmlreq = false;
      }
    }
  }

return xmlreq;
}

 /*
	* Returns a function that waits for the specified XMLHttpRequest
	* to complete, then passes it XML response to the given handler function.
  * req - The XMLHttpRequest whose state is changing
  * responseXmlHandler - Function to pass the XML response to
  */
 function getReadyStateXMLHandler(req, responseXmlHandler) {

   // Return an anonymous function that listens to the XMLHttpRequest instance
   return function () {

     // If the request's status is "complete"
     if (req.readyState == 4) {

       // Check that we received a successful response from the server
       if (req.status == 200) {

         // Pass the XML payload of the response to the handler function.
         responseXmlHandler(req.responseXML);

       } else {

         // An HTTP problem has occurred
         alert("HTTP error "+req.status+": "+req.statusText);
       }
     }
   }
 }

 /*
  * 返回一个函数等待XMLHttpRequest完成
  * req -   XMLHttpRequest对象
  * responseTextHandler-函数
  */
 function getReadyStateTextHandler(req, responseTextHandler) {

   // Return an anonymous function that listens to the XMLHttpRequest instance
   return function () {

     // If the request's status is "complete"
     if (req.readyState == 4) {

       // Check that we received a successful response from the server
       if (req.status == 200) {

         // Pass the XML payload of the response to the handler function.
         responseTextHandler(req.responseText);

       } else {

         // An HTTP problem has occurred
         alert("HTTP error "+req.status+": "+req.statusText);
       }
     }
   }
 }
