package com.gtis.oa.util;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Calendar;

@Component
public class SessionUtil {

    @Autowired
    UserManagerClient userManagerClient;


    private static final UserDto guest;

    static {
        guest = new UserDto();
        guest.setAdmin(1);
        guest.setUsername("guest");
        guest.setId("guest");
    }

    /**
     * 从session中获取用户信息
     * @return
     */
    public UserDto getCurrentUser(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null ){
            String username = authentication.getName();
            return userManagerClient.getUserDetailByUsername(username);
        }
        return null;
    }


    public String getCurrentUserId() {
        UserDto user = getCurrentUser();
        return user != null ? user.getId() : null;
    }

//    /**
//     * 用户配置信息
//     *
//     * @param request
//     * @return
//     */
//    @Deprecated
//    public static PfConfigVo getUserConfig(HttpServletRequest request) {
//        UserInfo info = getUserInfo(request);
//        return info.getConfig();
//    }
//
//    /**
//     * 只获取用户编号
//     *
//     * @param request
//     * @return
//     */
//    @Deprecated
//    public static String getUserId(HttpServletRequest request) {
//        UserInfo info = getUserInfo(request);
//        if (info != null)
//            return info.getId();
//        else
//            return "";
//    }
//
//    @Deprecated
//    public static String getUserIds(HttpServletRequest request) {
//        UserInfo info = getUserInfo(request);
//        return info.getUsersIdAll();
//    }

    /**
     * 获取当前用户信息
     *
     * @return
     */
    @Deprecated
    public static String getUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null ) {
            return authentication.getName();
        }
        return "";
    }

    /**
     * 获取当前时间 yyyy年MM月dd日 星期日
     *
     * @return
     */
    public static String getCurTime() {
        String result = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy年MM月dd日" + " ");
        result = tempDate.format(cal.getTime());
        result = result + " 星期" + getChineseDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
        return result;
    }

    public static String getChineseDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case Calendar.MONDAY:
                return "一";
            case Calendar.TUESDAY:
                return "二";
            case Calendar.WEDNESDAY:
                return "三";
            case Calendar.THURSDAY:
                return "四";
            case Calendar.FRIDAY:
                return "五";
            case Calendar.SATURDAY:
                return "六";
            case Calendar.SUNDAY:
                return "日";
        }
        return "";
    }
}
