package com.gtis.oa.util;


import com.gtis.oa.model.LawsType;
import com.gtis.oa.service.LawsService;
import com.gtis.oa.service.LawsTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import java.util.Map;

/**
 * <p>
 * 政策法规数据抓取定时任务配置
 * </p>
 *
 * @author <a href="wangxinyi@gtmap.com">wangxinyi</a>
 * @version V1.0, 2019-8-12
 */
@Component
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling
public class SaticScheduleTask {
    @Autowired
    LawsTypeService lawsTypeService;

    @Autowired
    LawsService lawsService;

    /**
     * 保存政策法规目录树
     */
    @Scheduled(cron = "0 0 0 1/7 * ?")
    public void saveTreeLawsType() {
        String url = "http://f.mnr.gov.cn/";
        try {
            Map<String, String> map = lawsTypeService.getLawsTypeWithUrl(url);
            for (String key : map.keySet()) {
                String value = map.get(key);
                String[] values = value.split(",");
                LawsType lawsTypeNew = new LawsType();
                lawsTypeNew.setTypeId(key);
                lawsTypeNew.setFmemo(values[1]);
                lawsTypeNew.setFname(values[1]);
                lawsTypeNew.setFtypeParentId(values[0]);
                lawsTypeNew.setIsUse("是");
                lawsTypeNew.setSort(Integer.parseInt(key));
                lawsTypeService.saveOrUpdate(lawsTypeNew);
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }

    /**
     * 保存政策法规内容
     */
    @Scheduled(cron = "0 0 1 1/7 * ?")
    public void saveTreeLaws() {
        String url = "http://f.mnr.gov.cn/index_3553.html";

        int s = 0;
        int i = 1;
        while (i<97) {
            int updataC = lawsService.getLawsWithUrl(url);
            s = s + updataC;
            System.out.print(url + s);
            url = "http://f.mnr.gov.cn/index_3553_" + i + ".html";
            i++;
        }
    }
}

